/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.a.f;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.a;
import com.vividsolutions.jts.geom.b;
import com.vividsolutions.jts.geom.d;
import com.vividsolutions.jts.geom.e;
import com.vividsolutions.jts.geom.g;
import com.vividsolutions.jts.geom.h;
import com.vividsolutions.jts.geom.k;
import com.vividsolutions.jts.geom.o;
import com.vividsolutions.jts.geom.t;
import java.util.Arrays;

public class Polygon
extends Geometry {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing linearRing, t t2, int n2) {
        this(linearRing, new LinearRing[0], new GeometryFactory(t2, n2));
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, t t2, int n2) {
        this(linearRing, linearRingArray, new GeometryFactory(t2, n2));
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (linearRing == null) {
            linearRing = this.getFactory().createLinearRing((d)null);
        }
        if (linearRingArray == null) {
            linearRingArray = new LinearRing[]{};
        }
        if (Polygon.hasNullElements(linearRingArray)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (linearRing.isEmpty() && Polygon.hasNonEmptyElements(linearRingArray)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = linearRing;
        this.holes = linearRingArray;
    }

    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        int n2;
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n3 = -1;
        Coordinate[] coordinateArray2 = this.shell.getCoordinates();
        for (n2 = 0; n2 < coordinateArray2.length; ++n2) {
            coordinateArray[++n3] = coordinateArray2[n2];
        }
        for (n2 = 0; n2 < this.holes.length; ++n2) {
            coordinateArray2 = this.holes[n2].getCoordinates();
            for (int i2 = 0; i2 < coordinateArray2.length; ++i2) {
                coordinateArray[++n3] = coordinateArray2[i2];
            }
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        int n2 = this.shell.getNumPoints();
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            n2 += this.holes[i2].getNumPoints();
        }
        return n2;
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        if (this.shell.getNumPoints() != 5) {
            return false;
        }
        d d2 = this.shell.getCoordinateSequence();
        h h2 = this.getEnvelopeInternal();
        for (int i2 = 0; i2 < 5; ++i2) {
            double d3 = d2.getX(i2);
            if (d3 != h2.d() && d3 != h2.e()) {
                return false;
            }
            double d4 = d2.getY(i2);
            if (d4 == h2.f() || d4 == h2.g()) continue;
            return false;
        }
        double d5 = d2.getX(0);
        double d6 = d2.getY(0);
        for (int i3 = 1; i3 <= 4; ++i3) {
            boolean bl;
            double d7 = d2.getX(i3);
            double d8 = d2.getY(i3);
            boolean bl2 = d7 != d5;
            boolean bl3 = bl = d8 != d6;
            if (bl2 == bl) {
                return false;
            }
            d5 = d7;
            d6 = d8;
        }
        return true;
    }

    public o getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public o getInteriorRingN(int n2) {
        return this.holes[n2];
    }

    public String getGeometryType() {
        return "Polygon";
    }

    public double getArea() {
        double d2 = 0.0 + Math.abs(f.b(this.shell.getCoordinates()));
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            d2 -= Math.abs(f.b(this.holes[i2].getCoordinates()));
        }
        return d2;
    }

    public double getLength() {
        double d2 = 0.0 + this.shell.getLength();
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            d2 += this.holes[i2].getLength();
        }
        return d2;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        o[] oArray = new LinearRing[this.holes.length + 1];
        o[] oArray2 = oArray;
        oArray[0] = this.shell;
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            oArray2[i2 + 1] = this.holes[i2];
        }
        if (oArray2.length <= 1) {
            return this.getFactory().createLinearRing(oArray2[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString(oArray2);
    }

    protected h computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry geometry, double d2) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        geometry = (Polygon)geometry;
        LinearRing linearRing = this.shell;
        LinearRing linearRing2 = ((Polygon)geometry).shell;
        if (!((Geometry)linearRing).equalsExact(linearRing2, d2)) {
            return false;
        }
        if (this.holes.length != ((Polygon)geometry).holes.length) {
            return false;
        }
        if (this.holes.length != ((Polygon)geometry).holes.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            if (((Geometry)this.holes[i2]).equalsExact(((Polygon)geometry).holes[i2], d2)) continue;
            return false;
        }
        return true;
    }

    public void apply(b b2) {
        this.shell.apply(b2);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            this.holes[i2].apply(b2);
        }
    }

    public void apply(g g2) {
        this.shell.apply(g2);
        if (!g2.a()) {
            for (int i2 = 0; i2 < this.holes.length; ++i2) {
                this.holes[i2].apply(g2);
                if (g2.a()) break;
            }
        }
        if (g2.b()) {
            this.geometryChanged();
        }
    }

    public void apply$6f9a9d12(k k2) {
        k2.a(this);
    }

    public void apply(k k2) {
        k2.a(this);
        this.shell.apply(k2);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            this.holes[i2].apply(k2);
        }
    }

    public Object clone() {
        Polygon polygon = (Polygon)super.clone();
        ((Polygon)super.clone()).shell = (LinearRing)this.shell.clone();
        polygon.holes = new LinearRing[this.holes.length];
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            polygon.holes[i2] = (LinearRing)this.holes[i2].clone();
        }
        return polygon;
    }

    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    public void normalize() {
        Polygon.a(this.shell, true);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            Polygon.a(this.holes[i2], false);
        }
        Arrays.sort(this.holes);
    }

    protected int compareToSameClass(Object object) {
        LinearRing linearRing = this.shell;
        object = ((Polygon)object).shell;
        return linearRing.compareToSameClass(object);
    }

    protected int compareToSameClass(Object object, e e2) {
        int n2;
        object = (Polygon)object;
        LinearRing linearRing = this.shell;
        LinearRing linearRing2 = ((Polygon)object).shell;
        int n3 = linearRing.compareToSameClass(linearRing2, e2);
        if (n3 != 0) {
            return n3;
        }
        n3 = this.getNumInteriorRing();
        int n4 = ((Polygon)object).getNumInteriorRing();
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            LinearRing linearRing3;
            LinearRing linearRing4 = (LinearRing)this.getInteriorRingN(n2);
            int n5 = linearRing4.compareToSameClass(linearRing3 = (LinearRing)((Polygon)object).getInteriorRingN(n2), e2);
            if (n5 == 0) continue;
            return n5;
        }
        if (n2 < n3) {
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        return 0;
    }

    private static void a(LinearRing linearRing, boolean bl) {
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = new Coordinate[linearRing.getCoordinates().length - 1];
        System.arraycopy(linearRing.getCoordinates(), 0, coordinateArray, 0, coordinateArray.length);
        Coordinate coordinate = a.c(linearRing.getCoordinates());
        a.a(coordinateArray, coordinate);
        System.arraycopy(coordinateArray, 0, linearRing.getCoordinates(), 0, coordinateArray.length);
        linearRing.getCoordinates()[coordinateArray.length] = coordinateArray[0];
        if (f.a(linearRing.getCoordinates()) == bl) {
            a.b(linearRing.getCoordinates());
        }
    }
}

