/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.keyczar.HmacKey;
import org.keyczar.KeyczarKey;
import org.keyczar.enums.CipherMode;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.ShortBufferException;
import org.keyczar.interfaces.DecryptingStream;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class AesKey
extends KeyczarKey {
    private Key aesKey;
    private int blockSize;
    private static final String AES_ALGORITHM = "AES";
    private static final CipherMode DEFAULT_MODE = CipherMode.CBC;
    @Expose
    private String aesKeyString = "";
    @Expose
    private HmacKey hmacKey = new HmacKey();
    @Expose
    private CipherMode mode = DEFAULT_MODE;
    private byte[] hash = new byte[4];

    AesKey() {
    }

    static AesKey generate() throws KeyczarException {
        return AesKey.generate(KeyType.AES.defaultSize());
    }

    static AesKey generate(int keySize) throws KeyczarException {
        AesKey key = new AesKey();
        key.size = keySize;
        byte[] aesBytes = Util.rand(key.size() / 8);
        key.aesKeyString = Base64Coder.encode(aesBytes);
        key.mode = DEFAULT_MODE;
        key.hmacKey = HmacKey.generate();
        key.init();
        return key;
    }

    @Override
    KeyType getType() {
        return KeyType.AES;
    }

    @Override
    byte[] hash() {
        return this.hash;
    }

    static AesKey read(String input) throws KeyczarException {
        AesKey key = (AesKey)Util.gson().fromJson(input, AesKey.class);
        key.hmacKey.init();
        key.init();
        return key;
    }

    private void init() throws KeyczarException {
        byte[] aesBytes = Base64Coder.decode(this.aesKeyString);
        this.aesKey = new SecretKeySpec(aesBytes, AES_ALGORITHM);
        this.blockSize = aesBytes.length;
        byte[] fullHash = Util.hash(Util.fromInt(this.blockSize), aesBytes, this.hmacKey.keyBytes());
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
    }

    @Override
    Stream getStream() throws KeyczarException {
        return new AesStream();
    }

    private class AesStream
    implements EncryptingStream,
    DecryptingStream {
        private Cipher encryptingCipher;
        private Cipher decryptingCipher;
        private SigningStream signStream;
        boolean ivRead = false;

        public AesStream() throws KeyczarException {
            IvParameterSpec zeroIv = new IvParameterSpec(new byte[AesKey.this.blockSize]);
            try {
                this.encryptingCipher = Cipher.getInstance(AesKey.this.mode.getMode());
                this.encryptingCipher.init(1, AesKey.this.aesKey, zeroIv);
                this.decryptingCipher = Cipher.getInstance(AesKey.this.mode.getMode());
                this.decryptingCipher.init(2, AesKey.this.aesKey, zeroIv);
                this.signStream = (SigningStream)AesKey.this.hmacKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public SigningStream getSigningStream() {
            return this.signStream;
        }

        @Override
        public VerifyingStream getVerifyingStream() {
            return (VerifyingStream)((Object)this.signStream);
        }

        @Override
        public void initDecrypt(ByteBuffer input) {
            byte[] iv = new byte[AesKey.this.blockSize];
            input.get(iv);
            this.decryptingCipher.update(iv);
            this.ivRead = true;
        }

        @Override
        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            byte[] ivPreImage = new byte[AesKey.this.blockSize];
            Util.rand(ivPreImage);
            try {
                return this.encryptingCipher.update(ByteBuffer.wrap(ivPreImage), output);
            }
            catch (javax.crypto.ShortBufferException e) {
                throw new ShortBufferException(e);
            }
        }

        @Override
        public int updateDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            if (this.ivRead && input.remaining() >= AesKey.this.blockSize) {
                byte[] temp = new byte[AesKey.this.blockSize];
                input.get(temp);
                this.decryptingCipher.update(temp);
                this.ivRead = false;
            }
            try {
                return this.decryptingCipher.update(input, output);
            }
            catch (javax.crypto.ShortBufferException e) {
                throw new ShortBufferException(e);
            }
        }

        @Override
        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.encryptingCipher.update(input, output);
            }
            catch (javax.crypto.ShortBufferException e) {
                throw new ShortBufferException(e);
            }
        }

        @Override
        public int doFinalDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            if (this.ivRead) {
                if (input.remaining() == 0) {
                    return 0;
                }
                byte[] temp = new byte[AesKey.this.blockSize];
                input.get(temp);
                this.decryptingCipher.update(temp);
                this.ivRead = false;
            }
            try {
                if (input.remaining() == 0) {
                    byte[] outputBytes = this.decryptingCipher.doFinal();
                    output.put(outputBytes);
                    return outputBytes.length;
                }
                return this.decryptingCipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.encryptingCipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int maxOutputSize(int inputLen) {
            return AesKey.this.mode.getOutputSize(AesKey.this.blockSize, inputLen);
        }
    }
}

