/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.keyczar.Encrypter;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamCache;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.BadVersionException;
import org.keyczar.exceptions.InvalidSignatureException;
import org.keyczar.exceptions.KeyNotFoundException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.ShortCiphertextException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.DecryptingStream;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;

public class Crypter
extends Encrypter {
    private static final int DECRYPT_CHUNK_SIZE = 1024;
    private static final Logger logger = Logger.getLogger(Crypter.class);
    private static final StreamCache<DecryptingStream> CRYPT_CACHE = new StreamCache();

    public Crypter(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public Crypter(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public byte[] decrypt(byte[] input) throws KeyczarException {
        ByteBuffer output = ByteBuffer.allocate(input.length);
        this.decrypt(ByteBuffer.wrap(input), output);
        output.reset();
        byte[] outputBytes = new byte[output.remaining()];
        output.get(outputBytes);
        return outputBytes;
    }

    public void decrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
        ByteBuffer inputCopy = input.asReadOnlyBuffer();
        logger.info((Object)Messages.getString("Crypter.Decrypting", inputCopy.remaining()));
        if (inputCopy.remaining() < 5) {
            throw new ShortCiphertextException(inputCopy.remaining());
        }
        byte version = inputCopy.get();
        if (version != 0) {
            throw new BadVersionException(version);
        }
        byte[] hash = new byte[4];
        inputCopy.get(hash);
        KeyczarKey key = this.getKey(hash);
        if (key == null) {
            throw new KeyNotFoundException(hash);
        }
        inputCopy.mark();
        DecryptingStream cryptStream = CRYPT_CACHE.get(key);
        if (cryptStream == null) {
            cryptStream = (DecryptingStream)key.getStream();
        }
        VerifyingStream verifyStream = cryptStream.getVerifyingStream();
        if (inputCopy.remaining() < verifyStream.digestSize()) {
            throw new ShortCiphertextException(inputCopy.remaining());
        }
        inputCopy.position(inputCopy.limit() - verifyStream.digestSize());
        ByteBuffer signature = inputCopy.slice();
        inputCopy.reset();
        inputCopy.limit(inputCopy.limit() - verifyStream.digestSize());
        cryptStream.initDecrypt(inputCopy);
        ByteBuffer headerAndIvToVerify = input.asReadOnlyBuffer();
        headerAndIvToVerify.limit(inputCopy.position());
        verifyStream.initVerify();
        verifyStream.updateVerify(headerAndIvToVerify);
        output.mark();
        while (inputCopy.remaining() > 1024) {
            ByteBuffer ciphertextChunk = inputCopy.slice();
            ciphertextChunk.limit(1024);
            cryptStream.updateDecrypt(ciphertextChunk, output);
            ciphertextChunk.rewind();
            verifyStream.updateVerify(ciphertextChunk);
            inputCopy.position(inputCopy.position() + 1024);
        }
        inputCopy.mark();
        verifyStream.updateVerify(inputCopy);
        if (!verifyStream.verify(signature)) {
            throw new InvalidSignatureException();
        }
        inputCopy.reset();
        cryptStream.doFinalDecrypt(inputCopy, output);
        output.limit(output.position());
        CRYPT_CACHE.put(key, cryptStream);
    }

    public String decrypt(String ciphertext) throws KeyczarException {
        return new String(this.decrypt(Base64Coder.decode(ciphertext)));
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.DECRYPT_AND_ENCRYPT;
    }
}

