/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import org.keyczar.DsaPublicKey;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class DsaPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String KEY_GEN_ALGORITHM = "DSA";
    private static final String SIG_ALGORITHM = "SHA1withDSA";
    @Expose
    private DsaPublicKey publicKey = new DsaPublicKey();
    @Expose
    private String x;
    private DSAPrivateKey jcePrivateKey;

    private DsaPrivateKey() {
    }

    @Override
    byte[] hash() {
        return this.getPublic().hash();
    }

    public String getKeyGenAlgorithm() {
        return KEY_GEN_ALGORITHM;
    }

    @Override
    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    @Override
    Stream getStream() throws KeyczarException {
        return new DsaSigningStream();
    }

    @Override
    KeyType getType() {
        return KeyType.DSA_PRIV;
    }

    public void setPublic(KeyczarPublicKey pub) throws KeyczarException {
        this.publicKey = (DsaPublicKey)pub;
        this.publicKey.init();
    }

    static DsaPrivateKey generate() throws KeyczarException {
        return DsaPrivateKey.generate(KeyType.DSA_PRIV.defaultSize());
    }

    void init() throws KeyczarException {
        this.publicKey.init();
        BigInteger xVal = new BigInteger(Base64Coder.decode(this.x));
        BigInteger pVal = new BigInteger(Base64Coder.decode(this.publicKey.p));
        BigInteger qVal = new BigInteger(Base64Coder.decode(this.publicKey.q));
        BigInteger gVal = new BigInteger(Base64Coder.decode(this.publicKey.g));
        DSAPrivateKeySpec spec = new DSAPrivateKeySpec(xVal, pVal, qVal, gVal);
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            this.jcePrivateKey = (DSAPrivateKey)kf.generatePrivate(spec);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    static DsaPrivateKey generate(int keySize) throws KeyczarException {
        KeyPairGenerator kpg;
        DsaPrivateKey key = new DsaPrivateKey();
        try {
            kpg = KeyPairGenerator.getInstance(KEY_GEN_ALGORITHM);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
        key.size = keySize;
        kpg.initialize(key.size());
        KeyPair pair = kpg.generateKeyPair();
        key.jcePrivateKey = (DSAPrivateKey)pair.getPrivate();
        DSAPublicKey pubKey = (DSAPublicKey)pair.getPublic();
        key.publicKey.set(pubKey.getY(), pubKey.getParams().getP(), pubKey.getParams().getQ(), pubKey.getParams().getG());
        key.x = Base64Coder.encode(key.jcePrivateKey.getX().toByteArray());
        key.init();
        return key;
    }

    static DsaPrivateKey read(String input) throws KeyczarException {
        DsaPrivateKey key = (DsaPrivateKey)Util.gson().fromJson(input, DsaPrivateKey.class);
        key.init();
        return key;
    }

    private class DsaSigningStream
    implements SigningStream,
    VerifyingStream {
        private Signature signature;
        private VerifyingStream verifyingStream;

        public DsaSigningStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(DsaPrivateKey.SIG_ALGORITHM);
                this.verifyingStream = (VerifyingStream)DsaPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return DsaPrivateKey.this.getType().getOutputSize();
        }

        @Override
        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(DsaPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        @Override
        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

