/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.keyczar.EcPublicKey;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class EcPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String KEY_GEN_ALGORITHM = "EC";
    private static final String SIG_ALGORITHM = "SHA256withECDSA";
    @Expose
    private EcPublicKey publicKey = new EcPublicKey();
    @Expose
    private String pkcs8;
    private PrivateKey jcePrivateKey;

    private EcPrivateKey() {
    }

    public String getKeyGenAlgorithm() {
        return KEY_GEN_ALGORITHM;
    }

    @Override
    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    @Override
    byte[] hash() {
        return this.getPublic().hash();
    }

    @Override
    Stream getStream() throws KeyczarException {
        return new EcSigningStream();
    }

    @Override
    KeyType getType() {
        return KeyType.EC_PRIV;
    }

    public void setPublic(KeyczarPublicKey pub) throws KeyczarException {
        this.publicKey = (EcPublicKey)pub;
        this.publicKey.init();
    }

    static EcPrivateKey generate() throws KeyczarException {
        return EcPrivateKey.generate(KeyType.EC_PRIV.defaultSize());
    }

    void init() throws KeyczarException {
        byte[] pkcs8Bytes = Base64Coder.decode(this.pkcs8);
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            this.jcePrivateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(pkcs8Bytes));
            this.publicKey.init();
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    static EcPrivateKey generate(int keySize) throws KeyczarException {
        EcPrivateKey key = new EcPrivateKey();
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_GEN_ALGORITHM, "GooKey");
            key.size = keySize;
            kpg.initialize(key.size());
            KeyPair pair = kpg.generateKeyPair();
            key.jcePrivateKey = pair.getPrivate();
            key.publicKey.set(pair.getPublic().getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
        key.pkcs8 = Base64Coder.encode(key.jcePrivateKey.getEncoded());
        key.init();
        return key;
    }

    static EcPrivateKey read(String input) throws KeyczarException {
        EcPrivateKey key = (EcPrivateKey)Util.gson().fromJson(input, EcPrivateKey.class);
        key.init();
        return key;
    }

    private class EcSigningStream
    implements SigningStream,
    VerifyingStream {
        private Signature signature;
        private VerifyingStream verifyingStream;

        public EcSigningStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(EcPrivateKey.SIG_ALGORITHM, "GooKey");
                this.verifyingStream = (VerifyingStream)EcPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return EcPrivateKey.this.getType().getOutputSize();
        }

        @Override
        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(EcPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        @Override
        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

