/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keyczar.KeyVersion;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyType;
import org.keyczar.util.Util;

class KeyMetadata {
    @Expose
    String name = "";
    @Expose
    KeyPurpose purpose = KeyPurpose.TEST;
    @Expose
    KeyType type = KeyType.TEST;
    @Expose
    List<KeyVersion> versions = new ArrayList<KeyVersion>();
    @Expose
    boolean encrypted = false;
    protected Map<Integer, KeyVersion> versionMap = new HashMap<Integer, KeyVersion>();

    private KeyMetadata() {
    }

    KeyMetadata(String n, KeyPurpose p, KeyType t) {
        this.name = n;
        this.purpose = p;
        this.type = t;
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    boolean addVersion(KeyVersion version) {
        int versionNumber = version.getVersionNumber();
        if (!this.versionMap.containsKey(versionNumber)) {
            this.versionMap.put(versionNumber, version);
            this.versions.add(version);
            return true;
        }
        return false;
    }

    boolean removeVersion(int versionNumber) {
        if (this.versionMap.containsKey(versionNumber)) {
            KeyVersion version = this.versionMap.get(versionNumber);
            this.versions.remove(version);
            this.versionMap.remove(versionNumber);
            return true;
        }
        return false;
    }

    String getName() {
        return this.name;
    }

    KeyPurpose getPurpose() {
        return this.purpose;
    }

    KeyType getType() {
        return this.type;
    }

    void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    boolean isEncrypted() {
        return this.encrypted;
    }

    KeyVersion getVersion(int versionNumber) {
        return this.versionMap.get(versionNumber);
    }

    List<KeyVersion> getVersions() {
        return this.versions;
    }

    static KeyMetadata read(String jsonString) {
        KeyMetadata kmd = (KeyMetadata)Util.gson().fromJson(jsonString, KeyMetadata.class);
        for (KeyVersion version : kmd.getVersions()) {
            kmd.versionMap.put(version.getVersionNumber(), version);
        }
        return kmd;
    }
}

