/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.util.Util;

class KeyVersion {
    @Expose
    private boolean exportable = false;
    @Expose
    private KeyStatus status = KeyStatus.ACTIVE;
    @Expose
    private int versionNumber = 0;

    private KeyVersion() {
    }

    KeyVersion(int v, boolean export) {
        this(v, KeyStatus.ACTIVE, export);
    }

    KeyVersion(int v, KeyStatus s, boolean export) {
        this.versionNumber = v;
        this.status = s;
        this.exportable = export;
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyVersion)) {
            return false;
        }
        KeyVersion v = (KeyVersion)o;
        return this.getVersionNumber() == v.getVersionNumber();
    }

    public int hashCode() {
        return this.versionNumber;
    }

    KeyStatus getStatus() {
        return this.status;
    }

    int getVersionNumber() {
        return this.versionNumber;
    }

    boolean isExportable() {
        return this.exportable;
    }

    void setStatus(KeyStatus status) {
        this.status = status == null ? this.status : status;
    }

    static KeyVersion read(String jsonString) {
        return (KeyVersion)Util.gson().fromJson(jsonString, KeyVersion.class);
    }
}

