/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.HashMap;
import java.util.Map;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.BadVersionException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Util;

public class MockKeyczarReader
implements KeyczarReader {
    private Map<Integer, KeyczarKey> keys;
    private Map<Integer, KeyczarKey> publicKeys;
    private KeyMetadata kmd;
    private KeyMetadata publicKmd;

    public MockKeyczarReader(String n, KeyPurpose p, KeyType t) {
        this.kmd = new KeyMetadata(n, p, t);
        this.publicKmd = null;
        this.keys = new HashMap<Integer, KeyczarKey>();
        this.publicKeys = new HashMap<Integer, KeyczarKey>();
    }

    @Override
    public String getKey(int version) throws KeyczarException {
        if (this.keys.containsKey(version)) {
            return this.keys.get(version).toString();
        }
        throw new BadVersionException((byte)version);
    }

    @Override
    public String getMetadata() {
        return Util.gson().toJson((Object)this.kmd);
    }

    public void setMetadata(KeyMetadata newKmd) {
        this.kmd = newKmd;
    }

    public void setPublicKeyMetadata(KeyMetadata publicKmd) {
        this.publicKmd = publicKmd;
    }

    public void setKey(int versionNumber, KeyczarKey key) {
        this.keys.put(versionNumber, key);
    }

    public void setPublicKey(int versionNumber, KeyczarKey key) {
        this.publicKeys.put(versionNumber, key);
    }

    public void removeKey(int versionNumber) {
        this.keys.remove(versionNumber);
    }

    public String name() {
        return this.kmd.getName();
    }

    public KeyPurpose purpose() {
        return this.kmd.getPurpose();
    }

    public KeyType type() {
        return this.kmd.getType();
    }

    public boolean addKey(int versionNumber, KeyStatus status) throws KeyczarException {
        KeyczarKey key = KeyczarKey.genKey(this.kmd.getType());
        this.keys.put(versionNumber, key);
        return this.kmd.addVersion(new KeyVersion(versionNumber, status, false));
    }

    public boolean addKey(int versionNumber, KeyStatus status, int size) throws KeyczarException {
        KeyczarKey key = KeyczarKey.genKey(this.kmd.getType(), size);
        this.keys.put(versionNumber, key);
        return this.kmd.addVersion(new KeyVersion(versionNumber, status, false));
    }

    public KeyStatus getStatus(int versionNumber) {
        return this.kmd.getVersion(versionNumber).getStatus();
    }

    public boolean existsVersion(int versionNumber) {
        return this.keys.containsKey(versionNumber);
    }

    public boolean exportedPublicKeySet() {
        return this.publicKmd != null;
    }

    public boolean hasPublicKey(int versionNumber) {
        KeyczarPrivateKey privateKey = (KeyczarPrivateKey)((Object)this.keys.get(versionNumber));
        KeyczarPublicKey publicKey = (KeyczarPublicKey)this.publicKeys.get(versionNumber);
        return privateKey != null && publicKey != null && publicKey.equals(privateKey.getPublic());
    }

    public int numKeys() {
        return this.keys.size();
    }

    public int getKeySize(int versionNumber) {
        return this.keys.get(versionNumber).size();
    }
}

