/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.jce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import org.keyczar.jce.EcCore;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;

public class EcPrivateKeyImpl
implements ECPrivateKey {
    private static final long serialVersionUID = -237229630170977756L;
    private BigInteger S;
    private ECParameterSpec params;

    EcPrivateKeyImpl(BigInteger S, ECParameterSpec params) {
        this.S = S;
        this.params = params;
    }

    @Override
    public BigInteger getS() {
        return this.S;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SEQUENCE privateKeyInfo = new SEQUENCE();
        privateKeyInfo.addElement((ASN1Value)new INTEGER(0L));
        SEQUENCE algid = new SEQUENCE();
        algid.addElement((ASN1Value)new OBJECT_IDENTIFIER("1.2.840.10045.2.1"));
        algid.addElement((ASN1Value)new OBJECT_IDENTIFIER(EcCore.getOID(this.params)));
        privateKeyInfo.addElement((ASN1Value)algid);
        SEQUENCE ecPrivateKey = new SEQUENCE();
        ecPrivateKey.addElement((ASN1Value)new INTEGER(1L));
        ecPrivateKey.addElement((ASN1Value)new OCTET_STRING(EcCore.fieldElemToBytes(this.S, this.params)));
        try {
            ecPrivateKey.encode((OutputStream)baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal ASN.1 encoding error", ioe);
        }
        privateKeyInfo.addElement((ASN1Value)new OCTET_STRING(baos.toByteArray()));
        baos.reset();
        try {
            privateKeyInfo.encode((OutputStream)baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal ASN.1 encoding error", ioe);
        }
        return baos.toByteArray();
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int bitlen = this.params.getOrder().bitLength();
        sb.append("GooKey EC private key, " + bitlen + " bit\n");
        sb.append("  Private value: " + this.S.toString(16) + "\n");
        sb.append("  Parameters: " + EcCore.getFriendlyName(this.params) + " (" + EcCore.getOID(this.params) + ")");
        return sb.toString();
    }
}

