/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxCellStatePreview;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;

public class mxMovePreview
extends mxEventSource {
    protected mxGraphComponent graphComponent;
    protected int threshold = 200;
    protected boolean placeholderPreview = false;
    protected boolean clonePreview = true;
    protected boolean contextPreview = true;
    protected boolean hideSelectionHandler = false;
    protected mxCellState startState;
    protected mxCellState[] previewStates;
    protected Object[] movingCells;
    protected Rectangle initialPlaceholder;
    protected Rectangle placeholder;
    protected mxRectangle lastDirty;
    protected transient mxCellStatePreview preview;

    public mxMovePreview(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxMovePreview.this.paint(graphics);
            }
        });
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public boolean isPlaceholderPreview() {
        return this.placeholderPreview;
    }

    public void setPlaceholderPreview(boolean bl) {
        this.placeholderPreview = bl;
    }

    public boolean isClonePreview() {
        return this.clonePreview;
    }

    public void setClonePreview(boolean bl) {
        this.clonePreview = bl;
    }

    public boolean isContextPreview() {
        return this.contextPreview;
    }

    public void setContextPreview(boolean bl) {
        this.contextPreview = bl;
    }

    public boolean isHideSelectionHandler() {
        return this.hideSelectionHandler;
    }

    public void setHideSelectionHandler(boolean bl) {
        this.hideSelectionHandler = bl;
    }

    public boolean isActive() {
        return this.startState != null;
    }

    public Object[] getMovingCells() {
        return this.movingCells;
    }

    public Object[] getCells(mxCellState mxCellState2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        return mxGraph2.getMovableCells(mxGraph2.getSelectionCells());
    }

    protected mxCellState[] getPreviewStates() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        LinkedList<mxCellState> linkedList = new LinkedList<mxCellState>();
        for (Object object : this.movingCells) {
            Object[] objectArray;
            mxCellState mxCellState2 = mxGraph2.getView().getState(object);
            if (mxCellState2 == null) continue;
            linkedList.add(mxCellState2);
            if (linkedList.size() >= this.threshold) {
                return null;
            }
            if (!this.isContextPreview()) continue;
            for (Object object2 : objectArray = mxGraph2.getAllEdges(new Object[]{object})) {
                mxCellState mxCellState3;
                if (mxGraph2.isCellSelected(object2) || (mxCellState3 = mxGraph2.getView().getState(object2)) == null) continue;
                if (linkedList.size() >= this.threshold) {
                    return null;
                }
                linkedList.add(mxCellState3);
            }
        }
        return linkedList.toArray(new mxCellState[linkedList.size()]);
    }

    protected boolean isCellOpaque(Object object) {
        return this.startState != null && this.startState.getCell() == object;
    }

    public void start(MouseEvent mouseEvent, mxCellState mxCellState2) {
        this.startState = mxCellState2;
        this.movingCells = this.getCells(mxCellState2);
        mxCellState[] mxCellStateArray = this.previewStates = !this.placeholderPreview ? this.getPreviewStates() : null;
        if (this.previewStates == null || this.previewStates.length >= this.threshold) {
            this.placeholder = this.getPlaceholderBounds(this.startState).getRectangle();
            this.initialPlaceholder = new Rectangle(this.placeholder);
            this.graphComponent.getGraphControl().repaint(this.placeholder);
        }
        this.fireEvent(new mxEventObject(mxEvent.START, "event", mouseEvent, "state", this.startState));
    }

    protected mxRectangle getPlaceholderBounds(mxCellState mxCellState2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        return mxGraph2.getView().getBounds(mxGraph2.getSelectionCells());
    }

    public mxCellStatePreview createCellStatePreview() {
        return new mxCellStatePreview(this.graphComponent, this.isClonePreview()){

            protected float getOpacityForCell(Object object) {
                if (mxMovePreview.this.isCellOpaque(object)) {
                    return 1.0f;
                }
                return super.getOpacityForCell(object);
            }
        };
    }

    public void update(MouseEvent mouseEvent, double d, double d2, boolean bl) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        if (this.placeholder != null) {
            Rectangle rectangle = new Rectangle(this.placeholder);
            this.placeholder.x = this.initialPlaceholder.x + (int)d;
            this.placeholder.y = this.initialPlaceholder.x + (int)d2;
            rectangle.add(this.placeholder);
            this.graphComponent.getGraphControl().repaint(rectangle);
        } else if (this.previewStates != null) {
            this.preview = this.createCellStatePreview();
            this.preview.setOpacity(this.graphComponent.getPreviewAlpha());
            for (mxCellState mxCellState2 : this.previewStates) {
                this.preview.moveState(mxCellState2, d, d2, false, false);
                boolean bl2 = true;
                if (d == 0.0 && d2 == 0.0 || !bl || !this.isContextPreview()) continue;
                bl2 = false;
                Object object = mxCellState2.getCell();
                while (!bl2 && object != null) {
                    bl2 = mxGraph2.isCellSelected(object);
                    object = mxGraph2.getModel().getParent(object);
                }
            }
            Object object = this.lastDirty;
            this.lastDirty = this.preview.show();
            if (object != null) {
                ((mxRectangle)object).add(this.lastDirty);
            } else {
                object = this.lastDirty;
            }
            if (object != null) {
                this.graphComponent.getGraphControl().repaint(((mxRectangle)object).getRectangle());
            }
        }
        if (this.isHideSelectionHandler()) {
            this.graphComponent.getSelectionCellsHandler().setVisible(false);
        }
        this.fireEvent(new mxEventObject(mxEvent.CONTINUE, "event", mouseEvent, "dx", d, "dy", d2));
    }

    protected void reset() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        if (this.placeholder != null) {
            Rectangle rectangle = this.placeholder;
            this.placeholder = null;
            this.graphComponent.getGraphControl().repaint(rectangle);
        }
        if (this.isHideSelectionHandler()) {
            this.graphComponent.getSelectionCellsHandler().setVisible(true);
        }
        if (!this.isClonePreview()) {
            mxGraph2.getView().revalidate();
        }
        this.previewStates = null;
        this.movingCells = null;
        this.startState = null;
        this.preview = null;
        if (this.lastDirty != null) {
            this.graphComponent.getGraphControl().repaint(this.lastDirty.getRectangle());
            this.lastDirty = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] stop(boolean bl, MouseEvent mouseEvent, double d, double d2, boolean bl2, Object object) {
        Object[] objectArray = this.movingCells;
        this.reset();
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxGraph2.getModel().beginUpdate();
        try {
            if (bl) {
                double d3 = mxGraph2.getView().getScale();
                objectArray = mxGraph2.moveCells(objectArray, d / d3, d2 / d3, bl2, object, mouseEvent.getPoint());
            }
            this.fireEvent(new mxEventObject(mxEvent.STOP, "event", mouseEvent, "commit", bl));
        }
        finally {
            mxGraph2.getModel().endUpdate();
        }
        return objectArray;
    }

    public void paint(Graphics graphics) {
        if (this.placeholder != null) {
            mxConstants.PREVIEW_BORDER.paintBorder(this.graphComponent, graphics, this.placeholder.x, this.placeholder.y, this.placeholder.width, this.placeholder.height);
        }
        if (this.preview != null) {
            this.preview.paint(graphics);
        }
    }
}

