/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.IndefinitePathException;
import com.jayway.jsonpath.InvalidModelPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.jayway.jsonpath.spi.MappingProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class JsonModel {
    private Object jsonObject;
    private JsonProvider jsonProvider;

    static void notNull(Object s, String msg) {
        if (s == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    static void notEmpty(String s, String msg) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
    }

    private JsonModel(String jsonObject, JsonProvider jsonProvider) {
        JsonModel.notNull(jsonObject, "json can not be null");
        this.jsonProvider = jsonProvider;
        this.jsonObject = jsonProvider.parse(jsonObject);
    }

    private JsonModel(Object jsonObject, JsonProvider jsonProvider) {
        JsonModel.notNull(jsonObject, "json can not be null");
        if (!(jsonObject instanceof Map) && !(jsonObject instanceof List)) {
            throw new IllegalArgumentException("Invalid container object");
        }
        this.jsonProvider = jsonProvider;
        this.jsonObject = jsonObject;
    }

    private JsonModel(InputStream jsonInputStream, JsonProvider jsonProvider) {
        JsonModel.notNull(jsonInputStream, "jsonInputStream can not be null");
        this.jsonProvider = jsonProvider;
        this.jsonObject = jsonProvider.parse(jsonInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonModel(URL jsonURL, JsonProvider jsonProvider) throws IOException {
        JsonModel.notNull(jsonURL, "jsonURL can not be null");
        InputStream jsonInputStream = null;
        try {
            jsonInputStream = jsonURL.openStream();
            this.jsonObject = jsonProvider.parse(jsonInputStream);
            this.jsonProvider = jsonProvider;
        }
        finally {
            IOUtils.closeQuietly((InputStream)jsonInputStream);
        }
    }

    public Object getJsonObject() {
        return this.jsonObject;
    }

    public <T> T get(String jsonPath, Filter ... filters) {
        return this.get(JsonPath.compile(jsonPath, filters));
    }

    public <T> T get(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        return jsonPath.read(this.jsonObject);
    }

    public ArrayOps opsForArray(String jsonPath) {
        return this.opsForArray(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public ArrayOps opsForArray(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        List opsTarget = this.getTargetObject(jsonPath, List.class);
        return new DefaultArrayOps(opsTarget);
    }

    public ObjectOps opsForObject(String jsonPath) {
        return this.opsForObject(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public ObjectOps opsForObject(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        Map opsTarget = this.getTargetObject(jsonPath, Map.class);
        return new DefaultObjectOps(opsTarget);
    }

    public String getJson() {
        return this.jsonProvider.toJson(this.jsonObject);
    }

    public String getJson(String jsonPath, Filter ... filters) {
        return this.getJson(JsonPath.compile(jsonPath, filters));
    }

    public String getJson(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        return this.jsonProvider.toJson(this.get(jsonPath));
    }

    public JsonModel getModel(String jsonPath, Filter ... filters) {
        return this.getModel(JsonPath.compile(jsonPath, filters));
    }

    public JsonModel getModel(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        Object subModel = jsonPath.read(this.jsonObject);
        if (!(subModel instanceof Map) && !(subModel instanceof List)) {
            throw new InvalidModelPathException("The path " + jsonPath.getPath() + " returned an invalid model " + (subModel != null ? subModel.getClass() : "null"));
        }
        return new JsonModel(subModel, this.jsonProvider);
    }

    public MappingModelReader map(String jsonPath) {
        return this.map(JsonPath.compile(jsonPath, new Filter[0]));
    }

    public MappingModelReader map(JsonPath jsonPath) {
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        return new DefaultMappingModelReader(this.get(jsonPath));
    }

    public static JsonModel create(String json) {
        JsonModel.notEmpty(json, "json can not be null or empty");
        return new JsonModel(json, JsonProviderFactory.createProvider());
    }

    public static JsonModel create(Object jsonObject) {
        JsonModel.notNull(jsonObject, "jsonObject can not be null");
        return new JsonModel(jsonObject, JsonProviderFactory.createProvider());
    }

    public static JsonModel create(URL url) throws IOException {
        JsonModel.notNull(url, "url can not be null");
        return new JsonModel(url, JsonProviderFactory.createProvider());
    }

    public static JsonModel create(InputStream jsonInputStream) throws IOException {
        JsonModel.notNull(jsonInputStream, "jsonInputStream can not be null");
        return new JsonModel(jsonInputStream, JsonProviderFactory.createProvider());
    }

    private <T> T getTargetObject(JsonPath jsonPath, Class<T> clazz) {
        PathToken currentToken;
        JsonModel.notNull(jsonPath, "jsonPath can not be null");
        if (!jsonPath.isPathDefinite()) {
            throw new IndefinitePathException(jsonPath.getPath());
        }
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        Object modelRef = this.jsonObject;
        LinkedList<PathToken> tokens = jsonPath.getTokenizer().getPathTokens();
        do {
            currentToken = tokens.poll();
            modelRef = currentToken.apply(modelRef, jsonProvider);
        } while (!tokens.isEmpty());
        if (modelRef.getClass().isAssignableFrom(clazz)) {
            throw new InvalidModelPathException(jsonPath + " does nor refer to a Map but " + currentToken.getClass().getName());
        }
        return clazz.cast(modelRef);
    }

    private static class DefaultMappingModelReader
    implements MappingModelReader {
        private Object model;

        private DefaultMappingModelReader(Object model) {
            this.model = model;
        }

        @Override
        public ListMappingModelReader toList() {
            return this;
        }

        @Override
        public <T> List<T> of(Class<T> targetClass) {
            return this.toListOf(targetClass);
        }

        @Override
        public <T> List<T> toListOf(Class<T> targetClass) {
            if (!(this.model instanceof List)) {
                this.model = Arrays.asList(this.model);
            }
            return MappingProviderFactory.createProvider().convertValue(this.model, List.class, targetClass);
        }

        @Override
        public <T> Set<T> toSetOf(Class<T> targetClass) {
            if (!(this.model instanceof List)) {
                HashSet<Object> setModel = new HashSet<Object>();
                setModel.add(this.model);
                this.model = setModel;
            }
            return MappingProviderFactory.createProvider().convertValue(this.model, Set.class, targetClass);
        }

        @Override
        public <T> T to(Class<T> targetClass) {
            return MappingProviderFactory.createProvider().convertValue(this.model, targetClass);
        }
    }

    private static class DefaultArrayOps
    implements ArrayOps {
        private List<Object> opsTarget;

        private DefaultArrayOps(List<Object> opsTarget) {
            this.opsTarget = opsTarget;
        }

        @Override
        public List<Object> getTarget() {
            return this.opsTarget;
        }

        @Override
        public ArrayOps add(Object o) {
            this.opsTarget.add(o);
            return this;
        }

        @Override
        public ArrayOps addAll(Collection<Object> collection) {
            this.opsTarget.addAll(collection);
            return this;
        }

        @Override
        public ArrayOps remove(Object o) {
            this.opsTarget.remove(o);
            return this;
        }

        @Override
        public ListMappingModelReader toList() {
            return new DefaultMappingModelReader(this.opsTarget);
        }

        @Override
        public <T> List<T> toListOf(Class<T> targetClass) {
            return new DefaultMappingModelReader(this.opsTarget).toListOf(targetClass);
        }

        @Override
        public <T> Set<T> toSetOf(Class<T> targetClass) {
            return new DefaultMappingModelReader(this.opsTarget).toSetOf(targetClass);
        }
    }

    private static class DefaultObjectOps
    implements ObjectOps {
        private Map<String, Object> opsTarget;

        private DefaultObjectOps(Map<String, Object> opsTarget) {
            this.opsTarget = opsTarget;
        }

        @Override
        public Map<String, Object> getTarget() {
            return this.opsTarget;
        }

        @Override
        public boolean containsKey(String key) {
            return this.opsTarget.containsKey(key);
        }

        @Override
        public ObjectOps put(String key, Object value) {
            this.opsTarget.put(key, value);
            return this;
        }

        @Override
        public ObjectOps putAll(Map<String, Object> map) {
            this.opsTarget.putAll(map);
            return this;
        }

        @Override
        public ObjectOps remove(String key) {
            this.opsTarget.remove(key);
            return this;
        }

        @Override
        public <T> T to(Class<T> targetClass) {
            return new DefaultMappingModelReader(this.opsTarget).to(targetClass);
        }
    }

    public static interface ArrayOps {
        public List<Object> getTarget();

        public ArrayOps add(Object var1);

        public ArrayOps addAll(Collection<Object> var1);

        public ArrayOps remove(Object var1);

        public ListMappingModelReader toList();

        public <T> List<T> toListOf(Class<T> var1);

        public <T> Set<T> toSetOf(Class<T> var1);
    }

    public static interface ObjectOps {
        public Map<String, Object> getTarget();

        public boolean containsKey(String var1);

        public ObjectOps put(String var1, Object var2);

        public ObjectOps putAll(Map<String, Object> var1);

        public ObjectOps remove(String var1);

        public <T> T to(Class<T> var1);
    }

    public static interface MappingModelReader
    extends ListMappingModelReader,
    ObjectMappingModelReader {
    }

    public static interface ListMappingModelReader {
        public <T> List<T> of(Class<T> var1);

        public ListMappingModelReader toList();

        public <T> List<T> toListOf(Class<T> var1);

        public <T> Set<T> toSetOf(Class<T> var1);
    }

    public static interface ObjectMappingModelReader {
        public <T> T to(Class<T> var1);
    }
}

