/*
 * Decompiled with CFR 0.152.
 */
package com.EricFitchett.net.mcastdiscovery;

import com.EricFitchett.net.mcastdiscovery.MCastDiscovery;
import com.EricFitchett.net.mcastdiscovery.Service;
import com.EricFitchett.net.mcastdiscovery.messages.DiscoverMessage;
import com.EricFitchett.net.mcastdiscovery.messages.NewServiceMessage;
import com.EricFitchett.net.mcastdiscovery.messages.RefreshRequestMessage;
import com.EricFitchett.net.mcastdiscovery.messages.RefreshServiceMessage;
import com.EricFitchett.net.mcastdiscovery.messages.RemoveServiceMessage;
import com.EricFitchett.util.SerializationUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DiscoveryThread
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final int REFRESH_REQUEST_FREQUENCY = 300000;
    private static final int REFRESH_TIMEOUT = 10000;
    private MCastDiscovery mcast;
    private boolean running = true;
    private long timeOfLastRefresh = System.currentTimeMillis();
    private long refreshTimeout = 0L;
    private Map<String, Set<Service>> refreshServices = new HashMap<String, Set<Service>>();

    public DiscoveryThread(MCastDiscovery mCastDiscovery) {
        this.mcast = mCastDiscovery;
    }

    public void end() {
        this.running = false;
    }

    public void run() {
        MulticastSocket multicastSocket;
        this.timeOfLastRefresh = System.currentTimeMillis();
        try {
            multicastSocket = new MulticastSocket(1897);
            multicastSocket.joinGroup(MCastDiscovery.MCAST_ADDRESS);
        }
        catch (IOException iOException) {
            this.running = false;
            this.mcast.getErrorHandler().error(iOException);
            return;
        }
        try {
            multicastSocket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            this.mcast.getErrorHandler().warning("Failed to set timeout on socket - continuing anyway.");
        }
        while (this.running) {
            this.handleRefresh();
            this.handleThePacket(this.getAPacket(multicastSocket));
        }
        try {
            multicastSocket.leaveGroup(MCastDiscovery.MCAST_ADDRESS);
        }
        catch (IOException iOException) {
            this.mcast.getErrorHandler().info("Failed to leave the multicast group (socket closed anyway).");
        }
        multicastSocket.close();
    }

    private DatagramPacket getAPacket(MulticastSocket multicastSocket) {
        byte[] byArray = new byte[8192];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            multicastSocket.receive(datagramPacket);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.mcast.getErrorHandler().debug("Socket timeout (this is normal).");
            return null;
        }
        catch (IOException iOException) {
            this.mcast.getErrorHandler().warning("Failed to receive data packet.");
            return null;
        }
        return datagramPacket;
    }

    private void handleThePacket(DatagramPacket datagramPacket) {
        Object object;
        if (datagramPacket == null) {
            return;
        }
        byte[] byArray = datagramPacket.getData();
        try {
            object = SerializationUtils.getObject(byArray);
        }
        catch (Exception exception) {
            this.mcast.getErrorHandler().info("Unrecognized message received.");
            return;
        }
        if (!(this.handleNewOrRemovedServicesMessages(object) || this.handleDiscoverMessages(object) || this.handleRefreshMessages(object))) {
            this.mcast.getErrorHandler().info("Unrecognized message received.");
            return;
        }
    }

    private boolean handleNewOrRemovedServicesMessages(Object object) {
        if (object instanceof NewServiceMessage) {
            Service service = ((NewServiceMessage)object).getService();
            this.mcast.newService(service);
        } else if (object instanceof RemoveServiceMessage) {
            Service service = ((RemoveServiceMessage)object).getService();
            this.mcast.serviceRemoved(service);
        } else {
            return false;
        }
        return true;
    }

    private boolean handleDiscoverMessages(Object object) {
        if (object instanceof DiscoverMessage) {
            DiscoverMessage discoverMessage = (DiscoverMessage)object;
            String string = discoverMessage.getType();
            if (string != null) {
                for (Service service : this.mcast.getMyServices()) {
                    if (!"*".equals(string) && !string.equals(service.getType())) continue;
                    try {
                        this.mcast.sendObject(new NewServiceMessage(service));
                    }
                    catch (IOException iOException) {
                        this.mcast.getErrorHandler().warning("Failed to send discovery response.");
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean handleRefreshMessages(Object object) {
        if (object instanceof RefreshRequestMessage) {
            this.timeOfLastRefresh = System.currentTimeMillis();
            this.refreshTimeout = this.timeOfLastRefresh + 10000L;
            this.refreshServices.clear();
            for (Service service : this.mcast.getMyServices()) {
                try {
                    this.mcast.sendObject(new RefreshServiceMessage(service));
                }
                catch (IOException iOException) {
                    this.mcast.getErrorHandler().warning("Failed to send refresh response.");
                }
            }
        } else if (object instanceof RefreshServiceMessage) {
            Service service = ((RefreshServiceMessage)object).getService();
            if (!this.refreshServices.containsKey(service.getType())) {
                this.refreshServices.put(service.getType(), new HashSet());
            }
            this.refreshServices.get(service.getType()).add(service);
        } else {
            return false;
        }
        return true;
    }

    private void handleRefresh() {
        if (System.currentTimeMillis() - this.timeOfLastRefresh > 300000L) {
            this.timeOfLastRefresh = System.currentTimeMillis();
            try {
                this.mcast.refresh();
            }
            catch (IOException iOException) {
                this.mcast.getErrorHandler().warning("Failed to send refresh request.");
            }
        }
        if (this.refreshTimeout != 0L && System.currentTimeMillis() > this.refreshTimeout) {
            this.refreshTimeout = 0L;
            Set<Service> set = this.mcast.getServices("*");
            this.mcast.setServices(this.refreshServices);
            Set<Service> set2 = this.mcast.getServices("*");
            Set<Service> set3 = this.mcast.getServices("*");
            set3.retainAll(set);
            set.removeAll(set3);
            set2.removeAll(set3);
            for (Service service : set) {
                this.mcast.notifyDroppedService(service);
            }
            for (Service service : set2) {
                this.mcast.notifyNewService(service);
            }
        }
    }
}

