/*
 * Decompiled with CFR 0.152.
 */
package com.EricFitchett.net.mcastdiscovery;

import com.EricFitchett.net.mcastdiscovery.DiscoveryThread;
import com.EricFitchett.net.mcastdiscovery.Service;
import com.EricFitchett.net.mcastdiscovery.ServiceListener;
import com.EricFitchett.net.mcastdiscovery.errorHandling.ErrorHandler;
import com.EricFitchett.net.mcastdiscovery.errorHandling.ErrorLevel;
import com.EricFitchett.net.mcastdiscovery.errorHandling.ErrorLevelHandler;
import com.EricFitchett.net.mcastdiscovery.errorHandling.NullErrorHandler;
import com.EricFitchett.net.mcastdiscovery.errorHandling.SysErrErrorHandler;
import com.EricFitchett.net.mcastdiscovery.messages.DiscoverMessage;
import com.EricFitchett.net.mcastdiscovery.messages.NewServiceMessage;
import com.EricFitchett.net.mcastdiscovery.messages.RefreshRequestMessage;
import com.EricFitchett.net.mcastdiscovery.messages.RemoveServiceMessage;
import com.EricFitchett.util.SerializationUtils;
import com.EricFitchett.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MCastDiscovery {
    public static final InetAddress MCAST_ADDRESS;
    public static final int MCAST_PORT = 1897;
    private DiscoveryThread discoveryThread;
    private transient ErrorHandler errorHandler = new ErrorLevelHandler(new SysErrErrorHandler(), ErrorLevel.DEBUG);
    private List<ServiceListener> serviceListeners = new LinkedList<ServiceListener>();
    private Map<String, Set<Service>> services = new HashMap<String, Set<Service>>();
    private Set<Service> myServices = new HashSet<Service>();

    public void initialize() throws IOException {
        this.discoveryThread = new DiscoveryThread(this);
        new Thread(this.discoveryThread).start();
        this.discover();
    }

    public void release() {
        this.unregisterMyServices();
        if (this.discoveryThread != null) {
            this.discoveryThread.end();
        }
        this.discoveryThread = null;
        this.myServices.clear();
        this.services.clear();
    }

    public void advertise(Service service) throws IOException {
        while (this.serviceExists(service)) {
            this.incrementService(service);
        }
        this.myServices.add(service);
        this.sendObject(new NewServiceMessage(service));
    }

    public void remove(Service service) throws IOException {
        this.sendObject(new RemoveServiceMessage(service));
        this.myServices.remove(service);
    }

    public void discover() throws IOException {
        this.discover("*");
    }

    public void discover(String string) throws IOException {
        this.sendObject(new DiscoverMessage(string));
    }

    public void addServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.add(serviceListener);
    }

    public boolean removeServiceListener(ServiceListener serviceListener) {
        return this.serviceListeners.remove(serviceListener);
    }

    public void setErrorHandler(ErrorHandler errorHandler, ErrorLevel errorLevel) {
        this.errorHandler = errorHandler == null || errorLevel == null ? new NullErrorHandler() : new ErrorLevelHandler(errorHandler, errorLevel);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        if (this.errorHandler instanceof ErrorLevelHandler) {
            ((ErrorLevelHandler)this.errorHandler).setErrorLevel(errorLevel);
        }
    }

    public Set<Service> getServices(String string) {
        if ("*".equals(string)) {
            HashSet<Service> hashSet = new HashSet<Service>();
            for (Set<Service> set : this.services.values()) {
                hashSet.addAll(set);
            }
            return hashSet;
        }
        if (this.services.get(string) == null) {
            return new HashSet<Service>();
        }
        HashSet<Service> hashSet = new HashSet<Service>();
        hashSet.addAll((Collection)this.services.get(string));
        return hashSet;
    }

    protected void newService(Service service) {
        if (!this.services.containsKey(service.getType())) {
            this.services.put(service.getType(), new HashSet());
        }
        if (this.services.get(service.getType()).add(service)) {
            this.notifyNewService(service);
        }
    }

    protected void serviceRemoved(Service service) {
        this.myServices.remove(service);
        if (this.services.containsKey(service.getType())) {
            if (this.services.get(service.getType()).remove(service)) {
                this.notifyDroppedService(service);
            }
            if (this.services.get(service.getType()).isEmpty()) {
                this.services.remove(service.getType());
            }
        }
    }

    protected void notifyDroppedService(Service service) {
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.serviceRemoved(service);
        }
    }

    protected void notifyNewService(Service service) {
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.newService(service);
        }
    }

    protected void refresh() throws IOException {
        this.sendObject(new RefreshRequestMessage());
    }

    protected void sendObject(Serializable serializable) throws IOException {
        byte[] byArray = SerializationUtils.getObjectBytes(serializable);
        this.sendMessage(byArray, MCAST_ADDRESS);
    }

    private boolean serviceExists(Service service) {
        return this.myServices.contains(service) || this.services.get(service.getType()) instanceof Set && this.services.get(service.getType()).contains(service);
    }

    private void incrementService(Service service) {
        String[] stringArray = StringUtils.captureRegExp("(.*?)(\\d+)$", service.getName());
        if (stringArray.length > 0) {
            int n;
            String string = stringArray.length == 1 ? "" : stringArray[0];
            String string2 = stringArray[stringArray.length - 1];
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
            string2 = String.format("%0" + string2.length() + "d", ++n);
            service.setName(string + string2);
        } else {
            service.setName(service.getName() + "2");
        }
    }

    private void sendMessage(byte[] byArray, InetAddress inetAddress) throws IOException {
        DatagramSocket datagramSocket = new DatagramSocket();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 1897);
        datagramSocket.send(datagramPacket);
    }

    protected Set<Service> getMyServices() {
        return Collections.unmodifiableSet(this.myServices);
    }

    private void unregisterMyServices() {
        for (Service service : this.myServices) {
            try {
                this.remove(service);
            }
            catch (IOException iOException) {
                this.errorHandler.warning("Could not remove service: " + service);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    protected void setServices(Map<String, Set<Service>> map) {
        this.services = map;
    }

    static {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName("227.34.166.74");
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        MCAST_ADDRESS = inetAddress;
    }
}

