/*
 * Decompiled with CFR 0.152.
 */
package com.EricFitchett.net.mcastdiscovery;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public final class Service
implements Serializable {
    private static final long serialVersionUID = 2737482011471211406L;
    private String name;
    private String type;
    private InetAddress[] addresses;
    private int port;

    public Service(String string, String string2) throws IOException {
        this(string, string2, 0);
    }

    public Service(String string, String string2, int n) throws IOException {
        this(string, string2, Service.getLocalAddresses(), n);
    }

    public Service(String string, String string2, InetAddress[] inetAddressArray) throws IOException {
        this(string, string2, inetAddressArray, 0);
    }

    public Service(String string, String string2, InetAddress[] inetAddressArray, int n) throws IOException {
        this.type = string == null ? "" : string;
        this.name = string2 == null ? "" : string2;
        this.addresses = inetAddressArray == null ? Service.getLocalAddresses() : inetAddressArray;
        this.port = n;
    }

    public InetAddress[] getAddresses() {
        return this.addresses;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Service service = (Service)object;
        if (!this.getType().equals(service.getType())) {
            return false;
        }
        if (!this.getName().equals(service.getName())) {
            return false;
        }
        if (this.getPort() != service.getPort()) {
            return false;
        }
        return Arrays.equals(this.getAddresses(), service.getAddresses());
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.addresses.length; ++i) {
            n += this.addresses[i].hashCode();
        }
        return this.type.hashCode() + n + this.port;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName());
        stringBuffer.append(": type=").append(this.getType());
        stringBuffer.append(", name=").append(this.getName());
        stringBuffer.append(", port=").append(this.getPort());
        InetAddress[] inetAddressArray = this.getAddresses();
        for (int i = 0; i < inetAddressArray.length; ++i) {
            stringBuffer.append(", address=").append(inetAddressArray[i].getHostAddress());
        }
        return stringBuffer.toString();
    }

    protected void setName(String string) {
        this.name = string;
    }

    private static InetAddress[] getLocalAddresses() throws IOException {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress()) continue;
                arrayList.add(inetAddress);
            }
        }
        return arrayList.toArray(new InetAddress[0]);
    }
}

