/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j;

import org.nmap4j.core.flags.ArgumentProperties;
import org.nmap4j.core.nmap.ExecutionResults;
import org.nmap4j.core.nmap.NMapExecutionException;
import org.nmap4j.core.nmap.NMapExecutor;
import org.nmap4j.core.nmap.NMapInitializationException;
import org.nmap4j.core.nmap.NMapProperties;
import org.nmap4j.data.NMapRun;
import org.nmap4j.parser.OnePassParser;

public class Nmap4j {
    private NMapProperties nmapProperties;
    private ArgumentProperties flags;
    private NMapExecutor nmapExecutor;
    private ExecutionResults results;

    public Nmap4j(String path) {
        this.nmapProperties = new NMapProperties(path);
        this.flags = new ArgumentProperties();
    }

    public void execute() throws NMapInitializationException, NMapExecutionException {
        this.nmapExecutor = new NMapExecutor(this.flags, this.nmapProperties);
        this.results = this.nmapExecutor.execute();
    }

    public void addFlags(String flagSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(flagSet);
        if (!flagSet.contains("-oX")) {
            sb.append(" -oX -");
        }
        this.flags.addFlag(sb.toString());
    }

    public void includeHosts(String hosts) {
        this.flags.addIncludedHost(hosts);
    }

    public void excludeHosts(String hosts) {
        this.flags.addExcludedHost(hosts);
    }

    public String getOutput() {
        return this.results.getOutput();
    }

    public NMapRun getResult() {
        OnePassParser parser = new OnePassParser();
        NMapRun nmapRun = parser.parse(this.results.getOutput(), 1);
        return nmapRun;
    }

    public boolean hasError() {
        return this.results.getErrors().contains("ERROR");
    }

    public ExecutionResults getExecutionResults() {
        return this.results;
    }
}

