/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.core.flags;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.nmap4j.core.flags.Flag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentProperties {
    private LinkedHashMap<String, String> flagMap = new LinkedHashMap();
    private HashSet<String> includeHosts = new HashSet();
    private HashSet<String> excludeHosts = new HashSet();

    public void addFlag(Flag f) {
        this.addFlag(f.toString());
    }

    public void addFlag(Flag f, String value) {
        this.addFlag(f.toString(), value);
    }

    public void addFlag(String singleFlag) {
        this.addFlag(singleFlag, null);
    }

    public void addFlag(String flag, String arg) {
        if (this.flagMap.keySet().contains(flag) && this.flagMap.get(flag) != null) {
            StringBuffer tempFlags = new StringBuffer();
            tempFlags.append(this.flagMap.get(flag));
            tempFlags.append(",");
            tempFlags.append(arg);
            this.flagMap.remove(flag);
            this.flagMap.put(flag, tempFlags.toString());
        } else {
            this.flagMap.put(flag, arg);
        }
    }

    public void replaceFlag(Flag f, String value) {
        if (this.flagMap.get(f.toString()) != null) {
            this.removeFlag(f);
        }
        this.flagMap.put(f.toString(), value);
    }

    public void removeFlag(Flag f) {
        this.flagMap.remove(f.toString());
    }

    public LinkedHashMap<String, String> getFlagMap() {
        return this.flagMap;
    }

    public void setFlagMap(LinkedHashMap<String, String> newMap) {
        this.flagMap = newMap;
    }

    public String getFlags() {
        StringBuffer flags = new StringBuffer();
        Set<String> mapKeys = this.flagMap.keySet();
        for (String keyValue : mapKeys) {
            String argumentForKey = this.flagMap.get(keyValue);
            flags.append(keyValue);
            if (argumentForKey != null) {
                flags.append(" ");
                flags.append(argumentForKey);
            }
            flags.append(" ");
        }
        if (this.excludeHosts != null && this.excludeHosts.size() > 0) {
            flags.append(Flag.EXCLUDE_HOSTS.toString());
            flags.append(" ");
            flags.append(this.convertSetToString(this.excludeHosts, ","));
        }
        if (this.includeHosts != null && this.includeHosts.size() > 0) {
            flags.append(" ");
            flags.append(this.convertSetToString(this.includeHosts, " "));
        }
        return flags.toString();
    }

    public void addIncludedHost(String host) {
        if (!this.includeHosts.contains(host)) {
            this.includeHosts.add(host);
        }
    }

    public void removeIncludedHost(String host) {
        if (this.includeHosts.contains(host)) {
            this.includeHosts.remove(host);
        }
    }

    public String getIncludedHostsAsString() {
        return this.convertSetToString(this.includeHosts, " ");
    }

    public Set<String> getIncludedHosts() {
        return this.includeHosts;
    }

    public void addExcludedHost(String host) {
        if (!this.excludeHosts.contains(host)) {
            this.excludeHosts.add(host);
        }
    }

    public void removeExcludedHost(String host) {
        if (this.excludeHosts.contains(host)) {
            this.excludeHosts.remove(host);
        }
    }

    public Set<String> getExcludeHost() {
        return this.excludeHosts;
    }

    public String getExcludedHostsAsString() {
        return this.convertSetToString(this.excludeHosts, ",");
    }

    public void clearFlags() {
        this.flagMap.clear();
    }

    private String convertSetToString(Set<String> hosts, String delimiter) {
        StringBuffer hostsBuffer = new StringBuffer();
        Iterator<String> hostsIt = hosts.iterator();
        while (hostsIt.hasNext()) {
            hostsBuffer.append(hostsIt.next());
            hostsBuffer.append(delimiter);
        }
        return hostsBuffer.toString();
    }
}

