/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.core.nmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.nmap4j.core.flags.ArgumentProperties;
import org.nmap4j.core.nmap.ExecutionResults;
import org.nmap4j.core.nmap.NMapExecutionException;
import org.nmap4j.core.nmap.NMapInitializationException;
import org.nmap4j.core.nmap.NMapProperties;

public class NMapExecutor {
    private ArgumentProperties nmapArguments;
    private NMapProperties nmapProperties;

    public NMapExecutor(ArgumentProperties argProps, NMapProperties nmapProps) throws NMapInitializationException {
        this.nmapArguments = argProps;
        this.nmapProperties = nmapProps;
        if (this.nmapArguments == null || this.nmapProperties == null) {
            throw new NMapInitializationException("You cannot instantiate an NMapExecutor with nulls in either argument. Please refer to the documentation if you aren't sure how to proceed.");
        }
        if (nmapProps.getPath() == null || nmapProps.getPath() != null && nmapProps.getPath().length() <= 0) {
            throw new NMapInitializationException("the NMAP_HOME variable is not set or you did not set this path.");
        }
    }

    private String getOS() {
        return System.getProperty("os.name");
    }

    private StringBuffer getCommand() {
        StringBuffer fullCommand = new StringBuffer();
        fullCommand.append(this.nmapProperties.getFullyFormattedCommand());
        fullCommand.append(" ");
        fullCommand.append(this.nmapArguments.getFlags());
        return fullCommand;
    }

    public ExecutionResults execute() throws NMapExecutionException {
        StringBuffer command = this.getCommand();
        ExecutionResults results = new ExecutionResults();
        try {
            results.setExecutedCommand(command.toString());
            Process process = Runtime.getRuntime().exec(command.toString());
            results.setErrors(this.convertStream(process.getErrorStream()));
            results.setOutput(this.convertStream(process.getInputStream()));
        }
        catch (IOException e) {
            throw new NMapExecutionException(e.getMessage(), e);
        }
        return results;
    }

    private String convertStream(InputStream is) throws IOException {
        String output;
        StringBuffer outputBuffer = new StringBuffer();
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(is));
        while ((output = streamReader.readLine()) != null) {
            outputBuffer.append(output);
            outputBuffer.append("\n");
        }
        return outputBuffer.toString();
    }

    public String toString() {
        return this.getCommand().toString();
    }
}

