/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.core.scans;

import org.nmap4j.core.flags.ArgumentProperties;
import org.nmap4j.core.flags.Flag;
import org.nmap4j.core.nmap.ExecutionResults;
import org.nmap4j.core.nmap.NMapExecutionException;
import org.nmap4j.core.nmap.NMapExecutor;
import org.nmap4j.core.nmap.NMapInitializationException;
import org.nmap4j.core.nmap.NMapProperties;
import org.nmap4j.core.scans.IScan;
import org.nmap4j.core.scans.IScanCallback;
import org.nmap4j.core.scans.IScanValidator;
import org.nmap4j.core.scans.NMapExecutorThread;
import org.nmap4j.core.scans.ParameterValidationFailureException;

public class BaseScan
implements IScan {
    protected ArgumentProperties argProps;
    protected NMapProperties nmapProps = new NMapProperties();
    private String executedCommand;

    public BaseScan() {
        this.argProps = new ArgumentProperties();
        this.argProps.addFlag(Flag.XML_OUTPUT, "-");
    }

    public BaseScan(String nmapPath) {
        this();
        this.nmapProps.setPath(nmapPath);
    }

    public void excludeHost(String host) {
        if (host != null) {
            this.argProps.addExcludedHost(host);
        }
    }

    public void excludeHosts(String[] hosts) {
        if (hosts != null && hosts.length > 0) {
            for (String h : hosts) {
                this.excludeHost(h);
            }
        }
    }

    public void includeHost(String host) {
        if (host != null && host.length() > 0) {
            this.argProps.addIncludedHost(host);
        }
    }

    public void includeHosts(String[] hosts) {
        if (hosts != null && hosts.length > 0) {
            for (String h : hosts) {
                this.includeHost(h);
            }
        }
    }

    public void addPort(int port) {
        this.argProps.addFlag(Flag.PORT_SPEC, Integer.toString(port));
    }

    public void addPorts(int[] ports) {
        if (ports != null && ports.length > 0) {
            for (int p : ports) {
                this.argProps.addFlag(Flag.PORT_SPEC, Integer.toString(p));
            }
        }
    }

    public void executeAsynchronousScan(IScanCallback isc) throws ParameterValidationFailureException, NMapExecutionException {
        NMapExecutorThread nmapExecThread = new NMapExecutorThread(this.argProps, this.nmapProps);
        nmapExecThread.setCallback(isc);
        Thread aThread = new Thread(nmapExecThread);
        aThread.start();
    }

    public ExecutionResults executeScan() throws ParameterValidationFailureException, NMapExecutionException, NMapInitializationException {
        NMapExecutor executor = new NMapExecutor(this.argProps, this.nmapProps);
        ExecutionResults results = executor.execute();
        this.executedCommand = executor.toString();
        return results;
    }

    public void removeExcludeHost(String host) {
        if (host != null && host.length() > 0) {
            this.argProps.removeExcludedHost(host);
        }
    }

    public void removeExcludeHosts(String[] hosts) {
        if (hosts != null && hosts.length > 0) {
            for (String h : hosts) {
                this.removeExcludeHost(h);
            }
        }
    }

    public void removeIncludeHost(String host) {
        if (host != null && host.length() > 0) {
            this.argProps.removeIncludedHost(host);
        }
    }

    public void removeIncludeHosts(String[] hosts) {
        if (hosts != null && hosts.length > 0) {
            for (String h : hosts) {
                this.removeIncludeHost(h);
            }
        }
    }

    public void setOutputType(IScan.OutputType ot, String fName) {
        String fileName = fName;
        if (fName == null || fName != null && fName.length() <= 0) {
            fileName = "-";
        }
        switch (ot) {
            case GREPPABLE: {
                this.argProps.addFlag(Flag.GREPPABLE_OUTPUT, fileName);
                break;
            }
            case SCRIPT_KIDDIE: {
                this.argProps.addFlag(Flag.SCRIPT_KIDDIE_OUPUT, fileName);
                break;
            }
            case XML: {
                this.argProps.addFlag(Flag.XML_OUTPUT, fileName);
                break;
            }
            case NORMAL: {
                this.argProps.addFlag(Flag.NORMAL_OUTPUT, fileName);
                break;
            }
            default: {
                this.argProps.addFlag(Flag.XML_OUTPUT, fileName);
            }
        }
    }

    public void setScanValidator(IScanValidator isv) {
    }

    public void setTiming(IScan.TimingFlag tf) {
    }

    public void setNMapPath(String path) {
        this.nmapProps.setPath(path);
    }

    public void addFlag(Flag flag) {
        this.argProps.addFlag(flag);
    }

    public void removeFlag(Flag flag) {
        this.argProps.removeFlag(flag);
    }

    public ArgumentProperties getArgumentProperties() {
        return this.argProps;
    }

    public NMapProperties getNMapProperties() {
        return this.nmapProps;
    }
}

