/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.data.host;

public class Cpe {
    public static final String CPE_ATTR = "cpe";
    private String cpeData;
    private String part = null;
    private String vendor = null;
    private String product = null;
    private String version = null;
    private String update = null;
    private String edition = null;
    private String language = null;

    public Cpe() {
    }

    public Cpe(String cpe) {
        this.cpeData = cpe.substring(5);
        this.parseData();
    }

    private void parseData() {
        String[] tokens = this.cpeData.split(":");
        int tokenNumber = 0;
        for (String token : tokens) {
            switch (tokenNumber) {
                case 0: {
                    this.part = token;
                    break;
                }
                case 1: {
                    this.vendor = token;
                    break;
                }
                case 2: {
                    this.product = token;
                    break;
                }
                case 3: {
                    this.version = token;
                    break;
                }
                case 4: {
                    this.update = token;
                    break;
                }
                case 5: {
                    this.edition = token;
                    break;
                }
                case 6: {
                    this.language = token;
                }
            }
            ++tokenNumber;
        }
    }

    public String getCpeData() {
        return this.cpeData;
    }

    public void setCpeData(String cpeData) {
        this.cpeData = cpeData;
    }

    public String getPart() {
        return this.part;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getLanguage() {
        return this.language;
    }
}

