/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.parser;

import java.util.ArrayList;
import java.util.List;
import org.nmap4j.data.NMapRun;
import org.nmap4j.data.host.Address;
import org.nmap4j.data.host.Cpe;
import org.nmap4j.data.host.Distance;
import org.nmap4j.data.host.Hostnames;
import org.nmap4j.data.host.Os;
import org.nmap4j.data.host.Ports;
import org.nmap4j.data.host.Status;
import org.nmap4j.data.host.TcpSequence;
import org.nmap4j.data.host.TcpTsSequence;
import org.nmap4j.data.host.Times;
import org.nmap4j.data.host.Uptime;
import org.nmap4j.data.host.os.OsClass;
import org.nmap4j.data.host.os.OsMatch;
import org.nmap4j.data.host.os.PortUsed;
import org.nmap4j.data.host.ports.Port;
import org.nmap4j.data.nmaprun.Debugging;
import org.nmap4j.data.nmaprun.Host;
import org.nmap4j.data.nmaprun.RunStats;
import org.nmap4j.data.nmaprun.ScanInfo;
import org.nmap4j.data.nmaprun.Verbose;
import org.nmap4j.data.nmaprun.host.ports.port.Service;
import org.nmap4j.data.nmaprun.host.ports.port.State;
import org.nmap4j.data.nmaprun.hostnames.Hostname;
import org.nmap4j.data.nmaprun.runstats.Finished;
import org.nmap4j.data.nmaprun.runstats.Hosts;
import org.nmap4j.parser.INMapRunHandler;
import org.nmap4j.parser.events.NMap4JParserEventListener;
import org.nmap4j.parser.events.ParserEvent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NMapXmlHandler
extends DefaultHandler {
    private static List<NMap4JParserEventListener> listeners;
    private INMapRunHandler runHandler;
    private long parseStartTime = 0L;
    private long parseEndTime = 0L;
    private NMapRun nmapRun;
    private ScanInfo scanInfo;
    private Debugging debugging;
    private Verbose verbose;
    private Host host;
    private Status status;
    private Address address;
    private Hostnames hostnames;
    private Hostname hostname;
    private Ports ports;
    private Port port;
    private State state;
    private Service service;
    private Os os;
    private PortUsed portUsed;
    private OsClass osClass;
    private OsMatch osMatch;
    private Distance distance;
    private TcpSequence tcpSequence;
    private TcpTsSequence tcpTsSequence;
    private Times times;
    private Uptime uptime;
    private RunStats runStats;
    private Finished finished;
    private Hosts hosts;
    private Cpe cpe;
    private boolean isCpeData = false;
    private String previousQName;

    public NMapXmlHandler(INMapRunHandler handler) {
        listeners = new ArrayList<NMap4JParserEventListener>();
        this.runHandler = handler;
    }

    private void fireEvent(Object payload) {
        ParserEvent event = new ParserEvent(this, payload);
        if (listeners != null && listeners.size() > 0) {
            for (NMap4JParserEventListener listener : listeners) {
                if (listener == null) continue;
                listener.parseEventNotification(event);
            }
        }
    }

    public static void addListener(NMap4JParserEventListener listener) {
        if (listeners == null) {
            listeners = new ArrayList<NMap4JParserEventListener>();
        }
        listeners.add(listener);
    }

    public static void removeListener(NMap4JParserEventListener listener) {
        listeners.remove(listener);
    }

    public void startDocument() throws SAXException {
        this.parseStartTime = System.currentTimeMillis();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("nmaprun")) {
            this.nmapRun = this.runHandler.createNMapRun(attributes);
        }
        if (qName.equals("scaninfo")) {
            this.scanInfo = this.runHandler.createScanInfo(attributes);
            this.nmapRun.setScanInfo(this.scanInfo);
        }
        if (qName.equals("debugging")) {
            this.debugging = this.runHandler.createDebugging(attributes);
            this.nmapRun.setDebugging(this.debugging);
        }
        if (qName.equals("verbose")) {
            this.verbose = this.runHandler.createVerbose(attributes);
            this.nmapRun.setVerbose(this.verbose);
        }
        if (qName.equals("host")) {
            this.host = this.runHandler.createHost(attributes);
            this.nmapRun.addHost(this.host);
        }
        if (qName.equals("status")) {
            this.status = this.runHandler.createStatus(attributes);
            this.host.setStatus(this.status);
        }
        if (qName.equals("address")) {
            this.address = this.runHandler.createAddress(attributes);
            this.host.addAddress(this.address);
        }
        if (qName.equals("hostnames")) {
            this.hostnames = this.runHandler.createHostnames(attributes);
            this.host.setHostnames(this.hostnames);
        }
        if (qName.equals("hostname")) {
            this.hostname = this.runHandler.createHostname(attributes);
            this.hostnames.setHostname(this.hostname);
        }
        if (qName.equals("ports")) {
            this.ports = this.runHandler.createPorts(attributes);
            this.host.setPorts(this.ports);
        }
        if (qName.equals("port")) {
            this.port = this.runHandler.createPort(attributes);
            this.ports.addPort(this.port);
        }
        if (qName.equals("state")) {
            this.state = this.runHandler.createState(attributes);
            this.port.setState(this.state);
        }
        if (qName.equals("service")) {
            this.service = this.runHandler.createService(attributes);
            this.port.setService(this.service);
        }
        if (qName.equals("os")) {
            this.os = this.runHandler.createOs(attributes);
            this.host.setOs(this.os);
        }
        if (qName.equals("portused")) {
            this.portUsed = this.runHandler.createPortUsed(attributes);
            this.os.addPortUsed(this.portUsed);
        }
        if (qName.equals("osclass")) {
            this.osClass = this.runHandler.createOsClass(attributes);
            this.os.addOsClass(this.osClass);
        }
        if (qName.equals("osmatch")) {
            this.osMatch = this.runHandler.createOsMatch(attributes);
            this.os.addOsMatch(this.osMatch);
        }
        if (qName.equals("distance")) {
            this.distance = this.runHandler.createDistance(attributes);
            this.host.setDistance(this.distance);
        }
        if (qName.equals("tcpsequence")) {
            this.tcpSequence = this.runHandler.createTcpSequence(attributes);
            this.host.setTcpSequence(this.tcpSequence);
        }
        if (qName.equals("tcptssequence")) {
            this.tcpTsSequence = this.runHandler.createTcpTsSequence(attributes);
            this.host.setTcpTsSequence(this.tcpTsSequence);
        }
        if (qName.equals("times")) {
            this.times = this.runHandler.createTimes(attributes);
            this.host.setTimes(this.times);
        }
        if (qName.equals("uptime")) {
            this.uptime = this.runHandler.createUptime(attributes);
            this.host.setUptime(this.uptime);
        }
        if (qName.equals("runstats")) {
            this.runStats = this.runHandler.createRunStats(attributes);
            this.nmapRun.setRunStats(this.runStats);
        }
        if (qName.equals("finished")) {
            this.finished = this.runHandler.createFinished(attributes);
            this.runStats.setFinished(this.finished);
        }
        if (qName.equals("hosts")) {
            this.hosts = this.runHandler.createHosts(attributes);
            this.runStats.setHosts(this.hosts);
        }
        if (qName.equals("cpe")) {
            this.isCpeData = true;
            this.cpe = this.runHandler.createCpe(attributes);
            if (this.previousQName.equals("osclass")) {
                this.osClass.addCpe(this.cpe);
            } else if (this.previousQName.equals("service")) {
                // empty if block
            }
        }
        this.previousQName = qName;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isCpeData) {
            String cpeText = new String(ch, start, length);
            this.cpe.setCpeData(cpeText);
            this.isCpeData = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("nmaprun")) {
            this.fireEvent(this.nmapRun);
            this.nmapRun = null;
        }
        if (qName.equals("scaninfo")) {
            this.fireEvent(this.scanInfo);
            this.scanInfo = null;
        }
        if (qName.equals("debugging")) {
            this.fireEvent(this.debugging);
            this.debugging = null;
        }
        if (qName.equals("verbose")) {
            this.fireEvent(this.verbose);
            this.verbose = null;
        }
        if (qName.equals("host")) {
            this.fireEvent(this.host);
            this.host = null;
        }
        if (qName.equals("status")) {
            this.fireEvent(this.status);
            this.status = null;
        }
        if (qName.equals("address")) {
            this.fireEvent(this.address);
            this.address = null;
        }
        if (qName.equals("hostname")) {
            this.fireEvent(this.hostname);
            this.hostname = null;
        }
        if (qName.equals("hostnames")) {
            this.fireEvent(this.hostnames);
            this.hostnames = null;
        }
        if (qName.equals("ports")) {
            this.fireEvent(this.ports);
            this.ports = null;
        }
        if (qName.equals("port")) {
            this.fireEvent(this.port);
            this.port = null;
        }
        if (qName.equals("state")) {
            this.fireEvent(this.state);
            this.state = null;
        }
        if (qName.equals("service")) {
            this.fireEvent(this.service);
            this.service = null;
        }
        if (qName.equals("os")) {
            this.fireEvent(this.os);
            this.os = null;
        }
        if (qName.equals("portused")) {
            this.fireEvent(this.portUsed);
            this.portUsed = null;
        }
        if (qName.equals("osclass")) {
            this.fireEvent(this.osClass);
            this.osClass = null;
        }
        if (qName.equals("osmatch")) {
            this.fireEvent(this.osMatch);
            this.osMatch = null;
        }
        if (qName.equals("distance")) {
            this.fireEvent(this.distance);
            this.distance = null;
        }
        if (qName.equals("tcpsequence")) {
            this.fireEvent(this.tcpSequence);
            this.tcpSequence = null;
        }
        if (qName.equals("tcptssequence")) {
            this.fireEvent(this.tcpTsSequence);
            this.tcpTsSequence = null;
        }
        if (qName.equals("times")) {
            this.fireEvent(this.times);
            this.times = null;
        }
        if (qName.equals("uptime")) {
            this.fireEvent(this.uptime);
            this.uptime = null;
        }
        if (qName.equals("runstats")) {
            this.fireEvent(this.runStats);
            this.runStats = null;
        }
        if (qName.equals("finished")) {
            this.fireEvent(this.finished);
            this.finished = null;
        }
        if (qName.equals("hosts")) {
            this.fireEvent(this.hosts);
            this.hosts = null;
        }
        if (qName.equals("cpe")) {
            this.fireEvent(this.cpe);
            this.cpe = null;
        }
    }

    public void endDocument() throws SAXException {
        this.parseEndTime = System.currentTimeMillis();
    }

    public long getExecTime() {
        return this.parseEndTime - this.parseStartTime;
    }
}

