/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.parser;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.nmap4j.data.NMapRun;
import org.nmap4j.parser.INMapRunHandler;
import org.nmap4j.parser.NMapRunHandlerImpl;
import org.nmap4j.parser.NMapXmlHandler;
import org.nmap4j.parser.events.NMap4JParserEventListener;
import org.nmap4j.parser.events.ParserEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OnePassParser
implements NMap4JParserEventListener {
    public static final int STRING_INPUT = 1;
    public static final int FILE_NAME_INPUT = 2;
    private NMapRun nmapRun;
    private INMapRunHandler nmrh = new NMapRunHandlerImpl();
    private NMapXmlHandler nmxh = new NMapXmlHandler(this.nmrh);

    public NMapRun parse(String input, int type) {
        NMapXmlHandler.addListener(this);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            if (type == 1) {
                StringReader strReader = new StringReader(input);
                InputSource source = new InputSource(strReader);
                sp.parse(source, (DefaultHandler)this.nmxh);
            } else if (type == 2) {
                sp.parse("file:" + input, (DefaultHandler)this.nmxh);
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        NMapXmlHandler.removeListener(this);
        return this.nmapRun;
    }

    public void parseEventNotification(ParserEvent event) {
        if (event.getPayload() instanceof NMapRun) {
            this.nmapRun = (NMapRun)event.getPayload();
        }
    }

    public void addListener(NMap4JParserEventListener aListener) {
        NMapXmlHandler.addListener(aListener);
    }

    public void removeListener(NMap4JParserEventListener aListener) {
        NMapXmlHandler.removeListener(aListener);
    }
}

