/*
 * Decompiled with CFR 0.152.
 */
package org.nmap4j.parser.util;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.nmap4j.parser.util.BogusIPGenerator;
import org.nmap4j.parser.util.UidGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NMapXmlObsfucator
extends DefaultHandler {
    private int indentIdx = 0;
    private static String XML_FILE = "/Users/jsvede/work/loquatic/workspaces/nmap4j/org.nmap4j.parser/nmap-webapp-20090831-123159.xml";

    public static void main(String[] args) {
        NMapXmlObsfucator nmxo = new NMapXmlObsfucator();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            if (args != null && args.length > 0) {
                XML_FILE = args[0];
            }
            sp.parse("file:" + XML_FILE, (DefaultHandler)nmxo);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        --this.indentIdx;
        StringBuffer indent = new StringBuffer();
        for (int x = 0; x < this.indentIdx; ++x) {
            indent.append("\t");
        }
        System.out.println(indent.toString() + "</" + qName + ">");
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        StringBuffer indent = new StringBuffer();
        for (int x = 0; x < this.indentIdx; ++x) {
            indent.append("\t");
        }
        System.out.print(indent.toString() + "<" + qName + " ");
        int lenAttr = attributes.getLength();
        for (int x = 0; x < lenAttr; ++x) {
            String name = attributes.getQName(x);
            if (qName.equals("hostname")) {
                String fakeHostName = this.generateRandomHostName(null);
                if (!name.equals("name")) continue;
                System.out.print(name + "=\"" + fakeHostName + "\" ");
                continue;
            }
            if (qName.equals("address")) {
                if (name.equals("addr")) {
                    String addrType = attributes.getValue("addrtype");
                    if (addrType == null || !addrType.equals("ipv4")) continue;
                    String bogusIpAddr = BogusIPGenerator.generateBadIpAddress();
                    System.out.print(name + "=\"" + bogusIpAddr + "\" ");
                    continue;
                }
                System.out.print(name + "=\"" + attributes.getValue(name) + "\" ");
                continue;
            }
            System.out.print(name + "=\"" + attributes.getValue(name) + "\" ");
        }
        System.out.print(">\n");
        ++this.indentIdx;
    }

    private String generateRandomHostName(String defaultDomainName) {
        String myDefaultDomainName = "dummydomain.com";
        String uid = UidGenerator.getBigId("host");
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(uid);
        nameBuffer.append(".");
        if (defaultDomainName != null) {
            nameBuffer.append(defaultDomainName);
        } else {
            nameBuffer.append(myDefaultDomainName);
        }
        return nameBuffer.toString();
    }
}

