/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.PoolBarrier;
import jsr166y.forkjoin.RecursiveAction;
import jsr166y.forkjoin.RunState;
import jsr166y.forkjoin.Submission;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinWorkerThread
extends Thread {
    final ForkJoinPool pool;
    private final PoolBarrier poolBarrier;
    private final AtomicInteger activeWorkerCounter;
    private final RunState runState;
    private ForkJoinTask<?>[] queue;
    private static final int INITIAL_CAPACITY = 8192;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private volatile long base;
    private volatile long sp;
    private volatile long fullStealCount;
    private long eventCount;
    private int stealCount;
    private int poolSize;
    private int poolIndex;
    private int randomVictimSeed;
    private int scans;
    long juRandomSeed;
    final JURandom juRandom;
    private static final int IDLING = 0;
    private static final int JOINING = 1;
    private static final int POLLING = 2;
    private static final int IDLING_SCANS_PER_SYNC = 16;
    private static final int JOINING_SCANS_PER_SYNC = 1024;
    private static final Random randomSeedGenerator = new Random();
    private static final Unsafe _unsafe = ForkJoinWorkerThread.getUnsafe();
    private static final long baseOffset;
    private static final long arrayBase;
    private static final int arrayShift;

    final void setWorkerPoolIndex(int i) {
        this.poolIndex = i;
    }

    final int getWorkerPoolIndex() {
        return this.poolIndex;
    }

    final void setPoolSize(int ps) {
        this.poolSize = ps;
    }

    final long getWorkerStealCount() {
        return this.fullStealCount;
    }

    final RunState getRunState() {
        return this.runState;
    }

    final int getQueueSize() {
        long n = this.sp - this.base;
        return n < 0L ? 0 : (int)n;
    }

    final boolean workerIsIdle() {
        return this.base >= this.sp && this.scans != 0;
    }

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
        this.activeWorkerCounter = pool.getActiveWorkerCounter();
        this.poolBarrier = pool.getPoolBarrier();
        this.poolSize = pool.getPoolSize();
        this.juRandomSeed = randomSeedGenerator.nextLong();
        int rseed = randomSeedGenerator.nextInt();
        this.randomVictimSeed = rseed == 0 ? 1 : rseed;
        this.juRandom = new JURandom();
        this.runState = new RunState();
        this.queue = new ForkJoinTask[8192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable exception = null;
        try {
            this.onStart();
            while (this.runState.isRunning()) {
                ForkJoinTask<?> t = this.getTask();
                if (t == null) {
                    this.onEmptyScan(0);
                    continue;
                }
                t.exec();
            }
            this.clearLocalTasks();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            this.onTermination(exception);
        }
    }

    protected void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable exception) {
        try {
            if (this.scans == 0) {
                this.scans = 1;
                this.activeWorkerCounter.decrementAndGet();
            }
            this.cancelTasks();
            this.runState.transitionToTerminated();
        }
        finally {
            this.pool.workerTerminated(this, exception);
        }
    }

    private ForkJoinTask<?> getTask() {
        ForkJoinTask<?> popped = this.popTask();
        if (popped != null) {
            return popped;
        }
        ForkJoinTask<?> stolen = this.getStolenTask();
        if (stolen != null) {
            return stolen;
        }
        return this.getSubmission();
    }

    private void onEmptyScan(int context) {
        int s = this.scans;
        if (s == 0) {
            this.scans = 1;
            this.activeWorkerCounter.decrementAndGet();
        } else if (s <= 16 || s <= 1024 && context == 1) {
            this.scans = s + 1;
        } else {
            this.scans = 1;
            int sc = this.stealCount;
            if (sc != 0) {
                this.stealCount = 0;
                if (sc < 0) {
                    sc = Integer.MAX_VALUE;
                }
                this.fullStealCount += (long)sc;
            }
            if (this.runState.isAtLeastStopping()) {
                if (context == 1) {
                    throw new CancellationException();
                }
            } else if (context == 2) {
                Thread.yield();
            } else {
                this.eventCount = this.poolBarrier.sync(this, this.eventCount);
            }
        }
    }

    private void growQueue() {
        ForkJoinTask<?>[] oldQ = this.queue;
        int oldSize = oldQ.length;
        int newSize = oldSize << 1;
        if (newSize > 0x40000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        ForkJoinTask[] newQ = new ForkJoinTask[newSize];
        int oldMask = oldSize - 1;
        int newMask = newSize - 1;
        long s = this.sp;
        for (long i = this.base; i < s; ++i) {
            newQ[(int)i & newMask] = oldQ[(int)i & oldMask];
        }
        this.sp = s;
        this.queue = newQ;
    }

    final void pushTask(ForkJoinTask<?> x) {
        long s = this.sp;
        ForkJoinTask<?>[] q = this.queue;
        int mask = q.length - 1;
        q[(int)s & mask] = x;
        this.sp = s + 1L;
        if ((s -= this.base) >= (long)(mask - 1)) {
            this.growQueue();
        } else if (s <= 0L) {
            this.poolBarrier.signal();
        }
    }

    private ForkJoinTask<?> popTask() {
        ForkJoinTask<?> x = null;
        long s = this.sp - 1L;
        ForkJoinTask<?>[] q = this.queue;
        if (q != null) {
            int idx = (int)s & q.length - 1;
            x = q[idx];
            this.sp = s;
            q[idx] = null;
            long b = this.base;
            if (s <= b) {
                if (s < b || !this.casBase(b++, b)) {
                    x = null;
                }
                this.sp = b;
            }
        }
        return x;
    }

    private boolean popIfNext(ForkJoinTask<?> task) {
        if (task != null) {
            int idx;
            long s = this.sp - 1L;
            ForkJoinTask<?>[] q = this.queue;
            if (q != null && q[idx = (int)s & q.length - 1] == task) {
                this.sp = s;
                q[idx] = null;
                long b = this.base;
                if (s > b) {
                    return true;
                }
                if (s == b && this.casBase(b++, b)) {
                    this.sp = b;
                    return true;
                }
                this.sp = b;
            }
        }
        return false;
    }

    private ForkJoinTask<?> tryStealTask() {
        long b = this.base;
        if (b < this.sp) {
            int k;
            ForkJoinTask<?> t;
            ForkJoinTask[] q = this.queue;
            if (this.queue != null && (t = q[k = (int)b & q.length - 1]) != null && this.casBase(b, b + 1L)) {
                ForkJoinWorkerThread.clearSlot(q, k, t);
                t.setStolen();
                return t;
            }
        }
        return null;
    }

    private ForkJoinTask<?> getStolenTask() {
        int n;
        ForkJoinWorkerThread[] ws = this.pool.getWorkers();
        if (ws != null && (n = ws.length) > 0) {
            int r;
            int iters = n << 1;
            int s = this.scans;
            int idx = r = this.randomVictimSeed;
            while (true) {
                ForkJoinWorkerThread v = ws[idx & n - 1];
                r ^= r << 1;
                r ^= r >>> 3;
                r ^= r << 10;
                if (v != null && v.base < v.sp) {
                    if (s == 0) {
                        ForkJoinTask<?> t = v.tryStealTask();
                        if (t != null) {
                            this.randomVictimSeed = r;
                            ++this.stealCount;
                            return t;
                        }
                        iters = n << 1;
                        idx = r;
                        continue;
                    }
                    AtomicInteger awc = this.activeWorkerCounter;
                    int c = awc.get();
                    if (!awc.compareAndSet(c, c + 1)) continue;
                    s = 0;
                    this.scans = 0;
                    continue;
                }
                if (--iters >= n) {
                    idx = r;
                    continue;
                }
                if (iters < 0) break;
                ++idx;
            }
        }
        return null;
    }

    private ForkJoinTask<?> getSubmission() {
        ForkJoinPool.SubmissionQueue sq = this.pool.getSubmissionQueue();
        while (sq.isApparentlyNonEmpty()) {
            Submission<?> t;
            int c;
            AtomicInteger awc;
            if (this.scans != 0 && (awc = this.activeWorkerCounter).compareAndSet(c = awc.get(), c + 1)) {
                this.scans = 0;
            }
            if (this.scans != 0 || (t = sq.poll()) == null) continue;
            return t;
        }
        return null;
    }

    private ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] q = this.queue;
        long s = this.sp - 1L;
        if (q == null || s <= this.base) {
            return null;
        }
        return q[(int)s & q.length - 1];
    }

    private void clearLocalTasks() {
        ForkJoinTask<?> t;
        while ((t = this.popTask()) != null) {
            if (this.runState.isAtLeastStopping()) {
                t.cancel();
                continue;
            }
            t.exec();
        }
    }

    final void cancelTasks() {
        while (this.base < this.sp) {
            ForkJoinTask<?> t = this.tryStealTask();
            if (t == null) continue;
            t.setDoneExceptionally(new CancellationException());
        }
    }

    public static ForkJoinPool getPool() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pool;
    }

    public static int getPoolIndex() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).poolIndex;
    }

    public static int getLocalQueueSize() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        long n = w.sp - w.base;
        return n < 0L ? 0 : (int)n;
    }

    public static int getEstimatedSurplusTaskCount() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return (int)(w.sp - w.base) - (w.poolSize - w.activeWorkerCounter.get());
    }

    public static ForkJoinTask<?> peekLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    public static ForkJoinTask<?> pollLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).popTask();
    }

    public static boolean removeIfNextLocalTask(ForkJoinTask<?> task) {
        return ((ForkJoinWorkerThread)Thread.currentThread()).popIfNext(task);
    }

    public static boolean executeLocalTask() {
        ForkJoinTask<?> t = ((ForkJoinWorkerThread)Thread.currentThread()).popTask();
        if (t == null) {
            return false;
        }
        t.exec();
        return true;
    }

    public static ForkJoinTask<?> pollTask() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        ForkJoinTask<?> t = w.getTask();
        if (t == null) {
            w.onEmptyScan(2);
        }
        return t;
    }

    public static boolean executeTask() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        ForkJoinTask<?> t = w.getTask();
        if (t == null) {
            w.onEmptyScan(2);
            return false;
        }
        t.exec();
        return true;
    }

    public static int nextRandomInt() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return w.juRandom.nextInt();
    }

    public static int nextRandomInt(int n) {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return w.juRandom.nextInt(n);
    }

    public static long nextRandomLong() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return w.juRandom.nextLong();
    }

    public static long nextRandomLong(long n) {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return w.juRandom.nextLong(n);
    }

    public static double nextRandomDouble() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        return w.juRandom.nextDouble();
    }

    static void signalTaskCompletion() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ((ForkJoinWorkerThread)t).poolBarrier.signal();
        }
    }

    final <T> T doJoinTask(ForkJoinTask<T> joinMe) {
        while (true) {
            Throwable ex;
            if ((ex = joinMe.exception) != null) {
                ForkJoinTask.rethrowException(ex);
            }
            if (joinMe.status < 0) {
                return joinMe.rawResult();
            }
            ForkJoinTask<?> t = this.getTask();
            if (t == null) {
                this.onEmptyScan(1);
                continue;
            }
            t.exec();
        }
    }

    final Throwable doQuietlyJoinTask(ForkJoinTask<?> joinMe) {
        Throwable ex;
        while ((ex = joinMe.exception) == null) {
            if (joinMe.status < 0) {
                return null;
            }
            ForkJoinTask<?> t = this.getTask();
            if (t == null) {
                this.onEmptyScan(1);
                continue;
            }
            t.exec();
        }
        return ex;
    }

    final boolean doTimedJoinTask(ForkJoinTask<?> joinMe, long nanos) {
        long startTime = System.nanoTime();
        while (joinMe.exception == null && joinMe.status >= 0) {
            if (nanos - (System.nanoTime() - startTime) <= 0L) {
                return false;
            }
            ForkJoinTask<?> t = this.getTask();
            if (t == null) {
                this.onEmptyScan(1);
                continue;
            }
            t.exec();
        }
        return true;
    }

    final void doForkJoin(RecursiveAction t1, RecursiveAction t2) {
        Throwable ex2;
        int touch = t1.status + t2.status;
        this.pushTask(t2);
        Throwable ex1 = t1.exec();
        Throwable throwable = ex2 = this.popIfNext(t2) ? t2.exec() : this.doQuietlyJoinTask(t2);
        if (ex2 != null) {
            ForkJoinTask.rethrowException(ex2);
        } else if (ex1 != null) {
            ForkJoinTask.rethrowException(ex1);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            if (ForkJoinWorkerThread.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            return Unsafe.getUnsafe();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    private static int computeArrayShift() {
        int s = _unsafe.arrayIndexScale(ForkJoinTask[].class);
        if ((s & s - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        return 31 - Integer.numberOfLeadingZeros(s);
    }

    private final boolean casBase(long cmp, long val) {
        return _unsafe.compareAndSwapLong(this, baseOffset, cmp, val);
    }

    private static final void clearSlot(ForkJoinTask[] array, int i, ForkJoinTask expect) {
        _unsafe.compareAndSwapObject(array, arrayBase + ((long)i << arrayShift), expect, null);
    }

    static {
        try {
            baseOffset = _unsafe.objectFieldOffset(ForkJoinWorkerThread.class.getDeclaredField("base"));
            arrayBase = _unsafe.arrayBaseOffset(ForkJoinTask[].class);
            arrayShift = ForkJoinWorkerThread.computeArrayShift();
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    final class JURandom {
        static final long Multiplier = 25214903917L;
        static final long Addend = 11L;
        static final long Mask = 0xFFFFFFFFFFFFL;

        JURandom() {
        }

        int next(int bits) {
            long next;
            ForkJoinWorkerThread.this.juRandomSeed = next = ForkJoinWorkerThread.this.juRandomSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(next >>> 48 - bits);
        }

        int nextInt() {
            return this.next(32);
        }

        int nextInt(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("n must be positive");
            }
            int bits = this.next(31);
            if ((n & -n) == n) {
                return (int)((long)n * (long)bits >> 31);
            }
            int val;
            while (bits - (val = bits % n) + (n - 1) < 0) {
                bits = this.next(31);
            }
            return val;
        }

        long nextLong() {
            return ((long)this.next(32) << 32) + (long)this.next(32);
        }

        long nextLong(long n) {
            if (n <= 0L) {
                throw new IllegalArgumentException("n must be positive");
            }
            long offset = 0L;
            while (n >= Integer.MAX_VALUE) {
                long nextn;
                int bits = this.next(2);
                long half = n >>> 1;
                long l = nextn = (bits & 2) == 0 ? half : n - half;
                if ((bits & 1) == 0) {
                    offset += n - nextn;
                }
                n = nextn;
            }
            return offset + (long)this.nextInt((int)n);
        }

        double nextDouble() {
            return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
        }
    }
}

