/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import jsr166y.forkjoin.AbstractParallelAnyArray;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArrayWithBounds;
import jsr166y.forkjoin.ParallelArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelArrayWithFilter;
import jsr166y.forkjoin.ParallelArrayWithLongMapping;
import jsr166y.forkjoin.ParallelArrayWithMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelLongArrayWithLongMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelArray<T>
extends AbstractParallelAnyArray.OUPap<T>
implements Iterable<T> {
    AsList listView;

    public static ForkJoinExecutor defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelArray(ForkJoinExecutor executor, T[] array, int limit) {
        super(executor, 0, limit, array);
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
    }

    ParallelArray(ForkJoinExecutor executor, T[] array) {
        super(executor, 0, array.length, array);
    }

    public static <T> ParallelArray<T> create(int size, Class<? super T> elementType, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(elementType, size);
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createUsingHandoff(T[] handoff, ForkJoinExecutor executor) {
        return new ParallelArray<T>(executor, handoff, handoff.length);
    }

    public static <T> ParallelArray<T> createFromCopy(T[] source, ForkJoinExecutor executor) {
        int size = source.length;
        Object[] array = (Object[])Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createFromCopy(int size, T[] source, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createEmpty(int size, Class<? super T> elementType, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(elementType, size);
        return new ParallelArray<Object>(executor, array, 0);
    }

    public ForkJoinExecutor getExecutor() {
        return this.ex;
    }

    @Override
    public void apply(Ops.Procedure<? super T> procedure) {
        super.apply(procedure);
    }

    @Override
    public T reduce(Ops.Reducer<T> reducer, T base) {
        return super.reduce(reducer, base);
    }

    @Override
    public ParallelArray<T> all() {
        return super.all();
    }

    @Override
    public ParallelArray<T> all(Class<? super T> elementType) {
        return super.all(elementType);
    }

    @Override
    public ParallelArray<T> replaceWithMapping(Ops.Op<? super T, ? extends T> op) {
        super.replaceWithMapping(op);
        return this;
    }

    @Override
    public ParallelArray<T> replaceWithMappedIndex(Ops.IntToObject<? extends T> op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelArray<T> replaceWithMappedIndex(Ops.IntAndObjectToObject<? super T, ? extends T> op) {
        super.replaceWithMappedIndex(op);
        return this;
    }

    @Override
    public ParallelArray<T> replaceWithGeneratedValue(Ops.Generator<? extends T> generator) {
        super.replaceWithGeneratedValue(generator);
        return this;
    }

    @Override
    public ParallelArray<T> replaceWithValue(T value) {
        super.replaceWithValue(value);
        return this;
    }

    @Override
    public <V, W> ParallelArray<T> replaceWithMapping(Ops.BinaryOp<? super T, ? super V, ? extends T> combiner, ParallelArrayWithMapping<W, V> other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public ParallelArray<T> replaceWithMapping(Ops.BinaryOp<T, T, T> combiner, T[] other) {
        super.replaceWithMapping(combiner, other);
        return this;
    }

    @Override
    public int indexOf(T target) {
        return super.indexOf(target);
    }

    @Override
    public int binarySearch(T target) {
        return super.binarySearch(target);
    }

    @Override
    public int binarySearch(T target, Comparator<? super T> comparator) {
        return super.binarySearch(target, comparator);
    }

    @Override
    public SummaryStatistics<T> summary(Comparator<? super T> comparator) {
        return super.summary(comparator);
    }

    @Override
    public SummaryStatistics<T> summary() {
        return super.summary();
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        return super.min(comparator);
    }

    @Override
    public T min() {
        return (T)super.min();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        return super.max(comparator);
    }

    @Override
    public T max() {
        return (T)super.max();
    }

    @Override
    public ParallelArray<T> cumulate(Ops.Reducer<T> reducer, T base) {
        super.cumulate(reducer, base);
        return this;
    }

    @Override
    public T precumulate(Ops.Reducer<T> reducer, T base) {
        return super.precumulate(reducer, base);
    }

    @Override
    public ParallelArray<T> sort(Comparator<? super T> comparator) {
        super.sort(comparator);
        return this;
    }

    @Override
    public ParallelArray<T> sort() {
        super.sort();
        return this;
    }

    @Override
    public ParallelArray<T> allUniqueElements() {
        return super.allUniqueElements();
    }

    @Override
    public ParallelArray<T> allNonidenticalElements() {
        return super.allNonidenticalElements();
    }

    public ParallelArray<T> removeAll(Ops.Predicate<? super T> selector) {
        AbstractParallelAnyArray.OFPap<? super T> v = new AbstractParallelAnyArray.OFPap<T>(this.ex, 0, this.fence, this.array, selector);
        PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(v, 0, this.fence);
        this.ex.invoke(f);
        this.removeSlotsAt(f.offset, this.fence);
        return this;
    }

    @Override
    public <U, V> boolean hasAllEqualElements(ParallelArrayWithMapping<U, V> other) {
        return super.hasAllEqualElements(other);
    }

    @Override
    public <U, V> boolean hasAllIdenticalElements(ParallelArrayWithMapping<U, V> other) {
        return super.hasAllIdenticalElements(other);
    }

    public ParallelArray<T> removeConsecutiveDuplicates() {
        int k = 0;
        int n = this.fence;
        Object[] arr = this.array;
        Object last = null;
        for (int i = k; i < n; ++i) {
            Object x = arr[i];
            if (x == null || last != null && last.equals(x)) continue;
            arr[k++] = last = x;
        }
        this.removeSlotsAt(k, n);
        return this;
    }

    public ParallelArray<T> removeNulls() {
        int k = 0;
        int n = this.fence;
        Object[] arr = this.array;
        for (int i = k; i < n; ++i) {
            Object x = arr[i];
            if (x == null) continue;
            arr[k++] = x;
        }
        this.removeSlotsAt(k, n);
        return this;
    }

    public ParallelArray<T> addAll(T[] other) {
        int csize = other.length;
        int end = this.fence;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
        return this;
    }

    public <V> ParallelArray<T> addAll(ParallelArrayWithMapping<V, T> other) {
        int end = this.fence;
        if (other.hasFilter()) {
            PAS.FJOAppendAllDriver r = new PAS.FJOAppendAllDriver(other, end, this.array);
            this.ex.invoke(r);
            this.array = r.results;
            this.fence = end + r.resultSize;
        } else {
            int csize = other.size();
            this.insertSlotsAt(end, csize);
            if (other.hasMap()) {
                this.ex.invoke(new PAS.FJOMap(other, other.origin, other.fence, null, this.array, end - other.origin));
            } else {
                System.arraycopy(other.array, 0, this.array, end, csize);
            }
        }
        return this;
    }

    @Override
    public ParallelArrayWithBounds<T> withBounds(int firstIndex, int upperBound) {
        return super.withBounds(firstIndex, upperBound);
    }

    @Override
    public ParallelArrayWithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
        return super.withFilter(selector);
    }

    @Override
    public <V, W> ParallelArrayWithFilter<T> withFilter(Ops.BinaryPredicate<? super T, ? super V> selector, ParallelArrayWithMapping<W, V> other) {
        return super.withFilter(selector, other);
    }

    @Override
    public ParallelArrayWithFilter<T> withIndexedFilter(Ops.IntAndObjectPredicate<? super T> selector) {
        return super.withIndexedFilter(selector);
    }

    @Override
    public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.Op<? super T, ? extends U> op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super T> op) {
        return super.withMapping(op);
    }

    @Override
    public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super T> op) {
        return super.withMapping(op);
    }

    @Override
    public <U, V, W> ParallelArrayWithMapping<T, V> withMapping(Ops.BinaryOp<? super T, ? super U, ? extends V> combiner, ParallelArrayWithMapping<W, U> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.ObjectAndDoubleToObject<? super T, ? extends V> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.ObjectAndLongToObject<? super T, ? extends V> combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <U, W> ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectAndObjectToDouble<? super T, ? super U> combiner, ParallelArrayWithMapping<W, U> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectAndDoubleToDouble<? super T> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectAndLongToDouble<? super T> combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <U, W> ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectAndObjectToLong<? super T, ? super U> combiner, ParallelArrayWithMapping<W, U> other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectAndDoubleToLong<? super T> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectAndLongToLong<? super T> combiner, ParallelLongArrayWithLongMapping other) {
        return super.withMapping(combiner, other);
    }

    @Override
    public <U> ParallelArrayWithMapping<T, U> withIndexedMapping(Ops.IntAndObjectToObject<? super T, ? extends U> mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super T> mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super T> mapper) {
        return super.withIndexedMapping(mapper);
    }

    @Override
    public Iterator<T> iterator() {
        return new ParallelArrayIterator<Object>(this.array, this.fence);
    }

    public List<T> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    @Override
    public int size() {
        return this.fence;
    }

    public T get(int i) {
        return (T)this.array[i];
    }

    public void set(int i, T x) {
        this.array[i] = x;
    }

    public T[] getArray() {
        return this.array;
    }

    public String toString() {
        return this.asList().toString();
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.fence = newLimit;
    }

    final void replaceElementsWith(T[] a) {
        System.arraycopy(a, 0, this.array, 0, a.length);
        this.fence = a.length;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            Class<?> elementType = this.array.getClass().getComponentType();
            Object[] a = (Object[])Array.newInstance(elementType, newCap);
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, T e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(T e) {
        int hi;
        if ((hi = this.fence++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.fence + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.fence) {
            System.arraycopy(this.array, index, this.array, index + len, this.fence - index);
        }
        this.fence = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.fence - index - 1);
        this.array[--this.fence] = null;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.fence;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.fence = newSize = size - (toIndex - fromIndex);
            while (size > newSize) {
                this.array[--size] = null;
            }
        }
    }

    final int seqIndexOf(Object target) {
        Object[] arr = this.array;
        int end = this.fence;
        if (target == null) {
            for (int i = 0; i < end; ++i) {
                if (arr[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < end; ++i) {
                if (!target.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    final int seqLastIndexOf(Object target) {
        Object[] arr = this.array;
        int last = this.fence - 1;
        if (target == null) {
            for (int i = last; i >= 0; --i) {
                if (arr[i] != null) continue;
                return i;
            }
        } else {
            for (int i = last; i >= 0; --i) {
                if (!target.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsList
    extends AbstractList<T>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public T get(int i) {
            if (i >= ParallelArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelArray.this.array[i];
        }

        @Override
        public T set(int i, T x) {
            if (i >= ParallelArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            Object[] arr = ParallelArray.this.array;
            Object t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelArray.this.fence == 0;
        }

        @Override
        public int size() {
            return ParallelArray.this.fence;
        }

        @Override
        public Iterator<T> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            if (index < 0 || index > ParallelArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(T e) {
            ParallelArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, T e) {
            if (index < 0 || index > ParallelArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            ParallelArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelArray.this.fence;
            ParallelArray.this.setLimit(hi + csize);
            Object[] arr = ParallelArray.this.array;
            for (Object e : c) {
                arr[hi++] = e;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            if (index < 0 || index > ParallelArray.this.fence) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelArray.this.insertSlotsAt(index, csize);
            Object[] arr = ParallelArray.this.array;
            for (Object e : c) {
                arr[index++] = e;
            }
            return true;
        }

        @Override
        public void clear() {
            Object[] arr = ParallelArray.this.array;
            for (int i = 0; i < ParallelArray.this.fence; ++i) {
                arr[i] = null;
            }
            ParallelArray.this.fence = 0;
        }

        @Override
        public boolean remove(Object o) {
            int idx = ParallelArray.this.seqIndexOf(o);
            if (idx < 0) {
                return false;
            }
            ParallelArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public T remove(int index) {
            Object oldValue = this.get(index);
            ParallelArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            ParallelArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            return ParallelArray.this.seqIndexOf(o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            return ParallelArray.this.seqIndexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ParallelArray.this.seqLastIndexOf(o);
        }

        @Override
        public Object[] toArray() {
            int len = ParallelArray.this.fence;
            Object[] a = new Object[len];
            System.arraycopy(ParallelArray.this.array, 0, a, 0, len);
            return a;
        }

        @Override
        public <V> V[] toArray(V[] a) {
            int len = ParallelArray.this.fence;
            if (a.length < len) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, len);
            }
            System.arraycopy(ParallelArray.this.array, 0, a, 0, len);
            if (a.length > len) {
                a[len] = null;
            }
            return a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ListIter
    implements ListIterator<T> {
        int cursor;
        int lastRet;
        T[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelArray.this.array;
            this.hi = ParallelArray.this.fence;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public T next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            Object next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelArray.this.removeSlotAt(k);
            this.hi = ParallelArray.this.fence;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public T previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            Object previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(T e) {
            int i = this.cursor;
            ParallelArray.this.insertElementAt(i, e);
            this.arr = ParallelArray.this.array;
            this.hi = ParallelArray.this.fence;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParallelArrayIterator<T>
    implements Iterator<T> {
        int cursor;
        final T[] arr;
        final int hi;

        ParallelArrayIterator(T[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public T next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SummaryStatistics<T> {
        public int size();

        public T min();

        public T max();

        public int indexOfMin();

        public int indexOfMax();
    }
}

