/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.Comparator;
import jsr166y.forkjoin.AbstractParallelAnyArray;
import jsr166y.forkjoin.CommonOps;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelArrayWithMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithLongMapping;
import jsr166y.forkjoin.ParallelLongArrayWithLongMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelDoubleArrayWithMapping<U>
extends AbstractParallelAnyArray.DPap {
    ParallelDoubleArrayWithMapping(ForkJoinExecutor ex, int origin, int fence, double[] array) {
        super(ex, origin, fence, array);
    }

    public void apply(Ops.Procedure<? super U> procedure) {
        this.ex.invoke(new PAS.FJOApply(this, this.origin, this.fence, null, procedure));
    }

    public U reduce(Ops.Reducer<U> reducer, U base) {
        PAS.FJOReduce f = new PAS.FJOReduce(this, this.origin, this.fence, null, reducer, base);
        this.ex.invoke(f);
        return (U)f.result;
    }

    public U any() {
        int i = this.anyIndex();
        return (U)(i < 0 ? null : this.oget(i));
    }

    public U min(Comparator<? super U> comparator) {
        return this.reduce(CommonOps.minReducer(comparator), null);
    }

    public U min() {
        return this.reduce(CommonOps.castedMinReducer(), null);
    }

    public U max(Comparator<? super U> comparator) {
        return this.reduce(CommonOps.maxReducer(comparator), null);
    }

    public U max() {
        return this.reduce(CommonOps.castedMaxReducer(), null);
    }

    public ParallelArray.SummaryStatistics<U> summary(Comparator<? super U> comparator) {
        PAS.FJOStats f = new PAS.FJOStats(this, this.origin, this.fence, null, comparator);
        this.ex.invoke(f);
        return f;
    }

    public ParallelArray.SummaryStatistics<U> summary() {
        return this.summary(CommonOps.castedComparator());
    }

    public ParallelArray<U> all() {
        return new ParallelArray<Object>(this.ex, this.allObjects(null));
    }

    public ParallelArray<U> all(Class<? super U> elementType) {
        return new ParallelArray<Object>(this.ex, this.allObjects(elementType));
    }

    public abstract <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> var1);

    public abstract ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> var1);

    public abstract ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> var1);

    public <V, W, X> ParallelDoubleArrayWithMapping<W> withMapping(Ops.BinaryOp<? super U, ? super V, ? extends W> combiner, ParallelArrayWithMapping<X, V> other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.ObjectAndDoubleToObject<? super U, ? extends V> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.ObjectAndLongToObject<? super U, ? extends V> combiner, ParallelLongArrayWithLongMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public <V, W> ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectAndObjectToDouble<? super U, ? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectAndDoubleToDouble<? super U> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectAndLongToDouble<? super U> combiner, ParallelLongArrayWithLongMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public <V, W> ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectAndObjectToLong<? super U, ? super V> combiner, ParallelArrayWithMapping<W, V> other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectAndDoubleToLong<? super U> combiner, ParallelDoubleArrayWithDoubleMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectAndLongToLong<? super U> combiner, ParallelLongArrayWithLongMapping other) {
        if (other.hasFilter()) {
            throw new IllegalArgumentException();
        }
        return this.withIndexedMapping(AbstractParallelAnyArray.indexedMapper(combiner, other, this.origin));
    }

    public abstract <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> var1);

    public abstract ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> var1);

    public abstract ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> var1);

    public Iterable<U> sequentially() {
        return new AbstractParallelAnyArray.Sequentially();
    }
}

