/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.util.ArrayList;
import java.util.List;

public class MultiGenericParser
extends GenericParser {
    private List<Parser> parsers = new ArrayList<Parser>(3);

    public MultiGenericParser(HapiContext hapiContext) {
        super(hapiContext);
        this.parsers.add((Parser)new PipeParser());
        this.parsers.add((Parser)new DefaultXMLParser());
    }

    public void addParser(Parser parser) {
        this.parsers.add(parser);
    }

    public void setPrimaryParser(Class<? extends Parser> clazz) {
        Parser parser = null;
        for (Parser parser2 : this.parsers) {
            if (!clazz.equals(parser2.getClass())) continue;
            parser = parser2;
            break;
        }
        if (parser != null) {
            this.parsers.remove(parser);
            this.parsers.add(0, parser);
        }
    }

    private Parser getParserForMessage(String string) throws HL7Exception {
        return this.getParserForEncoding(this.getEncoding(string));
    }

    private Parser getParserForEncoding(String string) throws HL7Exception {
        for (Parser parser : this.parsers) {
            if (!parser.getDefaultEncoding().equals(string)) continue;
            return parser;
        }
        throw new HL7Exception("Can't find appropriate parser - encoding not recognized: " + string);
    }

    public void setValidationContext(ValidationContext validationContext) {
        super.setValidationContext(validationContext);
        if (this.parsers != null) {
            for (Parser parser : this.parsers) {
                parser.setValidationContext(validationContext);
            }
        }
    }

    public String getEncoding(String string) {
        for (Parser parser : this.parsers) {
            String string2 = parser.getEncoding(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.parsers.get(0).getDefaultEncoding();
    }

    public boolean supportsEncoding(String string) {
        for (Parser parser : this.parsers) {
            if (!parser.supportsEncoding(string)) continue;
            return true;
        }
        return false;
    }

    public Segment getCriticalResponseData(String string) throws HL7Exception {
        return this.getParserForMessage(string).getCriticalResponseData(string);
    }

    public String getAckID(String string) {
        try {
            return this.getParserForMessage(string).getAckID(string);
        }
        catch (HL7Exception hL7Exception) {
            return null;
        }
    }

    public String getVersion(String string) throws HL7Exception {
        return this.getParserForMessage(string).getVersion(string);
    }

    protected String doEncode(Message message, String string) throws HL7Exception {
        Parser parser = this.getParserForEncoding(string);
        if (parser != null) {
            return parser.doEncode(message, string);
        }
        throw new EncodingNotSupportedException("The encoding " + string + " is not supported by " + ((Object)((Object)this)).getClass().getName());
    }

    protected String doEncode(Message message) throws HL7Exception {
        return this.parsers.get(0).doEncode(message);
    }

    public String doEncode(Segment segment, EncodingCharacters encodingCharacters) throws HL7Exception {
        return this.parsers.get(0).doEncode(segment, encodingCharacters);
    }

    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        return this.parsers.get(0).doEncode(type, encodingCharacters);
    }

    protected Message doParse(String string, String string2) throws HL7Exception {
        return this.getParserForMessage(string).doParse(string, string2);
    }

    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        this.parsers.get(0).parse(type, string, encodingCharacters);
    }

    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        this.parsers.get(0).parse(segment, string, encodingCharacters);
    }

    public void parse(Message message, String string) throws HL7Exception {
        this.parsers.get(0).parse(message, string);
    }

    protected Message doParseForSpecificPackage(String string, String string2, String string3) throws HL7Exception {
        return this.parsers.get(0).doParseForSpecificPackage(string, string2, string3);
    }

    public Message parse(String string) throws HL7Exception {
        Message message = super.parse(string);
        Parser parser = this.getParserForMessage(string);
        message.setParser(parser);
        return message;
    }

    @Deprecated
    public static GenericParser getInstanceWithNoValidation() {
        return new MultiGenericParser((HapiContext)new DefaultHapiContext(ValidationContextFactory.noValidation()));
    }
}

