/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestinationUIFactory;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.g;
import com.mimvista.d;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.j;
import com.mimvista.mui.MIMJFrame;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.BasicComboBoxModel;
import com.mimvista.swing.BasicListModel;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.co;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ArchiveUpgrader
extends MIMJFrame {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JPanel cards;
    private CardLayout cardLayout;
    private BasicListModel<SearchSource> archiveModel;
    private JList<SearchSource> archiveList;
    private a state;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> upgradeFuture;
    private JLabel archiveFolderLabel;
    private JProgressBar archiveFolderProgress;
    private JLabel monthFolderLabel;
    private JProgressBar monthFolderProgress;
    private JLabel seriesFolderLabel;
    private JEditorPane continueText;
    private boolean repairCancelled;
    private CardPanel introPanel = new CardPanel("intro"){
        private static final long serialVersionUID = 1L;

        @Override
        public void a() {
            ArchiveUpgrader.this.a(null, ArchiveUpgrader.b("ARCHIVE_UPGRADER_NEXT"));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public void c() {
            if (ArchiveUpgrader.this.t()) {
                ArchiveUpgrader.this.r();
                ArchiveUpgrader.this.a(ArchiveUpgrader.this.continuePanel);
            } else {
                ArchiveUpgrader.this.a(ArchiveUpgrader.this.inputPanel);
            }
        }
    };
    private CardPanel continuePanel = new CardPanel("continue"){
        private static final long serialVersionUID = 1L;

        @Override
        public void a() {
            StringBuilder stringBuilder = new StringBuilder("<ul>");
            for (String string : ((ArchiveUpgrader)ArchiveUpgrader.this).state.a) {
                stringBuilder.append("<li>").append(string).append("</li>");
            }
            stringBuilder.append("</ul>");
            String string = MIMFormat.a(ArchiveUpgrader.b("ARCHIVE_UPGRADER_CONTINUE_DESC_HTML"), stringBuilder.toString());
            ArchiveUpgrader.this.continueText.setText(string);
            ArchiveUpgrader.this.a(ArchiveUpgrader.b("ARCHIVE_UPGRADER_NEW_REPAIR"), ArchiveUpgrader.b("ARCHIVE_UPGRADER_PREV_REPAIR"));
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public void e() {
            ArchiveUpgrader.this.state = null;
            ArchiveUpgrader.this.a(ArchiveUpgrader.this.inputPanel);
        }

        @Override
        public void c() {
            ArchiveUpgrader.this.j();
            ArchiveUpgrader.this.a(ArchiveUpgrader.this.progressPanel);
        }
    };
    private CardPanel inputPanel = new CardPanel("input"){
        private static final long serialVersionUID = 1L;

        @Override
        public void a() {
            ArchiveUpgrader.this.a(ArchiveUpgrader.b("ARCHIVE_UPGRADER_BACK"), ArchiveUpgrader.b("ARCHIVE_UPGRADER_START_REPAIR"));
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean b() {
            return !ArchiveUpgrader.this.archiveModel.d().isEmpty();
        }

        @Override
        public void e() {
            ArchiveUpgrader.this.a(ArchiveUpgrader.this.introPanel);
        }

        @Override
        public void c() {
            List list = ArchiveUpgrader.this.archiveModel.d();
            if (list.isEmpty()) {
                return;
            }
            ArchiveUpgrader.this.state = new a();
            ((ArchiveUpgrader)ArchiveUpgrader.this).state.a = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                SearchSource searchSource = (SearchSource)list.get(i2);
                if (searchSource instanceof LocalSearchSource) {
                    ((ArchiveUpgrader)ArchiveUpgrader.this).state.a[i2] = PathUtils.getCanonicalOrAbsolutePath(((LocalSearchSource)searchSource).a());
                    continue;
                }
                if (!(searchSource instanceof RemoteSearchSource)) continue;
                ((ArchiveUpgrader)ArchiveUpgrader.this).state.a[i2] = PathUtils.getCanonicalOrAbsolutePath(((RemoteSearchSource)searchSource).y().n());
            }
            ArchiveUpgrader.this.q();
            ArchiveUpgrader.this.j();
            ArchiveUpgrader.this.a(ArchiveUpgrader.this.progressPanel);
        }
    };
    private CardPanel progressPanel = new CardPanel("progress"){
        private static final long serialVersionUID = 1L;

        @Override
        public void a() {
            ArchiveUpgrader.this.a(ArchiveUpgrader.b("ARCHIVE_UPGRADER_CANCEL_REPAIR"), ArchiveUpgrader.b("ARCHIVE_UPGRADER_CLOSE"));
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public void e() {
            ArchiveUpgrader.this.backButton.setEnabled(false);
            ArchiveUpgrader.this.o();
            ArchiveUpgrader.this.backButton.setEnabled(true);
            ArchiveUpgrader.this.a(ArchiveUpgrader.this.inputPanel);
        }

        @Override
        public void c() {
            ArchiveUpgrader.this.dispose();
        }
    };
    private CardPanel currentCard;
    private JPanel navigationPanel;
    private JButton backButton;
    private JButton nextButton;

    private static String b(String string) {
        return Messages.a("Archive", string);
    }

    public ArchiveUpgrader(@d Component component) {
        super("ARCHIVE UPGRADER");
        this.a();
        this.setTitle(ArchiveUpgrader.b("ARCHIVE_UPGRADER_TITLE"));
        this.c();
        this.setDefaultCloseOperation(2);
        this.setSize(700, 550);
        this.setLocationRelativeTo(component);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ArchiveUpgrader.this.w();
            }
        });
    }

    private void a() {
        if (!com.mimvista.metabase.j.a().a(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("The metabase is not running correctly.  You should not run a archive repair without a properly functioning metabase.  Please check the admin service to make sure it's running and not logging errors.");
        }
    }

    private void a(CardPanel cardPanel) {
        this.cardLayout.show(this.cards, cardPanel.f());
        this.currentCard = cardPanel;
        this.b();
    }

    private void b() {
        this.currentCard.a();
        this.backButton.setEnabled(this.currentCard.d());
        this.nextButton.setEnabled(this.currentCard.b());
    }

    private void a(String string, String string2) {
        this.backButton.setVisible(string != null);
        if (string != null) {
            this.backButton.setText(string);
        }
        this.nextButton.setVisible(string2 != null);
        if (string2 != null) {
            this.nextButton.setText(string2);
        }
    }

    private void c() {
        this.mainPanel = new JPanel(new BorderLayout());
        ArchiveUpgrader.a(this.mainPanel, 10);
        this.mainPanel.add(this.e(), "Center");
        this.mainPanel.add(this.d(), "South");
        this.a(this.introPanel);
        this.setContentPane(this.mainPanel);
    }

    private Component d() {
        this.navigationPanel = new JPanel(new BorderLayout());
        ArchiveUpgrader.a(this.navigationPanel, 5, 0, 0, 0);
        this.backButton = new JButton("");
        this.backButton.add(Box.createRigidArea(new Dimension(100, 30)));
        this.backButton.addActionListener(actionEvent -> this.currentCard.e());
        this.navigationPanel.add((Component)ArchiveUpgrader.b(this.backButton, null, null), "West");
        this.nextButton = new JButton("");
        this.nextButton.add(Box.createRigidArea(new Dimension(100, 30)));
        this.nextButton.addActionListener(actionEvent -> this.currentCard.c());
        this.navigationPanel.add((Component)ArchiveUpgrader.b(this.nextButton, null, null), "East");
        return this.navigationPanel;
    }

    private Component e() {
        this.cardLayout = new CardLayout();
        this.cards = new JPanel(this.cardLayout);
        ArchiveUpgrader.a(this.cards, 0, 0, 5, 0);
        this.cards.add(this.f(), this.introPanel.f());
        this.cards.add(this.g(), this.continuePanel.f());
        this.cards.add(this.h(), this.inputPanel.f());
        this.cards.add(this.i(), this.progressPanel.f());
        return this.cards;
    }

    private Component f() {
        this.introPanel.setLayout(new BorderLayout());
        JEditorPane jEditorPane = new JEditorPane("text/html", ArchiveUpgrader.b("ARCHIVE_UPGRADER_INTRO_DESC_HTML"));
        jEditorPane.setEditable(false);
        this.introPanel.add((Component)jEditorPane, "Center");
        return this.introPanel;
    }

    private Component g() {
        this.continuePanel.setLayout(new BorderLayout());
        this.continueText = new JEditorPane();
        this.continueText.setContentType("text/html");
        this.continueText.setEditable(false);
        this.continuePanel.add((Component)this.continueText, "Center");
        return this.continuePanel;
    }

    private Component h() {
        this.inputPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(ArchiveUpgrader.b("ARCHIVE_UPGRADER_ARCHIVE_FOLDERS_LABEL"));
        ArchiveUpgrader.a(jLabel, 0, 0, 5, 0);
        this.inputPanel.add((Component)jLabel, "North");
        this.archiveModel = new BasicComboBoxModel<SearchSource>(new SearchSource[0]);
        this.archiveModel.setSelectionMode(2);
        this.archiveList = new JList<SearchSource>(this.archiveModel);
        this.archiveList.setSelectionModel(this.archiveModel);
        this.archiveList.setFixedCellHeight(30);
        this.archiveList.setCellRenderer(new SendToDestinationUIFactory.SourceOrDestListCellRenderer(){
            private static final long serialVersionUID = 1L;
            {
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
                if (object instanceof RemoteSearchSource) {
                    RemoteSearchSource remoteSearchSource = (RemoteSearchSource)object;
                    if (remoteSearchSource.y().d() == null) {
                        this.label.setText(remoteSearchSource.y().n());
                    } else {
                        this.label.setText(remoteSearchSource.y().d() + " - " + remoteSearchSource.y().n());
                    }
                } else if (object instanceof LocalSearchSource) {
                    LocalSearchSource localSearchSource = (LocalSearchSource)object;
                    LocalSearchSource localSearchSource2 = g.d();
                    if (localSearchSource.equals(localSearchSource2)) {
                        this.label.setText(localSearchSource2.j());
                    } else {
                        this.label.setText(localSearchSource.j() + " - " + localSearchSource.a());
                    }
                }
                return this;
            }
        });
        this.archiveList.setAlignmentX(0.0f);
        this.archiveList.addListSelectionListener(listSelectionEvent -> this.b());
        this.v();
        this.inputPanel.add(this.archiveList, "Center");
        return this.inputPanel;
    }

    private Component i() {
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ArchiveUpgrader.b("ARCHIVE_UPGRADER_ARCHIVE_FOLDER")), BorderFactory.createEmptyBorder(5, 10, 10, 10)));
        this.archiveFolderLabel = new JLabel();
        this.archiveFolderLabel.setAlignmentX(0.0f);
        this.archiveFolderProgress = new JProgressBar(0, 100);
        this.archiveFolderProgress.setAlignmentX(0.0f);
        JPanel jPanel = ArchiveUpgrader.b((Component)this.archiveFolderProgress, null, (Integer)25);
        jPanel.setAlignmentX(0.0f);
        box.add(this.archiveFolderLabel);
        box.add(jPanel);
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ArchiveUpgrader.b("ARCHIVE_UPGRADER_MONTH_FOLDER")), BorderFactory.createEmptyBorder(5, 10, 10, 10)));
        this.monthFolderLabel = new JLabel();
        this.monthFolderLabel.setAlignmentX(0.0f);
        this.monthFolderProgress = new JProgressBar(0, 100);
        this.monthFolderProgress.setAlignmentX(0.0f);
        this.seriesFolderLabel = new JLabel();
        this.seriesFolderLabel.setAlignmentX(0.0f);
        jPanel = ArchiveUpgrader.b((Component)this.monthFolderProgress, null, (Integer)25);
        jPanel.setAlignmentX(0.0f);
        box2.add(this.monthFolderLabel);
        box2.add(jPanel);
        box2.add(this.seriesFolderLabel);
        this.progressPanel.add(ArchiveUpgrader.c(box, null, 100));
        this.progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.progressPanel.add(ArchiveUpgrader.c(box2, null, 100));
        this.progressPanel.add(Box.createVerticalGlue());
        return this.progressPanel;
    }

    private synchronized void j() {
        if (this.upgradeFuture != null && !this.upgradeFuture.isDone()) {
            return;
        }
        this.upgradeFuture = this.executor.submit(() -> {
            try {
                long l2 = System.currentTimeMillis();
                this.repairCancelled = false;
                ay.b((Object)("ARCHIVE UPGRADER: Starting an archive repair for " + Arrays.toString(this.state.a)), this);
                this.k();
                ay.b((Object)("ARCHIVE UPGRADER: Archive repair completed in " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - l2), (String)"H'h':m'm':s.S's'")), this);
            }
            catch (InterruptedException interruptedException) {
                ay.b((Object)"Archive repair cancelled", this);
                this.q();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error during repair", throwable, this);
            }
        });
    }

    private void k() throws InterruptedException {
        int n2 = 0;
        if (this.state.b != null) {
            n2 = Arrays.asList(this.state.a).indexOf(this.state.b);
        }
        while (n2 < this.state.a.length) {
            this.state.b = this.state.a[n2];
            this.n();
            this.a(this.archiveFolderLabel, this.state.b);
            this.l();
            ++n2;
            this.state.b = null;
        }
        this.s();
        this.p();
    }

    private void l() throws InterruptedException {
        File file = new File(this.state.b);
        if (this.state.c == null || this.state.d == null) {
            List<File> list = MIMFile.a(file, j.d);
            this.state.c = Lists.transform(list, File::getName).toArray(new String[0]);
            this.state.d = null;
        }
        int n2 = 0;
        if (this.state.d != null && (n2 = Arrays.asList(this.state.c).indexOf(this.state.d)) < 0) {
            n2 = 0;
        }
        this.a(this.archiveFolderProgress, n2, this.state.c.length);
        while (n2 < this.state.c.length) {
            this.state.d = this.state.c[n2];
            this.n();
            this.a(this.monthFolderLabel, this.state.d);
            this.m();
            this.state.d = null;
            this.a(this.archiveFolderProgress, ++n2, this.state.c.length);
        }
        this.state.c = null;
    }

    private void m() throws InterruptedException {
        File file = Path.joinFile(this.state.b, this.state.d);
        if (this.state.e == null || this.state.f == null) {
            List<File> list = MIMFile.a(file, j.f);
            this.state.e = Lists.transform(list, File::getName).toArray(new String[0]);
            this.state.f = null;
        }
        int n2 = 0;
        if (this.state.f != null && (n2 = Arrays.asList(this.state.e).indexOf(this.state.f)) < 0) {
            n2 = 0;
        }
        this.a(this.monthFolderProgress, n2, this.state.e.length);
        com.mimvista.archive.d d2 = new com.mimvista.archive.d();
        while (n2 < this.state.e.length) {
            this.state.f = this.state.e[n2];
            this.n();
            this.a(this.seriesFolderLabel, this.state.f);
            d2.a((Progress)o.o(), Path.joinFile(file, this.state.f));
            this.state.f = null;
            this.a(this.monthFolderProgress, ++n2, this.state.e.length);
        }
        this.state.e = null;
    }

    private void n() throws InterruptedException {
        co.a();
        if (this.repairCancelled) {
            throw new InterruptedException("Repair cancelled via boolean flag");
        }
    }

    private synchronized void o() {
        if (this.upgradeFuture != null) {
            this.repairCancelled = true;
            this.upgradeFuture.cancel(true);
            try {
                this.upgradeFuture.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error waiting for the repair future to return", throwable, this);
            }
            this.upgradeFuture = null;
        }
    }

    private void a(JLabel jLabel, String string) {
        SwingUtilities.invokeLater(() -> jLabel.setText(string));
    }

    private void a(JProgressBar jProgressBar, int n2, int n3) {
        SwingUtilities.invokeLater(() -> {
            if (jProgressBar.getMaximum() != n3) {
                jProgressBar.setMaximum(n3);
            }
            jProgressBar.setValue(n2);
        });
    }

    private void p() {
        SwingUtilities.invokeLater(() -> {
            this.backButton.setText(ArchiveUpgrader.b("ARCHIVE_UPGRADER_BACK"));
            this.nextButton.setEnabled(true);
        });
    }

    private void q() {
        try {
            File file = this.u();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writeValue(this.u(), (Object)this.state);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error while saving state", throwable, this);
        }
    }

    private void r() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.state = (a)objectMapper.readValue(this.u(), a.class);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error while restoring state", throwable, this);
        }
    }

    private void s() {
        this.u().delete();
    }

    private boolean t() {
        return this.u().isFile();
    }

    private File u() {
        return Path.joinFile(Path.getMiscDataPath(), "archive-repair", "state.json");
    }

    private void v() {
        block2: {
            MIMpacsConfig.PacsType pacsType;
            block3: {
                this.archiveModel.clear();
                this.archiveModel.addAll((Collection<SearchSource>)g.e());
                pacsType = MIMpacsConfig.h();
                if (MIMpacsConfig.PacsType.a(pacsType)) break block2;
                if (pacsType != MIMpacsConfig.PacsType.b) break block3;
                for (RemoteSearchSource remoteSearchSource : g.k()) {
                    this.archiveModel.add(remoteSearchSource);
                }
                break block2;
            }
            if (pacsType != MIMpacsConfig.PacsType.a) break block2;
            for (File file : MIMpacsConfig.e()) {
                RemotePatientListInfo remotePatientListInfo = new RemotePatientListInfo();
                remotePatientListInfo.g(file.getAbsolutePath());
                this.archiveModel.add(new RemoteSearchSource(remotePatientListInfo));
            }
        }
    }

    private void w() {
        if (this.upgradeFuture != null && !this.upgradeFuture.isDone()) {
            this.upgradeFuture.cancel(true);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void a(JComponent jComponent, int n2) {
        ArchiveUpgrader.a(jComponent, n2, n2, n2, n2);
    }

    private static void a(JComponent jComponent, int n2, int n3, int n4, int n5) {
        Border border = BorderFactory.createEmptyBorder(n2, n3, n4, n5);
        Border border2 = jComponent.getBorder();
        if (border2 != null) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(border, border2));
        } else {
            jComponent.setBorder(border);
        }
    }

    private static JPanel a(Component component, Integer n2, Integer n3) {
        return ArchiveUpgrader.a(component, n2, n3, null, null, null, null);
    }

    private static JPanel b(Component component, Integer n2, Integer n3) {
        return ArchiveUpgrader.a(component, null, null, n2, n3, null, null);
    }

    private static JPanel c(Component component, Integer n2, Integer n3) {
        return ArchiveUpgrader.a(component, null, null, null, null, n2, n3);
    }

    private static JPanel a(final Component component, final Integer n2, final Integer n3, final Integer n4, final Integer n5, final Integer n6, final Integer n7) {
        return new JPanel(){
            private static final long serialVersionUID = 1L;
            {
                this.setLayout(new BorderLayout());
                this.add(component, "Center");
            }

            @Override
            public Dimension getMinimumSize() {
                if (n2 != null && n3 != null) {
                    return new Dimension(n2, n3);
                }
                return this.a(super.getMinimumSize(), n2, n3);
            }

            @Override
            public Dimension getPreferredSize() {
                if (n4 != null && n5 != null) {
                    return new Dimension(n4, n5);
                }
                return this.a(super.getPreferredSize(), n4, n5);
            }

            @Override
            public Dimension getMaximumSize() {
                if (n6 != null && n7 != null) {
                    return new Dimension(n6, n7);
                }
                return this.a(super.getMaximumSize(), n6, n7);
            }

            private Dimension a(Dimension dimension, Integer n22, Integer n32) {
                if (n22 != null) {
                    dimension.width = n22;
                }
                if (n32 != null) {
                    dimension.height = n32;
                }
                return dimension;
            }
        };
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MIMContext.a(MIMContext.MIMType.a);
                    UIManager.setLookAndFeel(new MIMLookAndFeel());
                    ArchiveUpgrader archiveUpgrader = new ArchiveUpgrader(null);
                    archiveUpgrader.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            m.a(500L, 3000L);
                        }
                    });
                    archiveUpgrader.setVisible(true);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"", throwable, this);
                }
            }
        });
    }

    private static class a {
        public String[] a;
        public String b;
        public String[] c;
        public String d;
        public String[] e;
        public String f;

        private a() {
        }
    }

    private abstract class CardPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String cardName;

        public CardPanel(String string) {
            this.cardName = string;
        }

        public String f() {
            return this.cardName;
        }

        public void a() {
        }

        public boolean b() {
            return false;
        }

        public boolean d() {
            return false;
        }

        public void c() {
        }

        public void e() {
        }
    }
}

