/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.MetaCache;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.MIMpacsServer;
import com.mimvista.archive.s;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.ImageOrientation;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.reffinder.StudyFinder;
import com.mimvista.dicom.util.DicomDataHelper;
import com.mimvista.dicom.util.DicomDiff;
import com.mimvista.dicom.util.DicomRLEDecompressor;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.j;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.n;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.MetabasePrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mongodb.MongoException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

@ExternallyVisible
public class Archiver {
    public static final String DICOM_FILE_EXTENSION = ".dcm";
    public static final int MAX_FILENAME_LENGTH = 255;
    public static final int DEFAULT_ZASH_DIGITS = 5;
    public static final ImmutableSet<String> SOP_CLASSES_THAT_COULD_BE_MULTIFRAME = ImmutableSet.builder().add((Object)"1.2.840.10008.5.1.4.1.1.3.1").add((Object)"1.2.840.10008.5.1.4.1.1.20").add((Object)"1.2.840.10008.5.1.4.1.1.2.1").add((Object)"1.2.840.10008.5.1.4.1.1.4.1").build();
    private static final String a = "EmbedTmp";
    private static Messages b = Messages.a("Archive");
    private static ExecutorService c = Executors.newSingleThreadExecutor();

    public static File createNewArchiveDirectory(String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, File file) {
        String string8 = Archiver.getArchiveFolderNameNoZash(string, string2, string3, string4, string5, n2, string6, string7);
        if (string8 == null) {
            return null;
        }
        return Archiver.createNewArchiveDirectory(string4, file, string8);
    }

    public static File createNewArchiveDirectory(String string, File file, String string2) {
        String string3 = StudyFinder.dateToMonthFolder(string);
        File file2 = new File(file, string3);
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                ay.d((Object)"Non-directory file exists at desired month dir location!", Archiver.class);
                return null;
            }
        } else {
            file2.mkdirs();
            if (!file2.exists()) {
                ay.d((Object)"Unable to create month dir.  Permission issue?", Archiver.class);
                return null;
            }
        }
        return Archiver.createNewDirWithPrefixByFakeZashin(file2, string2, 5);
    }

    public static File createNewDirWithPrefixByFakeZashin(File file, String string, int n2) {
        block6: {
            double d2;
            int n3 = 0;
            int n4 = 0;
            do {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = Integer.toHexString(n3);
                for (int i2 = 0; i2 < n2 - string2.length(); ++i2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
                File file2 = new File(file, string + stringBuilder.toString().toUpperCase());
                if (!file2.exists()) {
                    if (file2.mkdirs()) {
                        return file2;
                    }
                    if (!file2.exists()) {
                        ++n4;
                    } else {
                        ay.a((Object)"Another archiver beat us to the punch... continuing.", Archiver.class);
                    }
                }
                if (n4 <= 5) continue;
                ay.d((Object)("Unable to create archive dir: " + file2.getAbsolutePath() + " There is probably a permissions issue."), Archiver.class);
                break block6;
            } while (!((double)(++n3) > (d2 = Math.pow(16.0, n2) - 1.0)));
            ay.d((Object)(d2 + " dirs with the same prefix??  Aborting."), Archiver.class);
        }
        return null;
    }

    public static String getArchiveFolderNameNoZash(String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7) {
        if (n2 < 1) {
            n2 = 1;
        }
        String string8 = String.valueOf(n2);
        String string9 = string4.substring(0, 4) + "-" + string4.substring(4, 6) + "-" + string4.substring(6, 8);
        String string10 = PathUtils.safeFilename(string6, true, true);
        String string11 = PathUtils.safeFilename(string7, true, true);
        String string12 = PathUtils.safeFilename(string, true, true) + "_" + PathUtils.safeFilename(string2, true, true) + "_" + Archiver.a(string3) + "_" + string9 + "_" + string5 + "_";
        String string13 = string12 + string10 + "_" + string11 + "_n" + string8 + "__";
        if (string13.length() + 5 > 255 && string11.length() > 5) {
            string13 = string12 + string10 + "_" + string11.substring(0, 5) + "..._n" + string8 + "__";
        }
        if (string13.length() + 5 > 255 && string10.length() > 5) {
            string13 = string12 + string10.substring(0, 5) + "..._" + string11 + "_n" + string8 + "__";
        }
        if (string13.length() + 5 > 255 && string11.length() > 5 && string10.length() > 5) {
            string13 = string12 + string10.substring(0, 5) + "..._" + string11.substring(0, 5) + "..._n" + string8 + "__";
        }
        if (string13.length() + 5 > 255) {
            ay.d((Object)("Generated folder name is too long to be accessed: " + string13), Archiver.class);
            return null;
        }
        return string13;
    }

    public static String getFolderNameNoZash(File file) {
        return Archiver.parseInfoFromDicom(file).a();
    }

    public static c parseInfoFromDicom(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + file);
        }
        if (file.isFile()) {
            return Archiver.getInfoForSingleFile(Archiver.a(file, true));
        }
        return Archiver.getInfoFromFolderContents(Archiver.b(file, true));
    }

    public static c getInfoFromFolderContents(Iterable<d> iterable) {
        c c2 = Archiver.a(iterable);
        return c2;
    }

    public static c getInfoForSingleFile(d d2) {
        c c2 = Archiver.a(Lists.newArrayList((Object[])new d[]{d2}));
        if (c2.a == null) {
            return null;
        }
        return c2;
    }

    private static c a(Iterable<d> iterable) {
        String[] stringArray;
        c c2 = new c();
        d d2 = (d)Iterables.get(iterable, (int)0);
        DicomObject dicomObject = d2.e;
        c2.a = dicomObject.getString(0x100010, " ");
        if (!c2.a.isEmpty() && c2.a.charAt(c2.a.length() - 1) == '\u0000') {
            c2.a = c2.a.substring(0, c2.a.length() - 1);
        }
        c2.a = NameFormatter.a(c2.a, dicomObject, true);
        c2.b = dicomObject.getString(0x100020);
        c2.c = dicomObject.getString(524384);
        String[] stringArray2 = RawDicomUtils.getDateAndTimeForDataset(dicomObject);
        c2.d = stringArray2[0];
        c2.e = stringArray2[1];
        c2.f = PathUtils.safeFilename(dicomObject.getString(528446), false);
        c2.g = PathUtils.safeFilename(dicomObject.getString(528432), false);
        if (DicomReader.isMIMSession(dicomObject)) {
            c2.c = "SESSION";
        }
        if ((stringArray = dicomObject.getStrings(2097207)) == null || stringArray.length != 6) {
            ay.c((Object)("Can not get Image Orientation Tag from the dicom file: " + d2.d), SeriesIdentifier.class);
            stringArray = null;
        } else {
            try {
                c2.l = new ImageOrientation(stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)"Image Orientation is not valid: ", (Throwable)numberFormatException, SeriesIdentifier.class);
            }
        }
        c2.i = dicomObject.getString(524310);
        c2.j = dicomObject.getString(0x20000E);
        c2.k = dicomObject.getString(524312);
        c2.h = Archiver.countNumberOfImages(c2, iterable);
        return c2;
    }

    public static int countNumberOfImages(c c2, Iterable<d> iterable) {
        int n2 = 0;
        for (d d2 : iterable) {
            if (SOP_CLASSES_THAT_COULD_BE_MULTIFRAME.contains((Object)c2.i)) {
                int n3 = d2.e.getInt(0x280008, -1);
                if (n3 >= 1) {
                    n2 += n3;
                    continue;
                }
                ++n2;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private static String a(String string) {
        if ("RTSTRUCT".equals(string)) {
            return "RTst";
        }
        return string;
    }

    public static void copySeries(String[] stringArray, File file, File file2, String string, MIMFile.a a2) throws IOException {
        if (file2.equals(file)) {
            ay.b((Object)"Don't need to do actual copying since source directory is identical with destination directory", Archiver.class);
        } else {
            for (File file3 : file.listFiles()) {
                if (file3.getName().toLowerCase().endsWith(".bak")) {
                    ay.b((Object)"Don't copy bak file in series directoy", Archiver.class);
                    a2.a(file3.getName());
                    a2.a((int)file3.length());
                    continue;
                }
                MIMFile.a(file3, new File(file2, file3.getName()), a2);
            }
        }
        Archiver.postSeriesArchived(file2);
    }

    public static b archiveSeries(File file, File file2) throws IOException {
        return Archiver.archiveSeries(file, file2, true);
    }

    public static b archiveSeries(File file, File file2, boolean bl2) throws IOException {
        return Archiver.archiveSeries(file, file2, null, bl2, new o());
    }

    public static b archiveSeries(File file, File file2, boolean bl2, Progress progress) throws IOException {
        return Archiver.archiveSeries(file, file2, null, bl2, progress);
    }

    public static b archiveSeries(File file, File file2, Iterable<d> iterable, boolean bl2, Progress progress) throws IOException {
        Archiver.a(file, file2);
        b b2 = new b();
        b2.b = PathUtils.getCanonicalOrAbsoluteFile(file);
        b2.a = file2;
        b2.c = bl2;
        b2.d = progress;
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("Not a valid folder: " + file2);
        }
        if (iterable == null) {
            iterable = Archiver.b(file2, true);
        }
        Archiver.a(b2, iterable);
        if (bl2 && !new MIMFile(file2).delete()) {
            ay.c((Object)("ARCHIVER: Unable to delete the incoming series folder: " + file2), Archiver.class);
        }
        for (File file3 : b2.g) {
            ay.b((Object)("ARCHIVER: Deleting unused series folder: " + file3), Archiver.class);
            Archiver.deleteSeriesFolder(file3);
        }
        return b2;
    }

    private static d a(File file, boolean bl2) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a valid file: " + file);
        }
        DicomReader.FilteredTagInputHandler filteredTagInputHandler = new DicomReader.FilteredTagInputHandler();
        filteredTagInputHandler.setSkipLargePrivateTags(1024);
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, new DicomReader.StopBeforeContentInputHandler(2145386512, filteredTagInputHandler));
        if (dicomObject != null) {
            return new d(new MIMFile(file), dicomObject, bl2);
        }
        return null;
    }

    private static Collection<d> b(File file, boolean bl2) {
        if (!file.isDirectory()) {
            d d2 = Archiver.a(file, bl2);
            if (d2 != null) {
                return Lists.newArrayList((Object[])new d[]{d2});
            }
            return Lists.newArrayList();
        }
        ArrayList arrayList = Lists.newArrayList();
        Object[] objectArray = file.listFiles(j.b);
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                d d3 = Archiver.a((File)object, bl2);
                if (d3 == null) continue;
                arrayList.add(d3);
            }
        }
        return arrayList;
    }

    private static void a(b b2, Iterable<d> iterable) throws IOException {
        ay.b((Object)("ARCHIVER: Archiving new series files from: " + b2.a.getAbsolutePath()), Archiver.class);
        Multimap<Object, d> multimap = new f().a(iterable);
        ay.b((Object)("ARCHIVER: Found " + multimap.keySet().size() + " series in the incoming folder"), Archiver.class);
        for (Object e2 : multimap.keySet()) {
            Object object3;
            if (b2.d.n() == Progress.Status.e) {
                return;
            }
            ArrayList arrayList = Lists.newArrayList();
            a a2 = new a(b2);
            a2.b.addAll(multimap.get(e2));
            List<d> list = Archiver.d(a2);
            a2.b.addAll(list);
            try {
                if (list.isEmpty()) {
                    arrayList.add(a2);
                    b2.a(a2);
                    Archiver.a(a2);
                } else {
                    object3 = new f().a(a2.b);
                    if (object3.keySet().size() == 1) {
                        arrayList.add(a2);
                        b2.a(a2);
                        Archiver.a(a2);
                    } else {
                        for (File file : object3.keySet()) {
                            Object object = new a(b2);
                            ((a)object).b.addAll(object3.get((Object)file));
                            ((a)object).d.addAll(a2.d);
                            arrayList.add(object);
                            b2.a((a)object);
                            Archiver.a((a)object);
                        }
                    }
                }
            }
            catch (Progress.CancelledException cancelledException) {
                for (File file : a2.e) {
                    if (Archiver.a(file, a2.b)) continue;
                    if (new MIMFile(file).delete()) {
                        ay.c((Object)("Due to cancelling current archival, deleted series folder " + file.getAbsolutePath()), Archiver.class);
                        continue;
                    }
                    ay.d((Object)("Failed to delet series folder caused by cancelling current archival: " + file.getAbsolutePath()), Archiver.class);
                }
                return;
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Series folders that were already in the archive:");
            for (File file : a2.c.keySet()) {
                ((StringBuilder)object3).append("\n\t").append(file);
            }
            ay.b(object3, Archiver.class);
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Series folders that the archiver just used:");
            for (a a3 : arrayList) {
                for (File file : a3.e) {
                    ((StringBuilder)object3).append("\n\t");
                    ((StringBuilder)object3).append(file);
                }
            }
            ay.b(object3, Archiver.class);
            HashSet hashSet = Sets.newHashSet((Iterable)a2.c.keySet());
            for (Object object : arrayList) {
                for (File file : ((a)object).e) {
                    hashSet.remove(file);
                    b2.g.remove(file);
                }
            }
            b2.g.addAll(hashSet);
        }
    }

    private static void a(a a2) throws IOException {
        if (!ArchivePrefs.enableSmartArchive.getValue().booleanValue()) {
            ay.b((Object)"ARCHIVER: Using the simple archiver", Archiver.class);
            Archiver.b(a2);
        } else {
            ay.b((Object)"ARCHIVER: Using the smart archiver", Archiver.class);
            Archiver.c(a2);
        }
    }

    private static void b(a a2) throws IOException {
        final Progress progress = a2.a.d;
        progress.b_(b.getProperty("ARCHIVE_GENERATE_NAME"));
        progress.a(true);
        File file = Archiver.a(a2, a2.b);
        if (file == null) {
            throw new IOException("ARCHIVER: Cannot get folder name");
        }
        long l2 = 0L;
        for (d d2 : a2.b) {
            l2 += d2.d.length();
        }
        if (progress.n() == Progress.Status.e) {
            if (!Archiver.a(file, a2.b)) {
                if (new MIMFile(file).delete()) {
                    ay.c((Object)("Due to cancelling current archival, deleted series folder " + file.getAbsolutePath()), Archiver.class);
                } else {
                    ay.d((Object)("Failed to delet series folder caused by cancelling current archival: " + file.getAbsolutePath()), Archiver.class);
                }
            }
            throw new Progress.CancelledException();
        }
        final long l3 = l2;
        MIMFile.a a3 = new MIMFile.a(){
            private long c = 0L;

            @Override
            public void a(int n2) {
                this.c += (long)n2;
                progress.b((int)((float)(this.c * 100L) / (float)l3));
            }

            @Override
            public void a(String string) {
                progress.b_(b.getProperty("SERIES_ARCHIVE_COPY") + string);
            }

            @Override
            public boolean a(Exception exception, MIMFile mIMFile, MIMFile mIMFile2) {
                exception.printStackTrace();
                return false;
            }
        };
        progress.a(false);
        for (d d3 : a2.b) {
            MIMFile mIMFile = new MIMFile(file, d3.e.getString(524312) + DICOM_FILE_EXTENSION);
            if (mIMFile.equals(d3.d)) {
                a3.a((int)d3.d.length());
                continue;
            }
            if (a2.a.c) {
                MIMFile.b(d3.d, mIMFile, a3);
            } else {
                MIMFile.a(d3.d, (File)mIMFile, a3);
            }
            if (progress.n() != Progress.Status.e) continue;
            if (!Archiver.a(file, a2.b)) {
                if (new MIMFile(file).delete()) {
                    ay.c((Object)("Due to cancelling current archival, deleted series folder " + file.getAbsolutePath()), Archiver.class);
                } else {
                    ay.d((Object)("Failed to delet series folder caused by cancelling current archival: " + file.getAbsolutePath()), Archiver.class);
                }
            }
            throw new Progress.CancelledException();
        }
        a2.e.add(PathUtils.getCanonicalOrAbsoluteFile(file));
        progress.b_(b.getProperty("ARCHIVE_POST_PROCESS"));
        Archiver.postSeriesArchived(file);
    }

    private static boolean a(File file, Iterable<d> iterable) {
        for (d d2 : iterable) {
            if (!file.equals(d2.d.getParentFile())) continue;
            return true;
        }
        return false;
    }

    private static void c(a a2) throws IOException {
        a2.a.d.b_(b.getProperty("ARCHIVE_SPLIT_SERIES"));
        a2.a.d.a(true);
        DicomObject dicomObject = a2.b.get((int)0).e;
        String string = dicomObject.getString(524310);
        if (com.mimvista.archive.b.a(string)) {
            for (d d2 : Archiver.b(a2.b)) {
                Archiver.b(a2, Lists.newArrayList((Object[])new d[]{d2}));
            }
            return;
        }
        Archiver.b(a2, a2.b);
    }

    private static List<d> d(a a2) {
        Object object;
        Object object2;
        File file;
        if (!ArchivePrefs.enableSmartArchive.getValue().booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        com.mimvista.metabase.e e2 = Archiver.b();
        if (e2 != null && e2.a(0L, TimeUnit.SECONDS)) {
            boolean bl2;
            file = ((d)Iterables.get(a2.b, (int)0)).e;
            object2 = file.getString(0x20000E);
            object = file.getString(524310);
            MetabaseQuery metabaseQuery = n.a().c(MetabaseKeys.fromTag(0x20000E), object2).c(MetabaseKeys.fromTag(524310), object).f("mimdata.folders").f("mimdata.patientLists");
            File file2 = a2.a.b;
            boolean bl3 = bl2 = MimpacsPrefs.lastRunPacsType.getValue() == MIMpacsConfig.PacsType.a && MIMpacsServer.isArchiveFolder(file2);
            if (bl2) {
                com.mimvista.metabase.b.b(metabaseQuery);
            } else {
                com.mimvista.metabase.b.b(metabaseQuery, file2.getAbsolutePath());
            }
            List<? extends Series> list = metabaseQuery.a(e2);
            for (Series series : list) {
                boolean bl4 = false;
                for (String string : series.getFolders()) {
                    File file3 = new File(string);
                    if (file3.equals(a2.a.a)) {
                        a2.c.putAll((Object)file3, a2.b);
                        bl4 = true;
                        continue;
                    }
                    if (!file3.isDirectory()) continue;
                    ArrayList arrayList2 = Lists.newArrayList();
                    for (File file4 : MIMFile.a(file3, j.b)) {
                        d d2 = Archiver.a(file4, false);
                        if (d2 == null || !d2.e.getString(0x20000E).equals(object2) || !d2.e.getString(524310).equals(object)) continue;
                        arrayList2.add(d2);
                    }
                    if (arrayList2.isEmpty()) continue;
                    bl4 = true;
                    a2.c.putAll((Object)file3, (Iterable)arrayList2);
                    arrayList.addAll(arrayList2);
                }
                if (!bl4) continue;
                a2.d.addAll(series.getPatientLists());
            }
        }
        file = a2.a.b;
        object2 = a2.a.a;
        object = ((File)object2).getParentFile();
        if (object != null && j.f.accept((File)object2) && j.d.accept((File)object) && file.equals(((File)object).getParentFile())) {
            arrayList.addAll(a2.b);
            a2.c.putAll(object2, a2.b);
        }
        return arrayList;
    }

    private static void a(File file, File file2) throws FileNotFoundException {
        if (!file.exists()) {
            ay.d((Object)("Archive Path " + file + " doesn't exist"), Archiver.class);
            throw new FileNotFoundException("Archive Path " + file + " doesn't exist");
        }
        if (!file.isDirectory()) {
            ay.d((Object)("Archive Path " + file + " is not a folder"), Archiver.class);
            throw new FileNotFoundException("Archive Path " + file + " is not a folder");
        }
        if (!file2.exists()) {
            ay.d((Object)("Series Path " + file2 + " doesn't exist"), Archiver.class);
            throw new FileNotFoundException("Series Path " + file2 + " doesn't exist");
        }
        if (!file2.isDirectory()) {
            ay.d((Object)("Series Path " + file2 + " is not a folder"), Archiver.class);
            throw new FileNotFoundException("Series Path " + file2 + " is not a folder");
        }
    }

    private static List<d> b(Iterable<d> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        Multimap<Object, d> multimap = new g().a(iterable);
        for (Object e2 : multimap.keySet()) {
            ArrayList arrayList2 = Lists.newArrayList((Iterable)multimap.get(e2));
            Collections.sort(arrayList2, new Comparator<d>(){

                public int a(d d2, d d3) {
                    if (d2.f != d3.f) {
                        return d2.f ? -1 : 1;
                    }
                    return Long.valueOf(d2.d.lastModified()).compareTo(d3.d.lastModified());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((d)object, (d)object2);
                }
            });
            d d2 = (d)arrayList2.get(0);
            arrayList.add(d2);
        }
        return arrayList;
    }

    private static File a(a a2, Iterable<d> iterable) {
        c c2 = Archiver.getInfoFromFolderContents(iterable);
        return Archiver.a(a2, c2, iterable);
    }

    private static File a(a a2, c c2, Iterable<d> iterable) {
        String string = c2.a();
        if (string == null) {
            return null;
        }
        for (File file : a2.c.keySet()) {
            if (!file.getName().startsWith(string) || Archiver.isMarkedForDeletion(file)) continue;
            Collection collection = a2.c.get((Object)file);
            HashSet hashSet = Sets.newHashSet((Iterable)Iterables.transform((Iterable)collection, d.a));
            for (d d2 : iterable) {
                hashSet.remove(d.a.apply((Object)d2));
            }
            if (!hashSet.isEmpty()) continue;
            return file;
        }
        return c2.a(a2.a.b, string);
    }

    private static void b(a a2, Iterable<d> iterable) throws IOException {
        Progress progress = a2.a.d;
        progress.b_(b.getProperty("ARCHIVE_GENERATE_NAME"));
        List<d> list = Archiver.b(iterable);
        File file = Archiver.a(a2, list);
        if (progress.n() == Progress.Status.e) {
            if (!Archiver.a(file, a2.b)) {
                if (new MIMFile(file).delete()) {
                    ay.c((Object)("Due to cancelling current archival, deleted series folder " + file.getAbsolutePath()), Archiver.class);
                } else {
                    ay.d((Object)("Failed to delet series folder caused by cancelling current archival: " + file.getAbsolutePath()), Archiver.class);
                }
            }
            throw new Progress.CancelledException();
        }
        progress.a(false);
        progress.b(0);
        progress.a(list.size());
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Couldn't create destination series folder: " + file);
        }
        for (d d2 : list) {
            progress.b_(b.getProperty("SERIES_ARCHIVE_PROCESS") + d2.d);
            Archiver.a(a2, d2, file);
            progress.N_();
            if (progress.n() != Progress.Status.e) continue;
            if (new MIMFile(file).delete()) {
                ay.c((Object)("Due to cancelling current archival, deleted series folder " + file.getAbsolutePath()), Archiver.class);
            } else {
                ay.d((Object)("Failed to delet series folder caused by cancelling current archival: " + file.getAbsolutePath()), Archiver.class);
            }
            throw new Progress.CancelledException();
        }
        try {
            d d2;
            MetaCache metaCache = new MetaCache();
            metaCache.a(new Date());
            Archiver.a(metaCache, Iterables.transform(list, d.b));
            d2 = ((d)list.stream().findAny().get()).e;
            String string = d2.getString(0x20000E);
            String string2 = d2.getString(s.c());
            a2.f = new UniqueSeriesPointer(string, metaCache.e());
            a2.g = string2;
            metaCache.d(file);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Unable to write MetaCache for series: " + file), throwable, Archiver.class);
        }
        a2.e.add(PathUtils.getCanonicalOrAbsoluteFile(file));
        progress.b_(b.getProperty("ARCHIVE_POST_PROCESS"));
        Archiver.postSeriesArchived(file);
    }

    private static void a(MetaCache metaCache, Iterable<DicomObject> iterable) {
        int[] nArray = Ints.toArray(DicomDiff.topLevelDiff(iterable));
        for (DicomObject dicomObject : iterable) {
            String string = dicomObject.getString(524312);
            Map<Object, Object> map = null;
            map = nArray.length == 0 ? Maps.newLinkedHashMap() : DicomDataHelper.convertToJsonMap(dicomObject.subSet(nArray), MetabasePrefs.maxdicomtagvaluewidth.getValue(), MetabasePrefs.maxdicomsequencelength.getValue(), MetabasePrefs.getDicomTagsToIgnore(), MetabasePrefs.getDicomTagPathsToNotIgnore(), MetabasePrefs.getDicomTagsThatShouldNotBeTruncated());
            metaCache.a(string, map);
            if (!dicomObject.contains(1253456)) continue;
            DicomElement dicomElement = dicomObject.get(1253456);
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                MetaCache metaCache2 = new MetaCache();
                Archiver.a(metaCache2, Arrays.asList(dicomObject2));
                metaCache.a(metaCache2);
            }
        }
    }

    private static void a(a a2, d d2, File file) throws IOException {
        File file2 = new File(file, d2.e.getString(524312) + DICOM_FILE_EXTENSION);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Couldn't create destination series folder");
        }
        if (Archiver.a(d2)) {
            File file3 = new File(file, "uncompressed_" + d2.d.getName());
            DicomJpegDecompressor.decompressFile(d2.d, file3);
            MIMFile.b(file3, file2);
            MIMFile.g(file2);
        } else if (Archiver.b(d2)) {
            File file4 = new File(file, "uncompressed_" + d2.d.getName());
            DicomRLEDecompressor.decompressFile(d2.d, file4);
            MIMFile.b(file4, file2);
            MIMFile.g(file2);
        } else if (!d2.d.equals(file2)) {
            if (a2.a.c && d2.f && d2.d.renameTo(file2)) {
                MIMFile.g(file2);
                return;
            }
            MIMFile.a(d2.d, file2);
        }
    }

    private static boolean a(d d2) {
        if (!ArchivePrefs.decompressDicomFiles.getValue().booleanValue()) {
            return false;
        }
        return DicomJpegDecompressor.isJpegCompressed(d2.e.getString(131088));
    }

    private static boolean b(d d2) {
        if (!ArchivePrefs.decompressDicomFiles.getValue().booleanValue()) {
            return false;
        }
        return DicomRLEDecompressor.isRLECompressed(d2.e);
    }

    private static com.mimvista.metabase.e b() {
        if (!(MIMContext.i() || MIMContext.k() || MIMContext.n())) {
            return com.mimvista.metabase.j.a();
        }
        return null;
    }

    public static void postSeriesArchived(File file) {
        MIMFile.f(file);
    }

    public static Set<File> archiveIntoImporterTemp(DcmSeries dcmSeries, Progress progress) {
        List<File> list = dcmSeries.getFiles();
        File file = list != null && list.size() > 0 ? dcmSeries.getFiles().get(0).getParentFile() : new File(Archiver.getDirContainingSeriesFiles(dcmSeries, true));
        try {
            b b2 = Archiver.archiveSeries(new File(Path.getImporterTempPath()), file, false, progress);
            Set<File> set = b2.a();
            File file2 = (File)Iterables.get(set, (int)0);
            dcmSeries.setLocalDir(file2.getAbsolutePath());
            dcmSeries.setArchiveDir(file2.getAbsolutePath());
            return set;
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, Archiver.class);
            return null;
        }
    }

    public static String getDirContainingSeriesFiles(DcmSeries dcmSeries) {
        return Archiver.getDirContainingSeriesFiles(dcmSeries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDirContainingSeriesFiles(DcmSeries dcmSeries, boolean bl2) {
        if (dcmSeries.isEmbedded()) {
            MIMFile mIMFile = new MIMFile(PathUtils.getTempPath(a, true, true));
            MIMFile mIMFile2 = new MIMFile(mIMFile, "unpack");
            MIMFile mIMFile3 = new MIMFile(mIMFile, "arch");
            mIMFile2.mkdirs();
            mIMFile3.mkdirs();
            LoaderDataProvider loaderDataProvider = dcmSeries.getDataProvider();
            for (String string : loaderDataProvider.getFilenames()) {
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = loaderDataProvider.getStream(string);
                    MIMFile mIMFile4 = new MIMFile(mIMFile2, string);
                    fileOutputStream = new FileOutputStream(mIMFile4);
                    cm.a(inputStream, fileOutputStream);
                }
                catch (Exception exception) {
                    String string2;
                    try {
                        ay.d((Object)"Failed to extract embedded DICOM...", (Throwable)exception, Archiver.class);
                        string2 = null;
                    }
                    catch (Throwable throwable) {
                        cm.a((Closeable)inputStream, null, null);
                        cm.a(fileOutputStream, null, null);
                        throw throwable;
                    }
                    cm.a((Closeable)inputStream, null, null);
                    cm.a((Closeable)fileOutputStream, null, null);
                    return string2;
                }
                cm.a((Closeable)inputStream, null, null);
                cm.a((Closeable)fileOutputStream, null, null);
            }
            try {
                b b2 = Archiver.archiveSeries(mIMFile3, mIMFile2);
                return ((File)Iterables.get(b2.a(), (int)0)).getAbsolutePath();
            }
            catch (Exception exception) {
                ay.d((Object)"Error.", (Throwable)exception, DcmSeries.class);
                return mIMFile2.getAbsolutePath();
            }
        }
        if (dcmSeries.getLocalDir() != null) {
            return dcmSeries.getLocalDir();
        }
        if (!bl2) {
            return dcmSeries.getArchiveDir();
        }
        return null;
    }

    public static boolean cleanTempDirForEmbeddedSeries(String string) {
        final MIMFile mIMFile = Archiver.getEmbeddedSeriesRootIfAvailable(string);
        if (mIMFile != null) {
            c.execute(new Runnable(){

                @Override
                public void run() {
                    mIMFile.delete();
                }
            });
            return true;
        }
        return false;
    }

    public static MIMFile getEmbeddedSeriesRootIfAvailable(String string) {
        if (!string.contains(a)) {
            return null;
        }
        MIMFile mIMFile = new MIMFile(string);
        while (!mIMFile.getName().startsWith(a)) {
            if ((mIMFile = mIMFile.g()) != null) continue;
            return null;
        }
        return mIMFile;
    }

    public static void deleteSeriesFolder(File file) {
        Object object;
        if (!MIMFile.a(file)) {
            ay.c((Object)("ARCHIVER: Unable to delete series folder: " + file + " - marking folder for deletion"), Archiver.class);
            if (!Archiver.a(file)) {
                ay.c((Object)"ARCHIVER: Couldn't mark series folder for deletion - scheduling it to be deleted on exit", Archiver.class);
                new MIMFile(file).a();
            }
        } else {
            String[] stringArray;
            object = file.getParentFile();
            if (object != null && ((File)object).getName().toLowerCase().endsWith("__studies") && (stringArray = ((File)object).list()) != null && stringArray.length == 0) {
                ((File)object).delete();
            }
        }
        if ((object = Archiver.b()) != null) {
            try {
                object.a(file);
            }
            catch (MongoException mongoException) {
                ay.d((Object)("Couldn't remove metabase entry for series: " + file), (Throwable)mongoException, Archiver.class);
            }
        }
    }

    public static boolean isMarkedForDeletion(File file) {
        return new File(file, "~reapme~").isFile();
    }

    private static boolean a(File file) {
        File file2 = new File(file, "~reapme~");
        MIMFile.f(file2);
        return file2.exists();
    }

    private static class g
    extends e<d> {
        private g() {
        }

        @Override
        public Object a(d d2) {
            return d2.e.getString(524312);
        }
    }

    private static class f
    extends e<d> {
        private f() {
        }

        @Override
        public Object a(d d2) {
            StringBuilder stringBuilder = new StringBuilder().append(d2.e.getString(0x20000E));
            String[] stringArray = ArchivePrefs.additionalMergeTags.getValue();
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    stringBuilder.append(" ").append(string).append("=");
                    try {
                        int n2 = TagUtils.forTagName(string);
                        String string2 = d2.e.getString(n2);
                        if (string2 == null) continue;
                        stringBuilder.append(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return stringBuilder.toString();
        }
    }

    private static abstract class e<T> {
        private e() {
        }

        public Multimap<Object, T> a(Iterable<T> iterable) {
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            for (T t2 : iterable) {
                Object object = this.a(t2);
                if (object == null) continue;
                linkedHashMultimap.put(object, t2);
            }
            return linkedHashMultimap;
        }

        public abstract Object a(T var1);
    }

    public static class a {
        public b a;
        public List<d> b = Lists.newArrayList();
        public Multimap<File, d> c = HashMultimap.create();
        public Set<String> d = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        public Set<File> e = Sets.newHashSet();
        public UniqueSeriesPointer f = null;
        public String g = null;

        public a(b b2) {
            this.a = b2;
        }
    }

    public static class b {
        public File a;
        public File b;
        public boolean c;
        public Progress d = new o();
        public List<d> e = Lists.newArrayList();
        public List<a> f = Lists.newArrayList();
        public Set<File> g = Sets.newHashSet();

        public b() {
        }

        public b(b b2) {
            this.a = b2.a;
            this.b = b2.b;
            this.c = b2.c;
            this.d = b2.d;
        }

        public void a(a a2) {
            this.f.add(a2);
            a2.a = this;
        }

        public Set<File> a() {
            if (this.f.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet hashSet = Sets.newHashSet();
            for (a a2 : this.f) {
                hashSet.addAll(a2.e);
            }
            return hashSet;
        }
    }

    public static class d {
        public static final Function<d, String> a = new Function<d, String>(){

            public String a(d d2) {
                return d2.e.getString(524312);
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((d)object);
            }
        };
        public static final Function<d, DicomObject> b = new Function<d, DicomObject>(){

            public DicomObject a(d d2) {
                return d2.e;
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((d)object);
            }
        };
        public static final Function<d, File> c = new Function<d, File>(){

            public File a(d d2) {
                return d2.d;
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((d)object);
            }
        };
        public File d;
        public DicomObject e;
        public boolean f = false;

        public d(File file, DicomObject dicomObject, boolean bl2) {
            this.d = file;
            this.e = dicomObject;
            this.f = bl2;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("filename", (Object)this.d).add("incoming", this.f).toString();
        }

        public int hashCode() {
            return this.d.hashCode() << 1 | (this.f ? 1 : 0);
        }

        public boolean equals(Object object) {
            if (!(object instanceof d)) {
                return false;
            }
            d d2 = (d)object;
            return this.d.equals(d2.d) && this.f == d2.f;
        }
    }

    @Deprecated
    public static class c {
        public String a = null;
        public String b = null;
        public String c = null;
        public String d = null;
        public String e = null;
        public String f = null;
        public String g = null;
        public int h = -1;
        public String i = null;
        public String j = null;
        public String k = null;
        public ImageOrientation l = null;

        public String a() {
            return Archiver.getArchiveFolderNameNoZash(this.a, this.b, this.c, this.d, this.e, this.h, this.g, this.f);
        }

        public File a(File file, String string) {
            return Archiver.createNewArchiveDirectory(this.d, file, string);
        }
    }
}

