/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mimvista.d;
import com.mimvista.dicom.SeriesEqualityHasher;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.json.b;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String a = "metacache.mim";
    private File fileOnDisk;
    private Map<String, Map<String, Object>> sops = Maps.newTreeMap();
    private List<MetaCache> children = Lists.newArrayList();
    private VersionNumber mimVersion = VersionNumber.rawCurrentVersionNotAccountingForMIMviewer();
    private Date archiveDate;
    private String equalityHash;

    @d
    public File a() {
        return this.fileOnDisk;
    }

    public VersionNumber b() {
        return this.mimVersion;
    }

    public void a(Map<String, Map<String, Object>> map) {
        this.sops.clear();
        if (map != null) {
            this.sops.putAll(map);
        }
        this.f();
    }

    public void b(Map<String, Map<String, Object>> map) {
        if (map != null && !map.isEmpty()) {
            this.sops.putAll(map);
            this.f();
        }
    }

    public void a(String string, @d Map<String, Object> map) {
        Preconditions.checkNotNull((Object)string);
        this.sops.put(string, map);
        this.f();
    }

    public Set<String> c() {
        return Collections.unmodifiableSet(this.sops.keySet());
    }

    public void a(MetaCache metaCache) {
        this.children.add(metaCache);
    }

    public MetaCache a(int n2) {
        return this.children.get(n2);
    }

    @d
    public Map<String, Object> a(String string) {
        return this.sops == null ? null : this.sops.get(string);
    }

    public void a(Date date) {
        this.archiveDate = (Date)date.clone();
    }

    public Date d() {
        return this.archiveDate;
    }

    public String e() {
        return this.equalityHash;
    }

    public static boolean a(File file) {
        return new File(file, a).isFile();
    }

    @d
    public static MetaCache b(File file) throws IOException {
        File file2 = new File(file, a);
        if (file2.isFile()) {
            return MetaCache.c(file2);
        }
        return null;
    }

    public static MetaCache c(File file) throws IOException {
        String string = Files.toString((File)file, (Charset)Charsets.UTF_8);
        Map map = (Map)b.a(string);
        MetaCache metaCache = MetaCache.c(map);
        metaCache.fileOnDisk = file;
        return metaCache;
    }

    public void d(File file) throws IOException {
        this.e(new File(file, a));
    }

    public void e(File file) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            bufferedWriter.write(b.a(MetaCache.b(this)));
            this.fileOnDisk = file;
        }
    }

    private static Map<String, Object> b(MetaCache metaCache) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        linkedHashMap.put("mimVersion", metaCache.mimVersion.getFullVersionString());
        linkedHashMap.put("archiveDate", metaCache.archiveDate);
        linkedHashMap.put("equalityHash", metaCache.equalityHash);
        linkedHashMap.put("sops", metaCache.sops);
        if (!metaCache.children.isEmpty()) {
            ArrayList arrayList = Lists.newArrayList();
            for (MetaCache metaCache2 : metaCache.children) {
                arrayList.add(MetaCache.b(metaCache2));
            }
            linkedHashMap.put("children", arrayList);
        }
        return linkedHashMap;
    }

    private static MetaCache c(Map<String, Object> map) {
        MetaCache metaCache = new MetaCache();
        metaCache.mimVersion = new VersionNumber((String)map.get("mimVersion"));
        metaCache.archiveDate = (Date)map.get("archiveDate");
        metaCache.equalityHash = (String)map.get("equalityHash");
        metaCache.sops.putAll((Map)map.get("sops"));
        if (map.containsKey("children")) {
            List list = (List)map.get("children");
            for (Map map2 : list) {
                metaCache.children.add(MetaCache.c(map2));
            }
        }
        return metaCache;
    }

    private void f() {
        this.equalityHash = this.sops == null || this.sops.isEmpty() ? null : SeriesEqualityHasher.hashSopUidStrings(this.sops.keySet()).toString();
    }
}

