/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.ArchiveNotFoundException;
import com.mimvista.archive.gui.StudyGroupingType;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.search.AbstractLocalSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.b;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.DcmStudyFactory;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.reffinder.StudyFinder;
import com.mimvista.file.PathUtils;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.cm;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class PlainLocalSearchSource
extends AbstractLocalSearchSource {
    private static final long serialVersionUID = 1L;
    protected String directory;

    public PlainLocalSearchSource(String string, String string2) {
        this.type = 1;
        this.sourceName = string;
        this.directory = string2;
    }

    public String a() {
        return this.directory;
    }

    public void a(String string) {
        this.directory = string;
    }

    @Override
    public String a(DcmSeries dcmSeries, Progress progress) {
        String string = dcmSeries.getArchiveDir();
        dcmSeries.setLocalDir(string);
        return string;
    }

    @Override
    public LoaderDataProvider a(DcmSeries dcmSeries) {
        if (dcmSeries.getFiles() == null) {
            dcmSeries.setFiles(Arrays.asList(new File(dcmSeries.getRealParentDirectory()).listFiles()));
        }
        return this.b(dcmSeries);
    }

    protected LoaderDataProvider b(DcmSeries dcmSeries) {
        return PlainLocalSearchSource.c(dcmSeries);
    }

    private void a(final Map<String, String> map, f<i> f2, SearchSource searchSource, final Searchable.a a2) {
        bg.b("PlainLocalSearchSource.performSearch");
        Progress progress = f2.getSearchProgress();
        progress.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                a2.a();
            }
        });
        try {
            final AtomicReference atomicReference = new AtomicReference();
            final AtomicReference atomicReference2 = new AtomicReference();
            final b b2 = new b(this.a());
            b2.a(progress);
            Thread thread = new Thread("Archive Search Thread"){

                @Override
                public void run() {
                    try {
                        atomicReference.set(b2.a(map, a2));
                    }
                    catch (ArchiveNotFoundException archiveNotFoundException) {
                        atomicReference2.set(archiveNotFoundException);
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error during archive search", throwable, PlainLocalSearchSource.this);
                    }
                }
            };
            thread.start();
            if (a2.b()) {
                return;
            }
            this.a(thread, f2.getSearchTimeout(), progress, a2);
            if (a2.b()) {
                return;
            }
            if (atomicReference2.get() != null) {
                throw (ArchiveNotFoundException)atomicReference2.get();
            }
            List list = atomicReference.get() != null ? (List)atomicReference.get() : Lists.newArrayListWithCapacity((int)0);
            if (a2.b()) {
                return;
            }
            Progress progress2 = f2.getSearchProgress();
            progress2.a(Messages.a("PatientList", "GROUPING_RESULTS_BY") + " " + StudyGroupingType.f().b());
            progress2.a(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    a2.a();
                }
            });
            List<DcmStudy> list2 = DcmStudyFactory.getDcmStudiesFromArchiveResults(list, progress2, searchSource, true, a2);
            Collections.sort(list2, new com.mimvista.compare.b(1));
            if (a2.b()) {
                return;
            }
            f2.setSearchResults(new i(list2, searchSource, Searchable.SearchType.a));
            bg.e("PlainLocalSearchSource.performSearch");
        }
        catch (ArchiveNotFoundException archiveNotFoundException) {
            if (a2.b()) {
                progress.j();
                return;
            }
            f2.setSearchResults(new i(new ArrayList<DcmStudy>(0), searchSource, Searchable.SearchType.a));
            f2.setStatusMessage("The folder " + this.a() + " does not exist", true);
            progress.j();
        }
    }

    @Override
    protected void a(Map<String, String> map, f<i> f2, Searchable.a a2) {
        this.a(map, f2, this, a2);
    }

    public void a(SeriesParameters seriesParameters, f<i> f2, SearchSource searchSource, final StudyFinder studyFinder, Progress progress) {
        Object object;
        Object object2;
        studyFinder.applyParams(seriesParameters);
        studyFinder.setArchivePath(this.a());
        final AtomicReference atomicReference = new AtomicReference();
        Thread thread = new Thread("Archive Search Thread"){

            @Override
            public void run() {
                try {
                    atomicReference.set(studyFinder.search());
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error during archive search", throwable, PlainLocalSearchSource.this);
                }
            }
        };
        thread.start();
        this.a(thread, f2.getSearchTimeout(), progress);
        ArrayList<File> arrayList = new ArrayList<File>();
        List list = (List)atomicReference.get();
        if (list != null) {
            object2 = list.listIterator();
            while (object2.hasNext()) {
                object = (QueryResult)object2.next();
                if (object != null) {
                    File file = new File(((QueryResult)object).path).getParentFile();
                    if (!arrayList.contains(file)) {
                        arrayList.add(file);
                    }
                    ((QueryResult)object).path = file.getAbsolutePath();
                    continue;
                }
                object2.remove();
            }
        }
        object2 = f2.getSearchProgress();
        object = DcmStudyFactory.getDcmStudiesFromArchiveResults(list, (Progress)object2, searchSource);
        f2.setSearchResults(new i((List<DcmStudy>)object, searchSource, null));
    }

    @Override
    protected void a(f<i> f2, final Searchable.a a2) {
        this.g = Searchable.SearchType.c;
        bg.b("LocalSearchSource.performRecentlyViewedSearch");
        Progress progress = f2.getSearchProgress();
        Map<String, String> map = this.a(a2);
        if (a2.b()) {
            return;
        }
        progress.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                a2.a();
            }
        });
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)map.size());
        for (String string : map.keySet()) {
            DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(string);
            dcmSeries.setRecentlyViewed(map.get(string));
            dcmSeries.setSearchSource(this);
            arrayList.add(dcmSeries);
        }
        List<DcmStudy> list = DcmStudyFactory.getDcmStudiesFromDcmSeries(arrayList, progress, false, a2);
        progress.b();
        bg.e("LocalSearchSource.performRecentlyViewedSearch");
        if (a2.b()) {
            return;
        }
        f2.setSearchResults(new i(list, this, Searchable.SearchType.c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> a(Searchable.a a2) {
        String[] stringArray;
        bg.a("read recentlog", 1000L, false);
        String[] stringArray2 = Maps.newLinkedHashMap();
        BufferedReader bufferedReader = null;
        String string = PathUtils.getCanonicalOrAbsolutePath(this.a());
        try {
            File file = com.mimvista.preferencesNew.cascade.c.d().a(CascadeSubfolder.a, ".recentlog.txt");
            if (file != null && file.exists()) {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!a2.b()) {
                        if (string2.length() < 30 || (stringArray = cn.a(string2, "|")).length != 2 || !stringArray[1].startsWith(string)) continue;
                        String string3 = stringArray[0];
                        File file2 = PathUtils.getCanonicalOrAbsoluteFile(stringArray[1]);
                        String string4 = file2.getAbsolutePath();
                        if (stringArray2.containsKey(string4) || !file2.isDirectory()) continue;
                        stringArray2.put(string4, string3);
                        continue;
                    }
                    break;
                }
            } else {
                stringArray = stringArray2;
                return stringArray;
            }
            stringArray = Maps.newLinkedHashMap();
            cm.a((Closeable)bufferedReader);
        }
        catch (IOException iOException) {
            ay.d((Object)"Error recently recently viewed log.", (Throwable)iOException, this);
            stringArray = Maps.newLinkedHashMap();
            return stringArray;
        }
        bg.e("read recentlog");
        return stringArray;
        finally {
            cm.a(bufferedReader);
            bg.e("read recentlog");
        }
    }

    @Override
    protected void a(SeriesParameters seriesParameters, f<i> f2) {
        this.a(seriesParameters, f2, this, new StudyFinder(), o.o());
    }

    @Override
    public String b() {
        return this.directory;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean d() {
        return true;
    }

    @Override
    public boolean e() {
        return false;
    }

    @Override
    public boolean f() {
        return false;
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public boolean h() {
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.directory == null ? 0 : this.directory.hashCode());
        n3 = 31 * n3 + (this.sourceName == null ? 0 : this.sourceName.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlainLocalSearchSource plainLocalSearchSource = (PlainLocalSearchSource)object;
        if (this.directory == null ? plainLocalSearchSource.directory != null : !this.directory.equals(plainLocalSearchSource.directory)) {
            return false;
        }
        return !cn.f(this.sourceName, plainLocalSearchSource.sourceName);
    }

    @Override
    public String i() {
        return "Local search source: " + this.directory;
    }
}

