/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.f;
import com.mimvista.archive.g;
import com.mimvista.archive.gui.LocalDestination;
import com.mimvista.archive.gui.RemoteDestination;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.h;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.MIMpacsServer;
import com.mimvista.archive.s;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.message.ArchiveHappenedMessage;
import com.mimvista.d;
import com.mimvista.dicom.DicomDestination;
import com.mimvista.dicom.util.FancyArchiveCacheCreator;
import com.mimvista.metabase.j;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mongodb.MongoInterruptedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class e {
    private static List<g> globalTransferCompleteListeners = Lists.newArrayList();
    private boolean shouldDeleteIncomingFolder = false;
    private boolean shouldCreateCacheFile = true;
    private boolean shouldScanSeriesIntoTheMetabase = true;
    private Progress progress = new o();
    private List<g> transferCompleteListeners = Lists.newArrayList();
    protected File incomingFolder;
    protected File destinationArchiveFolder;
    protected boolean isDestinationAMimpacsArchive = false;
    protected Iterable<Archiver.d> seriesFiles;
    protected Set<String> originalPacsPatientListNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalTransferCompleteListener(g g2) {
        List<g> list = globalTransferCompleteListeners;
        synchronized (list) {
            globalTransferCompleteListeners.add(g2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobalTransferCompleteListener(g g2) {
        List<g> list = globalTransferCompleteListeners;
        synchronized (list) {
            globalTransferCompleteListeners.remove(g2);
        }
    }

    public e(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("incomingFolder cannot be null");
        }
        if (file2 == null) {
            throw new NullPointerException("destArchiveFolder cannot be null");
        }
        this.incomingFolder = file;
        this.destinationArchiveFolder = file2;
        this.isDestinationAMimpacsArchive = MimpacsPrefs.lastRunPacsType.getValue() == MIMpacsConfig.PacsType.a && MIMpacsServer.isArchiveFolder(this.destinationArchiveFolder);
    }

    public e setDeleteIncomingFolder(boolean bl2) {
        this.shouldDeleteIncomingFolder = bl2;
        return this;
    }

    public e setCreateCacheFile(boolean bl2) {
        this.shouldCreateCacheFile = bl2;
        return this;
    }

    public e setPacsPatientLists(String ... stringArray) {
        return this.setPacsPatientLists(Lists.newArrayList((Object[])stringArray));
    }

    public e setPacsPatientLists(@d Iterable<String> iterable) {
        this.originalPacsPatientListNames.clear();
        if (iterable != null) {
            Iterables.addAll(this.originalPacsPatientListNames, iterable);
        }
        return this;
    }

    public e setSeriesFiles(Iterable<Archiver.d> iterable) {
        this.seriesFiles = iterable;
        return this;
    }

    public e setScanSeriesIntoTheMetabase(boolean bl2) {
        this.shouldScanSeriesIntoTheMetabase = bl2;
        return this;
    }

    public e setProgress(Progress progress) {
        this.progress = progress != null ? progress : new o();
        return this;
    }

    public e registerTransferCompleteListener(g g2) {
        this.transferCompleteListeners.add(g2);
        return this;
    }

    public e unregisterTransferCompleteListener(g g2) {
        this.transferCompleteListeners.remove(g2);
        return this;
    }

    public Archiver.b performAction() throws IOException {
        Archiver.b b2 = this.archiveData();
        for (Archiver.a a2 : b2.f) {
            TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (this.isDestinationAMimpacsArchive) {
                treeSet.addAll(this.originalPacsPatientListNames);
                treeSet.addAll(a2.d);
                if (treeSet.isEmpty()) {
                    treeSet.addAll(MIMpacsServer.getDefaultPatientListNames());
                }
            }
            for (File file : a2.e) {
                if (this.isDestinationAMimpacsArchive) {
                    try {
                        this.updateBakFile(file, treeSet);
                    }
                    catch (Throwable throwable) {
                        ay.c((Object)"An error occurred while updating the BAK file for a series", throwable, this);
                    }
                }
                if (this.shouldScanSeriesIntoTheMetabase) {
                    try {
                        this.scanData(file, treeSet);
                    }
                    catch (MongoInterruptedException mongoInterruptedException) {
                        ay.d((Object)("Mongo was interrupted during a db operation, the metabase record may not have been written properly for: " + file), this);
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"An error occurred while scanning a series into the metabase", throwable, this);
                    }
                }
                if (!this.shouldCreateCacheFile) continue;
                try {
                    this.createCacheFile(file);
                }
                catch (Throwable throwable) {
                    ay.c((Object)"An error occurred while creating the cache file for a series", throwable, this);
                }
            }
            this.fireArchiveTransferCompleteListeners(a2);
        }
        this.progress.b();
        return b2;
    }

    protected Archiver.b archiveData() throws IOException {
        return Archiver.archiveSeries(this.destinationArchiveFolder, this.incomingFolder, this.seriesFiles, this.shouldDeleteIncomingFolder, this.progress);
    }

    protected void updateBakFile(File file, Set<String> set) {
        h.a(file.getAbsolutePath(), set);
    }

    protected void createCacheFile(File file) {
        FancyArchiveCacheCreator.generateCacheForFolder(file);
    }

    protected void scanData(File file, Set<String> set) {
        com.mimvista.metabase.e e2 = j.a();
        if (e2 != null) {
            com.mimvista.metabase.h h2 = e2.c();
            if (this.isDestinationAMimpacsArchive) {
                h2.a(set);
            }
            h2.a(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireArchiveTransferCompleteListeners(Archiver.a a2) {
        f f2 = new f(this, a2);
        ArrayList arrayList = null;
        Iterator<g> iterator = globalTransferCompleteListeners;
        synchronized (iterator) {
            arrayList = Lists.newArrayList(globalTransferCompleteListeners);
        }
        for (g g2 : arrayList) {
            try {
                g2.a(f2);
            }
            catch (Throwable throwable) {
                ay.d((Object)"One of the global archiveTransferComplete listeners failed", throwable, this);
            }
        }
        for (g g2 : this.transferCompleteListeners) {
            try {
                g2.a(f2);
            }
            catch (Throwable throwable) {
                ay.d((Object)"One of the archiveTransferComplete listeners failed", throwable, this);
            }
        }
    }

    protected abstract List<SendToDestination> getBestMatchingDestinations();

    protected abstract SearchSource getBestMatchingSource();

    static {
        e.registerGlobalTransferCompleteListener(new g(){

            @Override
            public void a(final f f2) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SearchSource searchSource = f2.a().getBestMatchingSource();
                            List<SendToDestination> list = f2.a().getBestMatchingDestinations();
                            for (SendToDestination sendToDestination : list) {
                                String string = f2.b().g;
                                if (searchSource != null && sendToDestination != null) {
                                    s.a(sendToDestination, searchSource).a(f2.b().f, string);
                                } else {
                                    string = null;
                                }
                                ArchiveHappenedMessage.SeriesArchiveHappenedMessage seriesArchiveHappenedMessage = new ArchiveHappenedMessage.SeriesArchiveHappenedMessage(searchSource, sendToDestination, f2.b().f, string);
                                seriesArchiveHappenedMessage.sendAsync();
                            }
                        }
                        catch (Exception exception) {
                            ay.d((Object)"error trying to send automator archival message", (Throwable)exception, e.class);
                        }
                    }
                }.start();
            }
        });
    }

    public static class b
    extends e {
        public b(File file, File file2) {
            super(file, file2);
        }

        @Override
        protected List<SendToDestination> getBestMatchingDestinations() {
            for (LocalDestination localDestination : ag.h()) {
                File file;
                String string = localDestination.getDirectory();
                if (string == null || !(file = new File(string)).equals(this.destinationArchiveFolder)) continue;
                return Lists.newArrayList((Object[])new SendToDestination[]{localDestination});
            }
            ay.c((Object)("Local Destination " + this.destinationArchiveFolder + " was not in the list of configured destinations"), this);
            return Lists.newArrayList((Object[])new SendToDestination[]{new LocalDestination("", this.destinationArchiveFolder.getAbsolutePath())});
        }

        @Override
        protected SearchSource getBestMatchingSource() {
            return com.mimvista.archive.search.g.a(this.destinationArchiveFolder);
        }
    }

    public static class c
    extends e {
        public c(File file, File file2) {
            super(file, file2);
        }

        @Override
        protected List<SendToDestination> getBestMatchingDestinations() {
            ArrayList arrayList = Lists.newArrayList();
            List<RemoteDestination> list = ag.p();
            boolean bl2 = this.originalPacsPatientListNames.isEmpty();
            if (bl2) {
                for (RemoteDestination remoteDestination : list) {
                    if (!remoteDestination.getRemote().a(this.destinationArchiveFolder)) continue;
                    arrayList.add(remoteDestination);
                }
            } else {
                for (String string : this.originalPacsPatientListNames) {
                    for (RemoteDestination remoteDestination : list) {
                        if (!string.equalsIgnoreCase(remoteDestination.getRemote().l()) || !remoteDestination.getRemote().a(this.destinationArchiveFolder)) continue;
                        arrayList.add(remoteDestination);
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
            if (bl2) {
                ay.c((Object)("we archived to a simple RPL but couldn't find a matching RPL in the configs, returning a local destination instead: " + this.destinationArchiveFolder.getAbsolutePath()), this);
                return Lists.newArrayList((Object[])new SendToDestination[]{new LocalDestination("local destination", this.destinationArchiveFolder.getAbsolutePath())});
            }
            ay.c((Object)("couldn't find a matching remote destination for\n\tpatient lists: [" + cn.a(this.originalPacsPatientListNames, "; ") + "]\n\tarchive folder: " + this.destinationArchiveFolder), this);
            return arrayList;
        }

        @Override
        protected SearchSource getBestMatchingSource() {
            if (this.originalPacsPatientListNames.isEmpty()) {
                ay.b((Object)"archive was originally to a local PL", this);
                return com.mimvista.archive.search.g.a(this.destinationArchiveFolder);
            }
            if (this.originalPacsPatientListNames.size() > 1) {
                ay.c((Object)("cannot find proper remote destination because there are more than one original patient lists: " + cn.a(this.originalPacsPatientListNames, ";")), this);
                return null;
            }
            String string = (String)this.originalPacsPatientListNames.iterator().next();
            return com.mimvista.archive.search.g.b(string);
        }
    }

    public static class a
    extends e {
        private String AETitle;

        public a(File file, File file2, String string) {
            super(file, file2);
            this.AETitle = string;
        }

        @Override
        protected List<SendToDestination> getBestMatchingDestinations() {
            if (this.AETitle == null) {
                ay.c((Object)"cannot find proper dicom server because we don't know the AETitle", this);
                return Lists.newArrayList();
            }
            List<DicomDestination> list = ag.o();
            for (DicomDestination dicomDestination : list) {
                if (!dicomDestination.getAeTitle().equalsIgnoreCase(this.AETitle)) continue;
                return Lists.newArrayList((Object[])new SendToDestination[]{dicomDestination});
            }
            ay.c((Object)("cannot find proper dicom server: " + this.AETitle), this);
            return Lists.newArrayList();
        }

        @Override
        protected SearchSource getBestMatchingSource() {
            return com.mimvista.archive.search.g.a(this.AETitle);
        }
    }
}

