/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.mimvista.archive.gui.PatientSearchPanel;
import com.mimvista.archive.gui.SearchPanel;
import com.mimvista.archive.m;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.archive.search.pro.QueryParamGroup;
import com.mimvista.archive.search.pro.q;
import com.mimvista.automator.filter.SeriesFilter;
import com.mimvista.automator.filter.a;
import com.mimvista.automator.gui.parameter.SingleFilterPanel;
import com.mimvista.dicom.util.Operator;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.gui.util.c;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.b;
import com.mimvista.metabase.k;
import com.mimvista.metabase.n;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.DicomTagPanel;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.BooleanCondition;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class AdvancedPatientSearchPanel
extends JPanel
implements SearchPanel {
    private static final long serialVersionUID = 6387396623834753333L;
    private static Messages props = Messages.a("Archive");
    private static HashMultimap<String, Integer> tagMap = HashMultimap.create();
    private JPanel tagPanel;
    private List<SingleFilterPanel> tagList = new ArrayList<SingleFilterPanel>();
    private JRadioButton andSearch;
    private final SeriesFilter defaultFilter = new SeriesFilter(new TagPath(), Operator.CONTAINS, "");
    private boolean saveSearchParams = false;
    private List<SingleFilterPanel> savedTagList;
    private Border regularBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
    private Border errorBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red, 2), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    private final FuncUtils.m<SingleFilterPanel> removeListener = new FuncUtils.m<SingleFilterPanel>(){

        public void a(SingleFilterPanel singleFilterPanel) {
            AdvancedPatientSearchPanel.this.removeTag(singleFilterPanel);
        }

        @Override
        public /* synthetic */ void doIt(Object object) {
            this.a((SingleFilterPanel)object);
        }
    };

    public AdvancedPatientSearchPanel() {
        this.buildPanel();
    }

    private static void setupTagmap() {
        tagMap.put((Object)"keywords", (Object)528446);
        tagMap.put((Object)"keywords", (Object)528432);
        tagMap.put((Object)"keywords", (Object)0x100020);
        tagMap.put((Object)"keywords", (Object)930295816);
        tagMap.put((Object)"name", (Object)930295816);
        tagMap.put((Object)"id", (Object)0x100020);
        tagMap.put((Object)"modality", (Object)524384);
        tagMap.put((Object)"startDate", (Object)524320);
        tagMap.put((Object)"endDate", (Object)524320);
        tagMap.put((Object)"desc", (Object)528446);
    }

    private void addEmptyFilter() {
        SingleFilterPanel singleFilterPanel = new SingleFilterPanel(this.defaultFilter, this.removeListener, DicomTagPanel.b, false);
        this.addTag(singleFilterPanel);
        singleFilterPanel.c();
    }

    private void buildPanel() {
        JButton jButton = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPatientSearchPanel.this.addEmptyFilter();
            }
        }, "", false);
        jButton.setFocusable(false);
        JRadioButton jRadioButton = new JRadioButton(props.getProperty("ADVANCEDSEARCH_PANEL_OR"));
        this.andSearch = new JRadioButton(props.getProperty("ADVANCEDSEARCH_PANEL_AND"));
        jRadioButton.setFocusable(false);
        this.andSearch.setFocusable(false);
        this.andSearch.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(this.andSearch);
        JLabel jLabel = new JLabel(props.getProperty("ADVANCEDSEARCH_PANEL_MATCH"));
        this.tagPanel = new JPanel();
        this.tagPanel.setLayout(new BoxLayout(this.tagPanel, 1));
        this.rebuildTagPanel();
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(10));
        box.add(jRadioButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.andSearch);
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalStrut(10));
        JScrollPane jScrollPane = new JScrollPane(this.tagPanel, 20, 31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)box, "South");
        Dimension dimension = this.getPreferredSize();
        dimension.height *= 3;
        this.setPreferredSize(dimension);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setSize(this.getPreferredSize());
        this.addEmptyFilter();
    }

    public MetabaseQuery generateQuery() {
        MetabaseQuery metabaseQuery = n.a();
        ArrayList arrayList = Lists.newArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll((Collection<String>)b.b());
        for (SingleFilterPanel singleFilterPanel : this.tagList) {
            singleFilterPanel.setBorder(this.regularBorder);
            SeriesFilter seriesFilter = singleFilterPanel.a();
            if (seriesFilter == null || !seriesFilter.e()) {
                this.showBadTagNotification(singleFilterPanel);
                return null;
            }
            arrayList.add(seriesFilter.a(n.a()));
            if (seriesFilter.a().isMIMDataTagPath()) continue;
            hashSet.add(MetabaseKeys.fromTag(seriesFilter.a()));
        }
        metabaseQuery.c(hashSet);
        if (arrayList.isEmpty()) {
            return metabaseQuery;
        }
        if (arrayList.size() == 1) {
            return (MetabaseQuery)arrayList.get(0);
        }
        return this.andSearch.isSelected() ? metabaseQuery.a(arrayList) : metabaseQuery.b(arrayList);
    }

    public QueryParamGroup.QueryParamRootGroup generateNewStyleQuery() {
        QueryParamGroup.QueryParamRootGroup queryParamRootGroup = new QueryParamGroup.QueryParamRootGroup();
        HashSet<TagPath> hashSet = new HashSet<TagPath>();
        hashSet.addAll((Collection<TagPath>)b.a());
        boolean bl2 = this.andSearch.isSelected();
        QueryParamGroup queryParamGroup = bl2 ? queryParamRootGroup : queryParamRootGroup.c();
        for (SingleFilterPanel object : this.tagList) {
            object.setBorder(this.regularBorder);
            SeriesFilter seriesFilter = object.a();
            if (seriesFilter == null || !seriesFilter.e()) {
                this.showBadTagNotification(object);
                return null;
            }
            seriesFilter.a(queryParamGroup);
            if (seriesFilter.a().isMIMDataTagPath()) continue;
            hashSet.add(seriesFilter.a());
        }
        for (TagPath tagPath : hashSet) {
            queryParamRootGroup.a(tagPath);
        }
        return queryParamRootGroup;
    }

    public void addTag(SingleFilterPanel singleFilterPanel) {
        this.tagList.add(singleFilterPanel);
        singleFilterPanel.b();
        this.rebuildTagPanel();
    }

    public void removeTag(Object object) {
        this.tagList.remove(object);
        this.rebuildTagPanel();
    }

    public void removeAllTags() {
        this.tagList = new ArrayList<SingleFilterPanel>();
        this.rebuildTagPanel();
    }

    public void rebuildTagPanel() {
        this.tagPanel.removeAll();
        for (SingleFilterPanel singleFilterPanel : this.tagList) {
            singleFilterPanel.setOpaque(false);
            singleFilterPanel.setBorder(this.regularBorder);
            singleFilterPanel.setMaximumSize(new Dimension(singleFilterPanel.getMaximumSize().width, singleFilterPanel.getPreferredSize().height));
            this.tagPanel.add(singleFilterPanel);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void saveSearchParameters() {
        this.saveSearchParams = true;
        this.savedTagList = new ArrayList<SingleFilterPanel>(this.tagList);
    }

    public HashMap<String, String> getSearchParameters() {
        String string = null;
        String string2 = null;
        for (SingleFilterPanel singleFilterPanel : this.tagList) {
            SeriesFilter seriesFilter = singleFilterPanel.a();
            if (seriesFilter == null || !seriesFilter.e()) {
                return m.a(null, null, null, null, null, null, null);
            }
            TagPath tagPath = seriesFilter.a();
            if (new TagPath(0x100020).equals(tagPath)) {
                string = seriesFilter.d();
                continue;
            }
            if (!new TagPath(0x100010).equals(tagPath) && !new TagPath(930295816).equals(tagPath)) continue;
            string2 = seriesFilter.d();
        }
        return m.a(null, string2, string, null, null, null, null);
    }

    @Override
    public void clearFields() {
        this.tagList = new ArrayList<SingleFilterPanel>();
        this.rebuildTagPanel();
    }

    @Override
    public void setParameter(String string, String string2) {
        a a2 = AdvancedPatientSearchPanel.getSeriesFiltersFromOldBooMap(string, string2);
        for (SeriesFilter seriesFilter : a2.c()) {
            this.addTag(new SingleFilterPanel(seriesFilter, this.removeListener, DicomTagPanel.b, false));
        }
    }

    @Override
    public void setSearchParameters(Map<String, String> map) {
        if (this.saveSearchParams) {
            this.tagList = this.savedTagList;
            this.rebuildTagPanel();
            this.saveSearchParams = false;
        } else {
            this.removeAllTags();
            this.andSearch.setSelected(true);
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                this.setParameter(string, string2);
            }
        }
    }

    public void setSearchParameters(List<SeriesFilter> list) {
        this.tagList.clear();
        for (SeriesFilter seriesFilter : list) {
            this.addTag(new SingleFilterPanel(seriesFilter, this.removeListener, DicomTagPanel.b, false));
        }
    }

    @Override
    public boolean isSearchBlank() {
        return this.tagList.size() == 0;
    }

    @Override
    public Future<?> doSearch(SearchSource searchSource, f<i> f2, Searchable.a a2) {
        return AdvancedPatientSearchPanel.getSearchFuture(searchSource, f2, a2, this::generateNewStyleQuery, this::generateQuery, this::getClass);
    }

    public static Future<?> getSearchFuture(SearchSource searchSource, f<i> f2, Searchable.a a2, Supplier<QueryParamGroup.QueryParamRootGroup> supplier, Supplier<MetabaseQuery> supplier2, Supplier<Class<?>> supplier3) {
        Runnable runnable = null;
        if (searchSource.J()) {
            QueryParamGroup.QueryParamRootGroup queryParamRootGroup = supplier.get();
            if (queryParamRootGroup != null) {
                runnable = searchSource.a(new q.d(queryParamRootGroup), f2, a2);
            }
        } else {
            MetabaseQuery metabaseQuery = supplier2.get();
            if (metabaseQuery != null) {
                runnable = searchSource.b(metabaseQuery, f2, a2);
            }
        }
        if (runnable != null) {
            PatientSearchPanel.a(searchSource);
            return com.mimvista.util.work.m.e.a(runnable, "Advanced Patient List Search");
        }
        ay.b((Object)"Invalid parameter for query", supplier3.get());
        return null;
    }

    private void showBadTagNotification(SingleFilterPanel singleFilterPanel) {
        Messages messages = Messages.a("Automator");
        BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, messages.getProperty("INVALID_FILTER_TEXT"), new Notification.a());
        basicNotification.setTimeoutType(Notification.NotificationTimeoutType.b);
        basicNotification.setTimeout(2000L);
        u.b().c(basicNotification);
        singleFilterPanel.setBorder(this.errorBorder);
    }

    public List<SeriesFilter> getFilters() {
        ArrayList arrayList = Lists.newArrayList();
        for (SingleFilterPanel singleFilterPanel : this.tagList) {
            arrayList.add(singleFilterPanel.a());
        }
        return arrayList;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void commitDateEdit() {
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
    }

    @Override
    public void setDateFormat(String string) {
    }

    @Override
    public void prepareForSource(Searchable searchable) {
    }

    @Override
    public void cleanup() {
    }

    private static com.mimvista.automator.filter.b handleSpecialNameTag(int n2, String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string2 : k.a(string)) {
            arrayList.add(new SeriesFilter(new TagPath(n2), Operator.CONTAINS, string2));
        }
        return new a(BooleanCondition.b, arrayList);
    }

    public static a getSeriesFiltersFromOldBooMap(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return new a(BooleanCondition.b, new ArrayList());
        }
        ArrayList<com.mimvista.automator.filter.b> arrayList = new ArrayList<com.mimvista.automator.filter.b>();
        for (Integer n2 : tagMap.get((Object)string)) {
            if ("name".equals(string) || n2 == 930295816) {
                arrayList.add(AdvancedPatientSearchPanel.handleSpecialNameTag(n2, string2));
                continue;
            }
            if ("startDate".equals(string)) {
                arrayList.add(new SeriesFilter(new TagPath(n2), Operator.IS_GREATER_THAN_OR_EQUAL_TO, string2));
                continue;
            }
            if ("endDate".equals(string)) {
                arrayList.add(new SeriesFilter(new TagPath(n2), Operator.IS_LESS_THAN_OR_EQUAL_TO, string2));
                continue;
            }
            arrayList.add(new SeriesFilter(new TagPath(n2), Operator.CONTAINS, string2));
        }
        if ("keywords".equals(string)) {
            return new a(BooleanCondition.c, arrayList);
        }
        return new a(BooleanCondition.b, arrayList);
    }

    static {
        AdvancedPatientSearchPanel.setupTagmap();
    }
}

