/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.gui.CdExportPanel;
import com.mimvista.archive.gui.LocalDestination;
import com.mimvista.archive.gui.PatientListTransitionPane;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.ImportSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;

public class CdDestination
extends LocalDestination {
    public static Messages props = Messages.a("CDBurning");

    public static boolean isCdDestinationUsable() {
        return !MIMContext.k() && LicenseTransformer.isLicensedForAnyOf(Lists.newArrayList((Object[])new LicenseOption[]{LicenseOption.N}));
    }

    public CdDestination() {
        super(props.getProperty("CDDEST_MIMVIEWER_CD"), Path.getTempCDExportArchive());
    }

    @Override
    public String getIconName() {
        return "cd";
    }

    @Override
    protected boolean canRetrieveFrom(MIMcloudSearchSource mIMcloudSearchSource) {
        return false;
    }

    @Override
    protected boolean canRetrieveFrom(ImportSearchSource importSearchSource) {
        return true;
    }

    @Override
    public boolean canRetrieveFrom(SearchSource searchSource) {
        if (!CdDestination.isCdDestinationUsable()) {
            return false;
        }
        return super.canRetrieveFrom(searchSource);
    }

    @Override
    protected void retrieveFrom(DicomSearchSource dicomSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(dicomSearchSource, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(ImportSearchSource importSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(importSearchSource, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(LocalSearchSource localSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(localSearchSource, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(abstractRemoteSearchSource, list, bl2, m2);
    }

    private void a(SearchSource searchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingPatientList.b().g();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatientListTransitionPane.b();
            }
        });
        boolean bl3 = false;
        try {
            for (DcmSeries dcmSeries : list) {
                dcmSeries.setSearchSource(searchSource);
            }
            CdExportPanel cdExportPanel = SwingPatientList.b().f();
            cdExportPanel.a(list);
        }
        catch (Exception exception) {
            bl3 = true;
        }
        if (m2 != null) {
            m2.doIt(bl3 ? Progress.Status.d : Progress.Status.c);
        }
    }

    @Override
    protected void retrieveFrom(final FolderSearchSource folderSearchSource, final List<DcmSeries> list, final boolean bl2, final @d FuncUtils.m<Progress.Status> m2) {
        final ProgressPanel progressPanel = new ProgressPanel();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (DcmSeries dcmSeries : list) {
                    Archiver.archiveIntoImporterTemp(dcmSeries, progressPanel);
                    dcmSeries.setSearchSource(new FolderSearchSource("", dcmSeries.getLocalDir(), true));
                    MIMFile mIMFile = new MIMFile(dcmSeries.getLocalDir());
                    MIMFile mIMFile2 = mIMFile.g().g();
                    try {
                        if (Archiver.cleanTempDirForEmbeddedSeries(mIMFile.getAbsolutePath()) || mIMFile2 == null || !new File(Path.getImporterTempPath()).getCanonicalPath().equals(mIMFile2.getCanonicalPath())) continue;
                        mIMFile.f();
                    }
                    catch (IOException iOException) {
                        ay.d((Object)iOException, this);
                    }
                }
                if (folderSearchSource.o()) {
                    new MIMFile(folderSearchSource.a()).f();
                }
                CdDestination.this.a(folderSearchSource, list, bl2, m2);
            }
        };
        if (bl2) {
            runnable.run();
        } else {
            m.e.a(runnable, "CD Dest Temp Importer");
        }
    }
}

