/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.archive.gui.CdDestination;
import com.mimvista.archive.gui.LocalDestination;
import com.mimvista.archive.gui.PatientListSidePanel;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.archive.gui.v;
import com.mimvista.archive.search.AppSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.cdburning.CdBurningQueue;
import com.mimvista.cdburning.CdCompression;
import com.mimvista.cdburning.CdFormat;
import com.mimvista.cdburning.CdSpeed;
import com.mimvista.cdburning.b;
import com.mimvista.cdburning.d;
import com.mimvista.cdburning.e;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.file.MIMFile;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.JButtonWithToolTipCorrection;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.install.MimInstaller;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ao;
import com.mimvista.mui.goals.impl.d;
import com.mimvista.mui.toolbar.SidePanel;
import com.mimvista.preferencesNew.CdburningPrefs;
import com.mimvista.preferencesNew.ExportPrefs;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.ProgressPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CdExportPanel
extends SidePanel
implements ListDataListener {
    private static final long serialVersionUID = 376207722748363064L;
    private SwingPatientList patientList;
    private CdBurningQueue burnQueue = new CdBurningQueue();
    private JList queueList;
    private JPanel optionsPanel;
    private JPanel buttonsPanel;
    private JComboBox formatCombo;
    private JComboBox compressionCombo;
    private JComboBox speedCombo;
    private JTextField techNameField;
    private JTextField institutionField;
    private JCheckBox mimviewerCheckbox;
    private JCheckBox burnMultipleCheckbox;
    private JCheckBox exportCheckbox;
    private JLabel totalSize;
    private JCheckBox encryptedCheckbox;
    private JButton addButton;
    private JButton deleteButton;
    private JButton exportButton;
    private JButton previewButton;
    private JPanel main;
    private ActionListener exportActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CdExportPanel.this.a(false);
            try {
                if (!CdExportPanel.this.burnQueue.c()) {
                    File file = CdExportPanel.this.l();
                    file = CdExportPanel.this.a(file);
                    e e2 = CdExportPanel.this.i();
                    e2.a(file);
                }
            }
            catch (CancellationException cancellationException) {
                CdExportPanel.this.a();
            }
        }
    };
    private ActionListener burnActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CdExportPanel.this.a(false);
            try {
                if (!CdExportPanel.this.burnQueue.c()) {
                    e e2 = CdExportPanel.this.i();
                    e2.c();
                }
            }
            catch (CancellationException cancellationException) {
                CdExportPanel.this.a();
            }
        }
    };

    public CdExportPanel(SwingPatientList swingPatientList) {
        this.patientList = swingPatientList;
        this.setIcon(ImageManipulator.c("cd_burn", 18));
        this.setShowTitle(true);
        this.setName(Messages.a("CDBurning", "BURNCD_TITLE"));
        this.d();
        this.setPreferredSize(new Dimension(250, 0));
    }

    @Override
    public String getConfigIdentifier() {
        return "CD EXPORT";
    }

    private void d() {
        this.main = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.main, "Center");
        Box box = new Box(3);
        this.queueList = new JList(this.burnQueue);
        this.queueList.setCellRenderer(new CdExportJobCellRenderer());
        this.queueList.setSelectionMode(2);
        this.queueList.setVisibleRowCount(2);
        JScrollPane jScrollPane = new JScrollPane(this.queueList);
        this.e();
        box.add(this.optionsPanel);
        box.add(jScrollPane);
        this.main.add((Component)box, "Center");
        this.f();
        this.main.add((Component)this.buttonsPanel, "South");
        this.burnQueue.addListDataListener(this);
        this.setBorder(PatientListSidePanel.a(this));
    }

    private void e() {
        Messages messages = Messages.a("CDBurning");
        this.optionsPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 7909841667756895162L;

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                if (((CdExportPanel)CdExportPanel.this).queueList.getParent().getSize().height >= ((CdExportPanel)CdExportPanel.this).queueList.getPreferredScrollableViewportSize().height) {
                    return this.getPreferredSize();
                }
                return super.getMinimumSize();
            }
        };
        this.optionsPanel.setMinimumSize(new Dimension(100, 50));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.optionsPanel.add((Component)jScrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(messages.getProperty("CDEXPORT_PANEL_TYPE")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.formatCombo = new JComboBox<CdFormat>(CdFormat.values());
        try {
            this.formatCombo.setSelectedItem((Object)CdFormat.valueOf(CdburningPrefs.cdFormat.getValue()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        jPanel.add((Component)this.formatCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(messages.getProperty("CDEXPORT_PANEL_COMPRESSION")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.compressionCombo = new JComboBox<CdCompression>(CdCompression.values());
        try {
            this.compressionCombo.setSelectedItem((Object)CdCompression.valueOf(CdburningPrefs.cdCompressionType.getValue()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        jPanel.add((Component)this.compressionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(messages.getProperty("CDEXPORT_PANEL_SPEED")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.speedCombo = new JComboBox<CdSpeed>(CdSpeed.values());
        try {
            this.speedCombo.setSelectedItem((Object)CdSpeed.a(CdburningPrefs.cdBurningSpeed.getValue()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        jPanel.add((Component)this.speedCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(messages.getProperty("CDEXPORT_TECH_NAME")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        this.techNameField = new JTextField();
        this.techNameField.setText(CdburningPrefs.techName.getValue());
        jPanel.add((Component)this.techNameField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(messages.getProperty("CDEXPORT_PANEL_INSTITUTION")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        this.institutionField = new JTextField();
        this.institutionField.setText(CdburningPrefs.cdInstitution.getValue());
        jPanel.add((Component)this.institutionField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.mimviewerCheckbox = new JCheckBox(messages.getProperty("CDEXPORT_PANEL_MIMVIEWER"));
        if (e.e()) {
            this.mimviewerCheckbox.setSelected(CdburningPrefs.includeMimviewerOnCd.getValue());
        } else {
            this.mimviewerCheckbox.setSelected(false);
            this.mimviewerCheckbox.setEnabled(false);
        }
        this.mimviewerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdExportPanel.this.n();
            }
        });
        jPanel.add((Component)this.mimviewerCheckbox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.burnMultipleCheckbox = new JCheckBox(messages.getProperty("CDEXPORT_BURN_MULTIPLE"));
        this.burnMultipleCheckbox.setSelected(CdburningPrefs.burnMultipleCopies.getValue());
        jPanel.add((Component)this.burnMultipleCheckbox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.exportCheckbox = new JCheckBox(messages.getProperty("CDEXPORT_PANEL_EXPORT_CHECKBOX"));
        this.exportCheckbox.setSelected(CdburningPrefs.useExportInsteadOfBurnCd.getValue());
        this.exportCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdExportPanel.this.h();
            }
        });
        jPanel.add((Component)this.exportCheckbox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.encryptedCheckbox = new JCheckBox(messages.getProperty("CDEXPORT_PANEL_ENCRYPT"));
        this.encryptedCheckbox.setToolTipText(messages.getProperty("CDEXPORT_PANEL_ENCRYPT_TIP"));
        this.encryptedCheckbox.setSelected(CdburningPrefs.encryptCds.getValue());
        jPanel.add((Component)this.encryptedCheckbox, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.totalSize = new JLabel();
        this.n();
        jPanel.add((Component)this.totalSize, gridBagConstraints);
    }

    private void f() {
        Messages messages = Messages.a("CDBurning");
        GridLayout gridLayout = new GridLayout(1, 0);
        gridLayout.setHgap(3);
        this.buttonsPanel = new JPanel(gridLayout);
        this.buttonsPanel.setBackground(MIMLookAndFeel.E());
        this.addButton = CdExportPanel.buildCompanionButton(messages.getProperty("CDEXPORT_PANEL_ADD"), messages.b("CDEXPORT_PANEL_ADD_TIP"), "add", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdExportPanel.this.c();
            }
        });
        this.buttonsPanel.add(this.addButton);
        Messages messages2 = Messages.a("ButtonFactory");
        this.deleteButton = CdExportPanel.buildCompanionButton(messages2.getProperty("DELETE_BUTTON"), messages.b("CDEXPORT_PANEL_DELETE_TIP"), messages2.getProperty("DELETE_BUTTON_ICON"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        CdExportPanel.this.b();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CdExportPanel.this.queueList.clearSelection();
                            }
                        });
                    }
                }.start();
            }
        });
        this.deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    new Thread(){

                        @Override
                        public void run() {
                            CdExportPanel.this.burnQueue.a();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CdExportPanel.this.addButton.grabFocus();
                                }
                            });
                        }
                    }.start();
                }
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.previewButton = CdExportPanel.buildCompanionButton(messages.getProperty("CDEXPORT_PANEL_PREVIEW"), messages.b("CDEXPORT_PANEL_PREVIEW_TIP"), "cd", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdExportPanel.this.a(false);
                try {
                    e e2 = CdExportPanel.this.i();
                    e2.b();
                }
                catch (CancellationException cancellationException) {
                    CdExportPanel.this.a();
                }
            }
        });
        this.buttonsPanel.add(this.previewButton);
        this.exportButton = new JButtonWithToolTipCorrection();
        this.buttonsPanel.add(this.exportButton);
        this.h();
        this.a();
    }

    private void g() {
        this.a();
        this.n();
    }

    void a() {
        SearchSource searchSource;
        boolean bl2 = !this.burnQueue.c();
        boolean bl3 = this.burnQueue.b();
        boolean bl4 = false;
        if (this.patientList != null && this.patientList.s() != null && (searchSource = this.patientList.s().getLastSearchedSource()) instanceof AppSearchSource) {
            bl4 = new CdDestination().canRetrieveFrom(searchSource);
        }
        this.addButton.setEnabled(bl4 && bl3);
        this.deleteButton.setEnabled(bl2);
        this.exportButton.setEnabled(bl2 && bl3);
        this.previewButton.setEnabled(bl2 && bl3);
    }

    private void h() {
        Container container = this.exportButton.getParent();
        if (container == null) {
            return;
        }
        container.remove(this.exportButton);
        this.exportButton = this.exportCheckbox.isSelected() ? CdExportPanel.buildCompanionButton(Messages.a("CDBurning", "CDEXPORT_PANEL_EXPORT"), Messages.a("CDBurning", "CDEXPORT_PANEL_EXPORT_TIP"), "folder", this.exportActionListener) : CdExportPanel.buildCompanionButton(Messages.a("CDBurning", "CDEXPORT_PANEL_BURN"), Messages.a("CDBurning", "CDEXPORT_PANEL_BURN_TIP"), "cd_burn", this.burnActionListener);
        this.exportButton.setEnabled(!this.burnQueue.c());
        container.add(this.exportButton);
        container.invalidate();
        container.validate();
    }

    private void a(boolean bl2) {
        this.addButton.setEnabled(bl2);
        this.deleteButton.setEnabled(bl2);
        this.exportButton.setEnabled(bl2);
        this.previewButton.setEnabled(bl2);
    }

    private e i() throws CancellationException {
        b b2 = this.j();
        e e2 = new e((Iterable<d>)ImmutableList.copyOf((Iterable)this.burnQueue), b2);
        e2.a(this);
        e2.a();
        this.a(e2);
        return e2;
    }

    private void a(e e2) {
        final d.a a2 = new d.a(e2.g());
        u.b().c(a2);
        e2.a(new e.a(){

            @Override
            public void a() {
                CdExportPanel.this.burnQueue.a();
                u.b().d(a2);
                CdExportPanel.this.g();
            }

            @Override
            public void b() {
                u.b().d(a2);
                CdExportPanel.this.g();
            }

            @Override
            public void c() {
                u.b().d(a2);
                CdExportPanel.this.g();
            }
        });
    }

    private File a(File file) throws CancellationException {
        int n2;
        File file2 = new File(MimInstaller.homeDrive).getAbsoluteFile();
        File file3 = new File("/").getAbsoluteFile();
        while (file != null && file.getParent() == null && (file.equals(file2) || file.equals(file3)) && (n2 = JOptionPane.showConfirmDialog(this.m(), MIMFormat.a(Messages.a("CDBurning", "CDEXPORT_FORDER_WARN_TEXT"), file.getAbsolutePath()), Messages.a("CDBurning", "CDEXPORT_FORDER_WARN"), 2, 2)) != 0) {
            file = this.l();
        }
        return file;
    }

    private b j() throws CancellationException {
        b b2 = new b();
        b2.c = (CdCompression)((Object)this.compressionCombo.getSelectedItem());
        b2.e = (CdSpeed)((Object)this.speedCombo.getSelectedItem());
        b2.d = (CdFormat)((Object)this.formatCombo.getSelectedItem());
        b2.f = this.techNameField.getText();
        b2.g = this.institutionField.getText();
        b2.b = this.burnMultipleCheckbox.isSelected();
        b2.a = this.mimviewerCheckbox.isSelected();
        b2.h = this.exportCheckbox.isSelected();
        if (this.encryptedCheckbox.isSelected()) {
            char[] cArray = this.k();
            b2.i = cArray;
        }
        return b2;
    }

    private char[] k() throws CancellationException {
        String string = JOptionPane.showInputDialog(this, Messages.a("CDBurning", "CDEXPORT_ENCRYPTION_PASSWORD"), Messages.a("CDBurning", "BURNCD_TITLE"), 3);
        if (string == null || string.length() == 0) {
            throw new CancellationException();
        }
        return string.toCharArray();
    }

    private File l() throws CancellationException {
        String string = ExportPrefs.lastFolderExportDestination.getValue();
        MIMFileDialog mIMFileDialog = MIMFileDialog.a(this.m(), Messages.a("CDBurning", "CDEXPORT_PANEL_EXPORT_SELECT_FOLDER"), MIMFileDialog.FileDialogType.b, MIMFileDialog.FileDialogSelectionMode.b, string, true);
        AtomicReference atomicReference = new AtomicReference();
        MIMSwingUtils.b(() -> {
            mIMFileDialog.a(true);
            if (mIMFileDialog.a() != null) {
                ExportPrefs.lastFolderExportDestination.setValue(mIMFileDialog.a());
                atomicReference.set(new MIMFile(mIMFileDialog.a()));
            }
        });
        if (atomicReference.get() == null) {
            throw new CancellationException();
        }
        return (File)atomicReference.get();
    }

    private JFrame m() {
        return ao.S();
    }

    protected void b() {
        Object[] objectArray = this.queueList.getSelectedValues();
        ArrayList arrayList = Lists.newArrayList();
        for (Object object : objectArray) {
            d d2 = (d)object;
            arrayList.add(d2);
        }
        this.burnQueue.b(arrayList);
    }

    protected void c() {
        SearchSource searchSource = this.patientList.s().getLastSearchedSource();
        if (searchSource == null) {
            return;
        }
        boolean bl2 = new LocalDestination("", "").canRetrieveFrom(searchSource);
        if (!bl2 || searchSource instanceof MIMcloudSearchSource) {
            JOptionPane.showMessageDialog(this, Messages.a("CDBurning", "CDEXPORT_PANEL_FUNCTION_ERROR"), Messages.a("CDBurning", "BURNCD_TITLE"), 2);
            return;
        }
        final List<DcmSeries> list = v.a(this.patientList, this.patientList, Messages.a("CDBurning", "CDEXPORT_PANEL_PERFORM_ALL"));
        new Thread(){

            @Override
            public void run() {
                CdExportPanel.this.a(list);
            }
        }.start();
    }

    private void n() {
        float f2 = this.burnQueue.a(this.mimviewerCheckbox.isSelected());
        String string = CdExportPanel.a(f2);
        this.totalSize.setText(Messages.a("CDBurning", "CDEXPORT_TOTAL_SIZE") + " " + string);
    }

    public static String a(float f2) {
        if (f2 == -1.0f) {
            return Messages.a("CDBurning", "CDEXPORT_SIZE_UNKNOWN");
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(0);
        return decimalFormat.format(f2) + " MB";
    }

    public void a(List<DcmSeries> list) {
        this.burnQueue.a(list);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.g();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.g();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.g();
    }

    @Override
    public Color getPanelColor() {
        return MIMLookAndFeel.b(MIMLookAndFeel.a(), 0.9f);
    }

    static class CancellationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CancellationException() {
        }
    }

    public static class CdExportJobCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8752867227466769476L;

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (!(object instanceof d)) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            }
            d d2 = (d)object;
            String string = d2.g();
            String string2 = d2.h();
            String string3 = d2.f();
            String string4 = d2.j();
            String string5 = d2.i();
            String string6 = "<html><table><tr><td align=\"center\" valign=\"middle\" width=\"40\"><h3><strong>" + string2 + "</strong></h3></td><td><strong>" + string3 + "</strong> - " + string4 + "<br>" + string + "<br>" + string5 + "</td></tr></table></html>";
            Component component = super.getListCellRendererComponent((JList<?>)jList, string6, n2, bl2, bl3);
            SpringLayout springLayout = new SpringLayout();
            JPanel jPanel = new JPanel(springLayout);
            jPanel.setBackground(component.getBackground());
            jPanel.setPreferredSize(new Dimension(component.getPreferredSize().width, component.getPreferredSize().height));
            jPanel.add(component);
            if (!d2.m()) {
                jPanel.setPreferredSize(new Dimension(component.getPreferredSize().width, component.getPreferredSize().height + 40));
                ProgressPanel progressPanel = d2.c();
                if (progressPanel == null) {
                    return jPanel;
                }
                progressPanel.d().setBackground(component.getBackground());
                jPanel.add(progressPanel.d());
                springLayout.putConstraint("North", progressPanel.d(), 5, "South", component);
            }
            return jPanel;
        }
    }
}

