/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.gui.util.c;
import com.mimvista.util.cn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugSeriesReferencesDialog
extends JDialog {
    private static final long serialVersionUID = 368393577067731765L;

    public DebugSeriesReferencesDialog(Frame frame, DcmSeries dcmSeries) {
        super(frame, "Series References");
        JTextArea jTextArea = new JTextArea(15, 100);
        jTextArea.setFont(Font.decode("Monospaced"));
        jTextArea.setEditable(false);
        jTextArea.setText(DebugSeriesReferencesDialog.a(dcmSeries));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.add(c.d(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugSeriesReferencesDialog.this.dispose();
            }
        }, null));
        this.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private static String a(DcmSeries dcmSeries) {
        StringBuilder stringBuilder = new StringBuilder();
        Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> multimap = dcmSeries.getReferencedSeries();
        if (multimap == null || multimap.isEmpty()) {
            stringBuilder.append("This series doesn't reference any other series.");
        } else {
            boolean bl2 = true;
            for (DcmSeriesReference.ReferenceSource referenceSource : multimap.keySet()) {
                if (!bl2) {
                    stringBuilder.append("\n");
                }
                bl2 = false;
                stringBuilder.append((Object)referenceSource).append(" (tag: 0x").append(Integer.toHexString(referenceSource.getSequenceTag())).append(")\n");
                Collection collection = multimap.get((Object)referenceSource);
                if (collection == null || collection.isEmpty()) {
                    stringBuilder.append("   <empty>\n");
                    continue;
                }
                int n2 = 1;
                for (DcmSeriesReference dcmSeriesReference : collection) {
                    stringBuilder.append("   Reference ").append(n2++).append("\n");
                    Map<DcmSeriesReference.ReferenceUidType, String> map = dcmSeriesReference.getReferences();
                    if (map == null || map.isEmpty()) {
                        stringBuilder.append("      <empty>\n");
                        continue;
                    }
                    for (Map.Entry<DcmSeriesReference.ReferenceUidType, String> entry : map.entrySet()) {
                        stringBuilder.append("      ").append((Object)entry.getKey()).append(": ");
                        if (cn.h(entry.getValue())) {
                            stringBuilder.append("<blank>\n");
                            continue;
                        }
                        stringBuilder.append(entry.getValue() + "\n");
                    }
                    Set<DcmSeries> set = dcmSeriesReference.getReferencedDcmSeries();
                    if (set != null && !set.isEmpty()) {
                        stringBuilder.append("      ResolvedRefPKs: ");
                        stringBuilder.append(cn.a(set, ", ", new Function<DcmSeries, String>(){

                            public String a(DcmSeries dcmSeries) {
                                return Long.toString(dcmSeries.getPrimaryKey());
                            }

                            public /* synthetic */ Object apply(Object object) {
                                return this.a((DcmSeries)object);
                            }
                        }));
                        stringBuilder.append("\n");
                        continue;
                    }
                    stringBuilder.append("      ResolvedRefPKs: None (refs might not have been resolved)\n");
                }
            }
        }
        return stringBuilder.toString();
    }
}

