/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.PatientSearchPanel;
import com.mimvista.archive.gui.SearchPanel;
import com.mimvista.archive.m;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.preferencesNew.ImportPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImportSearchPanel
implements SearchPanel {
    private static Messages props = Messages.a("Archive");
    private JPanel panel;
    private JComboBox fileToSearch;
    private List<File> recentFiles;
    private int firstRecentFileIndex;
    private int initialSelectionIndex = 0;
    private ComboBoxModel searchFileModel = new DefaultComboBoxModel(){
        private static final long serialVersionUID = 1L;
        File selectedFile;

        @Override
        public void setSelectedItem(Object object) {
            this.selectedFile = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedFile;
        }

        @Override
        public int getSize() {
            return ImportSearchPanel.this.recentFiles.size();
        }

        @Override
        public Object getElementAt(int n2) {
            return ImportSearchPanel.this.recentFiles.get(n2);
        }
    };

    public ImportSearchPanel() {
        this.getMenuItems();
        this.buildPanel();
    }

    @Override
    public void setDateFormat(String string) {
    }

    @Override
    public void cleanup() {
    }

    private JButton buildBrowseButton() {
        JButton jButton = new JButton(props.getProperty("IMPORTSEARCHPANEL_BROWSE"), ImageManipulator.c("folder_mag_glass", 15));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = (File)ImportSearchPanel.this.fileToSearch.getSelectedItem();
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(SwingUtilities.getWindowAncestor(ImportSearchPanel.this.panel), props.getProperty("IMPORTSEARCHPANEL_TITLE"), MIMFileDialog.FileDialogType.a, MIMFileDialog.FileDialogSelectionMode.b, true);
                if (file != null && file.exists()) {
                    mIMFileDialog.b(file.getAbsolutePath());
                }
                mIMFileDialog.a(true);
                String string = mIMFileDialog.a();
                if (string == null) {
                    return;
                }
                File file2 = new File(string);
                ImportSearchPanel.this.searchFileModel.setSelectedItem(file2);
            }
        });
        jButton.setPreferredSize(new Dimension(jButton.getPreferredSize().width, 25));
        return jButton;
    }

    private void buildPanel() {
        this.fileToSearch = new JComboBox(this.searchFileModel);
        this.panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0};
        this.panel.setLayout(gridBagLayout);
        this.panel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.fileToSearch, gridBagConstraints);
        this.fileToSearch.setPreferredSize(new Dimension(100, 25));
        this.fileToSearch.setSelectedIndex(this.initialSelectionIndex);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panel.add((Component)this.buildBrowseButton(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.panel.add(Box.createGlue(), gridBagConstraints);
        Dimension dimension = this.panel.getPreferredSize();
        this.panel.setPreferredSize(new Dimension(700, dimension.height));
        this.panel.setMaximumSize(this.panel.getPreferredSize());
    }

    @Override
    public void clearFields() {
        if (this.firstRecentFileIndex == -1) {
            return;
        }
        this.recentFiles = this.recentFiles.subList(0, this.firstRecentFileIndex);
        this.saveViewedFiles();
        String string = ImportPrefs.cdDriveNew.getValue();
        if (this.recentFiles.contains(new File(string))) {
            this.searchFileModel.setSelectedItem(new File(string));
        } else {
            ImportPrefs.cdDriveNew.remove();
            this.searchFileModel.setSelectedItem(this.recentFiles.get(0));
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public HashMap<String, String> getSearchParameters() {
        this.addRecentFile(this.getSelectedFile());
        this.searchFileModel.setSelectedItem(this.getSelectedFile());
        ImportPrefs.cdDriveNew.setValue(this.getSelectedPath());
        this.saveViewedFiles();
        return m.a(null, this.getSelectedPath(), null, null, null, null, null);
    }

    private String getSelectedPath() {
        File file = this.getSelectedFile();
        String string = "";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    private File getSelectedFile() {
        return (File)this.searchFileModel.getSelectedItem();
    }

    @Override
    public void setParameter(String string, String string2) {
        if (string.equals("name") && string2 != null) {
            this.addRecentFile(new File(string2));
        }
    }

    @Override
    public void setSearchParameters(Map<String, String> map) {
        this.setParameter("name", map.get("name"));
    }

    private void saveViewedFiles() {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (int i2 = this.firstRecentFileIndex; i2 < this.recentFiles.size(); ++i2) {
            File file = this.recentFiles.get(i2);
            if (file == null) continue;
            linkedList.add(0, file);
        }
        if (linkedList.isEmpty()) {
            ImportPrefs.pastFiles.remove();
            return;
        }
        ImportPrefs.pastFiles.setValue(linkedList.toArray(new File[linkedList.size()]));
    }

    private void addRecentFile(File file) {
        if (file != null && !this.recentFiles.contains(file)) {
            this.recentFiles.add(this.firstRecentFileIndex, file);
            int n2 = ImportPrefs.maxFileList.getValue();
            if (this.recentFiles.size() > n2) {
                this.recentFiles.remove(n2);
            }
        }
    }

    private void getMenuItems() {
        File[] fileArray;
        this.recentFiles = Lists.newArrayList();
        String string = ImportPrefs.cdDriveNew.getValue().trim();
        for (File file : fileArray = File.listRoots()) {
            this.firstRecentFileIndex = this.recentFiles.size();
            this.addRecentFile(file);
        }
        int n2 = this.recentFiles.size();
        File[] fileArray2 = ImportPrefs.pastFiles.getValue();
        if (fileArray2 != null) {
            for (File file : fileArray2) {
                if (file == null) continue;
                this.firstRecentFileIndex = this.recentFiles.size();
                this.addRecentFile(file);
            }
        }
        this.firstRecentFileIndex = n2;
        if (!cn.h(string)) {
            File file = new File(string);
            this.addRecentFile(file);
            this.initialSelectionIndex = this.recentFiles.indexOf(file);
        } else {
            this.initialSelectionIndex = -1;
        }
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
    }

    @Override
    public void prepareForSource(Searchable searchable) {
    }

    @Override
    public void commitDateEdit() {
    }

    @Override
    public void saveSearchParameters() {
    }

    @Override
    public boolean isSearchBlank() {
        return false;
    }

    @Override
    public Future<?> doSearch(SearchSource searchSource, f<i> f2, Searchable.a a2) {
        PatientSearchPanel.a(searchSource);
        return com.mimvista.util.work.m.e.a(searchSource.b((Map<String, String>)this.getSearchParameters(), f2, a2), "Import Search");
    }
}

