/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mimvista.archive.ArchiveNotFoundException;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.e;
import com.mimvista.archive.gui.LocalDestination;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.c.h;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.util.AbstractDicomModifierNotification;
import com.mimvista.dicom.util.DicomAnonymizeNotification;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.file.ZipControl;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mimcloud.connection.CloudResponseException;
import com.mimvista.mimcloud.downloader.b;
import com.mimvista.mimcloud.g;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ak;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.ExportPrefs;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.r;
import com.mimvista.util.work.m;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import net.tomahawk.ExtensionsFilter;
import org.apache.commons.io.FilenameUtils;

public class PackageDestination
extends SendToDestination {
    public static Messages props = Messages.a("GUI");
    private static final long a = 15000L;

    public PackageDestination(String string) {
        this.name = string;
    }

    @Override
    public String getIconName() {
        return "folder_zip";
    }

    @Override
    protected boolean canRetrieveFrom(LocalSearchSource localSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(MIMcloudSearchSource mIMcloudSearchSource) {
        return true;
    }

    @Override
    protected void retrieveFrom(LocalSearchSource localSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(localSearchSource, list, bl2, false, m2);
    }

    private LocalDestination a(String string, String string2) {
        return new LocalDestination(string, string2){

            @Override
            protected e a(File file, File file2) {
                return super.a(file, file2).setScanSeriesIntoTheMetabase(false);
            }

            @Override
            protected boolean a() {
                return false;
            }
        };
    }

    @Override
    protected void retrieveFrom(FolderSearchSource folderSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        String[] stringArray;
        String string = PathUtils.getTempPath("packagedest", true, true);
        LocalDestination localDestination = this.a("tmp", string);
        localDestination.retrieveFrom(folderSearchSource, list, folderSearchSource.o(), m2);
        try {
            stringArray = new com.mimvista.archive.search.b(string).a("", "", "", "", "", "", "");
        }
        catch (ArchiveNotFoundException archiveNotFoundException) {
            throw new RuntimeException("Not sure how this could happen", archiveNotFoundException);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string2 : stringArray) {
            arrayList.add(DcmSeriesFactory.getDcmSeriesWithInfoAdded(folderSearchSource, new QueryResult(string2)));
        }
        this.a(new FolderSearchSource("tmp", string, true), arrayList, bl2, true, m2);
    }

    private void a(LocalSearchSource localSearchSource, final List<DcmSeries> list, boolean bl2, final boolean bl3, @d FuncUtils.m<Progress.Status> m2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DcmSeries object2 : list) {
            arrayList.add(Archiver.getDirContainingSeriesFiles(object2));
        }
        final Thread thread = this.zipFiles(PackageDestination.getSaveLocationBySeries(list), arrayList, null, m2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    ay.d((Object)"Interrupted while waiting on retrieve to finish", (Throwable)interruptedException, PackageDestination.this);
                }
                if (bl3) {
                    for (DcmSeries dcmSeries : list) {
                        new MIMFile(dcmSeries.getLocalDir()).delete();
                    }
                }
            }
        };
        if (bl2) {
            runnable.run();
        } else if (bl3) {
            m.e.submit(runnable);
        }
    }

    @Override
    protected void retrieveFrom(MIMcloudSearchSource mIMcloudSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.a(mIMcloudSearchSource, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(final AbstractRemoteSearchSource abstractRemoteSearchSource, final List<DcmSeries> list, boolean bl2, final @d FuncUtils.m<Progress.Status> m2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = GetOSPath.convertPath("C:\\MIM_DATA\\Temp\\MimQuery\\Archive");
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                final boolean[] blArray = new boolean[]{false};
                final HashMap hashMap = new HashMap();
                final ArrayList arrayList = Lists.newArrayList();
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                for (DcmSeries dcmSeries : list) {
                    final a a2 = new a(){

                        @Override
                        public void update(Observable observable, Object object) {
                            if (object != null && "canceled".equalsIgnoreCase((String)object) && !blArray[0]) {
                                blArray[0] = true;
                                for (h h2 : arrayList) {
                                    h2.cancelTransfer();
                                }
                            } else {
                                super.update(observable, object);
                            }
                        }
                    };
                    final h h2 = new h();
                    h2.addObserver(a2);
                    arrayList.add(h2);
                    LocalDestination localDestination = PackageDestination.this.a("ZipTemp", string);
                    FuncUtils.m<Progress.Status> m22 = new FuncUtils.m<Progress.Status>(){

                        public void a(Progress.Status status) {
                            if (m2 != null) {
                                m2.doIt(status);
                            }
                            if (Progress.Status.e == status || Progress.Status.d == status || Progress.Status.c == status) {
                                hashMap.put(a2, h2);
                                if (hashMap.keySet().size() == list.size()) {
                                    if (!blArray[0]) {
                                        new Thread(){

                                            @Override
                                            public void run() {
                                                try {
                                                    Thread thread = PackageDestination.this.b(hashMap, m2, blArray);
                                                    if (thread != null) {
                                                        thread.join();
                                                    }
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    ay.d((Object)"Error.", (Throwable)interruptedException, PackageDestination.class);
                                                }
                                                finally {
                                                    countDownLatch.countDown();
                                                }
                                            }
                                        }.start();
                                    } else {
                                        countDownLatch.countDown();
                                    }
                                }
                            }
                        }

                        @Override
                        public /* synthetic */ void doIt(Object object) {
                            this.a((Progress.Status)((Object)object));
                        }
                    };
                    h2.a(localDestination, ((RemoteSearchSource)abstractRemoteSearchSource).y().h(), ((RemoteSearchSource)abstractRemoteSearchSource).y().k(), dcmSeries.getArchiveDir(), m22);
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    ay.d((Object)"Error.", (Throwable)interruptedException, PackageDestination.class);
                }
            }
        };
        if (bl2) {
            runnable.run();
        } else {
            m.e.submit(runnable);
        }
    }

    private void a(final MIMcloudSearchSource mIMcloudSearchSource, final List<DcmSeries> list, boolean bl2, final @d FuncUtils.m<Progress.Status> m2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = GetOSPath.convertPath("C:\\MIM_DATA\\Temp\\MimCloud\\Archive");
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                final boolean[] blArray = new boolean[]{false};
                final HashMap hashMap = new HashMap();
                final ArrayList arrayList = Lists.newArrayList();
                b b2 = mIMcloudSearchSource.p();
                try {
                    b2.a(list);
                }
                catch (CloudResponseException cloudResponseException) {
                    com.mimvista.mimcloud.gui.a.a(cloudResponseException);
                    return;
                }
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                boolean bl2 = true;
                for (DcmSeries dcmSeries : list) {
                    final a a2 = new a(){

                        @Override
                        public void update(Observable observable, Object object) {
                            if (object != null && "canceled".equalsIgnoreCase((String)object) && !blArray[0]) {
                                blArray[0] = true;
                                new DelayedActionRunner(100, new Runnable(){

                                    @Override
                                    public void run() {
                                        for (com.mimvista.archive.remote.c.b b2 : arrayList) {
                                            b2.cancelTransfer();
                                        }
                                    }
                                }).b();
                            } else {
                                super.update(observable, object);
                            }
                        }
                    };
                    final g g2 = new g(b2, dcmSeries, false);
                    g2.addObserver(a2);
                    arrayList.add(g2);
                    LocalDestination localDestination = PackageDestination.this.a("ZipTemp", string);
                    FuncUtils.m<Progress.Status> m22 = new FuncUtils.m<Progress.Status>(){

                        public void a(Progress.Status status) {
                            if (m2 != null) {
                                m2.doIt(status);
                            }
                            if (Progress.Status.e == status || Progress.Status.d == status || Progress.Status.c == status) {
                                hashMap.put(a2, g2);
                                if (hashMap.keySet().size() == list.size()) {
                                    if (blArray[0]) {
                                        countDownLatch.countDown();
                                    } else {
                                        new Thread(){

                                            @Override
                                            public void run() {
                                                try {
                                                    Thread thread = PackageDestination.this.a(hashMap, m2, blArray);
                                                    if (thread != null) {
                                                        thread.join();
                                                    }
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    ay.d((Object)"Error.", (Throwable)interruptedException, PackageDestination.class);
                                                }
                                                finally {
                                                    countDownLatch.countDown();
                                                }
                                            }
                                        }.start();
                                    }
                                }
                            }
                        }

                        @Override
                        public /* synthetic */ void doIt(Object object) {
                            this.a((Progress.Status)((Object)object));
                        }
                    };
                    g2.a(localDestination, bl2, false, m22);
                    bl2 = false;
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    ay.d((Object)"Error.", (Throwable)interruptedException, PackageDestination.class);
                }
            }
        };
        if (bl2) {
            runnable.run();
        } else {
            m.b.submit(runnable);
        }
    }

    private Thread a(HashMap<a, g> hashMap, @d FuncUtils.m<Progress.Status> m2, boolean[] blArray) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        block2: for (a object : hashMap.keySet()) {
            long l2;
            long l3 = 0L;
            long l4 = l2 = Calendar.getInstance().getTimeInMillis();
            g g2 = hashMap.get(object);
            while (arrayList.size() < hashMap.keySet().size() + 1 && l3 < 15000L && !object.b()) {
                String string = g2.a();
                if (g2.getStatus() == Progress.Status.c && string != null) {
                    arrayList.add(string);
                    continue block2;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = Calendar.getInstance().getTimeInMillis();
                if (object.a()) {
                    l4 = l2;
                }
                l3 = l2 - l4;
            }
        }
        if (!blArray[0]) {
            final Thread thread = this.zipFiles(arrayList, new ProgressPanel(), m2);
            Thread thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (thread != null) {
                        try {
                            thread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException2) {
                                // empty catch block
                            }
                        }
                    }
                    for (String string : arrayList) {
                        new MIMFile(string).delete();
                    }
                }
            });
            thread2.start();
            return thread2;
        }
        return null;
    }

    private Thread b(HashMap<a, h> hashMap, @d FuncUtils.m<Progress.Status> m2, boolean[] blArray) {
        ArrayList arrayList = Lists.newArrayList();
        block2: for (a object : hashMap.keySet()) {
            long l2;
            long thread = 0L;
            long l3 = l2 = Calendar.getInstance().getTimeInMillis();
            h h2 = hashMap.get(object);
            while (arrayList.size() < hashMap.keySet().size() + 1 && thread < 15000L && !object.b()) {
                if (h2.getStatus() == Progress.Status.c && !h2.a().isEmpty()) {
                    arrayList.addAll(h2.a());
                    continue block2;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = Calendar.getInstance().getTimeInMillis();
                if (object.a()) {
                    l3 = l2;
                }
                thread = l2 - l3;
            }
        }
        final List list = Lists.transform((List)arrayList, (Function)new Function<File, String>(){

            public String a(File file) {
                return file.getAbsolutePath();
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((File)object);
            }
        });
        if (!blArray[0]) {
            final Thread thread = this.zipFiles(list, new ProgressPanel(), m2);
            Thread thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (thread != null) {
                        try {
                            thread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException2) {
                                // empty catch block
                            }
                        }
                    }
                    for (String string : list) {
                        new MIMFile(string).delete();
                    }
                }
            });
            thread2.start();
            return thread2;
        }
        return null;
    }

    public Thread zipFiles(List<String> list, Progress progress, @d FuncUtils.m<Progress.Status> m2) {
        return this.zipFiles(PackageDestination.getSaveLocation(list), list, progress, m2);
    }

    public Thread zipFiles(final File file, final List<String> list, Progress progress, @d FuncUtils.m<Progress.Status> m2) {
        if (file == null) {
            if (m2 != null) {
                m2.doIt(Progress.Status.d);
            }
            return null;
        }
        ExportPrefs.lastZipExportDestination.setValue(file.getParentFile().getAbsolutePath());
        long l2 = 0L;
        for (String string : list) {
            l2 += new MIMFile(string).length();
        }
        final long l3 = l2;
        final String string = new File(list.get(0)).getParentFile().getParent();
        if (progress == null) {
            progress = new ProgressPanel();
        }
        if (progress instanceof com.mimvista.util.progress.g) {
            ProgressQueueNotification.a((com.mimvista.util.progress.g)progress);
        }
        final Progress progress2 = progress;
        r.a(progress2, m2);
        progress2.a(3000);
        progress2.a(false);
        progress2.c(true);
        progress2.b_(props.getProperty("PACKAGEDEST_COMPRESSING"));
        progress2.a();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ZipControl.saveAllToZipFile(file.getAbsolutePath(), list, string, false, true, new MIMFile.a(){
                        long a = 0L;

                        @Override
                        public void a(int n2) {
                            this.a += (long)n2;
                            if ((double)this.a >= (double)(l3 * (long)(progress2.ah_() + 1)) / (double)progress2.g()) {
                                progress2.N_();
                            }
                        }

                        @Override
                        public void a(String string) {
                            progress2.b_(MIMFormat.a(props.getProperty("PACKAGEDEST_COPY"), string));
                        }

                        @Override
                        public boolean a(Exception exception, MIMFile mIMFile, MIMFile mIMFile2) {
                            return false;
                        }

                        @Override
                        public boolean a() {
                            return progress2.n() == Progress.Status.e;
                        }
                    });
                }
                catch (Exception exception) {
                    ay.d((Object)"caught exception while trying to zip", (Throwable)exception, this);
                    progress2.k();
                }
                if (progress2.n() == Progress.Status.e) {
                    new File(file.getAbsolutePath()).delete();
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                for (String string2 : list) {
                    Archiver.cleanTempDirForEmbeddedSeries(string2);
                }
                progress2.b();
            }
        };
        thread.start();
        return thread;
    }

    public static File getSaveLocationBySeries(List<DcmSeries> list) {
        if (list.size() == 0) {
            return null;
        }
        String string = PackageDestination.a(list);
        return PackageDestination.a(string);
    }

    private static String a(List<DcmSeries> list) {
        return PackageDestination.createPrefixFromNames(Lists.transform(list, (Function)new Function<DcmSeries, String>(){

            public String a(DcmSeries dcmSeries) {
                return dcmSeries.getPatientName();
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((DcmSeries)object);
            }
        }));
    }

    public static File getSaveLocation(List<String> list) {
        if (list.size() == 0) {
            return null;
        }
        String string = PackageDestination.b(list);
        return PackageDestination.a(string);
    }

    public static File getSaveLocationFromModifySeriesData(List<? extends AbstractDicomModifierNotification.ModifySeriesData<?>> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = PackageDestination.createPrefixFromNames(Lists.transform(list, (Function)new Function<AbstractDicomModifierNotification.ModifySeriesData<?>, String>(){

            public String a(AbstractDicomModifierNotification.ModifySeriesData<?> modifySeriesData) {
                String string;
                if (modifySeriesData instanceof DicomAnonymizeNotification.AnonymizeSeriesData && (string = ((DicomAnonymizeNotification.AnonymizeSeriesData)modifySeriesData).userInput.getUserInputValue(0x100010)) != null) {
                    return string;
                }
                return modifySeriesData.series.getPatientName();
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((AbstractDicomModifierNotification.ModifySeriesData)object);
            }
        }));
        return PackageDestination.a(string);
    }

    private static File a(String string) {
        Object object;
        String string2 = ArchivePrefs.dateFormat.getValue();
        String string3 = DateUtils.a(0, string2);
        String string4 = string + "(" + string3 + ").zip";
        String string5 = ExportPrefs.lastZipExportDestination.getValue();
        final MIMFileDialog mIMFileDialog = MIMFileDialog.a(ak.b().O(), props.getProperty("PACKAGEDEST_SAVE"), MIMFileDialog.FileDialogType.b, MIMFileDialog.FileDialogSelectionMode.a, string5, true);
        mIMFileDialog.a(string4);
        mIMFileDialog.a(new ExtensionsFilter(props.getProperty("PACKAGEDEST_ZIP"), "zip"));
        File file = null;
        if (SwingUtilities.isEventDispatchThread()) {
            mIMFileDialog.a(true);
            if (mIMFileDialog.a() != null) {
                file = new File(mIMFileDialog.a());
            }
        } else {
            try {
                object = new File[]{null};
                SwingUtilities.invokeAndWait(new Runnable((File[])object){
                    final /* synthetic */ File[] b;
                    {
                        this.b = fileArray;
                    }

                    @Override
                    public void run() {
                        mIMFileDialog.a(true);
                        if (mIMFileDialog.a() != null) {
                            this.b[0] = new File(mIMFileDialog.a());
                        }
                    }
                });
                file = object[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (file == null) {
            return null;
        }
        object = file.getAbsolutePath();
        if (object.indexOf(".zip") != object.length() - 4) {
            file = new File((String)object + ".zip");
        }
        return file;
    }

    private static String b(List<String> list) {
        return PackageDestination.createPrefixFromNames(Lists.transform(list, (Function)new Function<String, String>(){

            public String a(String string) {
                return FilenameUtils.getBaseName((String)string);
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((String)object);
            }
        }));
    }

    public static String createPrefixFromNames(List<String> list) {
        String string = "";
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 <= 0 || list.get(i2).equals(list.get(i2 - 1))) continue;
            string = props.getProperty("PACKAGEDEST_ZIP_PREFIX");
            break;
        }
        if (string.length() == 0) {
            string = list.get(0);
        }
        return string;
    }

    private class a
    implements Observer {
        boolean d = true;
        boolean e = false;

        private a() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this.d = true;
            this.e = object != null && "canceled".equalsIgnoreCase((String)object);
        }

        public boolean a() {
            boolean bl2 = this.d;
            this.d = false;
            return bl2;
        }

        public boolean b() {
            return this.e;
        }
    }
}

