/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Iterables;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.PlainLocalSearchSource;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.remote.RemoteListId;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.remote.RemoteServerId;
import com.mimvista.archive.remote.c.i;
import com.mimvista.archive.remote.j;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.ImportSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.pro.o;
import com.mimvista.archive.search.pro.q;
import com.mimvista.archive.search.pro.t;
import com.mimvista.automator.credentials.AutomatorCredentialsManager;
import com.mimvista.automator.credentials.b;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.QueryServerTestJDialog;
import com.mimvista.file.MIMFile;
import com.mimvista.metabase.s;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mimcloud.g;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.user.CookieBox;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.work.m;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;

public class RemoteDestination
extends SendToDestination {
    public static Messages props = Messages.a("Archive");
    private RemotePatientListInfo a;
    private CookieBox b;

    public RemoteDestination(RemotePatientListInfo remotePatientListInfo) {
        this(remotePatientListInfo.d() + " (" + remotePatientListInfo.l() + ")", remotePatientListInfo);
    }

    public RemoteDestination(String string, RemotePatientListInfo remotePatientListInfo) {
        this.a = remotePatientListInfo;
        this.name = string;
        if (j.a()) {
            SearchSource searchSource = com.mimvista.archive.search.g.a(this, true);
            if (searchSource == null) {
                ay.d((Object)("somehow came up with a null search source to match destination: " + remotePatientListInfo.h() + ": " + remotePatientListInfo.l()), this);
            } else {
                b b2 = AutomatorCredentialsManager.a().c(searchSource.i());
                if (b2 != null) {
                    this.b = AutomatorCredentialsManager.a(b2, remotePatientListInfo.h(), remotePatientListInfo.i());
                }
            }
        }
        this.newApiVersion = new o(new RemoteListId(new RemoteServerId(remotePatientListInfo.h(), remotePatientListInfo.i()), remotePatientListInfo.k()), this.getCookieBox());
    }

    public RemotePatientListInfo getRemote() {
        return this.a;
    }

    @Override
    public String getIconName() {
        return "MIM_logo_network";
    }

    public void setCookieBox(CookieBox cookieBox) {
        this.b = cookieBox;
        if (this.newApiVersion != null) {
            ((o)this.newApiVersion).a(cookieBox);
        }
    }

    public CookieBox getCookieBox() {
        if (this.b != null) {
            return this.b;
        }
        return LoginChecker.getInstance().currentCookieBox();
    }

    @Override
    public boolean matches(SearchSource searchSource) {
        if (searchSource == null || !(searchSource instanceof RemoteSearchSource)) {
            return false;
        }
        RemoteSearchSource remoteSearchSource = (RemoteSearchSource)searchSource;
        return this.a.k().equalsIgnoreCase(remoteSearchSource.y().k()) && this.a.h().equals(remoteSearchSource.y().h());
    }

    @Override
    protected boolean canRetrieveFrom(LocalSearchSource localSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(ImportSearchSource importSearchSource) {
        return true;
    }

    @Override
    protected boolean canRetrieveFrom(MIMcloudSearchSource mIMcloudSearchSource) {
        return true;
    }

    public void runTest(JDialog jDialog) {
        new QueryServerTestJDialog(jDialog, this).open();
    }

    @Override
    public o getProVersion() {
        return (o)super.getProVersion();
    }

    @Override
    protected void retrieveFrom(PlainLocalSearchSource plainLocalSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        for (DcmSeries dcmSeries : list) {
            q.e e2 = dcmSeries.getOwnerIfSpawnedViaNewApi();
            if (e2 == null) {
                e2 = t.a(Archiver.getDirContainingSeriesFiles(dcmSeries, true));
            }
            i i2 = new i(e2, this.getProVersion());
            i2.push(this, bl2, m2);
        }
    }

    @Override
    protected void retrieveFrom(LocalSearchSource localSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.retrieveFrom((PlainLocalSearchSource)localSearchSource, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(FolderSearchSource folderSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        for (DcmSeries dcmSeries : list) {
            q.e e2 = dcmSeries.getOwnerIfSpawnedViaNewApi();
            if (e2 == null) {
                e2 = t.a(Archiver.getDirContainingSeriesFiles(dcmSeries, true));
            }
            i i2 = new i(e2, this.getProVersion());
            if (folderSearchSource.o()) {
                i2.setDeleteWhenDone();
            }
            i2.push(this, bl2, m2);
        }
    }

    @Override
    protected void retrieveFrom(MIMcloudSearchSource mIMcloudSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        g.a(mIMcloudSearchSource, (SendToDestination)this, list, bl2, m2);
    }

    @Override
    protected void retrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        try {
            RemoteQueryServer remoteQueryServer = s.a(abstractRemoteSearchSource);
            for (DcmSeries dcmSeries : list) {
                com.mimvista.archive.remote.c.g g2 = new com.mimvista.archive.remote.c.g(remoteQueryServer, dcmSeries, ((RemoteSearchSource)abstractRemoteSearchSource).B(), this);
                g2.push(bl2, m2);
            }
        }
        catch (Exception exception) {
            ay.d((Object)("Exception while exporting from RemoteSearchSource " + abstractRemoteSearchSource.j() + ": "), (Throwable)exception, this);
        }
    }

    @Override
    protected void retrieveFrom(final ImportSearchSource importSearchSource, final List<DcmSeries> list, boolean bl2, final @d FuncUtils.m<Progress.Status> m2) {
        final com.mimvista.util.progress.g g2 = importSearchSource.a();
        final MIMFile.a a2 = importSearchSource.a(list, (Progress)g2);
        g2.a();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<String> list2 = importSearchSource.a(list, g2, a2);
                    if (list2 == null) {
                        return;
                    }
                    for (String string : list2) {
                        FolderSearchSource.a(importSearchSource, RemoteDestination.this, string, true, true, m2);
                    }
                }
                finally {
                    g2.b();
                }
            }
        };
        if (bl2) {
            runnable.run();
        } else {
            m.b.submit(runnable);
        }
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemoteDestination remoteDestination = (RemoteDestination)object;
        return !(this.a == null ? remoteDestination.a != null : !this.a.equals(remoteDestination.a));
    }

    public Set<String> getPossibleIdentifiers() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.a == null) {
            linkedHashSet.add(super.getIdentifier());
        } else {
            String string = this.a.h();
            linkedHashSet.add(string + " " + this.a.n() + " " + this.a.k());
            String string2 = this.a.j();
            if (string2 != null) {
                linkedHashSet.add(string2 + " " + this.a.n() + " " + this.a.k());
            }
        }
        return linkedHashSet;
    }

    @Override
    public String getIdentifier() {
        return (String)Iterables.getLast(this.getPossibleIdentifiers());
    }

    @Override
    public boolean doesMatchIdentifier(String string) {
        return this.getPossibleIdentifiers().contains(string);
    }
}

