/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.PlainLocalSearchSource;
import com.mimvista.archive.gui.SendToButton;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.CDViewerSearchSource;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.ImportSearchSource;
import com.mimvista.archive.search.LocalMetabaseSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.pro.q;
import com.mimvista.archive.search.pro.r;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.metabase.j;
import com.mimvista.metabase.n;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mui.toolbar.f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.FavoriteDestinationsPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.work.m;
import com.mimvista.workflow.backend.t;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

@ExternallyVisible
public abstract class SendToDestination
implements t,
Cloneable {
    public static final String FAV_PREFS = "favorite_destinations.txt";
    public static final int defaultIconHeight = 16;
    public boolean favorite = false;
    protected String name;
    @d
    protected r newApiVersion;

    public String getName() {
        return this.name.replace("\n", " ");
    }

    String getNameWithNewlines() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getExternalizedString() {
        return this.getName();
    }

    public Icon getIcon() {
        return this.getIcon(16);
    }

    public r getProVersion() {
        return this.newApiVersion;
    }

    @Override
    public Icon getIcon(int n2) {
        String string = this.getIconName();
        if (!cn.g(string)) {
            return ImageManipulator.c(string, n2);
        }
        return null;
    }

    public SendToButton getButton(f f2, FuncUtils.j<Void> j2) {
        boolean bl2 = this.isFavorite();
        SendToButton sendToButton = new SendToButton(this, bl2, j2);
        sendToButton.setHorizontalAlignment(2);
        sendToButton.setToolTipText(this.getName());
        return sendToButton;
    }

    public synchronized boolean isFavorite() {
        String[] stringArray;
        this.favorite = false;
        for (String string : stringArray = FavoriteDestinationsPrefs.destinations.getValue()) {
            if (!this.doesMatchIdentifier(string)) continue;
            this.favorite = true;
            break;
        }
        return this.favorite;
    }

    public synchronized void setFavorite(boolean bl2) {
        Object[] objectArray = FavoriteDestinationsPrefs.destinations.getValue();
        HashSet hashSet = Sets.newHashSet((Object[])objectArray);
        for (Object object : objectArray) {
            if (!this.doesMatchIdentifier((String)object)) continue;
            hashSet.remove(object);
        }
        if (bl2) {
            hashSet.add(this.getIdentifier());
        }
        Object[] objectArray2 = hashSet.toArray(new String[0]);
        FavoriteDestinationsPrefs.destinations.setValue((String[])objectArray2);
        this.favorite = bl2;
    }

    public abstract String getIconName();

    public boolean matches(SearchSource searchSource) {
        return false;
    }

    public boolean canRetrieveFrom(SearchSource searchSource) {
        if (!this.matches(searchSource) && !searchSource.w()) {
            return false;
        }
        if (searchSource instanceof LocalSearchSource) {
            return this.canRetrieveFrom((LocalSearchSource)searchSource);
        }
        if (searchSource instanceof AbstractRemoteSearchSource) {
            return this.canRetrieveFrom((AbstractRemoteSearchSource)searchSource);
        }
        if (searchSource instanceof DicomSearchSource) {
            return this.canRetrieveFrom((DicomSearchSource)searchSource);
        }
        if (searchSource instanceof ImportSearchSource) {
            return this.canRetrieveFrom((ImportSearchSource)searchSource);
        }
        if (searchSource instanceof MIMcloudSearchSource) {
            return this.canRetrieveFrom((MIMcloudSearchSource)searchSource);
        }
        if (searchSource instanceof CDViewerSearchSource) {
            return this.canRetrieveFrom((CDViewerSearchSource)searchSource);
        }
        return false;
    }

    protected boolean canRetrieveFrom(LocalSearchSource localSearchSource) {
        return false;
    }

    protected boolean canRetrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource) {
        return false;
    }

    protected boolean canRetrieveFrom(DicomSearchSource dicomSearchSource) {
        return false;
    }

    protected boolean canRetrieveFrom(ImportSearchSource importSearchSource) {
        return false;
    }

    protected boolean canRetrieveFrom(MIMcloudSearchSource mIMcloudSearchSource) {
        return false;
    }

    protected boolean canRetrieveFrom(CDViewerSearchSource cDViewerSearchSource) {
        return false;
    }

    public final void retrieveFrom(SearchSource searchSource, List<DcmSeries> list, @d FuncUtils.m<Progress.Status> m2) {
        this.retrieveFrom(searchSource, list, false, m2);
    }

    public final void retrieveFrom(SearchSource searchSource, List<DcmSeries> list) {
        this.retrieveFrom(searchSource, list, null);
    }

    public final void retrieveFrom(SearchSource searchSource, List<DcmSeries> list, boolean bl2) {
        this.retrieveFrom(searchSource, list, bl2, null);
    }

    private boolean attemptToTransferUsingNewApi(SearchSource searchSource, List<DcmSeries> list, boolean bl2, final @d FuncUtils.m<Progress.Status> m2) {
        q q2 = searchSource.m();
        r r2 = this.getProVersion();
        if (list.isEmpty()) {
            ay.d((Object)"Someone is trying to transfer an empty series list.", this);
            return false;
        }
        if (q2 != null && r2 != null) {
            if (!q2.d()) {
                ay.a((Object)"Can't do new-style transfer, the 2.0 SS impl doesn't have full support for creating DataProviders yet.", this);
                return false;
            }
            ay.b((Object)"Source and dest both have new API impls, modern transfer API may be usable...", this);
            ArrayList arrayList = Lists.newArrayList();
            for (DcmSeries object : list) {
                q.e e2 = object.getOwnerIfSpawnedViaNewApi();
                if (e2 == null) {
                    ay.c((Object)"Can't do new-style transfer, DcmSeries were produced via an old-style SS.", this);
                    arrayList = null;
                    break;
                }
                arrayList.add(e2);
            }
            if (arrayList != null) {
                ay.b((Object)"Using modern transfer API!", this);
                r.a a2 = r2.a(arrayList);
                for (final r.b b2 : a2.d) {
                    b2.b.c(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (m2 != null) {
                                m2.doIt(b2.b.n());
                            }
                        }
                    });
                }
                if (bl2) {
                    a2.c.run();
                } else {
                    m.b.a(a2.c, "New Style Transfer");
                }
                return true;
            }
        }
        return false;
    }

    public final void retrieveFrom(SearchSource searchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        if (bl2 && SwingUtilities.isEventDispatchThread()) {
            ay.c((Object)"Blocking retrieve requested on the event thread; not going to block.", this);
            bl2 = false;
        }
        if (searchSource instanceof LocalMetabaseSearchSource) {
            for (DcmSeries dcmSeries : list) {
                if (dcmSeries.getPrimaryKey() <= 0L) continue;
                n.a(dcmSeries.getPrimaryKey()).e(j.a());
            }
        }
        if (this.attemptToTransferUsingNewApi(searchSource, list, bl2, m2)) {
            return;
        }
        if (searchSource instanceof FolderSearchSource) {
            this.retrieveFrom((FolderSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof LocalSearchSource) {
            this.retrieveFrom((LocalSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof AbstractRemoteSearchSource) {
            this.retrieveFrom((AbstractRemoteSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof DicomSearchSource) {
            this.retrieveFrom((DicomSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof ImportSearchSource) {
            this.retrieveFrom((ImportSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof MIMcloudSearchSource) {
            this.retrieveFrom((MIMcloudSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof CDViewerSearchSource) {
            this.retrieveFrom((CDViewerSearchSource)searchSource, list, bl2, m2);
        } else if (searchSource instanceof PlainLocalSearchSource) {
            this.retrieveFrom((PlainLocalSearchSource)searchSource, list, bl2, m2);
        } else {
            throw new UnsupportedOperationException("Retrieval from " + searchSource.getClass().getSimpleName() + " is not implemented for " + this.getClass().getSimpleName());
        }
    }

    protected void retrieveFrom(PlainLocalSearchSource plainLocalSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from PlainLocalSearchSource is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(LocalSearchSource localSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from LocalSearchSource is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(AbstractRemoteSearchSource abstractRemoteSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from RemoteSearchSource is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(DicomSearchSource dicomSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from DicomSearchSource is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(ImportSearchSource importSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from ImportSearchSource is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(MIMcloudSearchSource mIMcloudSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from MIMcloud searchSourch is not implemented for " + this.getClass().getSimpleName());
    }

    protected void retrieveFrom(FolderSearchSource folderSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        this.retrieveFrom((LocalSearchSource)folderSearchSource, list, bl2, m2);
    }

    protected void retrieveFrom(CDViewerSearchSource cDViewerSearchSource, List<DcmSeries> list, boolean bl2, @d FuncUtils.m<Progress.Status> m2) {
        throw new UnsupportedOperationException("Retrieval from MIMViewer searchSourch is not implemented for " + this.getClass().getSimpleName());
    }

    public String toString() {
        return this.getName();
    }

    protected SendToDestination clone() {
        try {
            return (SendToDestination)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)cloneNotSupportedException, this);
            return null;
        }
    }

    public String getIdentifier() {
        return this.getClass().getSimpleName();
    }

    public boolean doesMatchIdentifier(String string) {
        return cn.a(string, this.getIdentifier(), true);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SendToDestination sendToDestination = (SendToDestination)object;
        return !(this.name == null ? sendToDestination.name != null : !this.name.equals(sendToDestination.name));
    }
}

