/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Maps;
import com.mimvista.archive.gui.AbstractBasicSearchPanel;
import com.mimvista.archive.gui.PatientSearchPanel;
import com.mimvista.archive.gui.StandardSearchPanelDateMenuItems;
import com.mimvista.archive.gui.at;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.archive.search.pro.QueryParamGroup;
import com.mimvista.archive.search.pro.q;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.gui.util.TextEditDefaultActions;
import com.mimvista.metabase.MetabaseOwnerStrings;
import com.mimvista.metabase.b;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.PatientListPrefs;
import com.mimvista.properties.ar;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.dcm4che2.data.VR;
import org.jdesktop.swingx.JXDatePicker;

public class StandardSearchPanel
extends AbstractBasicSearchPanel {
    protected List<JXDatePicker> timeComponents = new ArrayList<JXDatePicker>();
    protected List<at> searchBoxSources = new ArrayList<at>();
    protected JTextField keywordsField = new JTextField();

    public StandardSearchPanel() {
        this(ArchivePrefs.dateFormat.getValue());
    }

    public StandardSearchPanel(String string) {
        this(string, true);
    }

    protected StandardSearchPanel(String string, boolean bl2) {
        super(string, bl2);
        this.buildPanel();
    }

    @Override
    public void setDateFormat(String string) {
        this.dateFormat = string;
        for (JXDatePicker jXDatePicker : this.timeComponents) {
            jXDatePicker.setFormats(new String[]{string});
        }
    }

    @Override
    protected void buildPanel() {
        this.createSearchBoxes();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
        jPanel.setLayout(gridBagLayout);
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = this.searchPanel.getPreferredSize();
        dimension.height *= 3;
        this.searchPanel.setPreferredSize(dimension);
        this.searchPanel.setMaximumSize(this.searchPanel.getPreferredSize());
        this.searchPanel.setMinimumSize(this.searchPanel.getPreferredSize());
        this.searchPanel.setSize(this.searchPanel.getPreferredSize());
        int n2 = 0;
        int n3 = 0;
        for (at object2 : this.searchBoxSources) {
            if (n2 == 1 && object2.d()) {
                n2 = 0;
                ++n3;
            }
            jPanel.add((Component)object2.a, StandardSearchPanel.getGridBagConstraints(n2, n3, 2, 10));
            if (n2 == 0) {
                ++n2;
                continue;
            }
            n2 = 0;
            ++n3;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        jPanel.add(this.glue, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.searchPanel.setOpaque(false);
        this.searchPanel.setLayout(new BorderLayout());
        this.searchPanel.add((Component)jScrollPane, "Center");
    }

    public void setKeywordsLabel(String string) {
        if (this.keywordsField != null) {
            this.keywordsField.putClientProperty("com.mimvista.JTextField.InsideLabel", string);
        }
    }

    @Override
    public void enableSearchActionToDateFields(JButton jButton) {
        for (JXDatePicker jXDatePicker : this.timeComponents) {
            this.enableSearchActionToDateField(jXDatePicker, jButton);
        }
    }

    @Override
    public void commitDateEdit() {
        for (JXDatePicker jXDatePicker : this.timeComponents) {
            try {
                jXDatePicker.getEditor().commitEdit();
            }
            catch (ParseException parseException) {
                jXDatePicker.getEditor().setText("");
            }
        }
    }

    @Override
    public void clearFields() {
        for (at at2 : this.searchBoxSources) {
            at2.a((String)null);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.searchPanel;
    }

    public String createOldKey(at at2) {
        if (at2 instanceof at.a) {
            switch (at2.c().getTag(0).getTagInt()) {
                case 0x100010: {
                    return "name";
                }
                case 0x100020: {
                    return "id";
                }
            }
            return at2.a();
        }
        if (at2 instanceof at.g && this.timeComponents.indexOf(at2.a) == 0) {
            return "startDate";
        }
        if (at2 instanceof at.c && this.timeComponents.indexOf(at2.a) == 1) {
            return "endDate";
        }
        return at2.a();
    }

    @Override
    public HashMap<String, String> getSearchParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (at at2 : this.searchBoxSources) {
            if (cn.h(at2.b())) continue;
            hashMap.put(this.createOldKey(at2), at2.b());
        }
        return hashMap;
    }

    @Override
    public void setSearchParameters(Map<String, String> map) {
        this.clearFields();
        for (at at2 : this.searchBoxSources) {
            String string = this.createOldKey(at2);
            if (!map.containsKey(string)) continue;
            at2.a(map.get(string));
        }
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
    }

    @Override
    public void prepareForSource(Searchable searchable) {
        if (this.modalityField != null) {
            if (searchable.g()) {
                this.modalityField.setVisible(true);
            } else {
                this.modalityField.setVisible(false);
                this.modalityField.setText("");
            }
        }
        if (searchable instanceof RemoteSearchSource && this.ownerField != null) {
            RemoteSearchSource remoteSearchSource = (RemoteSearchSource)searchable;
            if (remoteSearchSource.z()) {
                this.ownerField.setVisible(true);
                while (this.ownerField.getItemCount() > MetabaseOwnerStrings.aG_().length) {
                    this.ownerField.removeItemAt(this.ownerField.getItemCount() - 1);
                }
                List<String> list = remoteSearchSource.A();
                for (String string : list) {
                    this.ownerField.addItem(string);
                }
            } else {
                this.ownerField.setVisible(false);
            }
        }
    }

    public QueryParamGroup.QueryParamRootGroup generateQuery() {
        QueryParamGroup.QueryParamRootGroup queryParamRootGroup = new QueryParamGroup.QueryParamRootGroup();
        HashSet<TagPath> hashSet = new HashSet<TagPath>();
        hashSet.addAll((Collection<TagPath>)b.a());
        for (at object : this.searchBoxSources) {
            if (cn.h(object.b())) continue;
            object.a(queryParamRootGroup);
            if (object.c().isMIMDataTagPath()) continue;
            hashSet.add(object.c());
        }
        for (TagPath tagPath : hashSet) {
            queryParamRootGroup.a(tagPath);
        }
        return queryParamRootGroup;
    }

    @Override
    public boolean isSearchBlank() {
        if (!((HashMap)this.getSearchParameters()).isEmpty()) {
            return false;
        }
        for (at at2 : this.searchBoxSources) {
            if (cn.h(at2.b())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Future<?> doSearch(SearchSource searchSource, f<i> f2, Searchable.a a2) {
        Runnable runnable;
        Serializable serializable;
        if (searchSource instanceof RemoteSearchSource && !((SearchSource)(serializable = (RemoteSearchSource)searchSource)).J()) {
            HashMap hashMap = Maps.newHashMap((Map)this.getSearchParameters());
            return m.e.a(searchSource.b((Map<String, String>)hashMap, f2, a2), "Legacy Patient List Search");
        }
        serializable = this.generateQuery();
        if (serializable != null && (runnable = searchSource.a(new q.d((QueryParamGroup.QueryParamRootGroup)serializable), f2, a2)) != null) {
            PatientSearchPanel.a(searchSource);
            return m.e.a(runnable, "Standard Patient List Search");
        }
        ay.b((Object)"Invalid parameter for query", this.getClass());
        return null;
    }

    private JXDatePicker makeDatePicker() {
        JXDatePicker jXDatePicker = new JXDatePicker(Locale.getDefault());
        JFormattedTextField jFormattedTextField = jXDatePicker.getEditor();
        JPopupMenu jPopupMenu = jFormattedTextField.getComponentPopupMenu();
        jPopupMenu.addSeparator();
        jPopupMenu.add(new TextEditDefaultActions.TextEditDefaultActionMenuItem(new StandardSearchPanelDateMenuItems.SearchDateTodayAction(this, (JTextComponent)jFormattedTextField)));
        jPopupMenu.add(new TextEditDefaultActions.TextEditDefaultActionMenuItem(new StandardSearchPanelDateMenuItems.SearchDateYesterdayAction(this, (JTextComponent)jFormattedTextField)));
        jPopupMenu.add(new TextEditDefaultActions.TextEditDefaultActionMenuItem(new StandardSearchPanelDateMenuItems.SearchDateLastWeekAction(this, (JTextComponent)jFormattedTextField)));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new TextEditDefaultActions.TextEditDefaultActionMenuItem(new StandardSearchPanelDateMenuItems.ClearSearchDateAction(this, (JTextComponent)jFormattedTextField)));
        jFormattedTextField.setComponentPopupMenu(jPopupMenu);
        jXDatePicker.setLightWeightPopupEnabled(true);
        jXDatePicker.setLinkPanel(null);
        return jXDatePicker;
    }

    private void CreateDate(TagPath tagPath, String string) {
        JXDatePicker jXDatePicker = this.makeDatePicker();
        this.searchBoxSources.add(new at.g(jXDatePicker, tagPath));
        JXDatePicker jXDatePicker2 = this.makeDatePicker();
        this.searchBoxSources.add(new at.c(jXDatePicker2, tagPath));
        this.timeComponents.add(jXDatePicker);
        this.timeComponents.add(jXDatePicker2);
        jXDatePicker.getEditor().putClientProperty("com.mimvista.JTextField.InsideLabel", MIMFormat.a(props.getProperty("STANDARD_START_RANGE").toString(), string));
        jXDatePicker2.getEditor().putClientProperty("com.mimvista.JTextField.InsideLabel", MIMFormat.a(props.getProperty("STANDARD_END_RANGE").toString(), string));
    }

    private void createOwnerField() {
        this.ownerField = new JComboBox();
        try {
            this.searchBoxSources.add(new at.f(this.ownerField, new TagPath(TagUtils.parse("mimdata.owners.ownerName"))));
            this.ownerField.setRenderer(new AbstractBasicSearchPanel.OwnerListCellRenderer());
            this.ownerField.setEditor(new AbstractBasicSearchPanel.a(this.ownerField));
            this.ownerField.setVisible(false);
            this.ownerField.setEditable(true);
            for (MetabaseOwnerStrings metabaseOwnerStrings : MetabaseOwnerStrings.aG_()) {
                this.ownerField.addItem(metabaseOwnerStrings.c());
            }
        }
        catch (DicomTagParseException dicomTagParseException) {
            // empty catch block
        }
    }

    private void createSearchBoxes() {
        Iterator iterator = ((ArrayList)PatientListPrefs.standardSearchFields.getValue()).iterator();
        while (iterator.hasNext()) {
            ar ar2 = (ar)iterator.next();
            try {
                TagPath tagPath = ar2.getTag();
                String string = ar2.getHeader();
                switch (tagPath.getTag(0).getTagInt()) {
                    case 930312194: {
                        tagPath = new TagPath(TagUtils.parse("mimdata.searchDate"));
                        ar2 = new ar(tagPath, string);
                        string = ar2.getHeader();
                        this.CreateDate(tagPath, string);
                        break;
                    }
                    case 930312193: {
                        this.keywordsField = new JTextField();
                        this.keywordsField.putClientProperty("com.mimvista.JTextField.InsideLabel", string);
                        this.searchBoxSources.add(new at.d(this.keywordsField, tagPath));
                        break;
                    }
                    case 524384: {
                        this.modalityField = new JTextField();
                        this.modalityField.putClientProperty("com.mimvista.JTextField.InsideLabel", string);
                        this.searchBoxSources.add(new at.e(this.modalityField, tagPath));
                        break;
                    }
                    default: {
                        VR vR = TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
                        if (VRUtils.isDateTypeVR(vR)) {
                            this.CreateDate(tagPath, string);
                            break;
                        }
                        JTextField jTextField = new JTextField();
                        jTextField.putClientProperty("com.mimvista.JTextField.InsideLabel", string);
                        this.searchBoxSources.add(new at.a(jTextField, tagPath));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                ay.d((Object)("Unable to parse tag while search box: " + ar2), (Throwable)exception, this);
            }
        }
        this.createOwnerField();
    }
}

