/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.mimvista.archive.gui.p;
import com.mimvista.archive.search.RemoteMetabaseSearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.gui.util.c;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.j;
import com.mimvista.metabase.n;
import com.mimvista.swing.i;
import com.mimvista.workflow.backend.g;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ViewJsonDicomRecordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> json;
    private JTextField searchTxt;
    private JXTreeTable jsonTree;
    private Pattern searchPattern;
    private p.a lastSearchNode;
    private int lastSearchRow;
    private Color origSearchBackground;
    private long lastExpandOrCollapse = 0L;
    private final Color GOOD_SEARCH_COLOR = new Color(20, 70, 20);
    private final Color BAD_SEARCH_COLOR = new Color(70, 20, 20);

    public ViewJsonDicomRecordDialog(Frame frame, g g2, Object object) {
        super(frame);
        this.setTitle("JSON DICOM Record: [id: " + object + "] " + g2.getModality() + ", " + g2.getPatientID());
        this.a(frame, JsonDicomSeries.castOrConvert(g2.getDicomSeries()).getMapView());
    }

    public ViewJsonDicomRecordDialog(Frame frame, DcmSeries dcmSeries, boolean bl2) {
        super(frame);
        this.setTitle("Metabase Record " + (bl2 ? "(db)" : "(mem)") + ": [pk: " + dcmSeries.getPrimaryKey() + "] " + dcmSeries.getDisplayModality() + ", " + dcmSeries.getNumberOfImages() + " Images, " + dcmSeries.getPatientID());
        this.a(frame, this.a(dcmSeries, bl2));
    }

    private void a(Frame frame, final Map<String, Object> map) {
        this.json = map;
        JLabel jLabel = new JLabel("Search:");
        this.searchTxt = new JTextField(40);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        box.add(jLabel);
        box.add(Box.createRigidArea(new Dimension(5, 0)));
        box.add(this.searchTxt);
        this.searchTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        ViewJsonDicomRecordDialog.this.a();
                        break;
                    }
                    case 27: {
                        ViewJsonDicomRecordDialog.this.searchTxt.setText("");
                    }
                }
            }
        });
        this.searchTxt.getDocument().addDocumentListener(new i(){
            private String b = null;

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.a(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.a(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.a(documentEvent);
            }

            public void a(DocumentEvent documentEvent) {
                try {
                    Document document = documentEvent.getDocument();
                    String string = document.getText(0, document.getLength()).trim();
                    if (string.isEmpty()) {
                        ViewJsonDicomRecordDialog.this.lastSearchNode = null;
                        this.b = "";
                        ViewJsonDicomRecordDialog.this.c();
                    } else if (!string.equals(this.b)) {
                        this.b = string;
                        ViewJsonDicomRecordDialog.this.lastSearchNode = null;
                        try {
                            ViewJsonDicomRecordDialog.this.searchPattern = Pattern.compile(string, 2);
                            ViewJsonDicomRecordDialog.this.a();
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            ViewJsonDicomRecordDialog.this.searchTxt.setBackground(ViewJsonDicomRecordDialog.this.BAD_SEARCH_COLOR);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.origSearchBackground = this.searchTxt.getBackground();
        this.jsonTree = new JXTreeTable((TreeTableModel)new DefaultTreeTableModel((TreeTableNode)new DefaultMutableTreeTableNode((Object)"Building tree...", false)));
        this.jsonTree.setRootVisible(true);
        this.jsonTree.setFont(Font.decode("Monospaced"));
        this.jsonTree.setHorizontalScrollEnabled(true);
        this.jsonTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ViewJsonDicomRecordDialog.this.searchTxt.setText("");
                    ViewJsonDicomRecordDialog.this.searchTxt.grabFocus();
                    keyEvent.consume();
                    return;
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c2 = keyEvent.getKeyChar();
                if (Character.isLetterOrDigit(c2) || Character.isWhitespace(c2) || c2 > ' ' && c2 < '\u007f') {
                    ViewJsonDicomRecordDialog.this.searchTxt.setText(Character.toString(c2));
                    ViewJsonDicomRecordDialog.this.searchTxt.grabFocus();
                    keyEvent.consume();
                }
            }
        });
        this.jsonTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                ViewJsonDicomRecordDialog.this.lastExpandOrCollapse = System.currentTimeMillis();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                ViewJsonDicomRecordDialog.this.lastExpandOrCollapse = System.currentTimeMillis();
            }
        });
        this.jsonTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 0 && mouseEvent.getClickCount() != 2) {
                    return;
                }
                int n2 = ViewJsonDicomRecordDialog.this.jsonTree.rowAtPoint(mouseEvent.getPoint());
                if (n2 >= 0 && System.currentTimeMillis() - ViewJsonDicomRecordDialog.this.lastExpandOrCollapse > 500L) {
                    if (ViewJsonDicomRecordDialog.this.jsonTree.isExpanded(n2)) {
                        ViewJsonDicomRecordDialog.this.jsonTree.collapseRow(n2);
                    } else {
                        ViewJsonDicomRecordDialog.this.jsonTree.expandRow(n2);
                    }
                }
            }
        });
        this.jsonTree.addHighlighter((Highlighter)new AbstractHighlighter(){

            protected boolean canHighlight(Component component, ComponentAdapter componentAdapter) {
                return ViewJsonDicomRecordDialog.this.lastSearchNode != null && componentAdapter.row == ViewJsonDicomRecordDialog.this.lastSearchRow;
            }

            protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
                if (componentAdapter.isSelected()) {
                    component.setBackground(ViewJsonDicomRecordDialog.this.GOOD_SEARCH_COLOR.brighter());
                } else {
                    component.setBackground(ViewJsonDicomRecordDialog.this.GOOD_SEARCH_COLOR);
                }
                return component;
            }
        });
        final SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private p c;

            protected Void a() throws Exception {
                this.c = p.a(map);
                return null;
            }

            @Override
            protected void done() {
                if (!this.isCancelled()) {
                    int n2;
                    Object object;
                    ViewJsonDicomRecordDialog.this.jsonTree.setRootVisible(false);
                    ViewJsonDicomRecordDialog.this.jsonTree.setTreeTableModel((TreeTableModel)this.c);
                    ViewJsonDicomRecordDialog.this.jsonTree.setAutoResizeMode(0);
                    int n3 = 10;
                    FontMetrics fontMetrics = ViewJsonDicomRecordDialog.this.jsonTree.getFontMetrics(ViewJsonDicomRecordDialog.this.jsonTree.getFont());
                    int n4 = ViewJsonDicomRecordDialog.this.jsonTree.getColumnCount();
                    int[] nArray = new int[n4];
                    p.b b2 = this.c.b();
                    while (b2.hasNext()) {
                        object = (p.a)b2.next();
                        for (n2 = 0; n2 < n4; ++n2) {
                            Object object2 = ((p.a)object).getValueAt(n2);
                            String string = object2 == null ? "" : object2.toString();
                            nArray[n2] = Math.max(nArray[n2], fontMetrics.stringWidth(string));
                        }
                    }
                    for (int i2 = 0; i2 < n4; ++i2) {
                        object = ViewJsonDicomRecordDialog.this.jsonTree.getColumn(i2);
                        n2 = Math.max(nArray[i2], fontMetrics.stringWidth(((TableColumn)object).getHeaderValue().toString()));
                        ((TableColumn)object).setPreferredWidth(n2 + 10);
                    }
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.a();
            }
        };
        swingWorker.execute();
        JScrollPane jScrollPane = new JScrollPane((Component)this.jsonTree);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "North");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.add(c.d(actionEvent -> this.dispose(), null));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (map == null) {
                    ViewJsonDicomRecordDialog.this.dispose();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!swingWorker.isDone()) {
                    swingWorker.cancel(true);
                }
            }
        });
        this.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(1440, 1080);
        this.setLocationRelativeTo(frame);
    }

    private void a() {
        p p2 = (p)this.jsonTree.getTreeTableModel();
        p.b b2 = p2.a(this.lastSearchNode == null ? p2.a() : this.lastSearchNode);
        while (b2.hasNext()) {
            p.a a2 = (p.a)b2.next();
            for (int i2 = 0; i2 < a2.getColumnCount(); ++i2) {
                Object object = a2.getValueAt(i2);
                if (!this.searchPattern.matcher(String.valueOf(object)).find()) continue;
                this.a(a2);
                return;
            }
        }
        this.b();
    }

    private void a(p.a a2) {
        this.searchTxt.setBackground(this.GOOD_SEARCH_COLOR);
        this.lastSearchNode = a2;
        TreePath treePath = this.lastSearchNode.c();
        this.jsonTree.expandPath(treePath);
        this.jsonTree.scrollPathToVisible(treePath);
        this.lastSearchRow = this.jsonTree.getRowForPath(treePath);
        this.jsonTree.repaint();
    }

    private void b() {
        this.searchTxt.setBackground(this.BAD_SEARCH_COLOR);
        this.lastSearchNode = null;
        this.jsonTree.repaint();
    }

    private void c() {
        this.searchTxt.setBackground(this.origSearchBackground);
        this.lastSearchNode = null;
        this.jsonTree.repaint();
    }

    private Map<String, Object> a(DcmSeries dcmSeries, boolean bl2) {
        Map<String, Object> map = dcmSeries.getMapView();
        if (bl2) {
            long l2 = dcmSeries.getPrimaryKey();
            MetabaseQuery metabaseQuery = n.a(l2);
            if (dcmSeries.getSearchSource() instanceof RemoteMetabaseSearchSource) {
                RemoteMetabaseSearchSource remoteMetabaseSearchSource = (RemoteMetabaseSearchSource)dcmSeries.getSearchSource();
                if (!remoteMetabaseSearchSource.r()) {
                    JOptionPane.showMessageDialog(this, "The remote source is too old to support direct metabase queries.");
                    return null;
                }
                try {
                    List<DcmSeries> list = remoteMetabaseSearchSource.a(metabaseQuery, (Searchable.a)null, (f<com.mimvista.archive.search.i>)null).get();
                    if (list.size() != 1) {
                        JOptionPane.showMessageDialog(this, "Can't find a remote metabase record for pk: " + l2);
                        return null;
                    }
                    map = list.get(0).getMapView();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, ExceptionUtils.getStackTrace((Throwable)exception));
                    return null;
                }
            } else {
                List<? extends Series> list = metabaseQuery.a(j.a());
                if (list.size() != 1) {
                    JOptionPane.showMessageDialog(this, "Can't find a local metabase record for pk: " + l2);
                    return null;
                }
                map = list.get(0).asJsonMap(1);
            }
        }
        return map;
    }
}

