/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui.fractions;

import com.google.common.collect.ImmutableList;
import com.mimvista.MimJsonSerializable;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;

@MimJsonSerializable
public enum FractionStatus {
    NOT_PROCESSED(MIMLookAndFeel.i().darker(), 2),
    PROCESSING(MIMLookAndFeel.o(), 2),
    FAILED_PROCESSING(MIMLookAndFeel.t(), 0),
    NEEDS_REVIEW(MIMLookAndFeel.i(), 1),
    REVIEWED(MIMLookAndFeel.i(), 0),
    IGNORED(MIMLookAndFeel.i(), 0),
    UNSUPPORTED(MIMLookAndFeel.t(), 2);

    public static final List<FractionStatus> USER_MODIFIABLE_STATUSES;
    public static final List<FractionStatus> CANCELLABLE_STATUSES;
    private Color color;
    private int font;

    private FractionStatus(Color color, int n3) {
        this.color = color;
        this.font = n3;
    }

    public void applyColor(JLabel jLabel) {
        jLabel.setForeground(this.color);
    }

    public void applyFont(Component component) {
        component.setFont(component.getFont().deriveFont(this.font));
    }

    public String getExternalizedString() {
        return Messages.a("ArayAdaptivePatientList", "FRACTION_STATUS_" + this.name());
    }

    public boolean shouldAuthorizeStatusChangeTo(FractionStatus fractionStatus) {
        switch (fractionStatus) {
            case REVIEWED: 
            case IGNORED: 
            case FAILED_PROCESSING: 
            case NOT_PROCESSED: {
                return true;
            }
            case NEEDS_REVIEW: {
                return this == REVIEWED;
            }
        }
        return false;
    }

    public static FractionStatus getFractionStatusFromWorkflowStatus(AutomatedWorkflowStatus automatedWorkflowStatus) {
        switch (automatedWorkflowStatus) {
            case b: 
            case m: 
            case a: 
            case o: {
                return NOT_PROCESSED;
            }
            case l: {
                return PROCESSING;
            }
            case p: {
                return NEEDS_REVIEW;
            }
        }
        return FAILED_PROCESSING;
    }

    static {
        USER_MODIFIABLE_STATUSES = new ImmutableList.Builder().add((Object)REVIEWED).add((Object)NEEDS_REVIEW).build();
        CANCELLABLE_STATUSES = new ImmutableList.Builder().add((Object)PROCESSING).add((Object)NOT_PROCESSED).build();
    }
}

