/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SourceType;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.gui.ai;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.am;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.FindingsUnbundler;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.file.ZipControl;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class k
extends ai {
    public k(aj aj2) {
        super(Messages.a("Archive", "EXTRACT_FINDINGS"), EnumSet.of(SourceType.b, SourceType.c, SourceType.d));
    }

    @Override
    public boolean accept(List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            if (Modality.FINDINGS.isSameModality(dcmSeries.getModality())) continue;
            return false;
        }
        return list.size() > 0;
    }

    @Override
    public void act(am am2) {
        this.a(am2.d());
        ArrayList arrayList = Lists.newArrayList(am2.d());
        m.e.execute(() -> {
            for (DcmSeries dcmSeries : arrayList) {
                try {
                    this.a(dcmSeries);
                }
                catch (Exception exception) {
                    ay.d((Object)"Error extracting findings", (Throwable)exception, this.getClass());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(DcmSeries dcmSeries) {
        ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.a(Messages.a("Archive", "EXTRACT_FINDINGS_PROGRESS"));
        progressPanel.a(true);
        ProgressQueueNotification.a(progressPanel);
        byte[] byArray = new FindingsUnbundler(dcmSeries.getDataProvider()).extractZippedBundle();
        MIMFile mIMFile = PathUtils.getTempPathUnique("extractFindings");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ZipControl.unZipTo((InputStream)byteArrayInputStream, mIMFile);
        }
        catch (Exception exception) {
            ay.d((Object)"Error unzipping findigns", (Throwable)exception, this.getClass());
        }
        finally {
            progressPanel.b();
            cm.a((Closeable)byteArrayInputStream, "Error closing stream", this.getClass());
        }
        SendToDestination sendToDestination = ag.a(dcmSeries.getSearchSource());
        FolderSearchSource.a(dcmSeries.getSearchSource(), sendToDestination, mIMFile.getAbsolutePath(), true);
    }

    private void a(List<DcmSeries> list) {
        LoginChecker loginChecker = LoginChecker.getInstance();
        String string = loginChecker.getUserFullName();
        if (string == null) {
            string = "";
        }
        try {
            string = string + " (" + InetAddress.getLocalHost().getHostAddress() + ")";
        }
        catch (Exception exception) {
            string = string + " (ERROR GETTING IP ADDRESS)";
        }
        string = string + " Opened DICOM information for the following series : ";
        for (DcmSeries dcmSeries : list) {
            SeriesInfo seriesInfo = dcmSeries.getDataProvider().getUncopiedMutableInfo();
            if (seriesInfo == null) continue;
            string = string + "\nUID: " + seriesInfo.ag() + ", dated: " + seriesInfo.M();
        }
        ay.b((Object)string, "auditlog");
    }
}

