/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui.report;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mimvista.archive.gui.SeriesContextMenuModel;
import com.mimvista.archive.gui.ah;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.h;
import com.mimvista.archive.gui.report.ReportResultPanel;
import com.mimvista.archive.gui.report.ReportResultTab;
import com.mimvista.archive.gui.report.a;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.DynamicPopupMenu;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.e;
import com.mimvista.gui.util.l;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.SeriesSelectionTable;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.g;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;

public class ReportCalendarPanel
extends ReportResultTab {
    private static final long serialVersionUID = 1L;
    private static final Comparator<com.mimvista.workflow.backend.g> a = new Comparator<com.mimvista.workflow.backend.g>(){

        public int a(com.mimvista.workflow.backend.g g2, com.mimvista.workflow.backend.g g3) {
            int n2 = cn.b(g2.getDate(), g3.getDate(), false);
            if (n2 == 0) {
                n2 = cn.b(g2.getTime(), g3.getTime(), false);
            }
            if (n2 == 0) {
                n2 = cn.b(g2.getModality(), g3.getModality(), false);
            }
            return n2;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((com.mimvista.workflow.backend.g)object, (com.mimvista.workflow.backend.g)object2);
        }
    };
    private JXMonthView monthView;
    private JLabel currentDate;
    private Multimap<String, DcmSeries> currentData = null;
    private Map<String, DcmSeries> currentRefdSeries = null;
    private List<Date> currentDates = Lists.newArrayList();
    private ReportResultPanel parent;
    private SeriesSelectionTable table;
    private JLabel currPosition;
    private JLabel firstDate;
    private JLabel lastDate;
    private JLabel dateLbl;
    private JButton delAfterBtn;

    public ReportCalendarPanel(ReportResultPanel reportResultPanel) {
        this.parent = reportResultPanel;
        this.d();
    }

    private void d() {
        this.setLayout(new BorderLayout());
        this.setBackground(ReportResultPanel.a);
        this.monthView = this.e();
        Box box = Box.createVerticalBox();
        box.setBackground(ReportResultPanel.a);
        box.add((Component)this.monthView);
        Messages messages = Messages.a("PatientList");
        Box box2 = Box.createHorizontalBox();
        box2.setBackground(ReportResultPanel.a);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(new JLabel(messages.b("REPORT_CALENDAR_FIRST_DATE")));
        box2.add(Box.createHorizontalStrut(5));
        this.firstDate = new JLabel();
        box2.add(this.firstDate);
        box2.add(Box.createHorizontalStrut(15));
        box2.add(new JLabel(messages.b("REPORT_CALENDAR_LAST_DATE")));
        box2.add(Box.createHorizontalStrut(5));
        this.lastDate = new JLabel();
        box2.add(this.lastDate);
        box2.add(Box.createHorizontalStrut(15));
        box2.add(Box.createGlue());
        box2.add(this.a(messages));
        box.add(box2);
        box.add(new JSeparator());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(ReportResultPanel.a);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createMatteBorder(10, 5, 10, 10, ReportResultPanel.a));
        jPanel2.setBackground(ReportResultPanel.a);
        this.dateLbl = new JLabel(messages.b("REPORT_CALENDAR_SELECTED_DATE"));
        this.dateLbl.setFont(ReportResultPanel.b);
        jPanel2.add(this.dateLbl);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.currentDate = new JLabel(Messages.a("Report", "NONE"));
        this.currentDate.setFont(ReportResultPanel.c);
        jPanel2.add(this.currentDate);
        jPanel2.add(Box.createHorizontalGlue());
        this.delAfterBtn = new JButton(messages.b("REPORT_CALENDAR_DELETE_GENERATED"));
        this.delAfterBtn.setToolTipText(messages.b("REPORT_CALENDAR_DELETE_GENERATED_TIP"));
        this.delAfterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportCalendarPanel.this.i();
            }
        });
        jPanel2.add(this.delAfterBtn);
        jPanel.add((Component)jPanel2, "North");
        this.table = new SeriesSelectionTable(true, this.parent.a().u(), null);
        this.table.setSelectionMode(2);
        this.table.setVisibleRowCount(5);
        this.table.setFillsViewportHeight(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReportCalendarPanel.this.parent.a().o();
            }
        });
        MIMSwingUtils.a((JTable)((Object)this.table), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportCalendarPanel.this.parent.a().j();
            }
        });
        Supplier<DynamicPopupMenu> supplier = () -> {
            List<e> list = ReportResultPanel.a((aj)this.parent, (JTable)((Object)this.table), true);
            list.add(new ah());
            list.add(new a(this.parent.d(), this.parent::h));
            return new DynamicPopupMenu(new SeriesContextMenuModel(this.parent, list));
        };
        DynamicPopupMenu.a((JTable)((Object)this.table), supplier);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 5, 5, 5, ReportResultPanel.a));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(ReportResultPanel.a);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)box, "North");
        jPanel3.add((Component)jPanel, "Center");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel3);
        this.add((Component)jScrollPane2, "Center");
    }

    private JXMonthView e() {
        JXMonthView jXMonthView = new JXMonthView();
        jXMonthView.setFont(ReportResultPanel.b.deriveFont(11));
        jXMonthView.setPreferredColumnCount(1);
        jXMonthView.setTraversable(true);
        jXMonthView.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        Color color = MIMLookAndFeel.b();
        jXMonthView.setSelectionBackground(MIMLookAndFeel.d());
        jXMonthView.setDayForeground(1, color);
        jXMonthView.setDayForeground(2, color);
        jXMonthView.setDayForeground(3, color);
        jXMonthView.setDayForeground(4, color);
        jXMonthView.setDayForeground(5, color);
        jXMonthView.setDayForeground(6, color);
        jXMonthView.setDayForeground(7, color);
        jXMonthView.setFlaggedDayForeground(Color.GREEN);
        jXMonthView.setSelectionMode(DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION);
        jXMonthView.getSelectionModel().addDateSelectionListener(new DateSelectionListener(){

            public void valueChanged(DateSelectionEvent dateSelectionEvent) {
                if (!dateSelectionEvent.isAdjusting()) {
                    ReportCalendarPanel.this.h();
                }
            }
        });
        return jXMonthView;
    }

    private void h() {
        if (this.currentDate != null) {
            SortedSet sortedSet = this.monthView.getSelectionModel().getSelection();
            if (!sortedSet.isEmpty()) {
                Object object;
                Object object2;
                Date date = (Date)sortedSet.first();
                Date date2 = (Date)sortedSet.last();
                DateFormat dateFormat = DateFormat.getDateInstance(1);
                if (date == date2) {
                    this.dateLbl.setText(Messages.a("PatientList", "REPORT_CALENDAR_SELECTED_DATE"));
                    this.currentDate.setText(dateFormat.format(date));
                    this.delAfterBtn.setText(Messages.a("PatientList", "REPORT_CALENDAR_DELETE_GENERATED"));
                    this.delAfterBtn.setToolTipText(Messages.a("PatientList", "REPORT_CALENDAR_DELETE_GENERATED_TIP"));
                } else {
                    object2 = dateFormat.format(date);
                    object = dateFormat.format(date2);
                    this.dateLbl.setText(Messages.a("PatientList", "REPORT_CALENDAR_SELECTED_DATES"));
                    this.currentDate.setText((String)object2 + " - " + (String)object);
                    this.delAfterBtn.setText(Messages.a("PatientList", "REPORT_CALENDAR_DELETE_GENERATED_RANGE"));
                    this.delAfterBtn.setToolTipText(Messages.a("PatientList", "REPORT_CALENDAR_DELETE_GENERATED_RANGE_TIP"));
                }
                if (this.currentData != null) {
                    object2 = new SimpleDateFormat("yyyyMMdd");
                    object = Lists.newArrayList();
                    for (Date date3 : sortedSet) {
                        String string = ((DateFormat)object2).format(date3);
                        Collection collection = this.currentData.get((Object)string);
                        if (collection == null) continue;
                        object.addAll(this.currentData.get((Object)string));
                    }
                    Collections.sort(object, a);
                    this.table.a((List<DcmSeries>)object);
                }
                if (this.currentDates != null) {
                    int n2 = -1;
                    if (date == date2) {
                        n2 = this.currentDates.indexOf(date);
                    }
                    object = n2 != -1 ? Integer.toString(n2 + 1) : "?";
                    String string = Messages.a("mui", "MIMMAIN_PAGE_RANGE");
                    this.currPosition.setText(MIMFormat.a(string, object, this.currentDates.size()));
                }
            } else {
                this.currentDate.setText(Messages.a("Report", "NONE"));
                this.table.a(new ArrayList<DcmSeries>(0));
                String string = Messages.a("mui", "MIMMAIN_PAGE_RANGE");
                this.currPosition.setText(MIMFormat.a(string, "?", this.currentDates.size()));
            }
        }
    }

    private JPanel a(Messages messages) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(5, 0, 5, 5, ReportResultPanel.a));
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.currPosition = new JLabel();
        jPanel.add(this.currPosition);
        jPanel.add(Box.createHorizontalStrut(10));
        JButton jButton = new JButton();
        jButton.setToolTipText(messages.b("REPORT_CALENDAR_FIRST_TIP"));
        jButton.setIcon(ImageManipulator.c("skip_start", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportCalendarPanel.this.currentDates.size() > 0) {
                    Date date = (Date)ReportCalendarPanel.this.currentDates.get(0);
                    ReportCalendarPanel.this.monthView.setSelectionDate(date);
                    ReportCalendarPanel.this.monthView.ensureDateVisible(date);
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton2 = new JButton();
        jButton2.setToolTipText(messages.b("REPORT_CALENDAR_PREV_TIP"));
        jButton2.setIcon(ImageManipulator.c("rewind", 16));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date date = ReportCalendarPanel.this.monthView.getSelectionModel().getFirstSelectionDate();
                if (date != null) {
                    for (int i2 = ReportCalendarPanel.this.currentDates.size() - 1; i2 >= 0; --i2) {
                        Date date2 = (Date)ReportCalendarPanel.this.currentDates.get(i2);
                        if (i2 != 0 && date2.compareTo(date) >= 0) continue;
                        ReportCalendarPanel.this.monthView.setSelectionDate(date2);
                        ReportCalendarPanel.this.monthView.ensureDateVisible(date2);
                        break;
                    }
                }
            }
        });
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton3 = new JButton();
        jButton3.setToolTipText(messages.b("REPORT_CALENDAR_NEXT_TIP"));
        jButton3.setIcon(ImageManipulator.c("fast_forward", 16));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date date = ReportCalendarPanel.this.monthView.getSelectionModel().getLastSelectionDate();
                if (date != null) {
                    for (int i2 = 0; i2 < ReportCalendarPanel.this.currentDates.size(); ++i2) {
                        Date date2 = (Date)ReportCalendarPanel.this.currentDates.get(i2);
                        if (i2 != ReportCalendarPanel.this.currentDates.size() - 1 && date2.compareTo(date) <= 0) continue;
                        ReportCalendarPanel.this.monthView.setSelectionDate(date2);
                        ReportCalendarPanel.this.monthView.ensureDateVisible(date2);
                        break;
                    }
                }
            }
        });
        jPanel.add(jButton3);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton4 = new JButton();
        jButton4.setToolTipText(messages.b("REPORT_CALENDAR_LAST_TIP"));
        jButton4.setIcon(ImageManipulator.c("skip_end", 16));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportCalendarPanel.this.currentDates.size() > 0) {
                    Date date = (Date)ReportCalendarPanel.this.currentDates.get(ReportCalendarPanel.this.currentDates.size() - 1);
                    ReportCalendarPanel.this.monthView.setSelectionDate(date);
                    ReportCalendarPanel.this.monthView.ensureDateVisible(date);
                }
            }
        });
        jPanel.add(jButton4);
        return jPanel;
    }

    public void a(List<DcmSeries> list, Map<String, DcmSeries> map) {
        Object object;
        String string;
        String string2;
        HashMultimap hashMultimap = HashMultimap.create();
        ArrayList arrayList = Lists.newArrayList();
        for (DcmSeries dcmSeries : list) {
            string2 = dcmSeries.getDisplayModality().toUpperCase();
            if ("SR".equals(string2) || "DOC".equals(string2) || "RTDOSE".equals(string2) || "RTST".equals(string2)) {
                arrayList.add(dcmSeries);
                continue;
            }
            string = dcmSeries.getDate();
            if (string != null) {
                object = DateUtils.b(string, "yyyyMMdd");
                hashMultimap.put(object, (Object)dcmSeries);
                continue;
            }
            ay.c((Object)("Series with no date in ReportCalendarPanel: " + dcmSeries), this);
        }
        for (DcmSeries dcmSeries : arrayList) {
            Object object2;
            string2 = dcmSeries.getDate();
            string = dcmSeries.getDisplayModality().toUpperCase();
            object = dcmSeries.getReferencedSeries();
            if (object != null) {
                DcmSeries dcmSeries2;
                DcmSeriesReference dcmSeriesReference;
                Set<DcmSeries> set;
                object2 = null;
                if ("SR".equals(string) || "DOC".equals(string)) {
                    object2 = object.get((Object)DcmSeriesReference.ReferenceSource.DocAndSRDerivedSeries);
                } else if ("RTDOSE".equals(string)) {
                    object2 = object.get((Object)DcmSeriesReference.ReferenceSource.ReferencedSeriesSequence);
                    if (object2 == null) {
                        object2 = object.get((Object)DcmSeriesReference.ReferenceSource.ReferencedRTPlanSequence);
                    }
                } else if ("RTST".equals(string)) {
                    object2 = object.get((Object)DcmSeriesReference.ReferenceSource.ReferencedFrameOfReferenceSequence);
                }
                if (!(object2 == null || object2.isEmpty() || (set = (dcmSeriesReference = (DcmSeriesReference)Iterables.get((Iterable)object2, (int)0)).getReferencedDcmSeries()) == null || set.isEmpty() || !hashMultimap.containsValue((Object)(dcmSeries2 = (DcmSeries)Iterables.get(set, (int)0))) && string2 != null)) {
                    string2 = dcmSeries2.getDate();
                }
            }
            if (string2 != null) {
                object2 = DateUtils.b(string2, "yyyyMMdd");
                hashMultimap.put(object2, (Object)dcmSeries);
                continue;
            }
            ay.c((Object)("Ref series with no date in ReportCalendarPanel: " + dcmSeries), this);
        }
        this.currentData = hashMultimap;
        this.currentRefdSeries = map;
        this.a(false);
    }

    private void a(boolean bl2) {
        Multimap<String, DcmSeries> multimap = this.currentData;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)multimap.keySet().size());
        for (Object object : multimap.keySet()) {
            try {
                arrayList.add(simpleDateFormat.parse((String)object));
            }
            catch (ParseException parseException) {
                ay.d((Object)"Unable to parse Date string, even though we created it.", (Throwable)parseException, this);
            }
        }
        Collections.sort(arrayList);
        this.currentDates = arrayList;
        this.monthView.clearFlaggedDates();
        if (!bl2) {
            this.monthView.clearSelection();
        }
        this.table.a(new ArrayList<DcmSeries>(0));
        if (arrayList.size() > 0) {
            Object object;
            this.monthView.setFlaggedDates(arrayList.toArray(new Date[arrayList.size()]));
            Date date = (Date)arrayList.get(0);
            this.firstDate.setText(DateFormat.getDateInstance(1).format(date));
            object = (Date)arrayList.get(arrayList.size() - 1);
            this.lastDate.setText(DateFormat.getDateInstance(1).format((Date)object));
            if (!bl2) {
                this.monthView.ensureDateVisible(date);
                this.monthView.ensureDateVisible((Date)object);
                this.monthView.setSelectionDate((Date)object);
            } else {
                SortedSet sortedSet = this.monthView.getSelectionModel().getSelection();
                if (!sortedSet.isEmpty()) {
                    for (Date date2 : sortedSet) {
                        this.monthView.getSelectionModel().addSelectionInterval(date2, date2);
                    }
                    this.h();
                }
            }
        } else {
            this.firstDate.setText("");
            this.lastDate.setText("");
        }
    }

    @Override
    public List<DcmSeries> a() {
        return Lists.newArrayList(this.table.a());
    }

    @Override
    public List<DcmSeries> b() {
        return Lists.newArrayList(this.table.c());
    }

    @Override
    public DcmSeries c() {
        return this.table.b();
    }

    @Override
    public void a(DcmSeries dcmSeries) {
        Multimap<String, DcmSeries> multimap = this.currentData;
        if (multimap != null) {
            Iterator iterator = multimap.values().iterator();
            while (iterator.hasNext()) {
                DcmSeries dcmSeries2 = (DcmSeries)iterator.next();
                if (!dcmSeries.equals(dcmSeries2)) continue;
                iterator.remove();
            }
            if (this.currentData == multimap) {
                this.a(true);
            }
        }
    }

    private void i() {
        SortedSet sortedSet = this.monthView.getSelectionModel().getSelection();
        if (!sortedSet.isEmpty()) {
            Date date;
            Date date2;
            Date date3;
            Date date4 = (Date)sortedSet.first();
            if (date4 == (date3 = (Date)sortedSet.last())) {
                date2 = date4;
                date = this.currentDates.get(this.currentDates.size() - 1);
            } else {
                date2 = date4;
                date = date3;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            HashMultimap hashMultimap = HashMultimap.create();
            Predicate<DcmSeries> predicate = new Predicate<DcmSeries>(){

                public boolean a(DcmSeries dcmSeries) {
                    String string = dcmSeries.getDisplayModality();
                    if (string != null) {
                        if ((string = string.toUpperCase()).startsWith("RT") && !"RTPLAN".equals(string)) {
                            return ReportCalendarPanel.this.currentRefdSeries != null && !ReportCalendarPanel.this.currentRefdSeries.containsValue(dcmSeries);
                        }
                        return "SR".equals(string) || "DOC".equals(string);
                    }
                    return false;
                }

                public /* synthetic */ boolean apply(Object object) {
                    return this.a((DcmSeries)object);
                }
            };
            for (Date date5 : this.currentDates) {
                String string;
                Collection collection;
                if (date5.compareTo(date2) < 0 || date5.compareTo(date) > 0 || (collection = this.currentData.get((Object)(string = simpleDateFormat.format(date5)))) == null) continue;
                for (DcmSeries dcmSeries : collection) {
                    if (!predicate.apply((Object)dcmSeries)) continue;
                    hashMultimap.put((Object)dcmSeries.getDisplayModality(), (Object)dcmSeries);
                }
            }
            ay.b((Object)("Located " + hashMultimap.size() + " non-image series to potentially delete in range " + simpleDateFormat.format(date2) + " to " + simpleDateFormat.format(date)), this);
            this.a((Multimap<String, DcmSeries>)hashMultimap);
        }
    }

    private void a(final Multimap<String, DcmSeries> multimap) {
        if (multimap.size() > 0) {
            ArrayList arrayList = Lists.newArrayList((Iterable)multimap.keySet());
            Collections.sort(arrayList);
            InputNotification inputNotification = new InputNotification(new Notification.a(), Messages.a("Automator", "ACTION_NAME_DELETE"), "badge_remove", true, true, AbstractInputContainer.ScrollBarType.b);
            inputNotification.setOkButtonText(Messages.a("ButtonFactory", "DELETE_BUTTON"));
            inputNotification.addTitle(Messages.a("Automator", "ACTION_NAME_DELETE"));
            inputNotification.addTextAreaAsLabel(Messages.a("PatientList", "REPORT_CALENDAR_DELETE_DESC"));
            inputNotification.addSeparator();
            final HashMap hashMap = Maps.newHashMap();
            for (String string : arrayList) {
                Collection collection = multimap.get((Object)string);
                if (collection == null) continue;
                l<Boolean> l2 = inputNotification.addCheckBox(string + " (" + collection.size() + ")");
                l2.a(Boolean.TRUE);
                hashMap.put(string, l2);
            }
            inputNotification.addOkListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final ArrayList arrayList = Lists.newArrayList();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (!((Boolean)((l)entry.getValue()).b()).booleanValue()) continue;
                        ay.b((Object)("Selected to delete: " + (String)entry.getKey()), this);
                        arrayList.addAll(multimap.get(entry.getKey()));
                    }
                    if (arrayList.size() > 0) {
                        Object object;
                        if (arrayList.size() == 1) {
                            object = Messages.a("PatientList", "REPORT_CALENDAR_DELETE_SERIES_SINGULAR");
                        } else {
                            object = Messages.a("PatientList", "REPORT_CALENDAR_DELETE_SERIES");
                            object = MIMFormat.a((String)object, arrayList.size());
                        }
                        int n2 = MOptionPane.c(ReportCalendarPanel.this.parent.a(), object, Messages.a("PatientList", "REPORT_CALENDAR_DELETE_SERIES_TITLE"), 0);
                        if (n2 == 0) {
                            ProgressQueueNotification.a(new ProgressQueueNotification.b(){

                                @Override
                                public void run(g g2) {
                                    g2.a();
                                    try {
                                        h.a(arrayList, g2, ReportCalendarPanel.this.parent);
                                    }
                                    finally {
                                        g2.b();
                                    }
                                }
                            });
                        }
                    }
                }
            });
            u.b().c(inputNotification);
        } else {
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.c, Messages.a("PatientList", "REPORT_CALENDAR_DELETE_NO_SERIES_FOUND"), new Notification.a(), Notification.NotificationTimeoutType.b, 5000L);
            u.b().c(basicNotification);
        }
    }
}

