/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui.report;

import com.google.common.collect.ImmutableSet;
import com.mimvista.archive.gui.SeriesContextMenuModel;
import com.mimvista.archive.gui.ah;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.report.ArtAssistHistoryDialog;
import com.mimvista.archive.gui.report.AutomatedReportStatusRenderer;
import com.mimvista.archive.gui.report.ReportQueueModel;
import com.mimvista.archive.gui.report.ReportResultPanel;
import com.mimvista.archive.gui.report.ReportResultTab;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.gui.util.DynamicPopupMenu;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.SimpleDynamicPopupModel;
import com.mimvista.gui.util.ac;
import com.mimvista.gui.util.e;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.n;
import com.mimvista.metabase.t;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.report.automated.service.c;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.SeriesSelectionTable;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.u;
import com.mimvista.util.v;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;

public class ReportListPanel
extends ReportResultTab {
    private static final long serialVersionUID = 1L;
    private static final long b = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    public static ImmutableSet<AutomatedWorkflowStatus> a = new ImmutableSet.Builder().add((Object)AutomatedWorkflowStatus.n).add((Object)AutomatedWorkflowStatus.o).add((Object)AutomatedWorkflowStatus.p).build();
    private ReportResultPanel parent;
    private ReportQueueModel queueModel = new ReportQueueModel();
    private SeriesSelectionTable reportsTable;
    private JXTable processingTable;
    private ArtAssistHistoryDialog historyWindow;
    private v autoRefresh = new u(b, new Runnable(){

        @Override
        public void run() {
            if (ReportListPanel.this.isShowing()) {
                ReportListPanel.this.d();
            }
            ReportListPanel.this.autoRefresh.b();
        }
    });

    public static List<c> a(SearchSource searchSource, List<ArtAssistConfig> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ArtAssistConfig object2 : list) {
            for (FractionInformation fractionInformation : object2.H()) {
                arrayList.add(fractionInformation.getFractionSeriesUID());
            }
        }
        Map<String, DcmSeries> map = l.a(searchSource, arrayList);
        ArrayList<c> arrayList2 = new ArrayList<c>();
        for (ArtAssistConfig artAssistConfig : list) {
            for (FractionInformation fractionInformation : artAssistConfig.H()) {
                if (a.contains((Object)fractionInformation.getWorkflowStatus())) continue;
                arrayList2.add(new c((DcmSeries)map.get(fractionInformation.getFractionSeriesUID()), fractionInformation, searchSource, artAssistConfig));
            }
        }
        return arrayList2;
    }

    public ReportListPanel(ReportResultPanel reportResultPanel) {
        this.parent = reportResultPanel;
        this.historyWindow = new ArtAssistHistoryDialog(this);
        this.h();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                ReportListPanel.this.autoRefresh.b();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                ReportListPanel.this.autoRefresh.a();
            }
        });
    }

    private void h() {
        this.setLayout(new BorderLayout());
        this.setBackground(ReportResultPanel.a);
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        jPanel.setBackground(ReportResultPanel.a);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(ReportResultPanel.a);
        this.processingTable = new JXTable((TableModel)this.queueModel);
        this.processingTable.setHighlighters(new Highlighter[]{MIMLookAndFeel.c(this.processingTable.getBackground())});
        this.processingTable.setRowHeight(25);
        this.processingTable.setAutoResizeMode(3);
        this.processingTable.setSelectionMode(2);
        this.processingTable.setDefaultRenderer(AutomatedWorkflowStatus.class, (TableCellRenderer)new AutomatedReportStatusRenderer());
        this.processingTable.setVisibleRowCount(8);
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)this.processingTable, 10);
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        tableColumnAdjuster.adjustColumns();
        this.queueModel.addTableModelListener(tableModelEvent -> SwingUtilities.invokeLater(tableColumnAdjuster::adjustColumns));
        DynamicPopupMenu.a((JTable)this.processingTable, () -> {
            SimpleDynamicPopupModel simpleDynamicPopupModel = new SimpleDynamicPopupModel(this.i());
            DynamicPopupMenu dynamicPopupMenu = new DynamicPopupMenu(simpleDynamicPopupModel);
            simpleDynamicPopupModel.b();
            return dynamicPopupMenu;
        });
        Messages messages = Messages.a("PatientList");
        jPanel2.add((Component)this.a((JTable)this.processingTable, messages.b("REPORT_PROCESSING_QUEUE_TITLE")), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Messages.a("GUI", "ABOUTDIALOG_HEAP_FREE_REFRESH"));
        jButton.setToolTipText(messages.b("REPORT_PROCESSING_REFRESH_TIP"));
        jButton.addActionListener(actionEvent -> m.e.a(this::d, "Refresh queue status"));
        JButton jButton2 = new JButton(messages.getProperty("SHOW_ALL_ART_ASSIST_HISTORY"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportListPanel.this.historyWindow.a(((ReportListPanel)ReportListPanel.this).parent.e().c);
                ReportListPanel.this.historyWindow.setVisible(true);
            }
        });
        box.add(Box.createHorizontalStrut(5));
        box.add(jButton2);
        box.add(Box.createHorizontalStrut(5));
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)box, "South");
        jPanel.add((Component)jPanel2, "North");
        this.reportsTable = new SeriesSelectionTable(false, this.parent.a().u(), null);
        this.reportsTable.setVisibleRowCount(8);
        this.reportsTable.setSelectionMode(2);
        this.reportsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReportListPanel.this.parent.a().o();
            }
        });
        MIMSwingUtils.a((JTable)((Object)this.reportsTable), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportListPanel.this.parent.a().j();
            }
        });
        Supplier<DynamicPopupMenu> supplier = () -> {
            List<e> list = ReportResultPanel.a((aj)this.parent, (JTable)((Object)this.reportsTable), false);
            return new DynamicPopupMenu(new SeriesContextMenuModel(this.parent, list));
        };
        DynamicPopupMenu.a((JTable)((Object)this.reportsTable), supplier);
        jPanel.add((Component)this.a((JTable)((Object)this.reportsTable), messages.b("REPORT_PROCESSING_FINISHED_TITLE")), "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel a(JTable jTable, String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(ReportResultPanel.a);
        Box box = Box.createHorizontalBox();
        box.setBackground(ReportResultPanel.a);
        box.add(Box.createHorizontalStrut(5));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(ReportResultPanel.b);
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)box, "North");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, ReportResultPanel.a));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    void d() {
        this.autoRefresh.a();
        SearchSource searchSource = this.parent.g();
        ReportResultPanel.b b2 = this.parent.e();
        if (searchSource == null || b2 == null) {
            return;
        }
        h h2 = (h)((Object)searchSource);
        List<ArtAssistConfig> list = l.a(h2, b2.b, b2.c);
        List<c> list2 = this.queueModel.a();
        List<c> list3 = ReportListPanel.a(searchSource, list);
        this.b(list3);
        if (!list2.equals(list3)) {
            this.historyWindow.b(b2.c);
        }
        MetabaseQuery metabaseQuery = n.a();
        t.c(metabaseQuery, b2.c, VersionNumber.rawCurrentVersionNotAccountingForMIMviewer());
        t.d(metabaseQuery, Modality.SR.get());
        Future<List<DcmSeries>> future = searchSource.a(metabaseQuery, (Searchable.a)new Searchable.b(), (f<i>)null);
        ArrayList<DcmSeries> arrayList = new ArrayList<DcmSeries>();
        try {
            future.get().stream().filter(dcmSeries -> SeriesIdentifier.comparePatientNames(dcmSeries.getPatientName(), b2.b)).collect(Collectors.toCollection(() -> arrayList));
        }
        catch (Exception exception) {
            ay.c((Object)exception, this);
        }
        this.a((List<DcmSeries>)arrayList);
        this.autoRefresh.b();
        try {
            if (!list2.isEmpty() && list2.size() != list3.size() && this.parent.a().k().j().s()) {
                SwingUtilities.invokeLater(() -> this.parent.a().k().B());
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error updating patient list", (Throwable)exception, this);
        }
    }

    private void a(List<DcmSeries> list) {
        SwingUtilities.invokeLater(() -> this.reportsTable.a(list));
    }

    private List<e> i() {
        ArrayList<e> arrayList = new ArrayList<e>();
        arrayList.add(new ac(Messages.a("PatientList", "REPORT_PROCESSING_REMOVE_SERIES"), actionEvent -> {
            List<c> list = this.j();
            if (list.isEmpty()) {
                return;
            }
            m.e.a(() -> {
                boolean bl2 = this.a((Collection<c>)list);
                this.d();
                if (!bl2) {
                    MOptionPane.b(this.parent, Messages.a("PatientList", "REPORT_PROCESSING_REMOVE_SERIES_ERROR"), Messages.a("PatientList", "REPORT_PROCESSING_REMOVE_SERIES_ERROR_TITLE"), 0);
                }
            }, "Cancel ART Tasks");
        }));
        arrayList.add(new ac(Messages.a("Automator", "REPORT_PROCESSING_RETRY_SERIES"), actionEvent -> {
            List<c> list = this.j();
            if (list.isEmpty()) {
                return;
            }
            m.e.a(() -> {
                boolean bl2 = this.a((c)list.iterator().next());
                this.d();
                if (!bl2) {
                    MOptionPane.b(this.parent, Messages.a("Automator", "REPORT_PROCESSING_RETRY_SERIES_ERROR"), Messages.a("Automator", "REPORT_PROCESSING_RETRY_SERIES_ERROR_TITLE"), 0);
                }
            }, "Retry ART Tasks");
        }));
        arrayList.add(new ah());
        arrayList.add(new ac(Messages.a("GUI", "ABOUTDIALOG_HEAP_FREE_REFRESH"), actionEvent -> m.e.a(this::d, "Refresh queue status")));
        arrayList.add(new ah());
        arrayList.add(new ac(Messages.a("Archive", "SELECT_ALL"), actionEvent -> this.processingTable.selectAll()));
        arrayList.add(new ac(Messages.a("Archive", "SELECT_ALL_DESELECT"), actionEvent -> this.processingTable.clearSelection()));
        return arrayList;
    }

    private List<c> j() {
        int[] nArray = this.processingTable.getSelectedRows();
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<c> arrayList = new ArrayList<c>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = this.processingTable.convertRowIndexToModel(nArray[i2]);
            c c2 = this.queueModel.a(n2);
            arrayList.add(c2);
        }
        return arrayList;
    }

    private boolean a(Collection<c> collection) {
        h h2 = (h)((Object)this.parent.g());
        boolean bl2 = true;
        for (c c2 : collection) {
            try {
                h2.a(c2.e(), c2.c(), false);
            }
            catch (Exception exception) {
                ay.d((Object)exception, this);
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean a(c c2) {
        h h2 = (h)((Object)this.parent.g());
        try {
            h2.a(c2.e(), c2.c(), true);
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return false;
        }
    }

    public void a(List<DcmSeries> list, List<c> list2) {
        this.autoRefresh.a();
        this.a(list);
        this.b(list2);
        this.autoRefresh.b();
    }

    private void b(List<c> list) {
        SwingUtilities.invokeLater(() -> this.queueModel.a(new ArrayList<c>(list)));
    }

    @Override
    public List<DcmSeries> a() {
        return new ArrayList<DcmSeries>(this.reportsTable.a());
    }

    @Override
    public List<DcmSeries> b() {
        return new ArrayList<DcmSeries>(this.reportsTable.c());
    }

    @Override
    public DcmSeries c() {
        return this.reportsTable.b();
    }

    @Override
    public void a(DcmSeries dcmSeries) {
        this.reportsTable.a(dcmSeries);
    }

    public SearchSource e() {
        return this.parent.g();
    }
}

