/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui.report;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.MIMSeriesPanel;
import com.mimvista.archive.gui.SeriesContextMenuModel;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.report.ReportResultPanel;
import com.mimvista.archive.gui.report.ReportResultTab;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.DynamicPopupMenu;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.SimpleDynamicPopupModel;
import com.mimvista.gui.util.ac;
import com.mimvista.gui.util.e;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.f;
import com.mimvista.report.cbct.gui.b;
import com.mimvista.swing.c;
import com.mimvista.swing.m;
import com.mimvista.swing.o;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.SeriesSelectionTable;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.x;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.netbeans.spi.wizard.Wizard;

public class ReportPlanPanel
extends ReportResultTab {
    private static final long serialVersionUID = 1L;
    private ReportResultPanel parent;
    private ReportItemsModel currentItemsModel;
    private Map<String, DcmSeries> currentRefMap;
    private SeriesSelectionTable refdSeriesTable;
    private JXTable planTable;
    private JLabel refWarning;
    private JLabel effDate;
    private JLabel fractions;
    private JLabel fractionsPerCBCT;
    private JLabel requiresShifts;
    private JLabel rxDose;
    private JLabel setupWorkflow;
    private JLabel dailyWorkflow;
    private JButton replan;
    private JLabel configName;

    public ReportPlanPanel(ReportResultPanel reportResultPanel) {
        this.parent = reportResultPanel;
        this.currentItemsModel = new ReportItemsModel();
        this.e();
    }

    private void e() {
        this.setBackground(ReportResultPanel.a);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(ReportResultPanel.a);
        this.planTable = new JXTable((TableModel)this.currentItemsModel);
        MIMSeriesPanel.a(this.planTable);
        this.planTable.setHighlighters(new Highlighter[]{MIMLookAndFeel.c(this.planTable.getBackground())});
        this.planTable.setRowHeight(25);
        this.planTable.setAutoResizeMode(3);
        this.planTable.setSelectionMode(0);
        this.planTable.setVisibleRowCount(5);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.planTable.setDefaultRenderer(Integer.class, (TableCellRenderer)defaultTableCellRenderer);
        this.planTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                JLabel jLabel = new JLabel();
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    jLabel.setIcon(ImageManipulator.c("star_green", 16));
                }
                JPanel jPanel = new JPanel();
                jPanel.setBackground(component.getBackground());
                jPanel.add(jLabel);
                return jPanel;
            }
        });
        this.planTable.setDefaultRenderer(a.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (object instanceof a) {
                    object = ((a)object).a();
                }
                return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            }
        });
        jPanel.add((Component)this.planTable.getTableHeader(), "North");
        jPanel.add((Component)this.planTable, "Center");
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)this.planTable, 10);
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        tableColumnAdjuster.adjustColumns();
        this.currentItemsModel.addTableModelListener(tableModelEvent -> SwingUtilities.invokeLater(tableColumnAdjuster::adjustColumns));
        this.planTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ReportPlanPanel.this.a(ReportPlanPanel.this.d());
            }
        });
        DynamicPopupMenu.a((JTable)this.planTable, () -> {
            SimpleDynamicPopupModel simpleDynamicPopupModel = new SimpleDynamicPopupModel(this.h());
            DynamicPopupMenu dynamicPopupMenu = new DynamicPopupMenu(simpleDynamicPopupModel);
            simpleDynamicPopupModel.b();
            return dynamicPopupMenu;
        });
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(15));
        box.add(new JSeparator());
        jPanel.add((Component)box, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(ReportResultPanel.a);
        jPanel2.add((Component)jPanel, "Center");
        JComponent jComponent = this.i();
        jPanel2.add((Component)jComponent, "South");
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        this.add((Component)jScrollPane, "Center");
    }

    private List<e> h() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new ac(Messages.a("PatientList", "REPORT_PLAN_REPLAN"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportPlanPanel.this.j();
            }
        }));
        arrayList.add(new ac(Messages.a("GUI", "MIMSWING_DELETE"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final ArtAssistConfig artAssistConfig = ReportPlanPanel.this.d();
                if (artAssistConfig == null) {
                    return;
                }
                String string = Messages.a("PatientList", "REPORT_RESULT_CONFIRM_DELETE_SINGLE");
                String string2 = Messages.a("PatientList", "REPORT_RESULT_CONFIRM_DELETE_SINGLE_TITLE");
                int n2 = MOptionPane.a(ReportPlanPanel.this.parent.getJOptionPaneParent(), (Object)string, string2, 0, 2);
                if (n2 != 0) {
                    return;
                }
                final FuncUtils.k<?> k2 = ReportResultPanel.a(ReportPlanPanel.this.parent, Collections.singletonList(artAssistConfig));
                com.mimvista.util.work.m.e.a(new Runnable(){

                    @Override
                    public void run() {
                        k2.get();
                        ReportPlanPanel.this.currentItemsModel.a(artAssistConfig);
                        if (ReportPlanPanel.this.currentItemsModel.getRowCount() == 0) {
                            ReportPlanPanel.this.parent.rerunCurrentSearch();
                        } else {
                            ReportResultPanel.j();
                        }
                    }
                }, "Reporting Deletion Waiter");
            }
        }));
        return arrayList;
    }

    public ArtAssistConfig d() {
        ArtAssistConfig artAssistConfig = null;
        int n2 = this.planTable.getSelectedRow();
        if (n2 != -1) {
            artAssistConfig = this.currentItemsModel.a(this.planTable.convertRowIndexToModel(n2));
        }
        return artAssistConfig;
    }

    private JComponent i() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Messages messages = Messages.a("PatientList");
        this.configName = new JLabel(MIMFormat.a(messages.b("REPORT_PLAN_SELECTED_LABEL"), messages.b("REPORT_PLAN_SELECTED_LABEL_NO_NAME")));
        this.configName.setFont(ReportResultPanel.b);
        jPanel.add((Component)c.d(this.configName), "North");
        JPanel jPanel2 = new JPanel(new SpringLayout());
        this.rxDose = new JLabel();
        jPanel2.add(this.a(Messages.a("Dose", "DOSE_SETTING_PRES_DOSE")));
        jPanel2.add(this.rxDose);
        this.fractions = new JLabel();
        jPanel2.add(this.a(messages.b("REPORT_PLAN_NUM_FRACTIONS_LABEL")));
        jPanel2.add(this.fractions);
        this.fractionsPerCBCT = new JLabel();
        jPanel2.add(this.a(Messages.a("Report", "CBCT_CONS_FRAC_PER_CBCT")));
        jPanel2.add(this.fractionsPerCBCT);
        this.requiresShifts = new JLabel();
        jPanel2.add(this.a(Messages.a("Report", "CBCT_REQUIRE_SHIFTS") + ":"));
        jPanel2.add(this.requiresShifts);
        o.a(jPanel2, 4, 2, 5, 5);
        JPanel jPanel3 = new JPanel(new SpringLayout());
        this.effDate = new JLabel();
        jPanel3.add(this.a(messages.b("REPORT_PLAN_EFF_DATE_LABEL")));
        jPanel3.add(this.effDate);
        this.setupWorkflow = new JLabel();
        jPanel3.add(this.a(messages.b("REPORT_PLAN_SETUP_WF_LABEL")));
        jPanel3.add(this.setupWorkflow);
        this.dailyWorkflow = new JLabel();
        jPanel3.add(this.a(messages.b("REPORT_PLAN_DAILY_WF_LABEL")));
        jPanel3.add(this.dailyWorkflow);
        o.a(jPanel3, 3, 2, 5, 5);
        jPanel.add(c.d(Box.createHorizontalStrut(50), c.f(jPanel2), Box.createHorizontalStrut(50), c.f(jPanel3)));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(messages.b("REPORT_PLAN_REF_SERIES_LABEL"));
        jLabel.setFont(ReportResultPanel.b.deriveFont((float)ReportResultPanel.b.getSize() - 1.0f));
        this.refWarning = new JLabel();
        this.refWarning.setForeground(Color.RED);
        jPanel4.add((Component)c.d(jLabel, this.refWarning), "North");
        this.refdSeriesTable = new SeriesSelectionTable(true, this.parent.a().u(), null);
        this.refdSeriesTable.setVisibleRowCount(4);
        this.refdSeriesTable.setSelectionMode(2);
        this.refdSeriesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReportPlanPanel.this.parent.a().o();
            }
        });
        MIMSwingUtils.a((JTable)((Object)this.refdSeriesTable), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportPlanPanel.this.parent.a().j();
            }
        });
        Supplier<DynamicPopupMenu> supplier = () -> {
            List<e> list = ReportResultPanel.a((aj)this.parent, (JTable)((Object)this.refdSeriesTable), false);
            return new DynamicPopupMenu(new SeriesContextMenuModel(this.parent, list));
        };
        DynamicPopupMenu.a((JTable)((Object)this.refdSeriesTable), supplier);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.refdSeriesTable.getTableHeader(), "North");
        jPanel5.add((Component)((Object)this.refdSeriesTable));
        jPanel4.add(jPanel5);
        this.replan = new JButton(messages.b("REPORT_PLAN_REPLAN"));
        this.replan.setToolTipText(messages.b("REPORT_PLAN_REPLAN_BUTTON_TIP"));
        this.replan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportPlanPanel.this.j();
            }
        });
        jPanel4.add((Component)c.d(this.replan), "South");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void j() {
        ArtAssistConfig artAssistConfig = this.d();
        if (artAssistConfig != null) {
            ArrayList arrayList = Lists.newArrayList();
            this.a(artAssistConfig, arrayList);
            b b2 = new b(artAssistConfig, arrayList);
            Wizard wizard = b2.createWizard();
            m.showWizard((Wizard)wizard);
        }
    }

    private Component a(String string) {
        JLabel jLabel = new JLabel(string, 4);
        jLabel.setForeground(MIMLookAndFeel.c());
        return jLabel;
    }

    private void a(@d ArtAssistConfig artAssistConfig) {
        ArrayList arrayList = Lists.newArrayList();
        boolean bl2 = true;
        Messages messages = Messages.a("PatientList");
        if (artAssistConfig != null) {
            bl2 = this.a(artAssistConfig, arrayList);
            this.configName.setText(MIMFormat.a(messages.b("REPORT_PLAN_SELECTED_LABEL"), messages.b("REPORT_PLAN_SELECTED_LABEL_NO_NAME")));
            if (!cn.h(artAssistConfig.E())) {
                this.configName.setText(MIMFormat.a(messages.b("REPORT_PLAN_SELECTED_LABEL"), artAssistConfig.E()));
            }
            this.effDate.setText(DateUtils.a().format(artAssistConfig.q()) + " " + DateUtils.c().format(artAssistConfig.q()));
            this.fractions.setText(Integer.toString(artAssistConfig.h()));
            this.fractionsPerCBCT.setText(Integer.toString(artAssistConfig.i()));
            this.requiresShifts.setText(Messages.a("General", artAssistConfig.j() ? "YES" : "NO"));
            this.replan.setEnabled(true);
            String string = "";
            switch (artAssistConfig.l()) {
                case USER: {
                    string = MIMFormat.a(messages.b("REPORT_PLAN_DOSE"), com.mimvista.util.contrast.a.a().format(artAssistConfig.k()));
                    break;
                }
                case PRESCRIPTION: {
                    string = MIMFormat.a(messages.b("REPORT_PLAN_DOSE_FROM_RTPLAN"), com.mimvista.util.contrast.a.a().format(artAssistConfig.k()));
                    break;
                }
                case MAX: {
                    string = messages.b("REPORT_PLAN_DOSE_MAX");
                }
            }
            this.rxDose.setText(string);
            this.a(artAssistConfig.e(), this.setupWorkflow);
            this.a(artAssistConfig.g(), this.dailyWorkflow);
        } else {
            this.configName.setText(null);
            this.effDate.setText(null);
            this.fractions.setText(null);
            this.fractionsPerCBCT.setText(null);
            this.rxDose.setText(null);
            this.setupWorkflow.setText(null);
            this.dailyWorkflow.setText(null);
            this.requiresShifts.setText(null);
            this.replan.setEnabled(false);
        }
        this.effDate.invalidate();
        this.fractions.invalidate();
        this.fractionsPerCBCT.invalidate();
        this.rxDose.invalidate();
        this.setupWorkflow.invalidate();
        this.dailyWorkflow.invalidate();
        this.requiresShifts.invalidate();
        this.rxDose.getParent().validate();
        this.setupWorkflow.getParent().validate();
        this.repaint();
        if (bl2) {
            this.refWarning.setText("");
        } else {
            this.refWarning.setText(messages.b("REPORT_PLAN_REF_MISSING_WARNING"));
        }
        this.refdSeriesTable.a(arrayList);
    }

    private void a(String string, JLabel jLabel) {
        String string2 = new a(string).a();
        jLabel.setText(string2);
        jLabel.setForeground(this.effDate.getForeground());
        jLabel.setFont(this.effDate.getFont());
    }

    private boolean a(ArtAssistConfig artAssistConfig, List<DcmSeries> list) {
        boolean bl2 = true;
        bl2 &= this.a(list, artAssistConfig.r());
        bl2 &= this.a(list, artAssistConfig.u());
        bl2 &= this.a(list, artAssistConfig.t());
        bl2 &= this.a(list, artAssistConfig.s());
        Set set = artAssistConfig.H().stream().map(fractionInformation -> fractionInformation.getPlanDose()).filter(uniqueSeriesPointer -> uniqueSeriesPointer != null).collect(Collectors.toSet());
        for (UniqueSeriesPointer uniqueSeriesPointer2 : set) {
            bl2 &= this.a(list, uniqueSeriesPointer2);
        }
        return bl2;
    }

    private boolean a(List<DcmSeries> list, UniqueSeriesPointer uniqueSeriesPointer) {
        if (uniqueSeriesPointer == null || cn.g(uniqueSeriesPointer.getSeriesUID())) {
            return true;
        }
        DcmSeries dcmSeries = this.currentRefMap.get(uniqueSeriesPointer.getSeriesUID());
        if (dcmSeries != null) {
            list.add(dcmSeries);
            return true;
        }
        return false;
    }

    public void a(List<ArtAssistConfig> list, Map<String, DcmSeries> map) {
        this.currentRefMap = map;
        this.currentItemsModel.a(list);
    }

    @Override
    public List<DcmSeries> a() {
        return Lists.newArrayList(this.refdSeriesTable.a());
    }

    @Override
    public List<DcmSeries> b() {
        return Lists.newArrayList(this.refdSeriesTable.c());
    }

    @Override
    public DcmSeries c() {
        return this.refdSeriesTable.b();
    }

    @Override
    public void a(DcmSeries dcmSeries) {
        this.refdSeriesTable.a(dcmSeries);
    }

    private class ReportItemsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<ArtAssistConfig> configs = new ArrayList<ArtAssistConfig>();
        private int currentPlanIndex = -1;

        private ReportItemsModel() {
        }

        public void a(Collection<ArtAssistConfig> collection) {
            this.configs.clear();
            if (collection != null) {
                this.configs.addAll(collection);
            }
            Collections.sort(this.configs, new f());
            this.fireTableDataChanged();
            this.a();
        }

        private void a() {
            if (this.configs.isEmpty()) {
                this.currentPlanIndex = -1;
                return;
            }
            Date date = new Date();
            List list = this.configs.stream().sorted(new f()).filter(artAssistConfig -> artAssistConfig.q().before(date) || artAssistConfig.q().equals(date)).collect(Collectors.toList());
            if (!list.isEmpty()) {
                ArtAssistConfig artAssistConfig2 = (ArtAssistConfig)list.get(0);
                this.currentPlanIndex = this.configs.indexOf(artAssistConfig2);
                ReportPlanPanel.this.planTable.setRowSelectionInterval(this.currentPlanIndex, this.currentPlanIndex);
            } else {
                this.currentPlanIndex = -1;
            }
        }

        @Override
        public int getRowCount() {
            return this.configs.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return Boolean.class;
                }
                case 2: 
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: 
                case 6: {
                    return a.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return Messages.a("PatientList", "REPORT_PLAN_CURRENT_HEADER");
                }
                case 1: {
                    return Messages.a("PatientList", "REPORT_PLAN_EFF_DATE_HEADER");
                }
                case 2: {
                    return Messages.a("PatientList", "REPORT_PLAN_NUM_FRACTIONS_HEADER");
                }
                case 3: {
                    return Messages.a("Report", "CBCT_CONS_FRAC_PER_CBCT");
                }
                case 4: {
                    return Messages.a("Report", "CBCT_REQUIRE_SHIFTS");
                }
                case 5: {
                    return Messages.a("PatientList", "REPORT_PLAN_SETUP_WF_HEADER");
                }
                case 6: {
                    return Messages.a("PatientList", "REPORT_PLAN_DAILY_WF_HEADER");
                }
                case 7: {
                    return Messages.a("PatientList", "REPORT_PLAN_SERIES_DESC_HEADER");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (n2 < 0 || n2 >= this.configs.size()) {
                return null;
            }
            ArtAssistConfig artAssistConfig = this.configs.get(n2);
            if (artAssistConfig == null) {
                return null;
            }
            switch (n3) {
                case 0: {
                    return n2 == this.currentPlanIndex;
                }
                case 1: {
                    if (artAssistConfig.v() == ArtAssistConfig.ArtAssistConfigSource.b) {
                        return Messages.a("Report", "STRUCTRPT_NOT_ANY");
                    }
                    return DateUtils.a().format(artAssistConfig.q()) + " " + DateUtils.c().format(artAssistConfig.q());
                }
                case 2: {
                    if (artAssistConfig.v() == ArtAssistConfig.ArtAssistConfigSource.b) {
                        return Messages.a("InfoItem", "UNKNOWN");
                    }
                    return artAssistConfig.h();
                }
                case 3: {
                    if (artAssistConfig.v() == ArtAssistConfig.ArtAssistConfigSource.b) {
                        return Messages.a("InfoItem", "UNKNOWN");
                    }
                    return artAssistConfig.i();
                }
                case 4: {
                    return Messages.a("General", artAssistConfig.j() ? "YES" : "NO");
                }
                case 5: {
                    return new a(artAssistConfig.e());
                }
                case 6: {
                    return new a(artAssistConfig.g());
                }
                case 7: {
                    return artAssistConfig.p();
                }
            }
            return null;
        }

        public ArtAssistConfig a(int n2) {
            return this.configs.get(n2);
        }

        public void a(ArtAssistConfig artAssistConfig) {
            int n2 = this.configs.indexOf(artAssistConfig);
            if (n2 > -1) {
                this.configs.remove(artAssistConfig);
                this.fireTableRowsDeleted(n2, n2);
                this.a();
                if (this.currentPlanIndex != -1) {
                    this.fireTableRowsUpdated(this.currentPlanIndex, this.currentPlanIndex);
                }
            }
        }
    }

    private static class a {
        String a = null;

        a(String string) {
            this.a = string;
        }

        String a() {
            return x.d(PathUtils.getFilenameFromPath(this.a));
        }
    }
}

