/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui.report;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.report.ReportResultPanel;
import com.mimvista.archive.gui.report.ReportResultTab;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.workflow.IsocenterAlignCommand;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.ak;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.IECFixedVector;
import com.mimvista.numerics.IECOrientationPair;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.report.cbct.FractionInfoKey;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.swing.widgets.ExcelTable;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class ShiftEditorPanel
extends ReportResultTab {
    private static final long serialVersionUID = 1L;
    private static final float a = 15.0f;
    private static final int b = 26;
    private static final FractionInfoKey[] c = new FractionInfoKey[]{FractionInfoKey.a, FractionInfoKey.e, FractionInfoKey.f, FractionInfoKey.g, FractionInfoKey.h, FractionInfoKey.i, FractionInfoKey.j, FractionInfoKey.k};
    private ReportResultPanel parent;
    private List<ArtAssistConfig> configs;
    private ArtAssistConfig selectedPlan;
    private a shiftTableModel;
    private h configStore;
    private boolean needsSave = false;
    private ExcelTable table;
    private List<DcmSeries> allFractionableSeries;
    private JLabel planDate;

    public ShiftEditorPanel(ReportResultPanel reportResultPanel) {
        this.parent = reportResultPanel;
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
    }

    public void a(ReportResultPanel.b b2, h h2, List<ArtAssistConfig> list, List<DcmSeries> list2, SearchSource searchSource) {
        this.configStore = h2;
        this.configs = list;
        this.allFractionableSeries = list2;
        this.a(false);
    }

    private void e() {
        this.removeAll();
        if (this.selectedPlan == null) {
            this.shiftTableModel = null;
            this.table = null;
            this.planDate = null;
            return;
        }
        List<DcmSeries> list = this.allFractionableSeries.stream().filter(dcmSeries -> dcmSeries.getSeriesOrStudyDateTime(true) != null).filter(dcmSeries -> this.selectedPlan.q().before(dcmSeries.getSeriesOrStudyDateTime(true))).collect(Collectors.toList());
        this.shiftTableModel = new a(list);
        this.table = new ExcelTable(this.shiftTableModel);
        this.table.setRowSelectionAllowed(false);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final Border leftMissingSeriesBorder = BorderFactory.createMatteBorder(1, 1, 1, 0, MIMLookAndFeel.r());
            private final Border centerMissingSeriesBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, MIMLookAndFeel.r());
            private final Border rightMissingSeriesBorder = BorderFactory.createMatteBorder(1, 0, 1, 1, MIMLookAndFeel.r());

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                jLabel.setBackground(MIMLookAndFeel.a());
                a a2 = (a)jTable.getModel();
                FractionInformation fractionInformation = a2.a().get(n2);
                DcmSeries dcmSeries = a2.a(fractionInformation);
                jLabel.setBorder(dcmSeries != null ? null : (n3 == 0 ? this.leftMissingSeriesBorder : (n3 == jTable.getColumnCount() - 1 ? this.rightMissingSeriesBorder : this.centerMissingSeriesBorder)));
                jLabel.setOpaque(dcmSeries == null);
                jLabel.setToolTipText(dcmSeries == null ? Messages.a("Report", "SHIFT_EDITOR_MISSING_FRACTION_TOOLTIP") : dcmSeries.getSeriesDescription());
                return jLabel;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(4);
        this.table.setDefaultRenderer(String.class, defaultTableCellRenderer);
        this.table.setRowHeight(26);
        this.table.a(15.0f);
        TableCellEditor tableCellEditor = this.table.getDefaultEditor(String.class);
        if (tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(1);
        }
        this.add((Component)new JScrollPane(this.table), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        String string = DateUtils.a().format(this.selectedPlan.q());
        this.planDate = new JLabel("<html><b>" + Messages.a("Report", "CURRENT_CONFIG_EFFECTIVE_DATE") + "</b> " + string + "</html>");
        jPanel.add((Component)this.planDate, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)new JLabel(Messages.a("Report", "SHIFT_EDITOR_HELP_TEXT")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)new JLabel(Messages.a("Commands", "ISOCENTER_ALIGN_ROTATION_ORDER")), gridBagConstraints);
        JButton jButton = new JButton(Messages.a("Commands", "ISOCENTER_ALIGN_SHOW_SHIFT_FORMAT"), ImageManipulator.c("align_box", 20));
        jButton.addActionListener(actionEvent -> {
            JFrame jFrame = IsocenterAlignCommand.displayShiftInfoDialog();
            jFrame.setVisible(true);
            jFrame.setLocationRelativeTo(ak.b().O());
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(Messages.a("Report", "SHIFT_EDITOR_SAVE_PLAN"), ImageManipulator.c("save", 20));
        jButton2.addActionListener(actionEvent -> this.h());
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.add((Component)jPanel, "North");
    }

    private void h() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.a(true);
        progressPanel.a(Messages.a("Report", "SHIFT_EDITOR_SAVING_SHIFTS"));
        progressPanel.a();
        ProgressQueueNotification.a(progressPanel);
        m.e.a(() -> {
            try {
                HashMap<FractionInformation, Boolean> hashMap = new HashMap<FractionInformation, Boolean>();
                for (FractionInformation fractionInformation2 : this.shiftTableModel.a()) {
                    FractionInformation fractionInformation3 = this.selectedPlan.a(null, null, fractionInformation2.getFractionNumber(), fractionInformation2.getFractionDeliveryNumber());
                    if (fractionInformation3 == null) {
                        ay.c((Object)("Couldn't find fraction from shift table model in local config: " + fractionInformation2.getLogString() + " in " + this.selectedPlan.J()), ShiftEditorPanel.class);
                        continue;
                    }
                    hashMap.put(fractionInformation3, !Objects.equals(fractionInformation3.getShiftMatrix(), fractionInformation2.getShiftMatrix()));
                    fractionInformation3.setShiftMatrix(fractionInformation2.getShiftMatrix());
                }
                this.configStore.a(this.selectedPlan);
                this.selectedPlan.H().stream().filter(fractionInformation -> fractionInformation.getWorkflowStatus() != AutomatedWorkflowStatus.p || (Boolean)hashMap.get(fractionInformation) != false).findFirst().ifPresent(fractionInformation -> this.configStore.a(this.selectedPlan, (FractionInformation)fractionInformation, true));
                ReportResultPanel.j();
                SwingUtilities.invokeLater(() -> {
                    this.needsSave = false;
                });
            }
            catch (Exception exception) {
                this.a(exception, "SHIFT_EDITOR_ERROR");
            }
            finally {
                progressPanel.b();
            }
        }, "Save Fractions - Shift Editor Panel");
    }

    private void a(Exception exception, String string) {
        ay.d((Object)exception, this);
        Messages messages = Messages.a("Report");
        MOptionPane.b(this, messages.getProperty(string), messages.getProperty("SHIFT_EDITOR_ERROR_TITLE"), 0);
    }

    private void a(boolean bl2) {
        ArtAssistConfig artAssistConfig = this.parent.d();
        if (artAssistConfig != this.selectedPlan || bl2) {
            if (!ArtAssistConfig.a(this.configStore.u(), this.configs, artAssistConfig)) {
                this.configs.add(artAssistConfig);
            }
            this.selectedPlan = artAssistConfig;
            this.e();
        }
    }

    @Override
    public List<DcmSeries> a() {
        return Lists.newArrayList();
    }

    @Override
    public List<DcmSeries> b() {
        return Lists.newArrayList();
    }

    @Override
    public DcmSeries c() {
        return null;
    }

    @Override
    public void a(DcmSeries dcmSeries) {
    }

    @Override
    public void f() {
        this.a(false);
    }

    @Override
    public void g() {
        if (this.table != null) {
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            if (this.needsSave) {
                Messages messages = Messages.a("Report");
                int n2 = MOptionPane.c(this, messages.getProperty("SHIFT_EDITOR_CONFIRM_SAVE"), messages.getProperty("SHIFT_EDITOR_CONFIRM_SAVE_TITLE"), 0);
                if (n2 == 0) {
                    this.h();
                } else {
                    this.a(true);
                }
            }
        }
    }

    private class a
    implements TableModel {
        private static final String b = "-";
        private List<FractionInformation> c;
        private Map<FractionInformation, DcmSeries> d = new HashMap<FractionInformation, DcmSeries>();

        public a(List<DcmSeries> list) {
            this.c = ShiftEditorPanel.this.selectedPlan.H().stream().map(FractionInformation::clone).peek(fractionInformation -> list.stream().filter(dcmSeries -> dcmSeries.getSeriesInstanceUID().equals(fractionInformation.getFractionSeriesUID())).findFirst().ifPresent(dcmSeries -> this.d.put((FractionInformation)fractionInformation, (DcmSeries)dcmSeries))).collect(Collectors.toList());
        }

        @Override
        public int getRowCount() {
            return this.c.size();
        }

        @Override
        public int getColumnCount() {
            return c.length;
        }

        @Override
        public String getColumnName(int n2) {
            return c[n2].b();
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return n3 > 1;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            String string;
            FractionInfoKey fractionInfoKey = c[n3];
            FractionInformation fractionInformation = this.c.get(n2);
            if (fractionInformation != null && (string = fractionInformation.getString(fractionInfoKey)) != null) {
                return string;
            }
            return b;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            float f2;
            FractionInfoKey fractionInfoKey = c[n3];
            try {
                f2 = Float.parseFloat(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            FractionInformation fractionInformation = this.c.get(n2);
            IECFixedVector iECFixedVector = new IECFixedVector();
            IECFixedVector iECFixedVector2 = new IECFixedVector();
            if (fractionInformation.getShiftMatrix() != null) {
                iECFixedVector = fractionInformation.getTranslation();
                iECFixedVector2 = fractionInformation.getRotation();
            }
            switch (fractionInfoKey) {
                case h: {
                    iECFixedVector.a(f2);
                    break;
                }
                case g: {
                    iECFixedVector.c(f2);
                    break;
                }
                case f: {
                    iECFixedVector.b(f2);
                    break;
                }
                case j: {
                    iECFixedVector2.d(f2);
                    break;
                }
                case k: {
                    iECFixedVector2.f(f2);
                    break;
                }
                case i: {
                    iECFixedVector2.e(f2);
                }
            }
            TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix = IECOrientationPair.a(iECFixedVector, iECFixedVector2);
            if (fractionInformation.getShiftMatrix() == null || !fractionInformation.getShiftMatrix().equals(typedMatrix)) {
                fractionInformation.setShiftMatrix(typedMatrix);
                ShiftEditorPanel.this.needsSave = true;
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public DcmSeries a(FractionInformation fractionInformation) {
            return this.d.get(fractionInformation);
        }

        public List<FractionInformation> a() {
            return this.c;
        }
    }
}

