/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.gui.SourceType;
import com.mimvista.archive.gui.am;
import com.mimvista.archive.gui.b;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.message.SeriesDeleteHappenedMessage;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.SeriesStatusChecker;
import com.mimvista.metabase.s;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.user.CookieBox;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class z
extends b {
    private HashMap<String, String> f;
    private String g;

    public z() {
        super(a.b("DELETE_FILES_TEXT"), EnumSet.of(SourceType.c));
    }

    @Override
    public boolean accept(am am2) {
        SearchSource searchSource = am2.b();
        if (!super.accept(searchSource) || !(searchSource instanceof RemoteSearchSource)) {
            return false;
        }
        RemoteSearchSource remoteSearchSource = (RemoteSearchSource)searchSource;
        if (!LoginChecker.getInstance().currentCookieBox().b(remoteSearchSource.y())) {
            return false;
        }
        try {
            RemoteQueryServer remoteQueryServer = s.a(remoteSearchSource);
            if (remoteQueryServer == null) {
                return false;
            }
            if (!remoteQueryServer.isMetabaseRunning()) {
                return true;
            }
            if (!am2.d().isEmpty()) {
                if (!remoteQueryServer.isLockProhibitive()) {
                    return true;
                }
                for (DcmSeries dcmSeries : am2.d()) {
                    if (SeriesStatusChecker.isViewStatusSetByCurrentUser(dcmSeries.getViewStatus(), "Locked") != 0) continue;
                    return false;
                }
            }
        }
        catch (MalformedURLException | NotBoundException | RemoteException exception) {
            ay.d((Object)"Adding Remote Delete File menu item: ", (Throwable)exception, this);
        }
        return true;
    }

    @Override
    public boolean couldBeSlow() {
        return true;
    }

    @Override
    public boolean acceptOrJustReturnTrueIfItsGonnaTakeTooLong(am am2) {
        if (!this.accept(am2.b())) {
            return false;
        }
        return super.acceptOrJustReturnTrueIfItsGonnaTakeTooLong(am2);
    }

    @Override
    public void act(final am am2) {
        ProgressQueueNotification.b b2 = new ProgressQueueNotification.b(){

            @Override
            public void run(g g2) {
                g2.a(com.mimvista.archive.gui.b.a.b("DELETE_PROGRESS_PLACEHOLDER"));
                g2.a(true);
                z.this.a(am2, g2);
                if (g2.n() != Progress.Status.e && (z.this.error || z.this.d)) {
                    BasicNotification basicNotification = z.this.d ? new BasicNotification(BasicNotification.NotificationType.a, MIMFormat.a(com.mimvista.archive.gui.b.a.b("DELETE_REMOTE_LOCKED_DENY"), com.mimvista.archive.gui.b.a.b("STATUSINFO_TEXT")), new Notification.a()) : new BasicNotification(BasicNotification.NotificationType.a, com.mimvista.archive.gui.b.a.getProperty("DELETE_REMOTE_FILES_FAILURE"), new Notification.a());
                    u.b().c(basicNotification);
                }
            }
        };
        ProgressQueueNotification.a(b2);
    }

    @Override
    protected List<DcmSeries> a(Component component, SearchSource searchSource, List<DcmSeries> list, g g2) throws Exception {
        return z.b(component, searchSource, list, g2);
    }

    public static List<DcmSeries> b(Component component, SearchSource searchSource, List<DcmSeries> list, g g2) throws RemoteException, MalformedURLException, NotBoundException {
        return z.a(component, searchSource, list, g2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static List<DcmSeries> a(Component component, SearchSource searchSource, List<DcmSeries> list, g g2, boolean bl2) throws RemoteException, MalformedURLException, NotBoundException {
        void var10_16;
        Object object;
        Object object2;
        boolean bl3;
        RemoteQueryServer remoteQueryServer = s.a((RemoteSearchSource)searchSource);
        String string = a.b("DELETE_PROGRESS_TITLE");
        boolean bl4 = false;
        boolean bl5 = true;
        for (DcmSeries object32 : list) {
            if (g2.n() == Progress.Status.e) {
                return new ArrayList<DcmSeries>();
            }
            List<String> list2 = object32.getViewStatusNames();
            if (list2.contains("Locked")) {
                bl4 = true;
            }
            if (SeriesStatusChecker.isViewStatusSetByCurrentUser(object32.getViewStatus(), "Locked") != 0) continue;
            bl5 = false;
        }
        boolean bl6 = bl3 = GraphicsEnvironment.isHeadless() || bm.a().map(Session::T).orElse(bm.l()) != false;
        if (bl4 && !bl5) {
            String string2 = a.b("DELETE_REMOTE_LOCKED_TITLE");
            if (!remoteQueryServer.isLockProhibitive()) {
                int n2;
                if (bl3) {
                    ay.b((Object)"found some locked series, but lock is not prohibitive.  Continuing", z.class);
                    n2 = 0;
                } else {
                    object2 = a.b("DELETE_REMOTE_LOCKED_BYPASS");
                    object = new Object[]{a.b("DELETE_REMOTE_LOCKED_CONTINUE"), a.b("SEARCHSOURCE_CANCEL")};
                    n2 = JOptionPane.showOptionDialog(component, object2, string2, 0, 3, null, object, object[0]);
                }
                if (n2 != 0) {
                    g2.j();
                    throw new RuntimeException(c);
                }
            } else {
                throw new RuntimeException(b);
            }
        }
        Object var10_14 = null;
        ArrayList arrayList = Lists.newArrayList();
        object2 = Lists.newArrayList();
        g2.a(list.size());
        g2.a(false);
        try {
            for (DcmSeries dcmSeries : list) {
                if (g2.n() != Progress.Status.e) {
                    if (dcmSeries.isEmbedded()) {
                        arrayList.add(dcmSeries);
                        continue;
                    }
                    g2.a(MIMFormat.a(string, dcmSeries.getModality() + " - " + dcmSeries.getPatientName()));
                    CookieBox cookieBox = null;
                    if (searchSource instanceof RemoteSearchSource) {
                        cookieBox = ((RemoteSearchSource)searchSource).B();
                    }
                    if (cookieBox == null) {
                        cookieBox = LoginChecker.getInstance().currentCookieBox();
                    }
                    remoteQueryServer.deleteSeries(dcmSeries.getRplName(), dcmSeries.getArchiveDir(), cookieBox);
                    object2.add(dcmSeries);
                    g2.N_();
                    continue;
                }
                break;
            }
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            DcmSeries dcmSeries;
            dcmSeries = object.next();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (!dcmSeries.getChildIds().contains(((DcmSeries)arrayList.get(i2)).getPrimaryKey())) continue;
                arrayList.remove(i2);
                --i2;
            }
        }
        if (arrayList.size() > 0) {
            g2.k();
            ay.c((Object)("Skipped delete of embedded series:\n" + ((Object)arrayList).toString()), z.class);
            if (!bl3) {
                object = new BasicNotification(BasicNotification.NotificationType.b, a.getProperty("DELETE_FILES_EMBED_FAIL"), new Notification.a());
                u.b().c((Notification)object);
            }
        }
        g2.a(a.b("DELETE_PROGRESS_PLACEHOLDER"));
        if (var10_16 != null) {
            throw var10_16;
        }
        if (bl2) {
            z.a((RemoteSearchSource)searchSource, (List<DcmSeries>)object2);
        }
        return object2;
    }

    private static void a(RemoteSearchSource remoteSearchSource, List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            UniqueSeriesPointer uniqueSeriesPointer = new UniqueSeriesPointer(dcmSeries.getSeriesInstanceUID(), dcmSeries.getEqualityHash());
            SeriesDeleteHappenedMessage seriesDeleteHappenedMessage = new SeriesDeleteHappenedMessage(remoteSearchSource, uniqueSeriesPointer, (String)dcmSeries.getTagValue(0x20000D));
            seriesDeleteHappenedMessage.sendAsync();
        }
    }

    @Override
    protected void a(List<DcmSeries> list, boolean bl2) {
        LoginChecker loginChecker = LoginChecker.getInstance();
        String string = loginChecker.getUserFullName();
        if (string == null) {
            string = "";
        }
        try {
            string = string + " (" + InetAddress.getLocalHost().getHostAddress() + ")";
        }
        catch (Exception exception) {
            string = string + " (ERROR GETTING IP ADDRESS)";
        }
        string = string + (bl2 ? " deleted the following series: " : " attempted but failed to fully delete the following series; some or all files may remain: ");
        for (DcmSeries dcmSeries : list) {
            string = string + "\nModality: " + dcmSeries.getModality() + "\tUID: " + dcmSeries.getSeriesInstanceUID() + "\tDated: " + DateUtils.a(dcmSeries.getDisplayDate());
        }
        ay.b((Object)string, "auditlog");
    }

    @Override
    public String getStatusMessage() {
        if (!this.error) {
            return a.b("DELETE_FILES_MESSAGE");
        }
        return this.g;
    }

    @Override
    public boolean rerunSearch() {
        return false;
    }

    @Override
    public int getMessageType() {
        return 2;
    }

    @Override
    public String getDoAllQuestion(List<DcmStudy> list) {
        return MIMFormat.a(a.b("DELETE_ALL_FILES_QUESTION"), list.size());
    }

    @Override
    public String getReallyDoAllQuestion(List<DcmSeries> list) {
        return a.b("REALLY_DELETE_ALL_FILES_QUESTION");
    }

    public void a(HashMap<String, String> hashMap) {
        this.f = hashMap;
    }

    public HashMap<String, String> a() {
        if (this.f == null) {
            return null;
        }
        return Maps.newHashMap(this.f);
    }
}

