/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.BackupInfo;
import com.mimvista.archive.gui.RemoteDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.h;
import com.mimvista.archive.j;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.RemoteDeleteException;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.remote.RemoteQueryServerImpl;
import com.mimvista.archive.remote.sockets.ClientMetabaseDumpRequestHandler;
import com.mimvista.archive.remote.sockets.ClientQueryRequestHandler;
import com.mimvista.archive.remote.sockets.b;
import com.mimvista.archive.remote.sockets.c;
import com.mimvista.archive.remote.sockets.e;
import com.mimvista.archive.remote.sockets.g;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.LocalMetabaseSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.SeriesReferenceExtractor;
import com.mimvista.dicom.SeriesStatusBundle;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.SuperDcmSeriesFactory;
import com.mimvista.event.Event;
import com.mimvista.event.EventNotifierServer;
import com.mimvista.event.EventType;
import com.mimvista.event.f;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.k;
import com.mimvista.license.q;
import com.mimvista.metabase.ArtAssistConfigQuery;
import com.mimvista.metabase.DbWriteResult;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseOwnerStrings;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.StatusMap;
import com.mimvista.metabase.indexing.ScanOptions;
import com.mimvista.metabase.indexing.client.MetabaseIndexingClient;
import com.mimvista.metabase.mongo.MongoMetabaseQuery;
import com.mimvista.metabase.n;
import com.mimvista.metabase.o;
import com.mimvista.metabase.s;
import com.mimvista.metabase.u;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.preferencesNew.g;
import com.mimvista.properties.af;
import com.mimvista.report.cbct.FractionAuthorizer;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.ClientArtConfigFilesRetrieveRequestHandler;
import com.mimvista.report.cbct.config.ClientArtConfigFilesStoreRequestHandler;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.report.cbct.config.m;
import com.mimvista.report.cbct.config.p;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.AuthenticationType;
import com.mimvista.user.AuthorizationService;
import com.mimvista.user.Cookie;
import com.mimvista.user.CookieBox;
import com.mimvista.user.NullCookieBox;
import com.mimvista.util.NetworkUtils;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.cn;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import org.apache.commons.lang3.time.DurationFormatUtils;
import sun.rmi.server.UnicastServerRef;

public class MIMpacsServer
extends RemoteQueryServerImpl {
    private static MIMpacsServer i;
    private StatusMap j = StatusMap.c();
    private AuthorizationService k;
    private com.mimvista.event.a l = new f();
    private String[] m;
    private long n;
    private ArrayList<String> o;
    private boolean p;
    private UnicastServerRef q;
    private Timer r;
    private Timer s;
    private Thread t;

    public static synchronized MIMpacsServer getInstance() throws RemoteException {
        if (i == null) {
            i = new MIMpacsServer(false, MIMpacsConfig.f);
        }
        return i;
    }

    public static boolean isRplMode() {
        try {
            RemoteQueryServer remoteQueryServer = com.mimvista.metabase.s.a("127.0.0.1", MIMpacsConfig.f);
            return !remoteQueryServer.isRunningInStorageServerMode();
        }
        catch (Exception exception) {
            return MIMpacsConfig.k() || !LicenseTransformer.runLicensed(new k(){

                @Override
                @q(a={LicenseOption.SVC_AUTH}, b="RUNNING LICENSED MIMPACS FOR PURPOSES OF MIGRATING DATA")
                public void run() {
                }
            });
        }
    }

    public static MIMpacsServer getInstanceForTest(int n2) throws RemoteException {
        i = new MIMpacsServer(true, n2);
        return i;
    }

    public static MIMpacsServer findInstance() {
        return i;
    }

    public static boolean isArchiveFolder(File file) {
        file = PathUtils.getCanonicalOrAbsoluteFile(file);
        for (String string : MIMpacsServer.getArchiveLocations()) {
            if (!file.equals(PathUtils.getCanonicalOrAbsoluteFile(string))) continue;
            return true;
        }
        return false;
    }

    public static boolean inArchiveFolder(String string) {
        MIMFile mIMFile = new MIMFile(string);
        for (String string2 : MIMpacsServer.getArchiveLocations()) {
            if (!PathUtils.isParentOf(new MIMFile(string2), mIMFile, true)) continue;
            return true;
        }
        return false;
    }

    public static void loadPatientListInfo(RemotePatientListInfo remotePatientListInfo, g.a a2) {
        String string = a2.getPatientListName();
        remotePatientListInfo.e(string);
        remotePatientListInfo.f(string);
        remotePatientListInfo.a(com.mimvista.metabase.j.a().a(string));
        remotePatientListInfo.requiresReadAuth = a2.isReadAuthRequired();
        remotePatientListInfo.readers = a2.getReadingUsers();
        remotePatientListInfo.readGroups = a2.getReadingGroups();
        remotePatientListInfo.requiresWriteAuth = a2.isWriteAuthRequired();
        remotePatientListInfo.writers = a2.getWritingUsers();
        remotePatientListInfo.writeGroups = a2.getWritingGroups();
    }

    public static List<String> getDefaultPatientListNames() {
        ArrayList arrayList = Lists.newArrayList();
        Object object = MimpacsPrefs.mimpacsPLs.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            g.a a2 = (g.a)iterator.next();
            if (!a2.isDefaultPatientList()) continue;
            arrayList.add(a2.getPatientListName());
        }
        return arrayList;
    }

    public static List<Long> getDefaultPatientListIds() {
        List<String> list = MIMpacsServer.getDefaultPatientListNames();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        com.mimvista.metabase.e e2 = com.mimvista.metabase.j.a();
        for (String string : list) {
            arrayList.add(e2.c(string));
        }
        return arrayList;
    }

    public static String[] getArchiveLocations() {
        return MimpacsPrefs.archiveLocation.getValue();
    }

    public static File getDirForSimpleRPL(String string) {
        Object object = MimpacsPrefs.simpleRPLs.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            g.b b2 = (g.b)iterator.next();
            if (!b2.getPatientListName().equalsIgnoreCase(string)) continue;
            return b2.getPatientListPath();
        }
        return null;
    }

    private MIMpacsServer(boolean bl2, int n2) throws RemoteException {
        super(n2);
        this.p = bl2;
        this.a();
    }

    @Override
    public HashMap<String, Boolean> getPacsServerLicenses() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("SVC_AUTH", LicenseTransformer.runLicensed(new k(){

            @Override
            @q(b="MIMpacs Basic Check", a={LicenseOption.SVC_AUTH})
            public void run() {
            }
        }));
        hashMap.put("SVC_PLUS", LicenseTransformer.runLicensed(new k(){

            @Override
            @q(b="MIMpacs Plus Check", a={LicenseOption.SVC_PLUS})
            public void run() {
            }
        }));
        hashMap.put("SVC_PREM", LicenseTransformer.runLicensed(new k(){

            @Override
            @q(b="MIMpacs Premium Check", a={LicenseOption.SVC_PREM})
            public void run() {
            }
        }));
        return hashMap;
    }

    @Override
    public boolean isMetabaseRunning() {
        return true;
    }

    @Override
    public boolean isLockProhibitive() {
        return this.j.a();
    }

    @Override
    public boolean isAutoLockingEnabled() {
        return this.j.b();
    }

    @Override
    public boolean isRunningInStorageServerMode() {
        return true;
    }

    @Override
    public RemotePatientListInfo[] getPatientLists(CookieBox cookieBox) throws RemoteException {
        cookieBox = super.b(cookieBox);
        RemotePatientListInfo[] remotePatientListInfoArray = super.getPatientLists(cookieBox);
        ArrayList arrayList = Lists.newArrayList();
        RemoteQueryServerImpl.Permission[] permissionArray = RemoteQueryServerImpl.Permission.a();
        block0: for (RemotePatientListInfo remotePatientListInfo : remotePatientListInfoArray) {
            for (RemoteQueryServerImpl.Permission permission : permissionArray) {
                a a2 = this.a(permission, remotePatientListInfo, cookieBox);
                if (a2.a == null) continue;
                arrayList.add(remotePatientListInfo);
                continue block0;
            }
        }
        return arrayList.toArray(new RemotePatientListInfo[arrayList.size()]);
    }

    @Override
    public int getEventNotifierPort() {
        return this.l instanceof f ? 0 : MIMpacsConfig.h;
    }

    @Override
    public List<QueryResult> findSeries(SeriesParameters seriesParameters, String string, CookieBox cookieBox) throws AccessException {
        cookieBox = super.b(cookieBox);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "is attempting to find series in patient list " + string + " ..."), "auditlog");
        if (seriesParameters.uidList == null || seriesParameters.uidList.isEmpty()) {
            ay.a((Object)"Unable to perform findSeries search, must provide at least one UID.", this);
            return Collections.emptyList();
        }
        RemotePatientListInfo remotePatientListInfo = this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "Access denied to patient list " + string), "auditlog");
            return Collections.emptyList();
        }
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        com.mimvista.metabase.b.a(metabaseQuery, seriesParameters);
        return this.a(metabaseQuery, remotePatientListInfo, false, true, cookieBox);
    }

    private DcmSeries b(String string, String string2, CookieBox cookieBox) throws AccessException {
        cookieBox = super.b(cookieBox);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "is requesting DICOM information of series " + string2 + " in patient list " + string), "auditlog");
        if (this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox) == null) {
            ay.d((Object)("Access to patient list '" + string + "' is not allowed for user " + MIMpacsServer.getRemoteLogPrefix(cookieBox)), "auditlog");
            throw new AccessException("Access to this patient list is not allowed.");
        }
        return SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
    }

    @Override
    public TreeMap<Integer, String> dicomDump(String string, String string2, CookieBox cookieBox) throws AccessException {
        DcmSeries dcmSeries = this.b(string, string2, cookieBox);
        if (dcmSeries == null) {
            return DcmSeriesFactory.dicomDump(string2);
        }
        String string3 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        TreeMap<Integer, String> treeMap = DcmSeriesFactory.dicomDump(string3);
        Archiver.cleanTempDirForEmbeddedSeries(string3);
        return treeMap;
    }

    @Override
    public void setStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) throws AccessException {
        cookieBox = super.b(cookieBox);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "is attempting to set status " + string3 + " on " + string2), "auditlog");
        if (this.d(cookieBox)) {
            return;
        }
        if (this.b(RemoteQueryServerImpl.Permission.b, string, cookieBox) == null) {
            return;
        }
        int n2 = StatusMap.c().a(string3);
        if (n2 < 0) {
            ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + " attempted to set unknown status: " + string3), "auditlog");
            return;
        }
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + " set status " + string3 + " on " + string2), "auditlog");
        Cookie cookie = cookieBox.d();
        String string4 = cookie != null ? cookie.f() : "(null)";
        BackupInfo backupInfo = new BackupInfo(string2);
        if (!backupInfo.b(string3)) {
            ay.b((Object)("Adding status " + string3 + " to BAK file for series: " + string2), "auditlog");
            backupInfo.b(string4, string3);
        }
        com.mimvista.metabase.n.a(l2).d("mimdata.statuses.statusId", n2).a(com.mimvista.metabase.j.a(), string4, n2);
        this.a(string2, l2);
    }

    @Override
    public void delStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) throws AccessException {
        if (this.d(cookieBox = super.b(cookieBox))) {
            return;
        }
        if (this.b(RemoteQueryServerImpl.Permission.b, string, cookieBox) == null) {
            return;
        }
        int n2 = StatusMap.c().a(string3);
        if (n2 < 0) {
            ay.d((Object)("User " + MIMpacsServer.getRemoteLogPrefix(cookieBox) + " attempted to delete unknown status: " + string3), "auditlog");
            return;
        }
        BackupInfo backupInfo = new BackupInfo(string2);
        if (backupInfo.b(string3)) {
            backupInfo.e(string3);
        }
        com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a(), n2);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + " removed status " + string3 + " on " + string2 + " in Patient List " + string), "auditlog");
        this.a(string2, l2);
    }

    @Override
    public void setOwner(long l2, String string, CookieBox cookieBox) throws AccessException {
        if (this.d(cookieBox = super.b(cookieBox))) {
            return;
        }
        String string2 = cookieBox.d().f();
        com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a(), string2, string);
        List<? extends Series> list = com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a());
        Series series = list.get(0);
        String string3 = series.getFolders().iterator().next();
        BackupInfo backupInfo = new BackupInfo(string3);
        backupInfo.c(string2, string);
        ay.b((Object)("User " + MIMpacsServer.getRemoteLogPrefix(cookieBox) + " set owner to: " + string + "series uid: " + series.getSeriesInstanceUid()), "auditlog");
    }

    @Override
    public void clearOwnerHistory(long l2, CookieBox cookieBox) throws RemoteException {
        if (this.d(cookieBox = super.b(cookieBox))) {
            return;
        }
        String string = cookieBox.d().f();
        com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a(), string);
        List<? extends Series> list = com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a());
        Series series = list.get(0);
        String string2 = series.getFolders().iterator().next();
        BackupInfo backupInfo = new BackupInfo(string2);
        backupInfo.f();
        backupInfo.c(string, MetabaseOwnerStrings.c.c());
        ay.b((Object)("User " + MIMpacsServer.getRemoteLogPrefix(cookieBox) + "cleared owner history on series uid: " + series.getSeriesInstanceUid()), "auditlog");
    }

    @Override
    public boolean hasStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) throws RemoteException {
        if (this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox = super.b(cookieBox)) == null) {
            return false;
        }
        int n2 = StatusMap.c().a(string3);
        if (n2 < 0) {
            ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + " attempted to check an unknown status: " + string3), this);
            return false;
        }
        return com.mimvista.metabase.n.a(l2).c("mimdata.statuses.statusId", n2).d(com.mimvista.metabase.j.a()) > 0L;
    }

    @Override
    public List<SeriesStatusInfo> getStatuses(String string, String string2, long l2, String string3, CookieBox cookieBox) throws RemoteException {
        if (this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox = super.b(cookieBox)) == null) {
            return new ArrayList<SeriesStatusInfo>();
        }
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "requested statuses for " + string2 + " in Patient List " + string), this);
        List<? extends Series> list = com.mimvista.metabase.n.a(l2).f("mimdata.statuses").a(com.mimvista.metabase.j.a());
        if (list.size() == 1) {
            return this.a(list.get(0).getStatuses(), string3);
        }
        return Collections.emptyList();
    }

    @Override
    public List<SeriesStatusBundle> getViewAndWorkflowStatuses(String string, List<String> list, List<Long> list2, CookieBox cookieBox) throws RemoteException {
        cookieBox = super.b(cookieBox);
        ArrayList<SeriesStatusBundle> arrayList = new ArrayList<SeriesStatusBundle>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            arrayList.add(null);
        }
        if (this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox) != null) {
            com.mimvista.metabase.e e2 = com.mimvista.metabase.j.a();
            String string2 = MIMpacsServer.getRemoteLogPrefix(cookieBox);
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                String string3 = null;
                if (i3 >= 0 && i3 < list.size()) {
                    string3 = list.get(i3);
                }
                ay.b((Object)(string2 + "requested statuses for " + String.valueOf(string3) + " in Patient List " + string), this);
                List<? extends Series> list3 = com.mimvista.metabase.n.a(list2.get(i3)).f("mimdata.statuses").a(e2);
                if (list3.size() != 1) continue;
                List<u> list4 = list3.get(0).getStatuses();
                List<SeriesStatusInfo> list5 = this.a(list4, "View");
                List<SeriesStatusInfo> list6 = this.a(list4, "Workflow");
                arrayList.set(i3, new SeriesStatusBundle(list5, list6));
            }
        }
        return arrayList;
    }

    @Override
    public SeriesOwnerInfo getOwner(long l2, CookieBox cookieBox) throws RemoteException {
        cookieBox = super.b(cookieBox);
        List<? extends Series> list = com.mimvista.metabase.n.a(l2).f("mimdata.owners").f("mimdata.currentOwner").a(com.mimvista.metabase.j.a());
        SeriesOwnerInfo seriesOwnerInfo = null;
        if (list.size() == 1) {
            seriesOwnerInfo = list.get(0).getCurrentOwner();
        }
        return seriesOwnerInfo;
    }

    @Override
    public boolean canSetStatus(String string, String[] stringArray) throws RemoteException {
        ay.b((Object)("Checking if status " + string + " can be set by a user in group(s) " + Arrays.toString(stringArray)), this);
        return this.j.a(string, Arrays.asList(stringArray));
    }

    @Override
    public boolean canDelStatus(String string, String[] stringArray) throws RemoteException {
        ay.b((Object)("Checking if status " + string + " can be removed by a user in group(s) " + Arrays.toString(stringArray)), this);
        return this.j.b(string, Arrays.asList(stringArray));
    }

    @Override
    public List<String> listStatuses(String string) throws RemoteException {
        return this.j.b(string);
    }

    @Override
    public List<String> listNextWorkflowStatuses(String string, String[] stringArray) throws RemoteException {
        return this.j.c(string, Arrays.asList(stringArray));
    }

    @Override
    public List<String> getAvailableUsers() {
        try {
            if (AuthorizationService.getInstance() != null) {
                return AuthorizationService.getInstance().getUserList().keySet().stream().sorted().collect(Collectors.toList());
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean hasOwnersEnabled() {
        return MimpacsPrefs.enableOwners.getValue();
    }

    @Override
    public void reloadConfiguration() {
        super.reloadConfiguration();
        this.a();
    }

    private void a() {
        this.b();
        this.c();
        StatusMap.d();
        if (!this.p) {
            this.d();
            this.f();
            this.g();
        }
    }

    private void b() {
        List<String> list = Arrays.stream(this.c).map(RemotePatientListInfo::k).collect(Collectors.toList());
        com.mimvista.metabase.j.a().a(list);
    }

    private void c() {
        if (this.r != null) {
            this.r.cancel();
            this.r = null;
        }
        if (this.s != null) {
            this.s.cancel();
            this.s = null;
        }
        if (MimpacsPrefs.enableFailover.getValue().booleanValue()) {
            try {
                int n2 = MimpacsPrefs.failover_webServerPort.getValue();
                File file = MimpacsPrefs.failover_webServerJsonFile.getValue();
                com.mimvista.archive.remote.b.a.a(n2, file);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Failed to start the failover web server", throwable, this);
            }
            if (!MimpacsPrefs.failover_isPrimary.getValue().booleanValue()) {
                String string = MimpacsPrefs.failover_otherPacsAddress.getValue();
                int n3 = MimpacsPrefs.failover_otherPacsPort.getValue();
                int n4 = MimpacsPrefs.failover_configSyncFrequencySeconds.getValue();
                long l2 = TimeUnit.SECONDS.toMillis(n4);
                int n5 = MimpacsPrefs.failover_metabaseSyncFrequencySeconds.getValue();
                long l3 = TimeUnit.SECONDS.toMillis(n5);
                long l4 = TimeUnit.SECONDS.toMillis(5L);
                this.r = new Timer("pacs-failover-config-sync", true);
                this.r.schedule((TimerTask)new com.mimvista.archive.remote.sync.b(string, n3), l4, l2);
                this.s = new Timer("pacs-failover-metabase-sync", true);
                this.s.schedule((TimerTask)new com.mimvista.archive.remote.sync.c(string, n3, n3 + 5), l4, l3);
            }
        }
    }

    @Override
    public void renamePatientList(String string, String string2, CookieBox cookieBox) throws RemoteException {
        try {
            com.mimvista.metabase.j.a().a(string, string2);
        }
        catch (Throwable throwable) {
            ay.d((Object)("The metabase rejected renaming patient list " + string + " to " + string2), throwable, this);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.l != null && this.l instanceof EventNotifierServer) {
            EventNotifierServer eventNotifierServer = (EventNotifierServer)this.l;
            eventNotifierServer.a();
        }
    }

    private void d() {
        AuthenticationType authenticationType = MimpacsPrefs.authServerMethod.getValue();
        if (this.k == null) {
            try {
                this.e();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Unable to start the authorization service", throwable, this);
            }
        } else if (this.k.getAuthType() == authenticationType) {
            this.k.reloadConfiguration();
        } else {
            ay.b((Object)("AuthType changed from " + this.k.getAuthType() + " to " + authenticationType + " - restarting the authorization service"), this);
            if (this.k.unexportRmiObject()) {
                try {
                    this.e();
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Unable to restart the authorization service after a config change!", throwable, this);
                }
            } else {
                ay.c((Object)"Unable to stop the authorization service - couldn't switch auth type", this);
            }
        }
    }

    @Override
    protected RemotePatientListInfo[] a(@d af af2) {
        ay.b((Object)"MIMPACS: Loading patient lists from the configuration...", this);
        this.m = MimpacsPrefs.archiveLocation.getValue();
        ay.b((Object)("MIMPACS: Configured archive folder(s): " + Arrays.toString(this.m)), this);
        this.n = MimpacsPrefs.minArchiveSpace.getValue().intValue();
        ay.b((Object)("MIMPACS: Minimum space required for archive location is " + this.n + " MB"), this);
        Object object = MimpacsPrefs.mimpacsPLs.getValue();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            g.a a2 = (g.a)iterator.next();
            RemotePatientListInfo remotePatientListInfo = new RemotePatientListInfo();
            remotePatientListInfo.a(VersionNumber.rawCurrentVersionNotAccountingForMIMviewer().getFullVersionString());
            remotePatientListInfo.g(af.valueArrayToString(this.m));
            MIMpacsServer.loadPatientListInfo(remotePatientListInfo, a2);
            if (a2.isDefaultPatientList()) {
                ay.b((Object)("MIMPACS: Patient List  (DEFAULT): " + remotePatientListInfo.k()), this);
            } else {
                ay.b((Object)("MIMPACS: Patient List : " + remotePatientListInfo.k()), this);
            }
            if (cn.h(remotePatientListInfo.k())) continue;
            arrayList.add(remotePatientListInfo);
        }
        return arrayList.toArray(new RemotePatientListInfo[arrayList.size()]);
    }

    @Override
    public ClientQueryRequestHandler executeMetabaseQuery(MetabaseQuery metabaseQuery, String string, CookieBox cookieBox) throws AccessException, IOException {
        CookieBox cookieBox2 = this.c(cookieBox);
        RemotePatientListInfo remotePatientListInfo = this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox2);
        if (remotePatientListInfo == null) {
            return null;
        }
        if (!MIMpacsConfig.c() && metabaseQuery.e() && metabaseQuery.d() <= 0) {
            throw new RuntimeException("Blank searches are not allowed");
        }
        long l2 = com.mimvista.metabase.j.a().c(string);
        if (l2 < 0L) {
            ay.d((Object)("The metabase doesn't have an entry for patient list: " + string), this);
            return null;
        }
        metabaseQuery.c("mimdata.patientLists", l2);
        VersionNumber versionNumber = new VersionNumber(6, 1, 0, "");
        VersionNumber versionNumber2 = cookieBox2.g();
        if (versionNumber2 == null || VersionNumberComparator.b.c(versionNumber2, versionNumber)) {
            ((MongoMetabaseQuery)metabaseQuery).g();
        }
        ((MongoMetabaseQuery)metabaseQuery).h();
        c c2 = new c(metabaseQuery, remotePatientListInfo, cookieBox2);
        com.mimvista.archive.remote.sockets.a a2 = new com.mimvista.archive.remote.sockets.a(c2, this);
        com.mimvista.archive.remote.sockets.e.a.a(a2);
        return c2.e();
    }

    @Override
    protected List<QueryResult> a(RemotePatientListInfo remotePatientListInfo, int n2, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        metabaseQuery.a(MetabaseKeys.dateAdded(com.mimvista.metabase.j.a().c(remotePatientListInfo.k())), SortOrder.DESCENDING);
        metabaseQuery.b(n2);
        return this.a(metabaseQuery, remotePatientListInfo, true, false, cookieBox);
    }

    @Override
    protected List<QueryResult> a(RemotePatientListInfo remotePatientListInfo, Date date, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        metabaseQuery.f(MetabaseKeys.dateAdded(com.mimvista.metabase.j.a().c(remotePatientListInfo.k())), date);
        metabaseQuery.a(MetabaseKeys.dateAdded(com.mimvista.metabase.j.a().c(remotePatientListInfo.k())), SortOrder.ASCENDING);
        return this.a(metabaseQuery, remotePatientListInfo, true, false, cookieBox);
    }

    @Override
    protected List<QueryResult> a(String string, String string2, String string3, String string4, String string5, String string6, String string7, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        com.mimvista.metabase.b.a(metabaseQuery, string, string2, string3, string4, string5, string6, string7, null);
        return this.a(metabaseQuery, remotePatientListInfo, false, false, cookieBox);
    }

    @Override
    protected List<QueryResult> a(Date date, Date date2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        com.mimvista.metabase.b.b(metabaseQuery, date, date2);
        return this.a(metabaseQuery, remotePatientListInfo, false, false, cookieBox);
    }

    @Override
    protected List<QueryResult> b(Date date, Date date2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = com.mimvista.metabase.n.a();
        com.mimvista.metabase.b.a(metabaseQuery, date, date2);
        return this.a(metabaseQuery, remotePatientListInfo, false, false, cookieBox);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected RemotePatientListInfo a(RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws ServerException {
        String string = MIMpacsConfig.m();
        if (string == null) {
            ay.d((Object)"There is not enough free space for storage", this);
            throw new ServerException("There is not enough free space for storage");
        }
        ay.b((Object)("Choosing following archive path for storage: " + string), this);
        RemotePatientListInfo remotePatientListInfo2 = new RemotePatientListInfo();
        remotePatientListInfo2.e(remotePatientListInfo.k());
        remotePatientListInfo2.f(remotePatientListInfo.l());
        remotePatientListInfo2.g(string);
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) return remotePatientListInfo2;
            ay.d((Object)("The specified archive path is not a valid directory: " + file.getAbsolutePath()), this);
            throw new ServerException("The specified archive path is not a valid directory: " + file.getAbsolutePath());
        }
        if (file.mkdirs()) {
            ay.b((Object)("Created archive directory: " + file.getAbsolutePath()), this);
            return remotePatientListInfo2;
        }
        ay.d((Object)("Failed to create archive directory: " + file.getAbsolutePath()), this);
        throw new ServerException("Failed to create archive directory: " + file.getAbsolutePath());
    }

    @Override
    protected void a(String string, String string2, CookieBox cookieBox) throws RemoteException {
        cookieBox = super.b(cookieBox);
        long l2 = com.mimvista.metabase.j.a().c(string);
        List<? extends Series> list = com.mimvista.metabase.n.a().c("mimdata.patientLists", l2).c("mimdata.folders", (Object)PathUtils.getCanonicalOrAbsolutePath(string2)).f("mimdata.patientLists").f("mimdata.folders").a(com.mimvista.metabase.j.a());
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl2 = false;
        for (Series series : list) {
            List<? extends Series> list2 = com.mimvista.metabase.n.a(series.getPk()).a(com.mimvista.metabase.j.a(), l2).f("mimdata.patientLists").a(com.mimvista.metabase.j.a());
            Series series2 = list2.get(0);
            boolean bl3 = series2.getPatientLists().isEmpty();
            if (bl3) {
                com.mimvista.metabase.n.a(series.getPk()).f(com.mimvista.metabase.j.a());
            }
            for (String string3 : series.getFolders()) {
                com.mimvista.archive.h.b(string3, string);
                if (!bl3) continue;
                ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + "The following series is no longer in any patient lists so we're deleting its files from the archive folder: " + string3), "auditlog");
                File file = new File(string3);
                Archiver.deleteSeriesFolder(file);
                if (!file.exists()) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            throw new RemoteDeleteException("Failed to delete all series paths.");
        }
    }

    @Override
    protected void a(LocalMetabaseSeries localMetabaseSeries, CookieBox cookieBox) throws AccessException {
        for (String string : localMetabaseSeries.patientListNames) {
            try {
                if (this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox) == null) continue;
                return;
            }
            catch (AccessException accessException) {
            }
        }
        Object object = String.format("%sClient doesn't have read permissions on any of the patient lists for series %d: [%s]", MIMpacsServer.getRemoteLogPrefix(cookieBox), localMetabaseSeries.dcmSeries.getPrimaryKey(), cn.a(localMetabaseSeries.patientListNames, ", "));
        ay.d(object, "auditlog");
        throw new AccessException("Permission denied.");
    }

    protected a a(RemoteQueryServerImpl.Permission permission, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws AccessException {
        if (remotePatientListInfo == null) {
            return new a("Null archive.");
        }
        String string = remotePatientListInfo.k();
        if (permission == RemoteQueryServerImpl.Permission.a && !cookieBox.a(remotePatientListInfo)) {
            return new a(" does not have read permission of patient list " + string, "Permission Denied (Read)");
        }
        if (permission == RemoteQueryServerImpl.Permission.b && !cookieBox.b(remotePatientListInfo)) {
            return new a(" does not have write permission of patient list " + string, "Permission Denied (Write)");
        }
        return new a(remotePatientListInfo);
    }

    protected a a(RemoteQueryServerImpl.Permission permission, String string, CookieBox cookieBox) throws AccessException {
        if (cn.h(string)) {
            return new a("Patient list name is invalid: '" + String.valueOf(string) + "'");
        }
        RemotePatientListInfo remotePatientListInfo = this.a(string, cookieBox);
        if (remotePatientListInfo == null) {
            return new a("Unknown patient list: '" + string + "'");
        }
        return this.a(permission, remotePatientListInfo, cookieBox);
    }

    @Override
    protected RemotePatientListInfo b(RemoteQueryServerImpl.Permission permission, String string, CookieBox cookieBox) throws AccessException {
        a a2 = this.a(permission, string, cookieBox);
        if (a2.b != null) {
            ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox) + a2.b), this);
        }
        if (a2.c != null) {
            String string2 = a2.c;
            if (cookieBox instanceof NullCookieBox.ReplacementNullCookieBox) {
                NullCookieBox.ReplacementNullCookieBox replacementNullCookieBox = (NullCookieBox.ReplacementNullCookieBox)cookieBox;
                string2 = string2 + "\tOriginal CookieBox was replaced because: " + replacementNullCookieBox.j();
            }
            throw new AccessException(string2);
        }
        return a2.a;
    }

    @Override
    public List<RemotePatientListInfo> getAllPermittedPatientLists(RemoteQueryServerImpl.Permission permission, CookieBox cookieBox) {
        ArrayList arrayList;
        block3: {
            block2: {
                arrayList = Lists.newArrayList();
                if (permission != RemoteQueryServerImpl.Permission.a) break block2;
                for (RemotePatientListInfo remotePatientListInfo : this.c) {
                    if (!cookieBox.a(remotePatientListInfo)) continue;
                    arrayList.add(remotePatientListInfo);
                }
                break block3;
            }
            if (permission != RemoteQueryServerImpl.Permission.b) break block3;
            for (RemotePatientListInfo remotePatientListInfo : this.c) {
                if (!cookieBox.b(remotePatientListInfo)) continue;
                arrayList.add(remotePatientListInfo);
            }
        }
        return arrayList;
    }

    public String[] getArchivePaths() {
        return this.m;
    }

    @Override
    public synchronized void startMetabaseScan() {
        if (this.t == null) {
            this.t = new Thread("MIMpacs Metabase Scanning Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        com.mimvista.metabase.e e2 = com.mimvista.metabase.j.a();
                        bg.a("MIMPACS: Waiting for the metabase to start...");
                        boolean bl2 = com.mimvista.metabase.j.a().a(5L, TimeUnit.MINUTES);
                        bg.a("MIMPACS: Waiting for the metabase to start...");
                        if (!bl2) {
                            ay.c((Object)"Waited 5 minutes and the metabase still isn't running, skipping startup scan", this);
                            return;
                        }
                        ArrayList arrayList = Lists.newArrayList();
                        for (RemotePatientListInfo remotePatientListInfo : MIMpacsServer.this.c) {
                            arrayList.add(remotePatientListInfo.k());
                        }
                        e2.a(arrayList);
                        com.mimvista.archive.j.f();
                        ArrayList arrayList2 = Lists.newArrayList();
                        for (String object : MIMpacsServer.getArchiveLocations()) {
                            File throwable = new File(object);
                            if (!throwable.exists()) {
                                ay.c((Object)("MIMPACS: Can't find archive folder: " + throwable), this);
                                continue;
                            }
                            arrayList2.add(throwable);
                        }
                        if (arrayList2.isEmpty()) {
                            ay.b((Object)"MIMPACS: No archive folders to scan", this);
                            return;
                        }
                        MetabaseIndexingClient metabaseIndexingClient = new MetabaseIndexingClient();
                        ScanOptions scanOptions = ScanOptions.a().a(MIMpacsServer.getDefaultPatientListNames());
                        try {
                            Iterator iterator = arrayList2.iterator();
                            while (iterator.hasNext()) {
                                File file = (File)iterator.next();
                                try {
                                    metabaseIndexingClient.a(file, scanOptions);
                                }
                                catch (MetabaseIndexingClient.IndexingServiceConnectException indexingServiceConnectException) {
                                    throw indexingServiceConnectException;
                                }
                                catch (Throwable throwable) {
                                    ay.d((Object)("Error trying to schedule a MIMpacs archive folder to be scanned: " + file), throwable, this);
                                }
                            }
                            try {
                                metabaseIndexingClient.c();
                            }
                            catch (Throwable throwable) {
                                ay.d((Object)"Error trying to schedule index creation", throwable, this);
                            }
                        }
                        catch (MetabaseIndexingClient.IndexingServiceConnectException indexingServiceConnectException) {
                            ay.d((Object)"Can't connect to the indexing service - check the admin service logs, the admin service may need to be restarted or might be old", (Throwable)indexingServiceConnectException, this);
                        }
                    }
                    finally {
                        MIMpacsServer.this.t = null;
                    }
                }
            };
            this.t.start();
        }
    }

    private void a(String string, long l2) {
        List<? extends Series> list = com.mimvista.metabase.n.a(l2).a(com.mimvista.metabase.j.a());
        if (list.size() == 1) {
            Series series = list.get(0);
            List<u> list2 = series.getStatuses();
            Collections.sort(list2, Collections.reverseOrder(u.a));
            ArrayList arrayList = Lists.newArrayList();
            for (u object2 : list2) {
                if (!StatusMap.a("View", object2.getId())) continue;
                arrayList.add(new SeriesStatusInfo(object2.getId(), object2.getUser(), object2.getTime().getTimeInMillis(), StatusMap.c().a(object2.getId())));
            }
            Object object3 = null;
            for (u u2 : list2) {
                if (!StatusMap.a("Workflow", u2.getId())) continue;
                object3 = new SeriesStatusInfo(u2.getId(), u2.getUser(), u2.getTime().getTimeInMillis(), StatusMap.c().a(u2.getId()));
                break;
            }
            Event event = new Event(EventType.b);
            event.a("PrimaryKey", Long.toString(l2));
            event.a("ArchiveDir", string);
            event.a("ViewStatus", cn.a(arrayList, "~!~", new Function<SeriesStatusInfo, String>(){

                public String a(SeriesStatusInfo seriesStatusInfo) {
                    return seriesStatusInfo.getStringEncoding();
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((SeriesStatusInfo)object);
                }
            }));
            event.a("WorkflowStatus", object3 != null ? ((SeriesStatusInfo)object3).getStringEncoding() : "");
            this.l.a(event);
        }
    }

    private List<SeriesStatusInfo> a(List<u> list, String string) {
        ArrayList<SeriesStatusInfo> arrayList = new ArrayList<SeriesStatusInfo>();
        if ("Workflow".equalsIgnoreCase(string)) {
            Collections.sort(list, Collections.reverseOrder(u.a));
        }
        for (u u2 : list) {
            int n2 = u2.getId();
            if (!StatusMap.a(string, n2)) continue;
            arrayList.add(new SeriesStatusInfo(u2.getId(), u2.getUser(), u2.getTime().getTimeInMillis(), u2.getName()));
        }
        return arrayList;
    }

    private void e() {
        ay.b((Object)"Starting the authorization service...", this);
        this.k = AuthorizationService.getInstance();
        if (this.k == null) {
            throw new RuntimeException("Failed to start the authorization service");
        }
        ay.b((Object)("The authorization service started with the following configuration: " + this.k.getConfigurationString()), this);
        try {
            com.mimvista.metabase.s.a();
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't connect to the authorization service after starting it", exception);
        }
    }

    private void f() {
        try {
            if (this.l == null) {
                this.l = new EventNotifierServer(MIMpacsConfig.h);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to starting event notifier server", (Throwable)iOException, this);
        }
    }

    private void g() {
        try {
            if (this.q == null) {
                this.q = com.mimvista.util.network.d.a();
            }
        }
        catch (RemoteException remoteException) {
            ay.d((Object)"Exception starting the network test service.", (Throwable)remoteException, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryResult> a(MetabaseQuery metabaseQuery, final RemotePatientListInfo remotePatientListInfo, final boolean bl2, boolean bl3, CookieBox cookieBox) {
        int n2;
        metabaseQuery.c((Iterable<String>)com.mimvista.metabase.b.b());
        if (!MIMpacsConfig.c() && metabaseQuery.e() && metabaseQuery.d() <= 0) {
            throw new RuntimeException("This MIMpacs server does not allow blank searches");
        }
        if (cookieBox.f() == null) {
            metabaseQuery.e("mimdata.embedIdx");
        }
        if ((n2 = MIMpacsConfig.d()) > 0 && metabaseQuery.d() <= 0) {
            metabaseQuery.b(n2);
        }
        List list = Lists.transform(this.getAllPermittedPatientLists(RemoteQueryServerImpl.Permission.a, cookieBox), (Function)new Function<RemotePatientListInfo, Long>(){

            public Long a(RemotePatientListInfo remotePatientListInfo) {
                return com.mimvista.metabase.j.a().c(remotePatientListInfo.l());
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((RemotePatientListInfo)object);
            }
        });
        final ArrayList arrayList = Lists.newArrayList((Iterable)list);
        final long l2 = com.mimvista.metabase.j.a().c(remotePatientListInfo.k());
        if (bl3) {
            metabaseQuery.a("mimdata.patientLists", (Collection)arrayList);
        } else {
            metabaseQuery.c("mimdata.patientLists", l2);
        }
        ay.a((Object)("MIMPACS: Query object: " + metabaseQuery), this);
        long l3 = metabaseQuery.d(com.mimvista.metabase.j.a());
        int n3 = (int)Math.min(10L, Math.round((double)l3 / 10000.0));
        try {
            this.h.acquireUninterruptibly(n3);
            final ArrayList arrayList2 = Lists.newArrayList();
            final boolean bl4 = this.getPacsServerLicenses().get("SVC_PREM");
            long l4 = System.currentTimeMillis();
            int n4 = metabaseQuery.a(com.mimvista.metabase.j.a(), new FuncUtils.m<List<? extends Series>>(){

                public void a(List<? extends Series> list) {
                    o o2 = new o(com.mimvista.metabase.j.a(), l2);
                    o2.a(list);
                    o2.a(new Function<MetabaseQuery, MetabaseQuery>(){

                        public MetabaseQuery a(MetabaseQuery metabaseQuery) {
                            return metabaseQuery.a("mimdata.patientLists", (Collection)arrayList);
                        }

                        public /* synthetic */ Object apply(Object object) {
                            return this.a((MetabaseQuery)object);
                        }
                    });
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (Series series : list) {
                        if (!bl4 && Modality.isMIMpacsPremiumRequired(series.getModality())) {
                            ay.c((Object)("Due to missing license SVC_PREM, failed to search RT series " + series.getSeriesInstanceUid()), this);
                            continue;
                        }
                        QueryResult queryResult = series.asQueryResult().a("archivealias", remotePatientListInfo.k());
                        SeriesReferenceExtractor.extractReferences(queryResult, series, o2);
                        if (bl2) {
                            queryResult.a("newlyreceived", simpleDateFormat.format(series.getDateAdded()));
                        }
                        arrayList2.add(queryResult);
                    }
                }

                @Override
                public /* synthetic */ void doIt(Object object) {
                    this.a((List)object);
                }
            });
            ay.a((Object)("MIMPACS: Metabase query returned " + n4 + " results in: " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - l4), (String)"H'h':m'm':s.S's'")), this);
            ArrayList arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            this.h.release(n3);
        }
    }

    private boolean d(CookieBox cookieBox) {
        if (cookieBox == null) {
            return true;
        }
        Cookie cookie = cookieBox.d();
        if (cookie == null) {
            return true;
        }
        return cn.h(cookie.f());
    }

    @Override
    public boolean exportToIdms(String string, String string2, CookieBox cookieBox) throws RemoteException {
        CookieBox cookieBox2 = this.b(cookieBox);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox2) + " is attempting to copy series " + string2 + " in source patient list " + string + " to server's configured IDMS"), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox2);
        if (remotePatientListInfo == null) {
            return false;
        }
        String string3 = string2;
        DcmSeries dcmSeries = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
        if (dcmSeries != null) {
            string3 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        }
        if (!new File(string3).isDirectory()) {
            ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox2) + "Series does not exist: " + string3), this);
            return false;
        }
        this.a(string3);
        ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox2) + "Push series to IDMS: " + string3), "auditlog");
        try {
            com.mimvista.archive.gui.n n2 = com.mimvista.archive.a.c();
            if (n2 == null) {
                ay.d((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox2) + "Not able to use IDMS connection: " + string3), "auditlog");
                boolean bl2 = false;
                return bl2;
            }
            n2.a(dcmSeries);
            ay.b((Object)(MIMpacsServer.getRemoteLogPrefix(cookieBox2) + " pushed series to IDMS: " + string3), "auditlog");
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            throw new RemoteException("Error uploading to IDMS: " + string2, exception);
        }
        finally {
            if (dcmSeries != null && dcmSeries.isEmbedded()) {
                Archiver.cleanTempDirForEmbeddedSeries(string3);
            }
        }
    }

    @Override
    public ArtAssistConfigQuery createArtConfigQuery(RemotePatientListInfo remotePatientListInfo) throws RemoteException {
        m m2 = this.a(remotePatientListInfo);
        return m2.a();
    }

    @Override
    public List<LinkedHashMap<String, Object>> queryArtConfigs(ArtAssistConfigQuery artAssistConfigQuery, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        m m2 = this.a(remotePatientListInfo);
        return m2.a(artAssistConfigQuery).stream().map(artAssistConfig -> m2.g((ArtAssistConfig)artAssistConfig)).collect(Collectors.toList());
    }

    @Override
    public DbWriteResult updateArtConfig(LinkedHashMap<String, Object> linkedHashMap, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        m m2 = this.a(remotePatientListInfo);
        ArtAssistConfig artAssistConfig = m2.a((DBObject)new BasicDBObject(linkedHashMap));
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Updating config: " + artAssistConfig.b()), this);
        DbWriteResult dbWriteResult = m2.a(artAssistConfig);
        return dbWriteResult;
    }

    @Override
    public ClientArtConfigFilesStoreRequestHandler saveArtConfigWithFiles(LinkedHashMap<String, Object> linkedHashMap, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        m m2 = this.a(remotePatientListInfo);
        ArtAssistConfig artAssistConfig = m2.a((DBObject)new BasicDBObject(linkedHashMap));
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Saving config files and updating: " + artAssistConfig.b()), this);
        com.mimvista.report.cbct.config.k k2 = new com.mimvista.report.cbct.config.k(cookieBox, m2, artAssistConfig);
        p p2 = new p(k2);
        com.mimvista.archive.remote.sockets.e.a.a(p2);
        return k2.a();
    }

    @Override
    public ClientArtConfigFilesRetrieveRequestHandler fetchArtConfigFiles(ArtAssistConfigQuery artAssistConfigQuery, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        m m2 = this.a(remotePatientListInfo);
        Path path = m2.b(artAssistConfigQuery);
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Fetching ART config files"), this);
        com.mimvista.report.cbct.config.j j2 = new com.mimvista.report.cbct.config.j(cookieBox, path);
        com.mimvista.report.cbct.config.o o2 = new com.mimvista.report.cbct.config.o(j2);
        com.mimvista.archive.remote.sockets.e.a.a(o2);
        return j2.a();
    }

    @Override
    public DbWriteResult removeArtConfig(LinkedHashMap<String, Object> linkedHashMap, FractionAuthorizer fractionAuthorizer, boolean bl2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        m m2 = this.a(remotePatientListInfo);
        ArtAssistConfig artAssistConfig = m2.a((DBObject)new BasicDBObject(linkedHashMap));
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Removing config: " + artAssistConfig.b()), this);
        return m2.a(artAssistConfig, fractionAuthorizer, bl2);
    }

    @Override
    public DbWriteResult updateArtConfigFraction(LinkedHashMap<String, Object> linkedHashMap, FractionUpdate fractionUpdate, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        m m2 = this.a(remotePatientListInfo);
        ArtAssistConfig artAssistConfig = m2.a((DBObject)new BasicDBObject(linkedHashMap));
        fractionUpdate.a(artAssistConfig);
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Updating fraction: " + fractionUpdate.q()), this);
        return m2.a(fractionUpdate);
    }

    @Override
    public List<FractionInformation> stopArtConfigFraction(LinkedHashMap<String, Object> linkedHashMap, FractionInformation fractionInformation, boolean bl2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IllegalStateException {
        m m2 = this.a(remotePatientListInfo);
        ArtAssistConfig artAssistConfig = m2.a((DBObject)new BasicDBObject(linkedHashMap));
        ay.b((Object)("ART Assist [" + this.e(cookieBox) + "]: Removing generated fraction data for fraction: " + fractionInformation.getFractionNumber() + "." + fractionInformation.getFractionDeliveryNumber() + "on config: " + artAssistConfig.b()), this);
        return m2.a(artAssistConfig, fractionInformation, bl2);
    }

    private m a(RemotePatientListInfo remotePatientListInfo) throws RemoteException {
        RemoteDestination remoteDestination = ag.a(remotePatientListInfo);
        if (remoteDestination != null) {
            return new m(com.mimvista.e.a.a(), remoteDestination);
        }
        throw new ServerException("Invalid PatientList on this machine: " + remotePatientListInfo.l());
    }

    @Override
    public ClientMetabaseDumpRequestHandler getMetabaseDump(CookieBox cookieBox) throws RemoteException, AccessException, IOException {
        String string = MimpacsPrefs.failover_otherPacsAddress.getValue();
        String string2 = "<no RMI context>";
        try {
            string2 = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (!NetworkUtils.a(string2, string)) {
            throw new AccessException(string2 + " is not in the failover config on this machine");
        }
        ay.b((Object)"Client requested a metabase dump", "auditlog");
        b b2 = new b(cookieBox);
        com.mimvista.archive.remote.sockets.e.a.a(new g(b2));
        return b2.a();
    }

    private String e(CookieBox cookieBox) {
        String string = cookieBox.e();
        if (cn.g(string)) {
            string = "NO USER";
        }
        return string;
    }

    private static class a {
        public final RemotePatientListInfo a;
        public final String b;
        public final String c;

        public a(String string, String string2) {
            this.b = string;
            this.c = string2;
            this.a = null;
        }

        public a(String string) {
            this(string, null);
        }

        public a(RemotePatientListInfo remotePatientListInfo) {
            this.b = null;
            this.c = null;
            this.a = remotePatientListInfo;
        }
    }
}

