/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.collect.Lists;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.RemoteObjectInfo;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.TransferedFile;
import com.mimvista.archive.remote.sockets.ClientMetabaseDumpRequestHandler;
import com.mimvista.archive.remote.sockets.ClientQueryRequestHandler;
import com.mimvista.b;
import com.mimvista.cloud.shared.common.mim.UploadOptions;
import com.mimvista.d;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.SeriesStatusBundle;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.metabase.ArtAssistConfigQuery;
import com.mimvista.metabase.DbWriteResult;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.mimcloud.connection.CloudResponseException;
import com.mimvista.report.cbct.FractionAuthorizer;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ClientArtConfigFilesRetrieveRequestHandler;
import com.mimvista.report.cbct.config.ClientArtConfigFilesStoreRequestHandler;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.user.CookieBox;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public interface RemoteQueryServer
extends Remote {
    public static final int a = 131072;
    public static final int b = 17192;

    public void hello() throws RemoteException;

    public String getVersion() throws RemoteException;

    public String getHostAddress() throws RemoteException;

    public String getServerName() throws RemoteException;

    public HashMap<String, Boolean> getPacsServerLicenses() throws RemoteException;

    public boolean isMetabaseRunning() throws RemoteException;

    public boolean isLockProhibitive() throws RemoteException;

    public boolean isAutoLockingEnabled() throws RemoteException;

    public boolean isRunningInStorageServerMode() throws RemoteException;

    public boolean isEnforcingLocalStorageRestrictions() throws RemoteException;

    public RemotePatientListInfo[] getPatientLists(CookieBox var1) throws RemoteException;

    public int getEventNotifierPort() throws RemoteException;

    public ClientQueryRequestHandler executeMetabaseQuery(MetabaseQuery var1, String var2, CookieBox var3) throws AccessException, IOException;

    public List<QueryResult> searchArchive(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, CookieBox var9) throws RemoteException;

    public List<QueryResult> searchArchiveLastAccessedBetween(Date var1, Date var2, String var3, CookieBox var4) throws RemoteException;

    public List<QueryResult> searchArchiveLastAccessedNotBetween(Date var1, Date var2, String var3, CookieBox var4) throws RemoteException;

    public List<QueryResult> searchNewlyReceived(String var1, int var2, CookieBox var3) throws RemoteException;

    public List<QueryResult> searchNewlyReceived(String var1, Date var2, CookieBox var3) throws RemoteException;

    public List<QueryResult> findSeries(SeriesParameters var1, String var2, CookieBox var3) throws RemoteException;

    public TreeMap<Integer, String> dicomDump(String var1, String var2, CookieBox var3) throws RemoteException;

    public Map<Integer, String[]> getValuesForDicomTags(String var1, int[] var2) throws RemoteException;

    public Map<Integer, String[]> getValuesForDicomTags(String var1, String var2, int[] var3, CookieBox var4) throws RemoteException;

    @Deprecated
    @b(a="5.5.9")
    public RemoteObjectInfo retrieveSeries(String var1, String var2, boolean var3, CookieBox var4) throws RemoteException, ServerNotActiveException, Exception;

    @Deprecated
    @d
    @b(a="5.5.9")
    public RemoteObjectInfo storeSeries(String var1, CookieBox var2) throws RemoteException;

    public long getSeriesSizeInBytes(String var1) throws RemoteException;

    public void deleteSeries(String var1, String var2, CookieBox var3) throws RemoteException;

    public boolean exportToAnotherRemotePatientList(String var1, String var2, String var3, String var4, CookieBox var5) throws RemoteException;

    public boolean exportToAnotherRemotePatientList(String var1, String var2, String var3, String var4, CookieBox var5, CookieBox var6) throws RemoteException;

    public boolean exportToRemotePatientList(String var1, String var2, String var3, String var4, CookieBox var5) throws RemoteException;

    public boolean exportToRemotePatientList(String var1, String var2, String var3, String var4, CookieBox var5, CookieBox var6) throws RemoteException;

    public boolean exportToDcmServer(String var1, String var2, String var3) throws RemoteException;

    public boolean exportToDcmServer(String var1, String var2, String var3, CookieBox var4) throws RemoteException;

    public boolean exportToCloud(String var1, byte[] var2, String[] var3, UploadOptions var4) throws RemoteException, CloudResponseException, CloudResponseException.NoCredentialsProvidedException;

    public boolean exportToIdms(String var1, String var2, CookieBox var3) throws RemoteException;

    public int getCloudUploadProgress() throws RemoteException;

    public String getCurrentSeriesName() throws RemoteException;

    public void setStatus(String var1, String var2, long var3, String var5, CookieBox var6) throws RemoteException;

    public void delStatus(String var1, String var2, long var3, String var5, CookieBox var6) throws RemoteException;

    public boolean hasStatus(String var1, String var2, long var3, String var5, CookieBox var6) throws RemoteException;

    public void setOwner(long var1, String var3, CookieBox var4) throws RemoteException;

    public void clearOwnerHistory(long var1, CookieBox var3) throws RemoteException;

    public SeriesOwnerInfo getOwner(long var1, CookieBox var3) throws RemoteException;

    public boolean hasOwnersEnabled() throws RemoteException;

    public List<String> getAvailableUsers() throws RemoteException;

    public List<SeriesStatusInfo> getStatuses(String var1, String var2, long var3, String var5, CookieBox var6) throws RemoteException;

    public String getCloudClientTypeName() throws RemoteException;

    public List<SeriesStatusBundle> getViewAndWorkflowStatuses(String var1, List<String> var2, List<Long> var3, CookieBox var4) throws RemoteException;

    public boolean canSetStatus(String var1, String[] var2) throws RemoteException;

    public boolean canDelStatus(String var1, String[] var2) throws RemoteException;

    public List<String> listStatuses(String var1) throws RemoteException;

    public List<String> listNextWorkflowStatuses(String var1, String[] var2) throws RemoteException;

    @Deprecated
    public RemoteObjectInfo getFileInputStream(String var1, String var2, boolean var3, CookieBox var4) throws RemoteException;

    public RemoteObjectInfo getFileOutputStream(String var1, String var2, CookieBox var3) throws RemoteException;

    public void reloadConfiguration() throws RemoteException;

    public void renamePatientList(String var1, String var2, CookieBox var3) throws RemoteException;

    public void startMetabaseScan() throws RemoteException;

    public MIMRawSocketStreamInfo retrieveUsingRawSocket(String var1, String var2, CookieBox var3) throws RemoteException, ServerNotActiveException, Exception;

    public MIMRawSocketStreamInfo sendUsingRawSocket(String var1, CookieBox var2) throws RemoteException, ServerNotActiveException, Exception;

    public ArtAssistConfigQuery createArtConfigQuery(RemotePatientListInfo var1) throws RemoteException;

    public List<LinkedHashMap<String, Object>> queryArtConfigs(ArtAssistConfigQuery var1, RemotePatientListInfo var2, CookieBox var3) throws RemoteException;

    public DbWriteResult updateArtConfig(LinkedHashMap<String, Object> var1, RemotePatientListInfo var2, CookieBox var3) throws RemoteException, IOException;

    public ClientArtConfigFilesStoreRequestHandler saveArtConfigWithFiles(LinkedHashMap<String, Object> var1, RemotePatientListInfo var2, CookieBox var3) throws RemoteException, IOException;

    public ClientArtConfigFilesRetrieveRequestHandler fetchArtConfigFiles(ArtAssistConfigQuery var1, RemotePatientListInfo var2, CookieBox var3) throws RemoteException, IOException;

    public DbWriteResult removeArtConfig(LinkedHashMap<String, Object> var1, FractionAuthorizer var2, boolean var3, RemotePatientListInfo var4, CookieBox var5) throws RemoteException;

    public DbWriteResult updateArtConfigFraction(LinkedHashMap<String, Object> var1, FractionUpdate var2, RemotePatientListInfo var3, CookieBox var4) throws RemoteException;

    public List<FractionInformation> stopArtConfigFraction(LinkedHashMap<String, Object> var1, FractionInformation var2, boolean var3, RemotePatientListInfo var4, CookieBox var5) throws RemoteException, IllegalStateException;

    public ClientMetabaseDumpRequestHandler getMetabaseDump(CookieBox var1) throws RemoteException, AccessException, IOException;

    public static class MIMRawSocketStreamInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public UUID streamUID;
        public ArrayList<TransferedFile> files;

        public MIMRawSocketStreamInfo() {
            this(UUID.randomUUID());
        }

        public MIMRawSocketStreamInfo(UUID uUID) {
            this(uUID, null);
        }

        public MIMRawSocketStreamInfo(UUID uUID, List<File> list) {
            this.streamUID = uUID;
            if (list != null) {
                this.files = Lists.newArrayList();
                for (File file : list) {
                    if (!file.isFile() || !file.exists() || file.getName().endsWith(".bak")) continue;
                    this.files.add(new TransferedFile(file.getName(), file.length()));
                }
            }
        }

        public UUID a() {
            return this.streamUID;
        }
    }
}

